/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.DoubleResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public class FractionalCSP3Descriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#Fsp3", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 0) {
            throw new CDKException("The FractionalCSP3Descriptor expects zero parameters");
        }
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public DescriptorValue calculate(IAtomContainer mol2) {
        DoubleResult result;
        try {
            int nC = 0;
            int nCSP3 = 0;
            CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(mol2.getBuilder());
            for (IAtom atom : mol2.atoms()) {
                if (atom.getAtomicNumber() != 6) continue;
                ++nC;
                IAtomType matched = matcher.findMatchingAtomType(mol2, atom);
                if (matched == null || matched.getHybridization() != IAtomType.Hybridization.SP3) continue;
                ++nCSP3;
            }
            result = new DoubleResult(nC == 0 ? 0.0 : (double)nCSP3 / (double)nC);
        }
        catch (CDKException e) {
            result = new DoubleResult(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResultType();
    }

    @Override
    public String[] getDescriptorNames() {
        return new String[]{"Fsp3"};
    }
}

