/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupKey;
import org.openscience.cdk.sgroup.SgroupType;
import org.openscience.cdk.smiles.BeamToCDK;
import org.openscience.cdk.smiles.CxSmilesParser;
import org.openscience.cdk.smiles.CxSmilesState;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import uk.ac.ebi.beam.Graph;

public final class SmilesParser {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(SmilesParser.class);
    private final IChemObjectBuilder builder;
    private final BeamToCDK beamToCDK;
    private boolean kekulise = true;
    private boolean strict = false;

    public SmilesParser(IChemObjectBuilder builder) {
        this.builder = builder;
        this.beamToCDK = new BeamToCDK(builder);
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public IReaction parseReactionSmiles(String smiles) throws InvalidSmilesException {
        int i;
        if (!smiles.contains(">")) {
            throw new InvalidSmilesException("Not a reaction SMILES: " + smiles);
        }
        int first = smiles.indexOf(62);
        int second = smiles.indexOf(62, first + 1);
        if (second < 0) {
            throw new InvalidSmilesException("Invalid reaction SMILES:" + smiles);
        }
        String reactants = smiles.substring(0, first);
        String agents = smiles.substring(first + 1, second);
        String products = smiles.substring(second + 1, smiles.length());
        IReaction reaction = this.builder.newInstance(IReaction.class, new Object[0]);
        if (!reactants.isEmpty()) {
            IAtomContainer reactantContainer = this.parseSmiles(reactants, true);
            IAtomContainerSet reactantSet = ConnectivityChecker.partitionIntoMolecules(reactantContainer);
            for (i = 0; i < reactantSet.getAtomContainerCount(); ++i) {
                reaction.addReactant(reactantSet.getAtomContainer(i));
            }
        }
        if (!agents.isEmpty()) {
            IAtomContainer agentContainer = this.parseSmiles(agents, true);
            IAtomContainerSet agentSet = ConnectivityChecker.partitionIntoMolecules(agentContainer);
            for (i = 0; i < agentSet.getAtomContainerCount(); ++i) {
                reaction.addAgent(agentSet.getAtomContainer(i));
            }
        }
        String title = null;
        if (!products.isEmpty()) {
            IAtomContainer productContainer = this.parseSmiles(products, true);
            IAtomContainerSet productSet = ConnectivityChecker.partitionIntoMolecules(productContainer);
            for (int i2 = 0; i2 < productSet.getAtomContainerCount(); ++i2) {
                reaction.addProduct(productSet.getAtomContainer(i2));
            }
            title = (String)productContainer.getProperty("cdk:Title");
            reaction.setProperty("cdk:Title", title);
        }
        try {
            this.parseRxnCXSMILES(title, reaction);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidSmilesException("Error parsing CXSMILES:" + e.getMessage());
        }
        return reaction;
    }

    public IAtomContainer parseSmiles(String smiles) throws InvalidSmilesException {
        return this.parseSmiles(smiles, false);
    }

    private IAtomContainer parseSmiles(String smiles, boolean isRxnPart) throws InvalidSmilesException {
        try {
            HashSet<String> warnings = new HashSet<String>();
            Graph g2 = Graph.parse(smiles, this.strict, warnings);
            for (String warning : warnings) {
                this.logger.warn(warning);
            }
            IAtomContainer mol2 = this.beamToCDK.toAtomContainer(this.kekulise ? g2.kekule() : g2, this.kekulise);
            if (!isRxnPart) {
                try {
                    this.parseMolCXSMILES(g2.getTitle(), mol2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new InvalidSmilesException("Error parsing CXSMILES:" + e.getMessage());
                }
            }
            return mol2;
        }
        catch (IOException e) {
            throw new InvalidSmilesException("could not parse '" + smiles + "', " + e.getMessage());
        }
        catch (Exception e) {
            throw new InvalidSmilesException("could not parse '" + smiles + "'");
        }
    }

    private int parseIntSafe(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void parseMolCXSMILES(String title, IAtomContainer mol2) throws InvalidSmilesException {
        CxSmilesState cxstate;
        int pos;
        if (title != null && title.startsWith("|") && (pos = CxSmilesParser.processCx(title, cxstate = new CxSmilesState())) >= 0) {
            mol2.setTitle(title.substring(pos));
            HashMap<IAtom, IAtomContainer> atomToMol = Maps.newHashMapWithExpectedSize(mol2.getAtomCount());
            ArrayList<IAtom> atoms = new ArrayList<IAtom>(mol2.getAtomCount());
            for (IAtom atom : mol2.atoms()) {
                atoms.add(atom);
                atomToMol.put(atom, mol2);
            }
            this.assignCxSmilesInfo(mol2.getBuilder(), mol2, atoms, atomToMol, cxstate);
        }
    }

    private void parseRxnCXSMILES(String title, IReaction rxn) throws InvalidSmilesException {
        CxSmilesState cxstate;
        int pos;
        if (title != null && title.startsWith("|") && (pos = CxSmilesParser.processCx(title, cxstate = new CxSmilesState())) >= 0) {
            rxn.setProperty("cdk:Title", title.substring(pos));
            HashMap<IAtom, IAtomContainer> atomToMol = new HashMap<IAtom, IAtomContainer>(100);
            ArrayList<IAtom> atoms = new ArrayList<IAtom>();
            for (IAtomContainer mol2 : rxn.getReactants().atomContainers()) {
                for (IAtom atom : mol2.atoms()) {
                    atoms.add(atom);
                }
            }
            for (IAtomContainer mol2 : rxn.getAgents().atomContainers()) {
                for (IAtom atom : mol2.atoms()) {
                    atoms.add(atom);
                }
            }
            for (IAtomContainer mol2 : rxn.getProducts().atomContainers()) {
                for (IAtom atom : mol2.atoms()) {
                    atoms.add(atom);
                }
            }
            this.handleFragmentGrouping(rxn, cxstate);
            for (IAtomContainer mol2 : rxn.getReactants().atomContainers()) {
                for (IAtom atom : mol2.atoms()) {
                    atomToMol.put(atom, mol2);
                }
            }
            for (IAtomContainer mol2 : rxn.getAgents().atomContainers()) {
                for (IAtom atom : mol2.atoms()) {
                    atomToMol.put(atom, mol2);
                }
            }
            for (IAtomContainer mol2 : rxn.getProducts().atomContainers()) {
                for (IAtom atom : mol2.atoms()) {
                    atomToMol.put(atom, mol2);
                }
            }
            this.assignCxSmilesInfo(rxn.getBuilder(), rxn, atoms, atomToMol, cxstate);
        }
    }

    private void handleFragmentGrouping(IReaction rxn, CxSmilesState cxstate) {
        if (cxstate.fragGroups == null && cxstate.racemicFrags == null) {
            return;
        }
        boolean reactant = true;
        int agent = 2;
        int product = 3;
        ArrayList<IAtomContainer> fragMap = new ArrayList<IAtomContainer>();
        HashMap<IAtomContainer, Integer> roleMap = new HashMap<IAtomContainer, Integer>();
        for (IAtomContainer mol2 : rxn.getReactants().atomContainers()) {
            fragMap.add(mol2);
            roleMap.put(mol2, 1);
        }
        for (IAtomContainer mol2 : rxn.getAgents().atomContainers()) {
            fragMap.add(mol2);
            roleMap.put(mol2, 2);
        }
        for (IAtomContainer mol2 : rxn.getProducts().atomContainers()) {
            fragMap.add(mol2);
            roleMap.put(mol2, 3);
        }
        if (cxstate.racemicFrags != null) {
            for (Integer grp : cxstate.racemicFrags) {
                IAtomContainer mol3;
                if (grp >= fragMap.size() || (mol3 = (IAtomContainer)fragMap.get(grp)) == null) continue;
                for (IStereoElement e : mol3.stereoElements()) {
                    if (e.getConfigClass() != 16896) continue;
                    e.setGroupInfo(327680);
                }
            }
        }
        if (cxstate.fragGroups != null) {
            boolean invalid = false;
            HashSet<Integer> visit = new HashSet<Integer>();
            for (List<Integer> grouping : cxstate.fragGroups) {
                IAtomContainer dest;
                if (grouping.get(0) >= fragMap.size() || (dest = (IAtomContainer)fragMap.get(grouping.get(0))) == null) continue;
                if (!visit.add(grouping.get(0))) {
                    invalid = true;
                }
                for (int i = 1; i < grouping.size(); ++i) {
                    IAtomContainer src;
                    if (!visit.add(grouping.get(i))) {
                        invalid = true;
                    }
                    if (grouping.get(i) >= fragMap.size() || (src = (IAtomContainer)fragMap.get(grouping.get(i))) == null) continue;
                    dest.add(src);
                    roleMap.put(src, 0);
                }
            }
            if (!invalid) {
                rxn.getReactants().removeAllAtomContainers();
                rxn.getAgents().removeAllAtomContainers();
                rxn.getProducts().removeAllAtomContainers();
                for (IAtomContainer mol4 : fragMap) {
                    switch ((Integer)roleMap.get(mol4)) {
                        case 1: {
                            rxn.getReactants().addAtomContainer(mol4);
                            break;
                        }
                        case 3: {
                            rxn.getProducts().addAtomContainer(mol4);
                            break;
                        }
                        case 2: {
                            rxn.getAgents().addAtomContainer(mol4);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void assignCxSmilesInfo(IChemObjectBuilder bldr, IChemObject chemObj, List<IAtom> atoms, Map<IAtom, IAtomContainer> atomToMol, CxSmilesState cxstate) throws InvalidSmilesException {
        Object object;
        IAtomContainer mol2;
        List<IBond> bonds;
        IAtom beg;
        Sgroup sgroup;
        if (cxstate.atomLabels != null) {
            for (Map.Entry<Integer, String> e : cxstate.atomLabels.entrySet()) {
                if (e.getKey() >= atoms.size()) continue;
                IAtom old = atoms.get(e.getKey());
                IPseudoAtom pseudo = bldr.newInstance(IPseudoAtom.class, new Object[0]);
                String val = e.getValue();
                if (val.endsWith("_p")) {
                    val = val.substring(0, val.length() - 2);
                } else if (val.startsWith("_AP")) {
                    pseudo.setAttachPointNum(this.parseIntSafe(val.substring(3)));
                }
                pseudo.setLabel(val);
                pseudo.setAtomicNumber(0);
                pseudo.setImplicitHydrogenCount(0);
                IAtomContainer mol3 = atomToMol.get(old);
                AtomContainerManipulator.replaceAtomByAtom(mol3, old, pseudo);
                atomToMol.put(pseudo, mol3);
                atoms.set(e.getKey(), mol3.getAtom(old.getIndex()));
            }
        }
        if (cxstate.atomValues != null) {
            for (Map.Entry<Integer, String> e : cxstate.atomValues.entrySet()) {
                atoms.get(e.getKey()).setProperty("cdk:Comment", e.getValue());
            }
        }
        if (cxstate.atomCoords != null) {
            int numAtoms = atoms.size();
            int numCoords = cxstate.atomCoords.size();
            int lim = Math.min(numAtoms, numCoords);
            if (cxstate.coordFlag) {
                for (int i = 0; i < lim; ++i) {
                    atoms.get(i).setPoint3d(new Point3d(cxstate.atomCoords.get(i)));
                }
            } else {
                for (int i = 0; i < lim; ++i) {
                    atoms.get(i).setPoint2d(new Point2d(cxstate.atomCoords.get(i)));
                }
            }
        }
        if (cxstate.atomRads != null) {
            for (Map.Entry<Integer, CxSmilesState.Radical> e : cxstate.atomRads.entrySet()) {
                if (e.getKey() >= atoms.size()) continue;
                int count = 0;
                switch (e.getValue()) {
                    case Monovalent: {
                        count = 1;
                        break;
                    }
                    case Divalent: 
                    case DivalentSinglet: 
                    case DivalentTriplet: {
                        count = 2;
                        break;
                    }
                    case Trivalent: 
                    case TrivalentDoublet: 
                    case TrivalentQuartet: {
                        count = 3;
                    }
                }
                IAtom atom = atoms.get(e.getKey());
                IAtomContainer mol4 = atomToMol.get(atom);
                while (count-- > 0) {
                    mol4.addSingleElectron(bldr.newInstance(ISingleElectron.class, atom));
                }
            }
        }
        HashMultimap<Object, Sgroup> sgroupMap = HashMultimap.create();
        HashMap<CxSmilesState.CxSgroup, Sgroup> sgroupRemap = new HashMap<CxSmilesState.CxSgroup, Sgroup>();
        if (cxstate.positionVar != null) {
            for (Map.Entry<Integer, List<Integer>> e : cxstate.positionVar.entrySet()) {
                sgroup = new Sgroup();
                sgroup.setType(SgroupType.ExtMulticenter);
                beg = atoms.get(e.getKey());
                IAtomContainer mol22 = atomToMol.get(beg);
                bonds = mol22.getConnectedBondsList(beg);
                if (bonds.isEmpty()) continue;
                sgroup.addAtom(beg);
                sgroup.addBond(bonds.get(0));
                for (Integer n : e.getValue()) {
                    sgroup.addAtom(atoms.get(n));
                }
                sgroupMap.put(mol22, sgroup);
            }
        }
        if (cxstate.ligandOrdering != null) {
            for (Map.Entry<Integer, List<Integer>> e : cxstate.ligandOrdering.entrySet()) {
                sgroup = new Sgroup();
                sgroup.setType(SgroupType.ExtAttachOrdering);
                beg = atoms.get(e.getKey());
                mol2 = atomToMol.get(beg);
                bonds = mol2.getConnectedBondsList(beg);
                if (bonds.isEmpty()) {
                    throw new InvalidSmilesException("CXSMILES LO: no bonds to order");
                }
                if (bonds.size() != e.getValue().size()) {
                    throw new InvalidSmilesException("CXSMILES LO: bond count and ordering count was different");
                }
                sgroup.addAtom(beg);
                for (Integer n : e.getValue()) {
                    IBond bond = beg.getBond(atoms.get(n));
                    if (bond == null) {
                        throw new InvalidSmilesException("CXSMILES LO: defined ordering to non-existant bond");
                    }
                    sgroup.addBond(bond);
                }
                sgroupMap.put(mol2, sgroup);
            }
        }
        if (cxstate.mysgroups != null) {
            block49: for (CxSmilesState.CxSgroup cxsgroup : cxstate.mysgroups) {
                void var15_65;
                if (!(cxsgroup instanceof CxSmilesState.CxPolymerSgroup)) continue;
                CxSmilesState.CxPolymerSgroup psgroup = (CxSmilesState.CxPolymerSgroup)cxsgroup;
                Sgroup sgroup2 = new Sgroup();
                HashSet<Object> atomset = new HashSet<Object>();
                Object mol5 = null;
                for (Integer n : psgroup.atoms) {
                    if (n >= atoms.size()) continue;
                    IAtom atom = atoms.get(n);
                    IAtomContainer amol = atomToMol.get(atom);
                    if (mol5 == null) {
                        mol5 = amol;
                    } else if (amol != mol5) continue block49;
                    atomset.add(atom);
                }
                if (mol5 == null) continue;
                for (IAtom iAtom : atomset) {
                    for (IBond bond : mol5.getConnectedBondsList(iAtom)) {
                        if (atomset.contains(bond.getOther(iAtom))) continue;
                        sgroup2.addBond(bond);
                    }
                    sgroup2.addAtom(iAtom);
                }
                sgroup2.setSubscript(psgroup.subscript);
                sgroup2.putValue(SgroupKey.CtabConnectivity, psgroup.supscript);
                object = psgroup.type;
                int n = -1;
                switch (((String)object).hashCode()) {
                    case 110: {
                        if (!((String)object).equals("n")) break;
                        boolean bl = false;
                        break;
                    }
                    case 108300: {
                        if (!((String)object).equals("mon")) break;
                        boolean bl = true;
                        break;
                    }
                    case 107994: {
                        if (!((String)object).equals("mer")) break;
                        int n2 = 2;
                        break;
                    }
                    case 3180: {
                        if (!((String)object).equals("co")) break;
                        int n3 = 3;
                        break;
                    }
                    case 3828: {
                        if (!((String)object).equals("xl")) break;
                        int n4 = 4;
                        break;
                    }
                    case 108290: {
                        if (!((String)object).equals("mod")) break;
                        int n5 = 5;
                        break;
                    }
                    case 108124: {
                        if (!((String)object).equals("mix")) break;
                        int n6 = 6;
                        break;
                    }
                    case 102: {
                        if (!((String)object).equals("f")) break;
                        int n7 = 7;
                        break;
                    }
                    case 96748: {
                        if (!((String)object).equals("any")) break;
                        int n8 = 8;
                        break;
                    }
                    case 102224: {
                        if (!((String)object).equals("gen")) break;
                        int n9 = 9;
                        break;
                    }
                    case 99: {
                        if (!((String)object).equals("c")) break;
                        int n10 = 10;
                        break;
                    }
                    case 102619: {
                        if (!((String)object).equals("grf")) break;
                        int n11 = 11;
                        break;
                    }
                    case 96681: {
                        if (!((String)object).equals("alt")) break;
                        int n12 = 12;
                        break;
                    }
                    case 112671: {
                        if (!((String)object).equals("ran")) break;
                        int n13 = 13;
                        break;
                    }
                    case 97633: {
                        if (!((String)object).equals("blk")) break;
                        int n14 = 14;
                    }
                }
                switch (var15_65) {
                    case 0: {
                        sgroup2.setType(SgroupType.CtabStructureRepeatUnit);
                        break;
                    }
                    case 1: {
                        sgroup2.setType(SgroupType.CtabMonomer);
                        break;
                    }
                    case 2: {
                        sgroup2.setType(SgroupType.CtabMer);
                        break;
                    }
                    case 3: {
                        sgroup2.setType(SgroupType.CtabCopolymer);
                        break;
                    }
                    case 4: {
                        sgroup2.setType(SgroupType.CtabCrossLink);
                        break;
                    }
                    case 5: {
                        sgroup2.setType(SgroupType.CtabModified);
                        break;
                    }
                    case 6: {
                        sgroup2.setType(SgroupType.CtabMixture);
                        break;
                    }
                    case 7: {
                        sgroup2.setType(SgroupType.CtabFormulation);
                        break;
                    }
                    case 8: {
                        sgroup2.setType(SgroupType.CtabAnyPolymer);
                        break;
                    }
                    case 9: {
                        sgroup2.setType(SgroupType.CtabGeneric);
                        break;
                    }
                    case 10: {
                        sgroup2.setType(SgroupType.CtabComponent);
                        break;
                    }
                    case 11: {
                        sgroup2.setType(SgroupType.CtabGraft);
                        break;
                    }
                    case 12: {
                        sgroup2.setType(SgroupType.CtabCopolymer);
                        sgroup2.putValue(SgroupKey.CtabSubType, "ALT");
                        break;
                    }
                    case 13: {
                        sgroup2.setType(SgroupType.CtabCopolymer);
                        sgroup2.putValue(SgroupKey.CtabSubType, "RAN");
                        break;
                    }
                    case 14: {
                        sgroup2.setType(SgroupType.CtabCopolymer);
                        sgroup2.putValue(SgroupKey.CtabSubType, "BLO");
                    }
                }
                sgroupMap.put(mol5, sgroup2);
                sgroupRemap.put(psgroup, sgroup2);
            }
        }
        if (cxstate.mysgroups != null) {
            block53: for (CxSmilesState.CxSgroup cxsgroup : cxstate.mysgroups) {
                if (!(cxsgroup instanceof CxSmilesState.CxDataSgroup)) continue;
                CxSmilesState.CxDataSgroup dsgroup = (CxSmilesState.CxDataSgroup)cxsgroup;
                HashSet atomset = new HashSet();
                mol2 = null;
                for (Integer idx : dsgroup.atoms) {
                    if (idx >= atoms.size()) continue;
                    IAtom iAtom = atoms.get(idx);
                    IAtomContainer amol = atomToMol.get(iAtom);
                    if (mol2 == null) {
                        mol2 = amol;
                    } else if (amol != mol2) continue block53;
                    atomset.add(iAtom);
                }
                if (dsgroup.field != null && dsgroup.field.startsWith("cdk:")) {
                    chemObj.setProperty(dsgroup.field, dsgroup.value);
                    continue;
                }
                Sgroup cdkSgroup = new Sgroup();
                cdkSgroup.setType(SgroupType.CtabData);
                object = atomset.iterator();
                while (object.hasNext()) {
                    IAtom iAtom = (IAtom)object.next();
                    cdkSgroup.addAtom(iAtom);
                }
                cdkSgroup.putValue(SgroupKey.DataFieldName, dsgroup.field);
                cdkSgroup.putValue(SgroupKey.DataFieldUnits, dsgroup.unit);
                cdkSgroup.putValue(SgroupKey.Data, dsgroup.value);
                sgroupRemap.put(dsgroup, cdkSgroup);
                if (mol2 != null) {
                    sgroupMap.put(mol2, cdkSgroup);
                    continue;
                }
                if (!(chemObj instanceof IAtomContainer)) continue;
                sgroupMap.put((IAtomContainer)chemObj, cdkSgroup);
            }
        }
        if (cxstate.mysgroups != null) {
            for (CxSmilesState.CxSgroup parent : cxstate.mysgroups) {
                Sgroup cdkParent = (Sgroup)sgroupRemap.get(parent);
                if (cdkParent == null) continue;
                for (CxSmilesState.CxSgroup child : parent.children) {
                    Sgroup cdkChild = (Sgroup)sgroupRemap.get(child);
                    if (cdkChild == null) continue;
                    cdkChild.addParent(cdkParent);
                }
            }
        }
        if (cxstate.racemic) {
            if (chemObj instanceof IAtomContainer) {
                for (IStereoElement e : ((IAtomContainer)chemObj).stereoElements()) {
                    if (e.getConfigClass() != 16896) continue;
                    e.setGroupInfo(327680);
                }
            } else if (chemObj instanceof IReaction) {
                for (IAtomContainer mol6 : ReactionManipulator.getAllAtomContainers((IReaction)chemObj)) {
                    for (IStereoElement e : mol6.stereoElements()) {
                        if (e.getConfigClass() != 16896) continue;
                        e.setGroupInfo(327680);
                    }
                }
            }
        }
        if (cxstate.stereoGrps != null) {
            for (Map.Entry<Integer, Integer> e : cxstate.stereoGrps.entrySet()) {
                IAtom atm = atoms.get(e.getKey());
                IAtomContainer mol3 = atomToMol.get(atm);
                for (IStereoElement stereo : mol3.stereoElements()) {
                    if (stereo.getConfigClass() != 16896 || !stereo.getFocus().equals(atm)) continue;
                    stereo.setGroupInfo(e.getValue());
                }
            }
        }
        for (Map.Entry e : sgroupMap.asMap().entrySet()) {
            ((IAtomContainer)e.getKey()).setProperty("cdk:CtabSgroups", new ArrayList(e.getValue()));
        }
    }

    @Deprecated
    public void setPreservingAromaticity(boolean preservingAromaticity) {
        this.kekulise = !preservingAromaticity;
    }

    @Deprecated
    public boolean isPreservingAromaticity() {
        return !this.kekulise;
    }

    public void kekulise(boolean kekulise) {
        this.kekulise = kekulise;
    }
}

