/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupType;
import org.openscience.cdk.tools.LoggingToolFactory;

public class MolecularFormulaManipulator {
    public static final int MolWeight = 1;
    public static final int MolWeightIgnoreSpecified = 2;
    public static final int MonoIsotopic = 3;
    public static final int MostAbundant = 4;
    public static final Comparator<IIsotope> NAT_ABUN_COMP = new Comparator<IIsotope>(){

        @Override
        public int compare(IIsotope o1, IIsotope o2) {
            return -Double.compare(o1.getNaturalAbundance(), o2.getNaturalAbundance());
        }
    };
    private static final char HYPHEN = '-';
    private static final char MINUS = '\u2013';
    private static final String HYPHEN_STR = "-";
    private static final String MINUS_STR = "\u2013";

    public static int getAtomCount(IMolecularFormula formula) {
        int count = 0;
        for (IIsotope isotope : formula.isotopes()) {
            count += formula.getIsotopeCount(isotope);
        }
        return count;
    }

    public static int getElementCount(IMolecularFormula formula, IElement element) {
        int count = 0;
        for (IIsotope isotope : formula.isotopes()) {
            if (!isotope.getSymbol().equals(element.getSymbol())) continue;
            count += formula.getIsotopeCount(isotope);
        }
        return count;
    }

    public static int getElementCount(IMolecularFormula formula, IIsotope isotope) {
        return MolecularFormulaManipulator.getElementCount(formula, formula.getBuilder().newInstance(IElement.class, isotope));
    }

    public static int getElementCount(IMolecularFormula formula, String symbol) {
        return MolecularFormulaManipulator.getElementCount(formula, formula.getBuilder().newInstance(IElement.class, symbol));
    }

    public static List<IIsotope> getIsotopes(IMolecularFormula formula, IElement element) {
        ArrayList<IIsotope> isotopeList = new ArrayList<IIsotope>();
        for (IIsotope isotope : formula.isotopes()) {
            if (!isotope.getSymbol().equals(element.getSymbol())) continue;
            isotopeList.add(isotope);
        }
        return isotopeList;
    }

    public static List<IElement> elements(IMolecularFormula formula) {
        ArrayList<IElement> elementList = new ArrayList<IElement>();
        ArrayList<String> stringList = new ArrayList<String>();
        for (IIsotope isotope : formula.isotopes()) {
            if (stringList.contains(isotope.getSymbol())) continue;
            elementList.add(isotope);
            stringList.add(isotope.getSymbol());
        }
        return elementList;
    }

    public static boolean containsElement(IMolecularFormula formula, IElement element) {
        for (IIsotope isotope : formula.isotopes()) {
            if (!element.getSymbol().equals(isotope.getSymbol())) continue;
            return true;
        }
        return false;
    }

    public static IMolecularFormula removeElement(IMolecularFormula formula, IElement element) {
        for (IIsotope isotope : MolecularFormulaManipulator.getIsotopes(formula, element)) {
            formula.removeIsotope(isotope);
        }
        return formula;
    }

    public static String getString(IMolecularFormula formula, String[] orderElements, boolean setOne) {
        return MolecularFormulaManipulator.getString(formula, orderElements, setOne, true);
    }

    private static void appendElement(StringBuilder sb, Integer mass, int elem, int count) {
        String symbol = Elements.ofNumber(elem).symbol();
        if (symbol.isEmpty()) {
            symbol = "R";
        }
        if (mass != null) {
            sb.append('[').append(mass).append(']').append(symbol);
        } else {
            sb.append(symbol);
        }
        if (count != 0) {
            sb.append(count);
        }
    }

    public static String getString(IMolecularFormula formula, String[] orderElements, boolean setOne, boolean setMassNumber) {
        StringBuilder stringMF = new StringBuilder();
        List<IIsotope> isotopesList = MolecularFormulaManipulator.putInOrder(orderElements, formula);
        Integer q = formula.getCharge();
        if (q != null && q != 0) {
            stringMF.append('[');
        }
        if (!setMassNumber) {
            int count = 0;
            int prev = -1;
            for (IIsotope isotope : isotopesList) {
                if (!Objects.equals(isotope.getAtomicNumber(), prev)) {
                    if (count != 0) {
                        MolecularFormulaManipulator.appendElement(stringMF, null, prev, setOne || count != 1 ? count : 0);
                    }
                    prev = isotope.getAtomicNumber();
                    count = formula.getIsotopeCount(isotope);
                    continue;
                }
                count += formula.getIsotopeCount(isotope);
            }
            if (count != 0) {
                MolecularFormulaManipulator.appendElement(stringMF, null, prev, setOne || count != 1 ? count : 0);
            }
        } else {
            for (IIsotope isotope : isotopesList) {
                int count = formula.getIsotopeCount(isotope);
                MolecularFormulaManipulator.appendElement(stringMF, isotope.getMassNumber(), isotope.getAtomicNumber(), setOne || count != 1 ? count : 0);
            }
        }
        if (q != null && q != 0) {
            stringMF.append(']');
            if (q > 0) {
                if (q > 1) {
                    stringMF.append(q);
                }
                stringMF.append('+');
            } else {
                if (q < -1) {
                    stringMF.append(-q.intValue());
                }
                stringMF.append('-');
            }
        }
        return stringMF.toString();
    }

    public static String getString(IMolecularFormula formula) {
        return MolecularFormulaManipulator.getString(formula, false);
    }

    public static String getString(IMolecularFormula formula, boolean setOne) {
        if (MolecularFormulaManipulator.containsElement(formula, formula.getBuilder().newInstance(IElement.class, "C"))) {
            return MolecularFormulaManipulator.getString(formula, MolecularFormulaManipulator.generateOrderEle_Hill_WithCarbons(), setOne, false);
        }
        return MolecularFormulaManipulator.getString(formula, MolecularFormulaManipulator.generateOrderEle_Hill_NoCarbons(), setOne, false);
    }

    public static String getString(IMolecularFormula formula, boolean setOne, boolean setMassNumber) {
        if (MolecularFormulaManipulator.containsElement(formula, formula.getBuilder().newInstance(IElement.class, "C"))) {
            return MolecularFormulaManipulator.getString(formula, MolecularFormulaManipulator.generateOrderEle_Hill_WithCarbons(), setOne, setMassNumber);
        }
        return MolecularFormulaManipulator.getString(formula, MolecularFormulaManipulator.generateOrderEle_Hill_NoCarbons(), setOne, setMassNumber);
    }

    public static List<IIsotope> putInOrder(String[] orderElements, IMolecularFormula formula) {
        ArrayList<IIsotope> isotopesList = new ArrayList<IIsotope>();
        for (String orderElement : orderElements) {
            IElement element = formula.getBuilder().newInstance(IElement.class, orderElement);
            if (!MolecularFormulaManipulator.containsElement(formula, element)) continue;
            List<IIsotope> isotopes = MolecularFormulaManipulator.getIsotopes(formula, element);
            Collections.sort(isotopes, new Comparator<IIsotope>(){

                @Override
                public int compare(IIsotope a, IIsotope b) {
                    Integer aMass = a.getMassNumber();
                    Integer bMass = b.getMassNumber();
                    if (aMass == null) {
                        return -1;
                    }
                    if (bMass == null) {
                        return 1;
                    }
                    return aMass.compareTo(bMass);
                }
            });
            isotopesList.addAll(isotopes);
        }
        return isotopesList;
    }

    @Deprecated
    public static String getHillString(IMolecularFormula formula) {
        StringBuffer hillString = new StringBuffer();
        TreeMap<String, Integer> hillMap = new TreeMap<String, Integer>();
        for (IIsotope isotope : formula.isotopes()) {
            String symbol = isotope.getSymbol();
            if (hillMap.containsKey(symbol)) {
                hillMap.put(symbol, (Integer)hillMap.get(symbol) + formula.getIsotopeCount(isotope));
                continue;
            }
            hillMap.put(symbol, formula.getIsotopeCount(isotope));
        }
        if (hillMap.containsKey("C")) {
            hillString.append('C');
            int count = (Integer)hillMap.get("C");
            if (count > 1) {
                hillString.append(count);
            }
            hillMap.remove("C");
            if (hillMap.containsKey("H")) {
                hillString.append('H');
                count = (Integer)hillMap.get("H");
                if (count > 1) {
                    hillString.append(count);
                }
                hillMap.remove("H");
            }
        }
        for (String key : hillMap.keySet()) {
            hillString.append(key);
            int count = (Integer)hillMap.get(key);
            if (count <= 1) continue;
            hillString.append(count);
        }
        return hillString.toString();
    }

    public static String getHTML(IMolecularFormula formula) {
        return MolecularFormulaManipulator.getHTML(formula, true, true);
    }

    public static String getHTML(IMolecularFormula formula, boolean chargeB, boolean isotopeB) {
        String[] orderElements = MolecularFormulaManipulator.containsElement(formula, formula.getBuilder().newInstance(IElement.class, "C")) ? MolecularFormulaManipulator.generateOrderEle_Hill_WithCarbons() : MolecularFormulaManipulator.generateOrderEle_Hill_NoCarbons();
        return MolecularFormulaManipulator.getHTML(formula, orderElements, chargeB, isotopeB);
    }

    public static String getHTML(IMolecularFormula formula, String[] orderElements, boolean showCharge, boolean showIsotopes) {
        StringBuilder sb = new StringBuilder();
        for (String orderElement : orderElements) {
            IElement element = formula.getBuilder().newInstance(IElement.class, orderElement);
            if (!MolecularFormulaManipulator.containsElement(formula, element)) continue;
            if (!showIsotopes) {
                sb.append(element.getSymbol());
                int n = MolecularFormulaManipulator.getElementCount(formula, element);
                if (n <= 1) continue;
                sb.append("<sub>").append(n).append("</sub>");
                continue;
            }
            for (IIsotope isotope : MolecularFormulaManipulator.getIsotopes(formula, element)) {
                Integer massNumber = isotope.getMassNumber();
                if (massNumber != null) {
                    sb.append("<sup>").append(massNumber).append("</sup>");
                }
                sb.append(isotope.getSymbol());
                int n = formula.getIsotopeCount(isotope);
                if (n <= 1) continue;
                sb.append("<sub>").append(n).append("</sub>");
            }
        }
        if (showCharge) {
            Integer charge = formula.getCharge();
            if (charge == CDKConstants.UNSET || charge == 0) {
                return sb.toString();
            }
            sb.append("<sup>");
            if (charge > 1 || charge < -1) {
                sb.append(Math.abs(charge));
            }
            if (charge > 0) {
                sb.append('+');
            } else {
                sb.append('\u2013');
            }
            sb.append("</sup>");
        }
        return sb.toString();
    }

    public static IMolecularFormula getMolecularFormula(String stringMF, IChemObjectBuilder builder) {
        return MolecularFormulaManipulator.getMolecularFormula(stringMF, false, builder);
    }

    public static IMolecularFormula getMajorIsotopeMolecularFormula(String stringMF, IChemObjectBuilder builder) {
        return MolecularFormulaManipulator.getMolecularFormula(stringMF, true, builder);
    }

    private static IMolecularFormula getMolecularFormula(String stringMF, boolean assumeMajorIsotope, IChemObjectBuilder builder) {
        IMolecularFormula formula = builder.newInstance(IMolecularFormula.class, new Object[0]);
        return MolecularFormulaManipulator.getMolecularFormula(stringMF, formula, assumeMajorIsotope);
    }

    public static IMolecularFormula getMolecularFormula(String stringMF, IMolecularFormula formula) {
        return MolecularFormulaManipulator.getMolecularFormula(stringMF, formula, false);
    }

    private static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    private static boolean isLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isSign(char c) {
        return c == '+' || c == '-' || c == '\u2013';
    }

    private static boolean parseIsotope(CharIter iter, IMolecularFormula mf, boolean setMajor) {
        Elements elem = null;
        int mass = 0;
        int count = 0;
        if (iter.nextIf('[')) {
            mass = iter.nextUInt();
            if (mass < 0) {
                return false;
            }
            elem = iter.nextElement();
            if (!iter.nextIf(']')) {
                return false;
            }
        }
        if (elem == null && (elem = iter.nextElement()) == null) {
            return false;
        }
        count = iter.nextUInt();
        if (count < 0) {
            count = 1;
        }
        IIsotope isotope = mf.getBuilder().newInstance(IIsotope.class, elem.symbol());
        isotope.setAtomicNumber(elem.number());
        if (mass != 0) {
            isotope.setMassNumber(mass);
        } else if (setMajor) {
            try {
                IIsotope major = Isotopes.getInstance().getMajorIsotope(elem.number());
                if (major != null) {
                    isotope.setMassNumber(major.getMassNumber());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        mf.addIsotope(isotope, count);
        return true;
    }

    private static IMolecularFormula getMolecularFormula(String stringMF, IMolecularFormula formula, boolean assumeMajorIsotope) {
        int pos;
        if (stringMF.contains(".") || stringMF.contains("(") || stringMF.length() > 0 && stringMF.charAt(0) >= '0' && stringMF.charAt(0) <= '9') {
            stringMF = MolecularFormulaManipulator.simplifyMolecularFormula(stringMF);
        }
        Integer charge = null;
        if ((stringMF.contains("+") || stringMF.contains(HYPHEN_STR) || stringMF.contains(MINUS_STR)) && (pos = MolecularFormulaManipulator.findChargePosition(stringMF)) >= 0 && pos != stringMF.length()) {
            charge = MolecularFormulaManipulator.parseCharge(new CharIter(pos, stringMF));
            if ((stringMF = stringMF.substring(0, pos)).charAt(0) == '[' && stringMF.charAt(stringMF.length() - 1) == ']') {
                stringMF = stringMF.substring(1, stringMF.length() - 1);
            }
        }
        if (stringMF.isEmpty()) {
            return null;
        }
        int len = stringMF.length();
        CharIter iter = new CharIter(0, stringMF);
        iter.str = stringMF;
        while (iter.pos < len) {
            if (MolecularFormulaManipulator.parseIsotope(iter, formula, assumeMajorIsotope)) continue;
            LoggingToolFactory.createLoggingTool(MolecularFormulaManipulator.class).error("Could not parse MF: " + iter.str);
            return null;
        }
        if (charge != null) {
            formula.setCharge(charge);
        }
        return formula;
    }

    private static int parseCharge(CharIter iter) {
        int sign = 0;
        int number = iter.nextUInt();
        switch (iter.next()) {
            case '+': {
                sign = 1;
                break;
            }
            case '-': 
            case '\u2013': {
                sign = -1;
            }
        }
        if (number < 0) {
            number = iter.nextUInt();
        }
        if (number < 0) {
            number = 1;
        }
        if (sign == 0) {
            switch (iter.next()) {
                case '+': {
                    sign = 1;
                    break;
                }
                case '-': 
                case '\u2013': {
                    sign = -1;
                }
            }
        }
        return sign * number;
    }

    private static int findChargePosition(String formula) {
        int end;
        int pos;
        for (pos = end = formula.length() - 1; pos >= 0 && MolecularFormulaManipulator.isSign(formula.charAt(pos)); --pos) {
        }
        int mark1 = pos;
        while (pos >= 0 && MolecularFormulaManipulator.isDigit(formula.charAt(pos))) {
            --pos;
        }
        int mark2 = pos;
        while (pos >= 0 && MolecularFormulaManipulator.isSign(formula.charAt(pos))) {
            --pos;
        }
        if (pos == mark2 && formula.charAt(pos) != ']') {
            pos = mark1;
        }
        return pos + 1;
    }

    @Deprecated
    public static double getTotalExactMass(IMolecularFormula formula) {
        return MolecularFormulaManipulator.correctMass(MolecularFormulaManipulator.getMass(formula, 3), formula.getCharge());
    }

    private static double correctMass(double mass, Integer charge) {
        if (charge == null) {
            return mass;
        }
        double massE = 5.4857990927E-4;
        if (charge > 0) {
            mass -= massE * (double)charge.intValue();
        } else if (charge < 0) {
            mass += massE * (double)Math.abs(charge);
        }
        return mass;
    }

    public static double getTotalMassNumber(IMolecularFormula formula) {
        double mass = 0.0;
        for (IIsotope isotope : formula.isotopes()) {
            try {
                IIsotope isotope2 = Isotopes.getInstance().getMajorIsotope(isotope.getSymbol());
                if (isotope2 == null) continue;
                mass += (double)(isotope2.getMassNumber() * formula.getIsotopeCount(isotope));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return mass;
    }

    private static double getExactMass(IsotopeFactory isofact, IIsotope atom) {
        if (atom.getExactMass() != null) {
            return atom.getExactMass();
        }
        if (atom.getMassNumber() != null) {
            return isofact.getExactMass(atom.getAtomicNumber(), atom.getMassNumber());
        }
        return isofact.getMajorIsotopeMass(atom.getAtomicNumber());
    }

    private static double getMassOrAvg(IsotopeFactory isofact, IIsotope atom) {
        if (atom.getMassNumber() == null || atom.getMassNumber() == 0) {
            return isofact.getNaturalMass(atom);
        }
        return MolecularFormulaManipulator.getExactMass(isofact, atom);
    }

    public static double getMass(IMolecularFormula mf, int flav) {
        Isotopes isofact;
        try {
            isofact = Isotopes.getInstance();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load Isotopes!");
        }
        double mass = 0.0;
        switch (flav & 0xF) {
            case 1: {
                for (IIsotope iso : mf.isotopes()) {
                    mass += (double)mf.getIsotopeCount(iso) * MolecularFormulaManipulator.getMassOrAvg(isofact, iso);
                }
                break;
            }
            case 2: {
                for (IIsotope iso : mf.isotopes()) {
                    mass += (double)mf.getIsotopeCount(iso) * isofact.getNaturalMass(iso.getAtomicNumber());
                }
                break;
            }
            case 3: {
                for (IIsotope iso : mf.isotopes()) {
                    mass += (double)mf.getIsotopeCount(iso) * MolecularFormulaManipulator.getExactMass(isofact, iso);
                }
                break;
            }
            case 4: {
                IMolecularFormula mamf = MolecularFormulaManipulator.getMostAbundant(mf);
                if (mamf == null) break;
                mass = MolecularFormulaManipulator.getMass(mamf, 3);
            }
        }
        return mass;
    }

    public static double getMass(IMolecularFormula mf) {
        return MolecularFormulaManipulator.getMass(mf, 1);
    }

    @Deprecated
    public static double getNaturalExactMass(IMolecularFormula formula) {
        return MolecularFormulaManipulator.getMass(formula, 2);
    }

    @Deprecated
    public static double getMajorIsotopeMass(IMolecularFormula formula) {
        return MolecularFormulaManipulator.getMass(formula, 3);
    }

    public static double getTotalNaturalAbundance(IMolecularFormula formula) {
        double abundance = 1.0;
        for (IIsotope isotope : formula.isotopes()) {
            if (isotope.getNaturalAbundance() == null) {
                return 0.0;
            }
            abundance *= Math.pow(isotope.getNaturalAbundance(), formula.getIsotopeCount(isotope));
        }
        return abundance / Math.pow(100.0, MolecularFormulaManipulator.getAtomCount(formula));
    }

    public static double getDBE(IMolecularFormula formula) throws CDKException {
        int[] valencies = new int[5];
        IAtomContainer ac = MolecularFormulaManipulator.getAtomContainer(formula);
        AtomTypeFactory factory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/structgen_atomtypes.xml", ac.getBuilder());
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            IAtomType[] types = factory.getAtomTypes(ac.getAtom(f).getSymbol());
            if (types.length == 0) {
                throw new CDKException("Calculation of double bond equivalents not possible due to problems with element " + ac.getAtom(f).getSymbol());
            }
            int n = types[0].getBondOrderSum().intValue();
            valencies[n] = valencies[n] + 1;
        }
        return 1 + valencies[4] + valencies[3] / 2 - valencies[1] / 2;
    }

    public static IMolecularFormula getMolecularFormula(IAtomContainer atomContainer) {
        IMolecularFormula formula = atomContainer.getBuilder().newInstance(IMolecularFormula.class, new Object[0]);
        return MolecularFormulaManipulator.getMolecularFormula(atomContainer, formula);
    }

    public static IMolecularFormula getMolecularFormula(IAtomContainer atomContainer, IMolecularFormula formula) {
        Set mattach = null;
        List sgroups = (List)atomContainer.getProperty("cdk:CtabSgroups");
        if (sgroups != null) {
            for (Sgroup sgroup : sgroups) {
                if (sgroup.getType() != SgroupType.ExtMulticenter) continue;
                for (IBond bond : sgroup.getBonds()) {
                    for (IAtom atom : sgroup.getAtoms()) {
                        if (!bond.contains(atom)) continue;
                        if (mattach == null) {
                            mattach = new HashSet();
                        }
                        mattach.add(atom);
                    }
                }
            }
        }
        if (mattach == null) {
            mattach = Collections.emptySet();
        }
        int charge = 0;
        int hcnt = 0;
        for (IAtom atm : atomContainer.atoms()) {
            if (atm instanceof IPseudoAtom && ((IPseudoAtom)atm).getAttachPointNum() != 0 || mattach.contains(atm)) continue;
            formula.addIsotope(atm);
            if (atm.getFormalCharge() != null) {
                charge += atm.getFormalCharge().intValue();
            }
            if (atm.getImplicitHydrogenCount() == null) continue;
            hcnt += atm.getImplicitHydrogenCount().intValue();
        }
        if (hcnt != 0) {
            IAtom hAtom = atomContainer.getBuilder().newInstance(IAtom.class, "H");
            formula.addIsotope(hAtom, hcnt);
        }
        formula.setCharge(charge);
        return formula;
    }

    public static IAtomContainer getAtomContainer(IMolecularFormula formula) {
        IAtomContainer atomContainer = formula.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        return MolecularFormulaManipulator.getAtomContainer(formula, atomContainer);
    }

    public static IAtomContainer getAtomContainer(IMolecularFormula formula, IAtomContainer atomContainer) {
        for (IIsotope isotope : formula.isotopes()) {
            int occur = formula.getIsotopeCount(isotope);
            for (int i = 0; i < occur; ++i) {
                IAtom atom = formula.getBuilder().newInstance(IAtom.class, isotope);
                atom.setImplicitHydrogenCount(0);
                atomContainer.addAtom(atom);
            }
        }
        return atomContainer;
    }

    public static IAtomContainer getAtomContainer(String formulaString, IChemObjectBuilder builder) {
        return MolecularFormulaManipulator.getAtomContainer(MolecularFormulaManipulator.getMolecularFormula(formulaString, builder));
    }

    public static String[] generateOrderEle() {
        return new String[]{"C", "H", "O", "N", "Si", "P", "S", "F", "Cl", "Br", "I", "Sn", "B", "Pb", "Tl", "Ba", "In", "Pd", "Pt", "Os", "Ag", "Zr", "Se", "Zn", "Cu", "Ni", "Co", "Fe", "Cr", "Ti", "Ca", "K", "Al", "Mg", "Na", "Ce", "Hg", "Au", "Ir", "Re", "W", "Ta", "Hf", "Lu", "Yb", "Tm", "Er", "Ho", "Dy", "Tb", "Gd", "Eu", "Sm", "Pm", "Nd", "Pr", "La", "Cs", "Xe", "Te", "Sb", "Cd", "Rh", "Ru", "Tc", "Mo", "Nb", "Y", "Sr", "Rb", "Kr", "As", "Ge", "Ga", "Mn", "V", "Sc", "Ar", "Ne", "He", "Be", "Li", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", "R"};
    }

    private static String[] generateOrderEle_Hill_NoCarbons() {
        return new String[]{"Ac", "Ag", "Al", "Am", "Ar", "As", "At", "Au", "B", "Ba", "Be", "Bh", "Bi", "Bk", "Br", "C", "Ca", "Cd", "Ce", "Cf", "Cl", "Cm", "Cn", "Co", "Cr", "Cs", "Cu", "Db", "Ds", "Dy", "Er", "Es", "Eu", "F", "Fe", "Fm", "Fr", "Ga", "Gd", "Ge", "H", "He", "Hf", "Hg", "Ho", "Hs", "I", "In", "Ir", "K", "Kr", "La", "Li", "Lr", "Lu", "Md", "Mg", "Mn", "Mo", "Mt", "N", "Na", "Nb", "Nd", "Ne", "Ni", "No", "Np", "O", "Os", "P", "Pa", "Pb", "Pd", "Pm", "Po", "Pr", "Pt", "Pu", "Ra", "Rb", "Re", "Rf", "Rg", "Rh", "Rn", "Ru", "S", "Sb", "Sc", "Se", "Sg", "Si", "Sm", "Sn", "Sr", "Ta", "Tb", "Tc", "Te", "Th", "Ti", "Tl", "Tm", "U", "V", "W", "Xe", "Y", "Yb", "Zn", "Zr", "R"};
    }

    private static String[] generateOrderEle_Hill_WithCarbons() {
        return new String[]{"C", "H", "Ac", "Ag", "Al", "Am", "Ar", "As", "At", "Au", "B", "Ba", "Be", "Bh", "Bi", "Bk", "Br", "Ca", "Cd", "Ce", "Cf", "Cl", "Cm", "Cn", "Co", "Cr", "Cs", "Cu", "Db", "Ds", "Dy", "Er", "Es", "Eu", "F", "Fe", "Fm", "Fr", "Ga", "Gd", "Ge", "He", "Hf", "Hg", "Ho", "Hs", "I", "In", "Ir", "K", "Kr", "La", "Li", "Lr", "Lu", "Md", "Mg", "Mn", "Mo", "Mt", "N", "Na", "Nb", "Nd", "Ne", "Ni", "No", "Np", "O", "Os", "P", "Pa", "Pb", "Pd", "Pm", "Po", "Pr", "Pt", "Pu", "Ra", "Rb", "Re", "Rf", "Rg", "Rh", "Rn", "Ru", "S", "Sb", "Sc", "Se", "Sg", "Si", "Sm", "Sn", "Sr", "Ta", "Tb", "Tc", "Te", "Th", "Ti", "Tl", "Tm", "U", "V", "W", "Xe", "Y", "Yb", "Zn", "Zr", "R"};
    }

    public static boolean compare(IMolecularFormula formula1, IMolecularFormula formula2) {
        if (!Objects.equals(formula1.getCharge(), formula2.getCharge())) {
            return false;
        }
        if (formula1.getIsotopeCount() != formula2.getIsotopeCount()) {
            return false;
        }
        for (IIsotope isotope : formula1.isotopes()) {
            if (!formula2.contains(isotope)) {
                return false;
            }
            if (formula1.getIsotopeCount(isotope) == formula2.getIsotopeCount(isotope)) continue;
            return false;
        }
        for (IIsotope isotope : formula2.isotopes()) {
            if (!formula1.contains(isotope)) {
                return false;
            }
            if (formula2.getIsotopeCount(isotope) == formula1.getIsotopeCount(isotope)) continue;
            return false;
        }
        return true;
    }

    public static List<IElement> getHeavyElements(IMolecularFormula formula) {
        ArrayList<IElement> newEle = new ArrayList<IElement>();
        for (IElement element : MolecularFormulaManipulator.elements(formula)) {
            if (element.getSymbol().equals("H")) continue;
            newEle.add(element);
        }
        return newEle;
    }

    public static String simplifyMolecularFormula(String formula) {
        String newFormula = formula;
        if (formula.contains(" ")) {
            newFormula = newFormula.replace(" ", "");
        }
        if (!formula.contains(".")) {
            return MolecularFormulaManipulator.breakExtractor(formula);
        }
        ArrayList<String> listMF = new ArrayList<String>();
        while (newFormula.contains(".")) {
            int pos = newFormula.indexOf(46);
            String thisFormula = newFormula.substring(0, pos);
            if (thisFormula.charAt(0) >= '0' && thisFormula.charAt(0) <= '9') {
                thisFormula = MolecularFormulaManipulator.multipleExtractor(thisFormula);
            }
            if (thisFormula.contains("(")) {
                thisFormula = MolecularFormulaManipulator.breakExtractor(thisFormula);
            }
            listMF.add(thisFormula);
            thisFormula = newFormula.substring(pos + 1, newFormula.length());
            if (!thisFormula.contains(".")) {
                if (thisFormula.charAt(0) >= '0' && thisFormula.charAt(0) <= '9') {
                    thisFormula = MolecularFormulaManipulator.multipleExtractor(thisFormula);
                }
                if (thisFormula.contains("(")) {
                    thisFormula = MolecularFormulaManipulator.breakExtractor(thisFormula);
                }
                listMF.add(thisFormula);
            }
            newFormula = thisFormula;
        }
        if (newFormula.contains("(")) {
            newFormula = MolecularFormulaManipulator.breakExtractor(newFormula);
        }
        String recentElementSymbol = "";
        String recentElementCountString = "0";
        ArrayList<String> eleSymb = new ArrayList<String>();
        ArrayList<Integer> eleCount = new ArrayList<Integer>();
        for (int i = 0; i < listMF.size(); ++i) {
            String thisFormula = (String)listMF.get(i);
            for (int f = 0; f < thisFormula.length(); ++f) {
                int countA;
                char thisChar = thisFormula.charAt(f);
                if (f < thisFormula.length()) {
                    if (thisChar >= 'A' && thisChar <= 'Z') {
                        recentElementSymbol = String.valueOf(thisChar);
                        recentElementCountString = "0";
                    }
                    if (thisChar >= 'a' && thisChar <= 'z') {
                        recentElementSymbol = recentElementSymbol + thisChar;
                    }
                    if (thisChar >= '0' && thisChar <= '9') {
                        recentElementCountString = recentElementCountString + thisChar;
                    }
                }
                if (f != thisFormula.length() - 1 && (thisFormula.charAt(f + 1) < 'A' || thisFormula.charAt(f + 1) > 'Z')) continue;
                int posit = eleSymb.indexOf(recentElementSymbol);
                int count = Integer.valueOf(recentElementCountString);
                if (posit == -1) {
                    eleSymb.add(recentElementSymbol);
                    eleCount.add(count);
                    continue;
                }
                int countP = Integer.valueOf(recentElementCountString);
                if (countP == 0) {
                    countP = 1;
                }
                if ((countA = ((Integer)eleCount.get(posit)).intValue()) == 0) {
                    countA = 1;
                }
                int value = countP + countA;
                eleCount.remove(posit);
                eleCount.add(posit, value);
            }
        }
        String newF = "";
        for (int i = 0; i < eleCount.size(); ++i) {
            String element = (String)eleSymb.get(i);
            int num = (Integer)eleCount.get(i);
            newF = num == 0 ? newF + element : newF + element + num;
        }
        return newF;
    }

    private static String breakExtractor(String formula) {
        boolean finalBreak = false;
        int innerMostBracket = formula.lastIndexOf("(");
        if (innerMostBracket < 0) {
            return formula;
        }
        String finalformula = formula.substring(0, innerMostBracket);
        String multipliedformula = "";
        String formulaEnd = "";
        String multiple = "";
        for (int f = innerMostBracket + 1; f < formula.length(); ++f) {
            char thisChar = formula.charAt(f);
            if (finalBreak) {
                if (MolecularFormulaManipulator.isDigit(thisChar)) {
                    multiple = multiple + thisChar;
                    continue;
                }
                formulaEnd = formula.substring(f, formula.length());
                break;
            }
            if (thisChar == ')') {
                finalBreak = true;
                continue;
            }
            multipliedformula = multipliedformula + thisChar;
        }
        if ((finalformula = finalformula + MolecularFormulaManipulator.muliplier(multipliedformula, multiple.isEmpty() ? 1 : Integer.valueOf(multiple)) + formulaEnd).contains("(")) {
            return MolecularFormulaManipulator.breakExtractor(finalformula);
        }
        return finalformula;
    }

    private static String multipleExtractor(String formula) {
        String recentCompoundCount = "0";
        String recentCompound = "";
        boolean found = false;
        for (int f = 0; f < formula.length(); ++f) {
            char thisChar = formula.charAt(f);
            if (thisChar >= '0' && thisChar <= '9') {
                if (!found) {
                    recentCompoundCount = recentCompoundCount + thisChar;
                    continue;
                }
                recentCompound = recentCompound + thisChar;
                continue;
            }
            found = true;
            recentCompound = recentCompound + thisChar;
        }
        return MolecularFormulaManipulator.muliplier(recentCompound, Integer.valueOf(recentCompoundCount));
    }

    private static String muliplier(String formula, int factor) {
        String finalformula = "";
        String recentElementSymbol = "";
        String recentElementCountString = "0";
        for (int f = 0; f < formula.length(); ++f) {
            char thisChar = formula.charAt(f);
            if (f < formula.length()) {
                if (thisChar >= 'A' && thisChar <= 'Z') {
                    recentElementSymbol = String.valueOf(thisChar);
                    recentElementCountString = "0";
                }
                if (thisChar >= 'a' && thisChar <= 'z') {
                    recentElementSymbol = recentElementSymbol + thisChar;
                }
                if (thisChar >= '0' && thisChar <= '9') {
                    recentElementCountString = recentElementCountString + thisChar;
                }
            }
            if (f != formula.length() - 1 && (formula.charAt(f + 1) < 'A' || formula.charAt(f + 1) > 'Z')) continue;
            Integer recentElementCount = Integer.valueOf(recentElementCountString);
            finalformula = recentElementCount == 0 ? finalformula + recentElementSymbol + factor : finalformula + recentElementSymbol + recentElementCount * factor;
        }
        return finalformula;
    }

    public static boolean adjustProtonation(IMolecularFormula mf, int hcnt) {
        if (mf == null) {
            throw new NullPointerException("No formula provided");
        }
        if (hcnt == 0) {
            return false;
        }
        IChemObjectBuilder bldr = mf.getBuilder();
        int chg = mf.getCharge() != null ? mf.getCharge() : 0;
        IIsotope proton = null;
        int pcount = 0;
        for (IIsotope iso : mf.isotopes()) {
            int count;
            if (!"H".equals(iso.getSymbol()) || (count = mf.getIsotopeCount(iso)) < hcnt) continue;
            if (proton == null && (iso.getMassNumber() == null || iso.getMassNumber() == 1)) {
                proton = iso;
                pcount = count;
                continue;
            }
            if (proton == null || iso.getMassNumber() == null || iso.getMassNumber() != 1 || proton.getMassNumber() != null) continue;
            proton = iso;
            pcount = count;
        }
        if (proton == null && hcnt < 0) {
            return false;
        }
        if (proton == null && hcnt > 0) {
            proton = bldr.newInstance(IIsotope.class, "H");
            proton.setMassNumber(1);
        }
        mf.removeIsotope(proton);
        if (pcount + hcnt > 0) {
            mf.addIsotope(proton, pcount + hcnt);
        }
        mf.setCharge(chg + hcnt);
        return true;
    }

    private static boolean addIsotopeDist(IMolecularFormula mf, IIsotope[] isotopes, int idx, int count) {
        if (count == 0) {
            return true;
        }
        double frac = 100.0;
        for (int i = 0; i < idx; ++i) {
            frac -= isotopes[i].getNaturalAbundance().doubleValue();
        }
        double p = isotopes[idx].getNaturalAbundance() / frac;
        if (p >= 1.0) {
            mf.addIsotope(isotopes[idx], count);
            return true;
        }
        double kMin = (double)(count + 1) * (1.0 - p) - 1.0;
        double kMax = (double)(count + 1) * (1.0 - p);
        if ((int)Math.ceil(kMin) == (int)Math.floor(kMax)) {
            int k = (int)kMax;
            mf.addIsotope(isotopes[idx], count - k);
            return MolecularFormulaManipulator.addIsotopeDist(mf, isotopes, idx + 1, k);
        }
        return false;
    }

    public static IMolecularFormula getMostAbundant(IMolecularFormula mf) {
        Isotopes isofact;
        try {
            isofact = Isotopes.getInstance();
        }
        catch (IOException e) {
            return null;
        }
        IMolecularFormula res = mf.getBuilder().newInstance(IMolecularFormula.class, new Object[0]);
        for (IIsotope iso : mf.isotopes()) {
            int count = mf.getIsotopeCount(iso);
            if (iso.getMassNumber() == null || iso.getMassNumber() == 0) {
                IIsotope[] isotopes = isofact.getIsotopes(iso.getSymbol());
                Arrays.sort(isotopes, NAT_ABUN_COMP);
                if (MolecularFormulaManipulator.addIsotopeDist(res, isotopes, 0, count)) continue;
                return null;
            }
            res.addIsotope(iso, count);
        }
        return res;
    }

    public static IMolecularFormula getMostAbundant(IAtomContainer mol2) {
        return MolecularFormulaManipulator.getMostAbundant(MolecularFormulaManipulator.getMolecularFormula(mol2));
    }

    private static final class CharIter {
        int pos;
        String str;

        public CharIter(int pos, String str) {
            this.pos = pos;
            this.str = str;
        }

        char next() {
            return this.pos == this.str.length() ? (char)'\u0000' : this.str.charAt(this.pos++);
        }

        int nextUInt() {
            char c = this.next();
            if (!MolecularFormulaManipulator.isDigit(c)) {
                if (c != '\u0000') {
                    --this.pos;
                }
                return -1;
            }
            int res = c - 48;
            while (MolecularFormulaManipulator.isDigit(c = this.next())) {
                res = 10 * res + (c - 48);
            }
            if (c != '\u0000') {
                --this.pos;
            }
            return res;
        }

        Elements nextElement() {
            char c1 = this.next();
            if (!MolecularFormulaManipulator.isUpper(c1)) {
                if (c1 != '\u0000') {
                    --this.pos;
                }
                return null;
            }
            char c2 = this.next();
            if (!MolecularFormulaManipulator.isLower(c2)) {
                if (c2 != '\u0000') {
                    --this.pos;
                }
                return Elements.ofString("" + c1);
            }
            return Elements.ofString("" + c1 + c2);
        }

        boolean nextIf(char c) {
            if (this.str.charAt(this.pos) == c) {
                ++this.pos;
                return true;
            }
            return false;
        }
    }
}

