/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.attribute;

import nu.xom.Attribute;
import org.xmlcml.cml.base.StringSTAttribute;
import org.xmlcml.euclid.Util;

public class DelimiterAttribute
extends StringSTAttribute {
    public static final String NAME = "delimiter";
    private String splitter = null;
    private String concat = null;

    public DelimiterAttribute() {
        super(NAME);
    }

    public DelimiterAttribute(String value) {
        super(NAME);
        this.setCMLValue(value);
    }

    public DelimiterAttribute(Attribute att) throws RuntimeException {
        super(att);
        this.setCMLValue(att.getValue());
    }

    public void setCMLValue(String value) throws RuntimeException {
        if (value == null) {
            value = " ";
        }
        if ((value = value.trim()).equals("")) {
            value = " ";
        } else if (value.length() > 1) {
            throw new RuntimeException("Non-whitespace delimiter must only be single character");
        }
        super.setCMLValue(value);
        if (value.equals(" ")) {
            this.setSplitter("\\s+");
            this.setConcat(" ");
        } else {
            this.setSplitter(DelimiterAttribute.getEscapedDelimiter(value));
            this.setConcat(value);
        }
    }

    public String getConcat() {
        return this.concat;
    }

    public void setConcat(String concat) {
        this.concat = concat;
    }

    public String getSplitter() {
        return this.splitter;
    }

    public void setSplitter(String splitter) {
        this.splitter = splitter;
    }

    private static String getEscapedDelimiter(String delim) {
        String delim1 = delim;
        if (delim.length() == 1 && (delim.equals("|") || delim.equals("?") || delim.equals("*") || delim.equals("."))) {
            delim1 = "\\" + delim;
        }
        return delim1;
    }

    public String[] getSplitContent(String content) {
        String[] ss = new String[]{};
        if ((content = content.trim()).length() > 0) {
            if (!this.isWhitespace()) {
                if (content.startsWith(this.concat)) {
                    content = content.substring(1);
                }
                if (content.endsWith(this.concat)) {
                    content = content.substring(0, content.length() - this.concat.length());
                }
            }
            ss = content.split(this.splitter);
        }
        return ss;
    }

    public void checkDelimiter(String s2) throws RuntimeException {
        if (s2.split(this.splitter).length > 1) {
            throw new RuntimeException("cannot delimit {" + s2 + "} with {" + this.concat + "}");
        }
    }

    public String getDelimitedXMLContent(String s2) {
        if (s2 == null) {
            s2 = "";
        }
        if (!s2.equals("") && !this.isWhitespace()) {
            if (!s2.startsWith(this.concat)) {
                s2 = this.concat + s2;
            }
            if (!s2.endsWith(this.concat)) {
                s2 = s2 + this.concat;
            }
        }
        return s2;
    }

    public String appendXMLContent(String s2, String snew) {
        s2 = this.getDelimitedXMLContent(s2);
        s2 = !this.isWhitespace() ? (s2.length() == 0 ? this.concat + snew + this.concat : s2 + snew + this.concat) : s2 + this.concat + snew;
        return s2;
    }

    private boolean isWhitespace() {
        return "\\s+".equals(this.splitter);
    }

    public String getDelimitedXMLContent(String[] ss) {
        for (String s2 : ss) {
            this.checkDelimiter(s2);
        }
        String s3 = Util.concatenate(ss, this.concat);
        if (!this.isWhitespace()) {
            s3 = this.concat + s3 + this.concat;
        }
        return s3;
    }

    public String getDelimitedXMLContent(boolean[] bb) {
        for (boolean b : bb) {
            this.checkDelimiter("" + b);
        }
        String s2 = Util.concatenate(bb, this.concat);
        if (!this.isWhitespace()) {
            s2 = this.concat + s2 + this.concat;
        }
        return s2;
    }

    public String getDelimitedXMLContent(double[] dd) {
        for (double d : dd) {
            this.checkDelimiter("" + d);
        }
        String s2 = Util.concatenate(dd, this.concat);
        if (!this.isWhitespace()) {
            s2 = this.concat + s2 + this.concat;
        }
        return s2;
    }

    public String getDelimitedXMLContent(int[] ii) {
        for (int i : ii) {
            this.checkDelimiter("" + i);
        }
        String s2 = Util.concatenate(ii, this.concat);
        if (!this.isWhitespace()) {
            s2 = this.concat + s2 + this.concat;
        }
        return s2;
    }

    public void debug(String s2) {
        Util.println("-------- " + s2 + " -------");
        Util.println(this + " .. " + this.getValue() + " .. " + this.splitter + " .. " + this.concat);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        RESET,
        PRESERVE;

    }
}

