/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.xmlcml.euclid.Plane3;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.Real2;

public class EuclidTestUtils {
    public static String testEquals(double[] a, double[] b, double eps) {
        String s2 = null;
        if (a == null) {
            s2 = "a is null";
        } else if (b == null) {
            s2 = "b is null";
        } else if (a.length != b.length) {
            s2 = "unequal arrays: " + a.length + "/" + b.length;
        } else {
            for (int i = 0; i < a.length; ++i) {
                if (Real.isEqual(a[i], b[i], eps)) continue;
                s2 = "unequal element at (" + i + "), " + a[i] + " != " + b[i];
                break;
            }
        }
        return s2;
    }

    public static String testEquals(String msg, double[] a, double[] b, double eps) {
        String s2 = EuclidTestUtils.testEquals(a, b, eps);
        if (s2 != null) {
            s2 = msg + ": " + s2;
        }
        return s2;
    }

    static String testEquals(double[][] a, double[][] b, double eps) {
        String s2 = null;
        if (a == null) {
            s2 = "a is null";
        } else if (b == null) {
            s2 = "b is null";
        } else if (a.length != b.length) {
            s2 = "unequal arrays: " + a.length + "/" + b.length;
        } else {
            block0: for (int i = 0; i < a.length; ++i) {
                if (a[i].length != b[i].length) {
                    s2 = "row (" + i + ") has unequal lengths: " + a[i].length + "/" + b[i].length;
                    break;
                }
                for (int j = 0; j < a[i].length; ++j) {
                    if (Real.isEqual(a[i][j], b[i][j], eps)) continue;
                    s2 = "unequal element at (" + i + ", " + j + "), (" + a[i][j] + " != " + b[i][j] + ")";
                    continue block0;
                }
            }
        }
        return s2;
    }

    public static String testEquals(String msg, double[][] a, double[][] b, double eps) {
        String s2 = EuclidTestUtils.testEquals(a, b, eps);
        if (s2 != null) {
            s2 = msg + ": " + s2;
        }
        return s2;
    }

    public static String testEquals(Real2 a, Real2 b, double eps) {
        String s2 = null;
        if (a == null) {
            s2 = "a is null";
        } else if (b == null) {
            s2 = "b is null";
        } else if (!Real.isEqual(a.x, b.x, eps) || !Real.isEqual(a.y, b.y, eps)) {
            s2 = "" + a + " != " + b;
        }
        return s2;
    }

    public static String testEquals(String msg, Plane3 expected, Plane3 test, double epsilon) {
        String s2 = null;
        s2 = test == null ? msg + ": null test" : (expected == null ? msg + ": null expected" : EuclidTestUtils.testEquals(msg, expected.getArray(), test, epsilon));
        return s2;
    }

    public static String testEquals(String msg, double[] expected, Plane3 test, double epsilon) {
        String s2 = null;
        s2 = expected == null ? msg + ": expected should not be null" : (expected.length != 4 ? msg + ": expected must be of length 4; was " + expected.length : (test == null ? msg + ": test should not be null" : EuclidTestUtils.testEquals(msg, expected, test.getArray(), epsilon)));
        return s2;
    }
}

