/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.util.List;
import org.apache.log4j.Logger;
import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.RealMatrix;
import org.xmlcml.euclid.Transform2;
import org.xmlcml.euclid.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Real2
implements EuclidConstants {
    private static Logger LOG = Logger.getLogger(Real2.class);
    public double x;
    public double y;

    public Real2() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public Real2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Real2(String s2) {
        this(Util.splitToDoubleArray(s2, " "));
    }

    public Real2(String s2, String delimiter) {
        this(Util.splitToDoubleArray(s2, delimiter));
    }

    public Real2(double[] x) {
        if (x == null) {
            throw new EuclidRuntimeException("requires non-null array");
        }
        if (x.length != 2) {
            throw new EuclidRuntimeException("requires array of length 2; found: " + x.length);
        }
        this.x = x[0];
        this.y = x[1];
    }

    public Real2(Real2 r) {
        this.x = r.x;
        this.y = r.y;
    }

    public void swap() {
        double t = this.x;
        this.x = this.y;
        this.y = t;
    }

    public void sortAscending() {
        if (this.x > this.y) {
            this.swap();
        }
    }

    public void sortDescending() {
        if (this.x < this.y) {
            this.swap();
        }
    }

    public void clear() {
        this.y = 0.0;
        this.x = 0.0;
    }

    public void setX(double xx) {
        this.x = xx;
    }

    public void setY(double yy) {
        this.y = yy;
    }

    public boolean isEqualTo(Real2 r) {
        return Real.isEqual(this.x, r.x) && Real.isEqual(this.y, r.y);
    }

    public boolean isEqualTo(Real2 r, double eps) {
        return Real.isEqual(this.x, r.x, eps) && Real.isEqual(this.y, r.y, eps);
    }

    public boolean isOrigin() {
        return Real.isZero(this.x, Real.getEpsilon()) && Real.isZero(this.y, Real.getEpsilon());
    }

    public boolean isOrigin(double epsilon) {
        return Real.isZero(this.x, epsilon) && Real.isZero(this.y, epsilon);
    }

    public Real2 plus(Real2 r2) {
        return new Real2(this.x + r2.x, this.y + r2.y);
    }

    public void plusEquals(Real2 r2) {
        this.x += r2.x;
        this.y += r2.y;
    }

    public Real2 subtract(Real2 r2) {
        return new Real2(this.x - r2.x, this.y - r2.y);
    }

    public void negative() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public Real2 multiplyBy(double f) {
        return new Real2(this.x * f, this.y * f);
    }

    public void multiplyEquals(double f) {
        this.x *= f;
        this.y *= f;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double elementAt(int elem) throws EuclidRuntimeException {
        if (elem == 0) {
            return this.x;
        }
        if (elem == 1) {
            return this.y;
        }
        throw new EuclidRuntimeException("bad index " + elem);
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double getDistance(Real2 r) {
        return r == null ? Double.NaN : Math.sqrt((this.x - r.x) * (this.x - r.x) + (this.y - r.y) * (this.y - r.y));
    }

    public double getSquaredDistance(Real2 r) {
        return r == null ? Double.NaN : (this.x - r.x) * (this.x - r.x) + (this.y - r.y) * (this.y - r.y);
    }

    public Real2 getMidPoint(Real2 p) {
        return new Real2((this.x + p.x) / 2.0, (this.y + p.y) / 2.0);
    }

    public Real2 getUnitVector() {
        double length = this.getLength();
        if (Real.isZero(length, Real.getEpsilon())) {
            throw new EuclidRuntimeException("zero length vector");
        }
        Real2 temp = new Real2(this.x, this.y);
        temp = temp.multiplyBy(1.0 / length);
        return temp;
    }

    public double dotProduct(Real2 r) {
        return this.x * r.x + this.y * r.y;
    }

    public static Angle getAngle(Real2 p1, Real2 p2, Real2 p3) {
        if (p1 == null || p2 == null || p3 == null) {
            throw new RuntimeException("null coordinates");
        }
        double x1 = p1.x - p2.x;
        double y1 = p1.y - p2.y;
        double x3 = p3.x - p2.x;
        double y3 = p3.y - p2.y;
        double angle1 = Math.atan2(x1, y1);
        double angle3 = Math.atan2(x3, y3);
        double angle13 = angle1 - angle3;
        Angle angle123 = new Angle(angle13, Angle.Units.RADIANS);
        double d12 = p1.getDistance(p2);
        double d13 = p1.getDistance(p3);
        double d23 = p2.getDistance(p3);
        double cost = (-d13 * d13 + d12 * d12 + d23 * d23) / (2.0 * d12 * d23);
        double anglex = Math.acos(cost);
        LOG.trace("AAA " + anglex + "/" + angle13 + "//" + p1 + "/" + p2 + "/" + p3);
        return angle123;
    }

    public void transformBy(Transform2 t) {
        double xx = t.flmat[0][0] * this.x + t.flmat[0][1] * this.y + t.flmat[0][2];
        double yy = t.flmat[1][0] * this.x + t.flmat[1][1] * this.y + t.flmat[1][2];
        this.x = xx;
        this.y = yy;
    }

    public Real2 getTransformed(Transform2 t) {
        Real2 p = new Real2(this);
        p.transformBy(t);
        return p;
    }

    public static Real2[] addPolygonOnLine(Real2 point1, Real2 point2, int nPoints, int end, Real2 repelPoint) {
        double distb;
        double dista;
        double theta0;
        Real2 center0;
        if (end < 1) {
            end = 1;
        }
        Real2[] newPoints = new Real2[nPoints];
        Real2 mid = point1.getMidPoint(point2);
        double dTheta = Math.PI * 2 / (double)nPoints;
        double lineTheta = point1.subtract(point2).getAngle();
        double line2 = point1.subtract(mid).getLength();
        double halfTheta = 0.5 * (dTheta * (double)end);
        double dist = line2 / Math.tan(halfTheta);
        double angle = lineTheta - 1.5707963267948966;
        Real2 center = center0 = mid.makePoint(dist, angle);
        double theta = theta0 = -halfTheta + angle + Math.PI;
        if (repelPoint != null) {
            double tempDist = center.subtract(repelPoint).getLength();
            Real2 center1 = mid.makePoint(dist, angle + Math.PI);
            if (center1.subtract(repelPoint).getLength() > tempDist) {
                center = center1;
                dTheta = -dTheta;
                theta = halfTheta + angle;
            }
        }
        double rad = line2 / Math.sin(halfTheta);
        newPoints = Real2.makePoints(center, nPoints, rad, theta, dTheta);
        if (repelPoint != null && (dista = newPoints[1].subtract(repelPoint).getLength()) > (distb = newPoints[nPoints - 2].subtract(repelPoint).getLength())) {
            center = center0;
            dTheta = -dTheta;
            theta = theta0;
            newPoints = Real2.makePoints(center, nPoints, rad, theta, dTheta);
        }
        return newPoints;
    }

    private static Real2[] makePoints(Real2 center, int nPoints, double rad, double theta, double dTheta) {
        Real2[] points = new Real2[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            points[i] = center.makePoint(rad, theta);
            theta += dTheta;
        }
        return points;
    }

    public double getAngle() {
        return Math.atan2(this.y, this.x);
    }

    public Real2 makePoint(double rad, double theta) {
        Real2 point = new Real2();
        point.x = this.x + rad * Math.cos(theta);
        point.y = this.y + rad * Math.sin(theta);
        return point;
    }

    public static Real2 getCentroid(List<Real2> p2Vector) {
        if (p2Vector.size() < 1) {
            return null;
        }
        Real2 p = new Real2();
        for (int j = 0; j < p2Vector.size(); ++j) {
            p = p.plus(p2Vector.get(j));
        }
        double scale = 1.0 / new Double(p2Vector.size());
        p = p.multiplyBy(scale);
        return p;
    }

    public static int getSerialOfNearestPoint(List<Real2> p2v, Real2 point) {
        double dist = Double.MAX_VALUE;
        int serial = -1;
        for (int j = 0; j < p2v.size(); ++j) {
            double d = p2v.get(j).subtract(point).getLength();
            if (!(d < dist)) continue;
            serial = j;
            dist = d;
        }
        return serial;
    }

    public static RealMatrix getDistanceMatrix(List<Real2> coords1, List<Real2> coords2) {
        int size = coords1.size();
        int size2 = coords2.size();
        RealMatrix distMatrix = new RealMatrix(size, size2);
        double[][] distMatrixMat = distMatrix.getMatrix();
        for (int i = 0; i < size; ++i) {
            Real2 ri = coords1.get(i);
            for (int j = 0; j < size2; ++j) {
                double dij;
                Real2 rj = coords2.get(j);
                distMatrixMat[i][j] = dij = ri.getDistance(rj);
            }
        }
        return distMatrix;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public double[] getXY() {
        double[] dd = new double[]{this.x, this.y};
        return dd;
    }

    public Real2 format(int places) {
        this.x = Util.format(this.x, places);
        this.y = Util.format(this.y, places);
        return this;
    }
}

