/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.awt.Graphics;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.Transform2;

public class Window2 {
    public static final int X = 0;
    public static final int Y = 1;
    Real2 origin;
    Real2 farPoint;
    Real2 dim;

    public Window2(Real2 origin, Real2 farPoint) {
        this.origin = new Real2(origin);
        this.farPoint = new Real2(farPoint);
        this.getDim();
    }

    public Real2 getDim() {
        this.dim = new Real2(this.farPoint.getX() - this.origin.getX(), this.farPoint.getY() - this.origin.getY());
        return this.dim;
    }

    public Real2 getOrigin() {
        return this.origin;
    }

    public Real2 getFarPoint() {
        return this.farPoint;
    }

    public Real2 getExtent(int axis) {
        if (axis == 0) {
            return new Real2(this.origin.getX(), this.farPoint.getX());
        }
        if (axis == 1) {
            return new Real2(this.origin.getY(), this.farPoint.getY());
        }
        return null;
    }

    public void drawRect(Graphics g2) {
        int t;
        int x1 = (int)this.origin.getX();
        int x2 = (int)this.farPoint.getX();
        int y1 = (int)this.origin.getY();
        int y2 = (int)this.farPoint.getY();
        if (x1 > x2) {
            t = x2;
            x2 = x1;
            x1 = t;
        }
        if (y1 > y2) {
            t = y2;
            y2 = y1;
            y1 = t;
        }
        g2.drawRect(x1, y1, x2 - x1, y2 - y1);
    }

    public void fillRect(Graphics g2) {
        int t;
        int x1 = (int)this.origin.getX();
        int x2 = (int)this.farPoint.getX();
        int y1 = (int)this.origin.getY();
        int y2 = (int)this.farPoint.getY();
        if (x1 > x2) {
            t = x2;
            x2 = x1;
            x1 = t;
        }
        if (y1 > y2) {
            t = y2;
            y2 = y1;
            y1 = t;
        }
        g2.fillRect(x1, y1, x2 - x1, y2 - y1);
    }

    public void transformBy(Transform2 tr) {
        this.origin.transformBy(tr);
        this.farPoint.transformBy(tr);
        this.getDim();
    }

    public String toString() {
        return "Window2: " + this.origin + "/" + this.farPoint + "(" + this.dim + ")";
    }
}

