/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.InvalidSmilesException;

final class AddDirectionalLabels
extends AbstractFunction<Graph, Graph> {
    AddDirectionalLabels() {
    }

    @Override
    public Graph apply(Graph g2) throws InvalidSmilesException {
        int u;
        boolean altered;
        ArrayList<Edge> doublebonds = new ArrayList<Edge>();
        for (int u2 = 0; u2 < g2.order(); ++u2) {
            int d = g2.degree(u2);
            for (int j = 0; j < d; ++j) {
                Edge e = g2.edgeAt(u2, j);
                int v = e.other(u2);
                if (v <= u2 || e.bond() != Bond.DOUBLE || g2.degree(u2) < 2 || g2.degree(v) < 2 || g2.degree(u2) + g2.degree(v) <= 4) continue;
                doublebonds.add(e);
            }
        }
        if (doublebonds.isEmpty()) {
            return g2;
        }
        HashSet remain = new HashSet(doublebonds);
        HashMap<Edge, Edge> replacements = new HashMap<Edge, Edge>();
        HashSet<Edge> completed = new HashSet<Edge>();
        do {
            altered = false;
            for (Edge e : remain) {
                Status status = this.replaceImplWithExpl(g2, e, replacements);
                if (status == Status.WAITING) continue;
                completed.add(e);
                altered = true;
            }
            remain.removeAll(completed);
            completed.clear();
        } while (altered && !remain.isEmpty());
        if (remain.size() == doublebonds.size()) {
            return g2;
        }
        for (Edge e : remain) {
            int u3 = e.either();
            int v = e.other(u3);
            int d = g2.degree(u3);
            for (int j = 0; j < d; ++j) {
                Edge f = g2.edgeAt(u3, j);
                if (!this.isDirectional(f, replacements) || !this.safeToClean(g2, f.other(u3), replacements)) continue;
                replacements.put(f, new Edge(u3, f.other(u3), Bond.IMPLICIT));
            }
            int d2 = g2.degree(v);
            for (int j = 0; j < d2; ++j) {
                Edge f = g2.edgeAt(v, j);
                if (!this.isDirectional(f, replacements) || !this.safeToClean(g2, f.other(v), replacements)) continue;
                replacements.put(f, new Edge(v, f.other(v), Bond.IMPLICIT));
            }
        }
        Graph h2 = new Graph(g2.order());
        h2.addFlags(g2.getFlags(-1));
        for (u = 0; u < g2.order(); ++u) {
            h2.addAtom(g2.atom(u));
            h2.addTopology(g2.topologyOf(u));
        }
        for (u = 0; u < g2.order(); ++u) {
            int d = g2.degree(u);
            for (int j = 0; j < d; ++j) {
                Edge e = g2.edgeAt(u, j);
                if (e.other(u) >= u) continue;
                Edge replacement = (Edge)replacements.get(e);
                if (replacement != null) {
                    e = replacement;
                }
                h2.addEdge(e);
            }
        }
        return h2.sort(new Graph.CanOrderFirst());
    }

    private boolean isDirectional(Edge f, Map<Edge, Edge> replacements) {
        if (f.bond().directional()) {
            return true;
        }
        Edge g2 = replacements.get(f);
        return g2 != null && g2.bond().directional();
    }

    boolean safeToClean(Graph g2, int v, Map<Edge, Edge> replacements) {
        int d = g2.degree(v);
        for (int j = 0; j < d; ++j) {
            Edge e = g2.edgeAt(v, j);
            if (e.bond().order() != 2) continue;
            int w = e.other(v);
            int d2 = g2.degree(w);
            for (int j2 = 0; j2 < d2; ++j2) {
                Edge f = g2.edgeAt(w, j2);
                if (!this.isDirectional(f, replacements)) continue;
                return false;
            }
        }
        return true;
    }

    private Status replaceImplWithExpl(Graph g2, Edge e, Map<Edge, Edge> acc) throws InvalidSmilesException {
        Status vstat;
        int u = e.either();
        int v = e.other(u);
        Status ustat = this.replaceImplWithExpl(g2, e, u, acc);
        if (ustat == (vstat = this.replaceImplWithExpl(g2, e, v, acc))) {
            return ustat;
        }
        if (ustat == Status.INVALID && vstat != Status.WAITING) {
            return Status.INVALID;
        }
        if (vstat == Status.INVALID && ustat != Status.WAITING) {
            return Status.INVALID;
        }
        return Status.WAITING;
    }

    private Status replaceImplWithExpl(Graph g2, Edge e, int u, Map<Edge, Edge> acc) throws InvalidSmilesException {
        int v;
        Edge existing;
        Edge implicit = null;
        Edge explicit = null;
        for (Edge f : g2.edges(u)) {
            Edge f2 = acc.containsKey(f) ? acc.get(f) : f;
            switch (f2.bond(u)) {
                case SINGLE: 
                case IMPLICIT: 
                case IMPLICIT_AROMATIC: {
                    if (implicit != null) {
                        return Status.WAITING;
                    }
                    implicit = f;
                    break;
                }
                case DOUBLE: 
                case DOUBLE_AROMATIC: {
                    if (f.equals(e)) break;
                    return Status.COMPLETED;
                }
                case UP: 
                case DOWN: {
                    if (explicit != null) {
                        if (acc.containsKey(explicit)) {
                            explicit = acc.get(explicit);
                        }
                        if ((f.bond() == Bond.UP || f.bond() == Bond.DOWN) && explicit.bond(u).inverse() != f.bond(u)) {
                            return Status.INVALID;
                        }
                        if (explicit.bond(u).inverse() != f2.bond(u)) {
                            acc.put(f, f2.inverse());
                            BitSet visited = new BitSet();
                            visited.set(u);
                            this.invertExistingDirectionalLabels(g2, visited, acc, f2.other(u));
                        }
                        return Status.COMPLETED;
                    }
                    explicit = f;
                }
            }
        }
        if (implicit == null) {
            return Status.COMPLETED;
        }
        if (explicit == null) {
            return Status.WAITING;
        }
        if (acc.containsKey(explicit)) {
            explicit = acc.get(explicit);
        }
        if ((existing = acc.put(implicit, new Edge(u, v = implicit.other(u), explicit.bond(u).inverse()))) != null && existing.bond(u) != explicit.bond(u).inverse()) {
            throw new InvalidSmilesException("unable to assign explict type for " + implicit);
        }
        return Status.COMPLETED;
    }

    private void invertExistingDirectionalLabels(Graph g2, BitSet visited, Map<Edge, Edge> replacement, int u) {
        visited.set(u);
        if (g2.topologyOf(u) == null) {
            return;
        }
        for (Edge e : g2.edges(u)) {
            int v = e.other(u);
            if (visited.get(v)) continue;
            Edge f = replacement.get(e);
            if (f != null && f.bond().directional()) {
                replacement.put(e, f.inverse());
            } else if (e.bond().directional()) {
                replacement.put(e, e.inverse());
            }
            this.invertExistingDirectionalLabels(g2, visited, replacement, v);
        }
    }

    static enum Status {
        COMPLETED,
        WAITING,
        INVALID;

    }
}

