/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.AtomImpl;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.Topology;

final class ToSubsetAtoms
extends AbstractFunction<Graph, Graph> {
    ToSubsetAtoms() {
    }

    @Override
    public Graph apply(Graph g2) {
        Graph h2 = new Graph(g2.order());
        for (int u = 0; u < g2.order(); ++u) {
            Topology t = g2.topologyOf(u);
            if (t.type() == Configuration.Type.None) {
                h2.addAtom(ToSubsetAtoms.toSubset(g2.atom(u), g2, u));
                continue;
            }
            h2.addAtom(g2.atom(u));
            h2.addTopology(t);
        }
        for (Edge e : g2.edges()) {
            h2.addEdge(e);
        }
        return h2;
    }

    static Atom toSubset(Atom a, Graph g2, int u) {
        if (a.subset()) {
            return a;
        }
        if (!a.element().organic()) {
            return a;
        }
        if (a.charge() != 0 || a.atomClass() != 0 || a.isotope() >= 0) {
            return a;
        }
        Atom subset = a.aromatic() ? AtomImpl.AromaticSubset.ofElement(a.element()) : AtomImpl.AliphaticSubset.ofElement(a.element());
        int impliedHCount = subset.hydrogens(g2, u);
        return impliedHCount != a.hydrogens() ? a : subset;
    }
}

