"""
            DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
                    Version 2, December 2004
 Copyright (C) 2022 Christian "veeso" Visintin
 Everyone is permitted to copy and distribute verbatim or modified
 copies of this license document, and changing it is allowed as long
 as the name is changed.
            DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
  0. You just DO WHAT THE FUCK YOU WANT TO.
"""

from .api.santiebeati import SantiEBeatiClient
from .santo import Santo

from typing import List


class Factory(object):
    """Santi factory"""

    @staticmethod
    def make_santi_from_santiebeati() -> List[Santo]:
        """Get list of santi from santiebeati.it"""
        return SantiEBeatiClient().query_santi(1024)

    @staticmethod
    def make_santi_from_file(file: str) -> List[Santo]:
        """Make santi dictionary from a file (line by line)"""
        with open(file) as f:
            return list(map(lambda x: Santo(x.strip()), f.readlines()))

    @staticmethod
    def make_santi_from_local() -> List[Santo]:
        """Make a list of santi from local data"""
        return [
            Santo("Beata Aberilla"),
            Santo("Beata Barbara da Milano"),
            Santo("Beata Barbara Jeong Sun-mae"),
            Santo("Beata Bartolomea (Mea) da Siena"),
            Santo("Beata Bartolomea Carletti da Chivasso"),
            Santo("Beata Bartolomea da Siena"),
            Santo("Beata Beata Caterina da Valensasco"),
            Santo("Beata Camilla Díez Blanco"),
            Santo("Beata Camilla Gentili di Rovellone"),
            Santo("Beata Candelaria di San Giuseppe (Susanna Paz-Castillo Ramirez)"),
            Santo("Beata Candida da Como"),
            Santo("Beata Candida da Milazzo"),
            Santo("Beata Caterina Caldes Socias"),
            Santo("Beata Daniela di San Barnaba (Vicenta Achurra Gogenola)"),
            Santo("Beata Daria (Josefa Engracia) Andiarena Sagaseta"),
            Santo("Beata Faconda (Catalina) Margenat Roura"),
            Santo("Beata Gabriella di San Giovanni della Croce (Francisca Pons Sardá)"),
            Santo("Beata Gaetana Sterni"),
            Santo("Beata Hildegard Burjan"),
            Santo("Beata Ida di Boulogne"),
            Santo("Beata Ida di Lovanio"),
            Santo(
                "Beata Ifigenia di S. Matteo (Francesca Maria Susanna) de Gaillard de la Valdène"
            ),
            Santo("Beata Ildegarda (Hildegarda) di Kempten"),
            Santo("Beata Ildegonda"),
            Santo("Beata Josaphata Michaelina Hordashevska"),
            Santo("Beata Laura Vicuna"),
            Santo("Beata Maddalena Albrici"),
            Santo("Beata Maddalena Caterina Morano"),
            Santo(
                "Beata Maddalena del Santo Sacramento (Maddalena Francesca) de Justamond"
            ),
            Santo("Beata Maddalena della Concezione"),
            Santo("Beata Maddalena la Maggiore"),
            Santo("Beata Maddalena Panattieri"),
            Santo("Beata Mafalda"),
            Santo("Beata Maria Raffaella (Santina) Cimatti"),
            Santo("Beata Maria Restituta (Elena) Kafka"),
            Santo("Beata Natalia Tulasiewicz"),
            Santo("Beata Nemesia (Giulia) Valle"),
            Santo("Beata Oda"),
            Santo("Beata Odette Prévost"),
            Santo("Beata Olimpia (Olha Bidà)"),
            Santo("Beata Ombelina"),
            Santo("Beata Panacea De' Muzzi"),
            Santo("Beata Paola Gambara Costa"),
            Santo("Beata Paola Montaldi"),
            Santo("Beata Paolina von Mallinckrodt"),
            Santo("Beata Raffaella Ybarra"),
            Santo("Beata Salome di Niederaltaich"),
            Santo("Beata Salomea da Cracovia"),
            Santo("Beata Sancia del Portogallo"),
            Santo("Beata Tarcisia (Olga) Mackiv"),
            Santo("Beata Tarsila Cordoba Belda"),
            Santo("Beata Ulrica Nisch"),
            Santo("Beata Umiliana de Cerchi"),
            Santo("Beata Wilbirg (Vilburga)"),
            Santo("Beata Zdenka Cecilia Schelingova"),
            Santo("Beate 6 Monache Mercedarie di Merriz"),
            Santo(
                "Beate Maddalena della Madre di Dio (Elisabeth) Verchière e 5 compagne"
            ),
            Santo("Beati 10 Padri Mercedari"),
            Santo("Beati 11 Padri Mercedari"),
            Santo("Beati 6 Padri Mercedari"),
            Santo("Beati 6 Redentori Mercedari"),
            Santo("Beati 7 Cavalieri Mercedari"),
            Santo("Beati Baldassarre, Antonio ed Ignazio Uchibori"),
            Santo(
                "Beati Edmigio Primo Rodriguez, Amalio Zariquiegui Mendoza e Valerio Bernardo Herrero Martínez"
            ),
            Santo(
                "Beati Edmondo Duke, Riccardo Hill, Giovanni Hogg e Riccardo Holiday"
            ),
            Santo(
                "Beati Edoardo Campion, Roberto Wilcox, Cristoforo Buxton e Roberto Widmerpool"
            ),
            Santo("Beati Edoardo Jones e Antonio Middleton"),
            Santo("Beati Edoardo Powell, Riccardo Fetherston e Tommaso Abel"),
            Santo("Beati Edoardo Stransham e Nicola Wheeler"),
            Santo("Beati Federico (Carlo) Rubio Álvarez e 3 compagni"),
            Santo("Beati Gaspare Hikojiro ed Andrea Yoshida"),
            Santo("Beati Gaspare Koteda, Francesco Takeya e Pietro Shichiemon"),
            Santo("Beati Ildefonso della Croce (Anatolio Garcia Nozal) e 5 compagni"),
            Santo("Beati Johannes Prassek, Hermann Lange e Eduard Muller"),
            Santo(
                "Beati Laureano (Salvatore) Ferrer Cardet, sacerdote, Benedetto (Emanuele) Ferrer Jordá e Bernardino (Paolo"
            ),
            Santo("Beati Raffaele Pardo Molina e Giuseppe Maria Vidal Segu"),
            Santo("Beati Raffale Alonso Gutierrez e Carlo Diaz Gandia"),
            Santo("Beati Raimondo e Guglielmo da Granada"),
            Santo("Beati Salvatore Lilli e 7 compagni laici armeni"),
            Santo("Beati Ugo Faringdon (Cook), Giovanni Eynon e Giovanni Rugg"),
            Santo("Beati Ugone Taylor e Marmaduke Bowes"),
            Santo("Beato Abbondio Martín Rodríguez"),
            Santo("Beato Acacio (Acacio María) Calleja Santamaría"),
            Santo("Beato Achille (Achilles Jozef) Puchala"),
            Santo("Beato Achilleo (Sant'Achilla)"),
            Santo("Beato Acisclo (Joaquin) Pina Piazuelo"),
            Santo("Beato Andrea de las Heras"),
            Santo("Beato Baldassarre Ravaschieri da Chiavari"),
            Santo("Beato Baldassarre Velasquez"),
            Santo("Beato Balsamo di Cava"),
            Santo("Beato Barnaba Kim I-u"),
            Santo("Beato Bartoli Antonio da Rimini"),
            Santo("Beato Bartolo Buonpedoni da San Gimignano"),
            Santo("Beato Bartolo Longo"),
            Santo("Beato Bartolomeo (Meo) da Firenze"),
            Santo("Beato Bartolomeo Aiutamicristo da Pisa"),
            Santo("Beato Bartolomeo Blanco"),
            Santo("Beato Bartolomeo Blanco Marquez"),
            Santo("Beato Bartolomeo Cerveri"),
            Santo("Beato Bartolomeo da Urbino"),
            Santo("Beato Bartolomé Caparrós García"),
            Santo("Beato Caio di Corea"),
            Santo("Beato Camillo Costanzo"),
            Santo("Beato Candido Castan San José"),
            Santo("Beato Candido Ranzi"),
            Santo("Beato Dalmazio Moner"),
            Santo("Beato Damiano"),
            Santo("Beato Damiano da Finale"),
            Santo("Beato Damiano de Portu"),
            Santo("Beato Damiano Grassi da Rivoli"),
            Santo("Beato Damián Gómez Jiménez"),
            Santo("Beato Daniele Alessio Brottier"),
            Santo("Beato Daniele Dajani"),
            Santo("Beato Daniele de Ungrispach"),
            Santo("Beato Daniele dell'Annunziata"),
            Santo("Beato Daniele Gomez Lucas"),
            Santo("Beato Dario Acosta Zurita"),
            Santo("Beato Dario Hernandez Morato"),
            Santo("Beato Davanzato da Poggibonsi"),
            Santo("Beato Davide (Daudi) Okelo"),
            Santo("Beato Davide Carlos Maranon"),
            Santo("Beato Davide di Himmerod"),
            Santo("Beato Dámaso Luis (Antolín Martínez Martínez)"),
            Santo("Beato Edmondo Bojanowski"),
            Santo("Beato Edmondo Ignazio Rice"),
            Santo("Beato Edmondo Sykes"),
            Santo("Beato Edoardo (Edward) Grzymala"),
            Santo("Beato Edoardo Burden"),
            Santo("Beato Edoardo Coleman"),
            Santo("Beato Edoardo Detkens"),
            Santo("Beato Edoardo Giuseppe Rosaz"),
            Santo("Beato Edoardo Kazmierski"),
            Santo("Beato Edoardo Klinik"),
            Santo("Beato Edoardo Oldcorne"),
            Santo("Beato Edoardo Osbaldeston"),
            Santo("Beato Edoardo Poppe"),
            Santo("Beato Edoardo Twing"),
            Santo("Beato Edoardo Waterson"),
            Santo("Beato Eduardo Cabanach Majem"),
            Santo("Beato Eduardo Romero Cortés"),
            Santo("Beato Eduardo Valverde Rodríguez"),
            Santo("Beato Facio (Fazio) di Cremona"),
            Santo("Beato Facundo Fernández Rodríguez"),
            Santo("Beato Falcone"),
            Santo("Beato Faustino Oteiza Segura"),
            Santo("Beato Fedele (Hieronim) Chojnacki"),
            Santo("Beato Fedele da Puzol (Mariano Climent Sanchís)"),
            Santo("Beato Fedele Fuidio Rodriguez"),
            Santo("Beato Federico"),
            Santo("Beato Gabriel Olivares Roda"),
            Santo("Beato Gabriel-Joseph-Roger Longueville"),
            Santo("Beato Gabriele Ferretti"),
            Santo("Beato Gabriele Maria (Giovanni Stefano) Allegra"),
            Santo("Beato Gabriele Maria da Benyfayo (Giuseppe Maria Sanchis Mompò)"),
            Santo("Beato Gabriele Pergaud"),
            Santo("Beato Galeotto Roberto Malatesta"),
            Santo("Beato Gallo (o Gregorio)"),
            Santo("Beato Gamelberto"),
            Santo("Beato Gandolfo da Binasco"),
            Santo("Beato Garcia Darlet"),
            Santo("Beato Garcia de Cardenas"),
            Santo("Beato Garcia dAure"),
            Santo("Beato Gaspare (Mikel) Suma"),
            Santo("Beato Gaspare Burgherre"),
            Santo("Beato Gaspare Daverio"),
            Santo("Beato Gaspare de Bono"),
            Santo("Beato Gaspare Stanggassinger"),
            Santo("Beato Gaudenzio Carmelino da Omegna"),
            Santo("Beato Gaudenzio Carmelino di Omegna"),
            Santo("Beato Hans (Giovanni) Wagner"),
            Santo("Beato Hartmann (Artmanno) di Bressanone"),
            Santo("Beato Henri Vergès"),
            Santo("Beato Hermenegildo Lorenzo (Modesto Saez Manzanares)"),
            Santo("Beato Herminio Motos Torrecillas"),
            Santo("Beato Hroznata (Hrornata, Croznato)"),
            Santo("Beato Hryhorij Khomysyn"),
            Santo("Beato Idesbaldo delle Dune"),
            Santo("Beato Ignazio (Choukrallah) Maloyan"),
            Santo("Beato Ignazio (Ignatius) Klopotowski"),
            Santo("Beato Ignazio (Nazju) Falzon"),
            Santo("Beato Ignazio Casanovas Perramon"),
            Santo("Beato Ignazio Choe In-cheol"),
            Santo("Beato Ignazio de Azevedo e 38 compagni"),
            Santo("Beato Ilarione (Pawel) Januszewski"),
            Santo("Beato Jacopo (Iacopone) da Todi"),
            Santo("Beato Jaime Calatrava Romero"),
            Santo("Beato Jaime Llach Candell"),
            Santo("Beato Jakob Kern"),
            Santo("Beato Janos Scheffler"),
            Santo("Beato Jarogniew Wojciechowski"),
            Santo("Beato Jaume Puig Mirosa"),
            Santo("Beato Jean Chevillard"),
            Santo("Beato Jean-Baptiste Souzy"),
            Santo("Beato Jean-François Bousquet"),
            Santo("Beato Jean-Marie du Lau dAlleman"),
            Santo("Beato Jesus Hita Miranda"),
            Santo("Beato Jesús Emilio Jaramillo Monsalve"),
            Santo("Beato Joaquín Berruezo Prieto"),
            Santo("Beato Joaquín Gisbert Aguilera"),
            Santo("Beato Jorio"),
            Santo("Beato Josafat Kocylovskyj"),
            Santo("Beato Josafat Roque (Urbano Corral González)"),
            Santo("Beato Josaphat Chichkov"),
            Santo("Beato Josè Aparicio Sanz"),
            Santo("Beato José Almunia López-Teruel"),
            Santo("Beato José Azurmendi Larrìnaga"),
            Santo("Beato José Calasanz Marqués"),
            Santo("Beato José Camí Camí"),
            Santo("Beato José Cano García"),
            Santo("Beato José Castaño Galera"),
            Santo("Beato José Fuentes Ballesteros"),
            Santo("Beato José García Librán"),
            Santo("Beato José Guardiet y Pujol"),
            Santo("Beato José Gómez de Haro"),
            Santo("Beato José Gómez Matarín"),
            Santo("Beato José Jordán Blecua"),
            Santo("Beato José Lara Garzón"),
            Santo("Beato José María Fernández Sánchez"),
            Santo("Beato José María González Solís"),
            Santo("Beato José María Martínez Vizcaíno"),
            Santo("Beato José María Poyatos Ruiz"),
            Santo("Beato José Máximo Moro Briz"),
            Santo("Beato José Nadal Guiu"),
            Santo("Beato José Pérez Fernández"),
            Santo("Beato José ÁlvarezBenavides de la Torre"),
            Santo("Beato Kamen Vitchev"),
            Santo("Beato Ladislao (Wladyslaw) Bladzinski"),
            Santo("Beato Ladislao (Wladyslaw) Demski"),
            Santo("Beato Ladislao (Wladyslaw) Findysz"),
            Santo("Beato Ladislao (Wladyslaw) Goral"),
            Santo("Beato Ladislao (Wladyslaw) Maczkowski"),
            Santo("Beato Ladislao (Wladyslaw) Miegon"),
            Santo("Beato Ladislao Batthyány-Strattmann"),
            Santo("Beato Ladislao Bukowinski"),
            Santo("Beato Ladislao da Gielnow"),
            Santo("Beato Ladislao Luis (Isidro Muñoz Antolín)"),
            Santo("Beato Lamberto di Neuwerk"),
            Santo("Beato Landolfo da Vareglate"),
            Santo("Beato Lanfranco di Canterbury"),
            Santo("Beato Lanuino"),
            Santo("Beato Laurent (Abbé Laurent)"),
            Santo("Beato Macario lo Scozzese"),
            Santo("Beato Narciso (Narcyz) Putz"),
            Santo("Beato Narciso Basté Basté"),
            Santo("Beato Narciso de Estenaga y Echevarria"),
            Santo("Beato Narciso Giovanni (Narcyz Jan) Turchan"),
            Santo("Beato Narciso Sitjà Basté"),
            Santo("Beato Natale Ilario Le Conte"),
            Santo("Beato Natale Pinot"),
            Santo("Beato Natale Tenaud"),
            Santo("Beato Ndoc Suma"),
            Santo("Beato Nevolone"),
            Santo("Beato Oddino Barotti"),
            Santo("Beato Oddone (Oddo) di Novara"),
            Santo("Beato Odoardo Focherini"),
            Santo("Beato Odorico da Pordenone"),
            Santo("Beato Oglerio"),
            Santo("Beato Oliviero Lefevre"),
            Santo("Beato Omeljan (Emilian) Kovc"),
            Santo("Beato Onorato (Venceslao) Kazminsky"),
            Santo("Beato Pablo Segalá Solé"),
            Santo("Beato Pacifico"),
            Santo("Beato Pacifico da Valencia (Pedro Salcedo Puchades)"),
            Santo("Beato Pacifico Ramati da Cerano"),
            Santo("Beato Pagano di Lecco"),
            Santo("Beato Radulfo (Rodolfo) di La Fustaie"),
            Santo("Beato Radulfo di Sisteron"),
            Santo("Beato Rafael Calatrava Ros"),
            Santo("Beato Rafael García Torres"),
            Santo("Beato Raffaele Alcocer Martínez"),
            Santo("Beato Raffaele Chylinski"),
            Santo("Beato Raffaele di Barletta"),
            Santo("Beato Raffaele Luigi Rafiringa"),
            Santo("Beato Raimondo da Capua (delle Vigne)"),
            Santo("Beato Raimondo da Cardona"),
            Santo("Beato Raimondo da Moncada"),
            Santo("Beato Raimondo da Tolosa"),
            Santo("Beato Raimondo de Bar"),
            Santo("Beato Raimondo de Barellis"),
            Santo("Beato Raimondo de Cayuela"),
            Santo("Beato Raimondo de Fosso"),
            Santo("Beato Raimondo de Pirrariis"),
            Santo("Beato Raimondo di Monteolivo"),
            Santo("Beato Raimondo di Santa Grazia"),
            Santo("Beato Raimondo du Puy"),
            Santo("Beato Raimondo Eirin Mayo"),
            Santo("Beato Raimondo Folch"),
            Santo("Beato Raimondo Lullo"),
            Santo("Beato Raimondo Martì Soriano"),
            Santo("Beato Saba Ji Hwang"),
            Santo("Beato Sabino Hernandez Laso"),
            Santo("Beato Sadoc e 48 compagni"),
            Santo("Beato Salomone dUngheria"),
            Santo("Beato Salvatore (Salvador) Mollar Ventura"),
            Santo("Beato Salvatore Damiano (Salvador Damian) Enguix Garès"),
            Santo("Beato Salvatore Estrugo Solves"),
            Santo("Beato Salvatore Fernandez Perez"),
            Santo("Beato Salvatore Ferrandis Seguì"),
            Santo("Beato Salvio Huix Miralpeix"),
            Santo("Beato Samuele Marzorati e compagni"),
            Santo("Beato Sebastiano Kimura"),
            Santo("Beato Taddeo (Tadeusz) Dulny"),
            Santo("Beato Taddeo Machar (Tadhg MacCarthy)"),
            Santo("Beato Tassilone III"),
            Santo("Beato Teobaldo da Narbona"),
            Santo("Beato Ubaldo da Borgo San Sepolcro (Ubaldo Adimari)"),
            Santo("Beato Ugo de Actis"),
            Santo("Beato Ugo de Mataplana"),
            Santo("Beato Ugo di Bonnevaux"),
            Santo("Beato Ugo di Fosses"),
            Santo("Beato Ugo di Macon"),
            Santo("Beato Ugo di Novalesa"),
            Santo("Beato Ugo di Tennenbach"),
            Santo("Beato Ugo Green"),
            Santo("Beato Ugolino da Gualdo Cattaneo"),
            Santo("Beato Ugolino Magalotti da Fiegni"),
            Santo("Beato Ugolino Zefirini"),
            Santo("Beato Uldarico (Jean-Baptiste) Guillaume"),
            Santo("Beato Umberto Benso"),
            Santo("Beato Umberto di Fritzlar"),
            Santo("Beato Umberto di Miribel"),
            Santo("Beato Umberto III di Savoia"),
            Santo("Beato Urbano II"),
            Santo("Beato Valentin Palencia Marquina"),
            Santo("Beato Valentino Gil Arribas"),
            Santo("Beato Valentino Paquay"),
            Santo("Beato Valentino Rovira"),
            Santo("Beato Vasil Hopko"),
            Santo("Beato Wenceslao Pedernera"),
            Santo("Beato Wincenty Stefan Frelichowski"),
            Santo("Beato Wolfango da Steinkirchen"),
            Santo("Beato Xumpo (Michele)"),
            Santo("Beato Yoshida Xoum (Giovanni)"),
            Santo("Beato Zacarias Cuesta Campo"),
            Santo("Beato Zaccaria"),
            Santo("Beato Zaccaria Abadía Buesa"),
            Santo("Beato Zeffirino Namuncurà"),
            Santo("Beato Zefirino Agostini"),
            Santo("Beato Zefirino Gimenez Malla"),
            Santo("Beato Zenone (Zynovij) Kovalyk"),
            Santo("Beato Zoltan Lajos Meszlenyi"),
            Santo("Cattedra di San Pietro Apostolo"),
            Santo("Coro angelico dei Principati"),
            Santo("Coro angelico dei Serafini"),
            Santo("Coro angelico delle Potenze o Potestà"),
            Santo("Emer Mezzanotte"),
            Santo("I Santi nell'anno liturgico"),
            Santo("Il Coro angelico dei Principati"),
            Santo("Il Coro angelico dei Serafini"),
            Santo("Il Coro angelico dei Troni"),
            Santo("Il Coro angelico delle Dominazioni"),
            Santo("Il Coro angelico delle Potenze o Potestà"),
            Santo("Il Coro angelico delle Virtù"),
            Santo("Il Martirio di San Giovanni Battista"),
            Santo("Il Sacro Manto di san Giuseppe"),
            Santo("Il Santissimo Nome di Gesù"),
            Santo("La Cattedra di San Pietro Apostolo"),
            Santo("La Commemorazione di tutti i fedeli defunti"),
            Santo("La Conversione di San Paolo Apostolo"),
            Santo("La Dedicazione della Basilica Lateranense"),
            Santo("La Dedicazione delle basiliche dei Santi Pietro e Paolo"),
            Santo("La devozione delle 3 Ave Maria"),
            Santo("La Natività di San Giovanni Battista"),
            Santo("Martirio di San Giovanni Battista"),
            Santo("Natività di San Giovanni Battista"),
            Santo("Sacro Manto di san Giuseppe"),
            Santo("San Bacco (Dahhat) il Giovane"),
            Santo("San Bacolo di Sorrento"),
            Santo("San Baino di Thérouanne"),
            Santo("San Baiulo (e Liberato)"),
            Santo("San Baldo"),
            Santo("San Baldomero"),
            Santo("San Baldovino (Balduino) da Rieti"),
            Santo("San Banban di Lethglenn"),
            Santo("San Banban Sapiens"),
            Santo("San Barbato di Benevento"),
            Santo("San Barbaziano di Ravenna"),
            Santo("San Bardone (Bardo) di Magonza"),
            Santo("San Barlaam di Antiochia"),
            Santo("San Barnaba"),
            Santo("San Barsanofio"),
            Santo("San Barses (Barsen) di Edessa"),
            Santo("San Barsimeo (Barsamya)"),
            Santo("San Barto di Vaison"),
            Santo("San Bartolomeo"),
            Santo("San Basilio Magno"),
            Santo("San Beda detto il Venerabile"),
            Santo("San Benedetto da Norcia"),
            Santo("San Bernardino da Siena"),
            Santo("San Bernardo di Chiaravalle"),
            Santo("San Biagio"),
            Santo("San Bonaventura"),
            Santo("San Bonifacio"),
            Santo("San Bruno (Brunone)"),
            Santo("San Cadfano"),
            Santo("San Cadoc di Llancarfan"),
            Santo("San Cadwaladr Fendigaid"),
            Santo("San Cagnoaldo di Laon"),
            Santo("San Cainnech"),
            Santo("San Caio"),
            Santo("San Caio di Corinto"),
            Santo("San Caio di Milano"),
            Santo("San Calcedonio"),
            Santo("San Caleb (o Elesbaan, Elsebaan)"),
            Santo("San Calepodio"),
            Santo("San Caletrico di Chartres"),
            Santo("San Calimero di Milano"),
            Santo("San Callinico di Gangra"),
            Santo("San Calliopio"),
            Santo("San Callisto Caravario"),
            Santo("San Callisto di Huesca"),
            Santo("San Callisto I"),
            Santo("San Calogero"),
            Santo("San Calogero di Brescia"),
            Santo("San Caluppano"),
            Santo("San Cameliano di Troyes"),
            Santo("San Camillo de Lellis"),
            Santo("San Canio (Canione) di Atella"),
            Santo("San Canuto IV"),
            Santo("San Canuto Lavard"),
            Santo("San Carlo Borromeo"),
            Santo("San Casimiro"),
            Santo("San Charbel (Giuseppe) Makhluf"),
            Santo("San Cipriano"),
            Santo("San Cirillo"),
            Santo("San Cirillo d'Alessandria"),
            Santo("San Cirillo di Gerusalemme"),
            Santo("San Clemente I Romano"),
            Santo("San Colombano"),
            Santo("San Cornelio"),
            Santo("San Cosma"),
            Santo("San Dadone di Conques"),
            Santo("San Dagoberto II"),
            Santo("San Dalmazio (Dalmazzo) di Pavia"),
            Santo("San Dalmazio di Rodez"),
            Santo("San Damaso I"),
            Santo("San Damiano"),
            Santo("San Damiano d'Africa"),
            Santo("San Damiano de Veuster"),
            Santo("San Damiano di Pavia"),
            Santo("San Damiano di Terracina"),
            Santo("San Dana (Danatte)"),
            Santo("San Daniele Comboni"),
            Santo("San Daniele di Bangor"),
            Santo("San Daniele di Padova"),
            Santo("San Daniele e compagni"),
            Santo("San Daniele lo Stilita"),
            Santo("San Dasio"),
            Santo("San Dasio, Zotico e Caio (Gaio)"),
            Santo("San Dato di Ravenna"),
            Santo("San David di Menevia (del Galles)"),
            Santo("San David I"),
            Santo("San Davide di Salonicco"),
            Santo("San Davide di Svezia (David di Vasteras)"),
            Santo("San Dionigi e compagni"),
            Santo("San Domenico di Guzman"),
            Santo("San Domenico Savio"),
            Santo("San Fabiano"),
            Santo("San Fabio e compagni"),
            Santo("San Fabio il Vessillifero"),
            Santo("San Fachtna (o Fachanano)"),
            Santo("San Falco di Palena"),
            Santo("San Famiano"),
            Santo("San Fandila di Cordova"),
            Santo("San Fantino il Giovane"),
            Santo("San Fantino il Vecchio (o il Taumaturgo)"),
            Santo("San Farone di Meaux"),
            Santo("San Faustiniano"),
            Santo("San Faustino dellIncarnazione (Manuel Míguez González)"),
            Santo("San Fausto"),
            Santo("San Fausto di Alessandria"),
            Santo("San Fausto di Riez"),
            Santo("San Favorino di Vercelli"),
            Santo("San Febadio di Agen"),
            Santo("San Fechin di Fobhar"),
            Santo("San Fedele da Sigmaringen (Mark Roy)"),
            Santo("San Fedele di Como"),
            Santo("San Fedele di Merida"),
            Santo("San Fedele di Strasburgo"),
            Santo("San Filippo"),
            Santo("San Filippo Neri"),
            Santo("San Francesco d'Assisi"),
            Santo("San Francesco da Paola"),
            Santo("San Francesco di Sales"),
            Santo("San Francesco Saverio"),
            Santo("San Gabriele"),
            Santo("San Gabriele dell'Addolorata"),
            Santo("San Gabriele Lalemant"),
            Santo("San Gabriele Taurino Dufresse"),
            Santo("San Gaetano Catanoso"),
            Santo("San Gaetano Errico"),
            Santo("San Gaetano Thiene"),
            Santo("San Galattorio di Lescar"),
            Santo("San Galdino"),
            Santo("San Galgano Guidotti"),
            Santo("San Gallo"),
            Santo("San Gallo di Aosta"),
            Santo("San Garibaldo di Ratisbona"),
            Santo("San Garino di Toul"),
            Santo("San Gaspare Del Bufalo"),
            Santo("San Gaspare Luigi Bertoni"),
            Santo("San Gaucherio di Aureil"),
            Santo("San Gaudenzio"),
            Santo("San Gaudenzio (Gaudenzo) di Rimini"),
            Santo("San Gaudenzio (Razdim)"),
            Santo("San Gaudenzio di Bergell"),
            Santo("San Gennaro"),
            Santo("San Gesù Mendez Montoya"),
            Santo("San Giacomo il Maggiore"),
            Santo("San Giacomo il Minore"),
            Santo("San Giacomo Ilario (Emanuele) Barbal Cosàn"),
            Santo("San Gioacchino"),
            Santo("San Giorgio"),
            Santo("San Giosafat Kuncewycz"),
            Santo("San Giovanni"),
            Santo("San Giovanni Battista de La Salle"),
            Santo("San Giovanni Bosco"),
            Santo("San Giovanni Crisostomo"),
            Santo("San Giovanni da Capestrano"),
            Santo("San Giovanni da Kety (Canzio)"),
            Santo("San Giovanni Damasceno"),
            Santo("San Giovanni della Croce"),
            Santo("San Giovanni di Dio"),
            Santo("San Giovanni Eudes"),
            Santo("San Giovanni Fisher"),
            Santo("San Giovanni I"),
            Santo("San Giovanni Leonardi"),
            Santo("San Giovanni Maria Vianney"),
            Santo("San Giovanni Paolo II (Karol Wojtyla)"),
            Santo("San Giovanni XXIII (Angelo Giuseppe Roncalli)"),
            Santo("San Girolamo (o Gerolamo)"),
            Santo("San Girolamo Emiliani (Miani)"),
            Santo("San Giuda Taddeo"),
            Santo("San Giuseppe"),
            Santo("San Giuseppe Calasanzio"),
            Santo("San Giustino"),
            Santo("San Gregorio I, detto Magno"),
            Santo("San Gregorio Nazianzeno"),
            Santo("San Gregorio VII"),
            Santo("San Hemming di Abo"),
            Santo("San Hoardon"),
            Santo("San Hussik"),
            Santo("San Hywel Faig (Howel)"),
            Santo("San Iarlath"),
            Santo("San Jaenbert"),
            Santo("San Jarlath di Armagh"),
            Santo("San Jean-Louis Bonnard"),
            Santo("San Jose Isabel Flores Varela"),
            Santo("San Josè Manyanet y Vives"),
            Santo("San Juan Diego Cuauhtlatoatzin"),
            Santo("San Kevin (Coemgen)"),
            Santo("San Kilian (Chiliano)"),
            Santo("San Koloman (Colman)"),
            Santo("San Kragon (Cragon)"),
            Santo("San Lachtain"),
            Santo("San Lachtain di Freshford"),
            Santo("San Ladislao"),
            Santo("San Lamberto (Lantberto) di Frisinga"),
            Santo("San Lamberto di Lione"),
            Santo("San Lamberto di Maastricht"),
            Santo("San Lamberto di Saragozza"),
            Santo("San Lamberto di Vence"),
            Santo("San Landelino"),
            Santo("San Landelino di Ettenheim"),
            Santo("San Landerico"),
            Santo("San Landerico di Parigi"),
            Santo("San Lanfranco Beccari"),
            Santo("San Lanfranco di Vercelli"),
            Santo("San Lanno (Lando)"),
            Santo("San Lasreano o Molasso"),
            Santo("San Laudo di Coutances"),
            Santo("San Launo di Thouars"),
            Santo("San Launomaro"),
            Santo("San Laureato"),
            Santo("San Lauriano"),
            Santo("San Lauro e compagni"),
            Santo("San Laverio"),
            Santo("San Lazzaro"),
            Santo("San Lazzaro di Milano"),
            Santo("San Leone I, detto Magno"),
            Santo("San Lorenzo"),
            Santo("San Lorenzo da Brindisi"),
            Santo("San Luca"),
            Santo("San Ludovico (Luigi IX)"),
            Santo("San Luigi Gonzaga"),
            Santo("San Luigi Maria Grignion da Montfort"),
            Santo("San Mac Cairthind"),
            Santo("San Mac Nisse"),
            Santo("San Macario d'Armenia"),
            Santo("San Macario di Alessandria"),
            Santo("San Macario di Collesano"),
            Santo("San Macario di Gerusalemme"),
            Santo("San Macario di Pelecete"),
            Santo("San Macario il Grande"),
            Santo("San Macario l'Alessandrino"),
            Santo("San MacCulind (o MacCuillinn)"),
            Santo("San Machar di Aberdeen"),
            Santo("San Macuto (o Maclovio) di Aleth"),
            Santo("San Mael Ruain"),
            Santo("San Maeldoid"),
            Santo("San Maelmuire"),
            Santo("San Maggiorino di Acqui"),
            Santo("San Magino di Tarragona"),
            Santo("San Maglorio"),
            Santo("San Magnerico di Treviri"),
            Santo("San Magno"),
            Santo("San Magno de Trincheri"),
            Santo("San Magno di Anagni (o da Trani)"),
            Santo("San Marco"),
            Santo("San Martino de Porres"),
            Santo("San Martino di Tours"),
            Santo("San Martino I"),
            Santo("San Massimiliano Maria (Rajmund) Kolbe"),
            Santo("San Matteo"),
            Santo("San Mattia"),
            Santo("San Metodio"),
            Santo("San Michele"),
            Santo("San Namazio di Clermont"),
            Santo("San Namazio di Vienne"),
            Santo("San Nancto (Nuncto)"),
            Santo("San Napoleone"),
            Santo("San Narciso di Gerusalemme"),
            Santo("San Narno"),
            Santo("San Narsete (Nerses) I il Parto"),
            Santo("San Narsete (Nerses) IV Klajetzi (o Shnorhali)"),
            Santo("San Narsete e Giuseppe"),
            Santo("San Natale"),
            Santo("San Natale Chabanel"),
            Santo("San Natale di Milano"),
            Santo("San Nathalan"),
            Santo("San Nathì (Nateo)"),
            Santo("San Naum"),
            Santo("San Nazario di Capodistria"),
            Santo("San Nemesio di Alessandria"),
            Santo("San Neofito di Nicea"),
            Santo("San Nepoziano"),
            Santo("San Nereo"),
            Santo("San Nestore di Magydos"),
            Santo("San Nicandro"),
            Santo("San Nicasio Camuto de Burgio"),
            Santo("San Nicasio di Reims"),
            Santo("San Nicola di Mira (di Bari)"),
            Santo("San Norberto"),
            Santo("San Pabai"),
            Santo("San Pablo di Merida"),
            Santo("San Pabo"),
            Santo("San Paciano di Barcellona"),
            Santo("San Pacifico da Sanseverino Marche"),
            Santo("San Pacomio"),
            Santo("San Pafnuzio"),
            Santo("San Palemone"),
            Santo("San Palerio di Telese"),
            Santo("San Palladio"),
            Santo("San Palladio di Auxerre"),
            Santo("San Palladio di Saintes"),
            Santo("San Palmerio"),
            Santo("San Pammachio di Roma"),
            Santo("San Pancrazio"),
            Santo("San Pancrazio di Taormina"),
            Santo("San Panfilo di Roma"),
            Santo("San Panfilo di Sulmona"),
            Santo("San Panfilo e compagni"),
            Santo("San Pantagato di Vienne"),
            Santo("San Pantaleone"),
            Santo("San Panteno"),
            Santo("San Paolino Bigazzini"),
            Santo("San Paolino d'Aquileia"),
            Santo("San Paolino di Lucca"),
            Santo("San Paolino di Nola"),
            Santo("San Paolo"),
            Santo("San Paolo della Croce"),
            Santo("San Paolo Miki e compagni"),
            Santo("San Paolo VI (Giovanni Battista Montini)"),
            Santo("San Patrizio"),
            Santo("San Pier Damiani"),
            Santo("San Pietro"),
            Santo("San Pietro Canisio"),
            Santo("San Pietro Chanel"),
            Santo("San Pietro Claver"),
            Santo("San Pietro Crisologo"),
            Santo("San Pietro Giuliano Eymard"),
            Santo("San Pio da Pietrelcina (Francesco Forgione)"),
            Santo("San Pio V (Antonio Ghislieri)"),
            Santo("San Pio X (Giuseppe Sarto)"),
            Santo("San Policarpo"),
            Santo("San Ponziano"),
            Santo("San Quadrato"),
            Santo("San Quadrato (Codrato) di Magnesia"),
            Santo("San Quadrato di Utica"),
            Santo("San Quarto"),
            Santo("San Quarto di Capua"),
            Santo("San Quinidio"),
            Santo("San Quintino"),
            Santo("San Quintino di Vermand"),
            Santo("San Quinto di Capua"),
            Santo("San Quinto e compagni"),
            Santo("San Quinto il Taumaturgo"),
            Santo("San Quinziano"),
            Santo("San Quiriaco (Ciriaco) di Treviri"),
            Santo("San Quirico"),
            Santo("San Quirino"),
            Santo("San Quirino di Roma"),
            Santo("San Quirino di Siscia"),
            Santo("San Quirino di Tivoli"),
            Santo("San Quodvultdeus"),
            Santo("San Rabano Mauro"),
            Santo("San Racholf"),
            Santo("San Radbodo di Utrecht"),
            Santo("San Radulfo"),
            Santo("San Radulfo (Rodolfo) di Bourges"),
            Santo("San Raffaele"),
            Santo("San Raffaele Arnaiz Baron"),
            Santo("San Raffaele di San Giuseppe (Josef Kalinowski)"),
            Santo("San Raffaele Guizar Valencia"),
            Santo("San Raimondo"),
            Santo("San Raimondo Albert"),
            Santo("San Raimondo de Blanes"),
            Santo("San Raimondo de Penafort"),
            Santo("San Raimondo di Fitero"),
            Santo("San Roberto Bellarmino"),
            Santo("San Rocco"),
            Santo("San Romualdo"),
            Santo("San Saba Archimandrita"),
            Santo("San Saba il Giovane"),
            Santo("San Saba il Goto"),
            Santo("San Sabas Reyes Salazar"),
            Santo("San Sabiniano"),
            Santo("San Sabino"),
            Santo("San Sabino di Avellino"),
            Santo("San Sabino di Canosa"),
            Santo("San Sabino di Spoleto"),
            Santo("San Sacerdote di Limoges"),
            Santo("San Sacerdote di Lione"),
            Santo("San Sagaris (Sagaro, Sagara)"),
            Santo("San Salmodio (o Psalmodio)"),
            Santo("San Salomone"),
            Santo("San Salomone (Guillaume-Nicolas-Louis) Leclerq"),
            Santo("San Salomone di Cordova"),
            Santo("San Salonio di Ginevra"),
            Santo("San Salvatore Grionesos da Horta"),
            Santo("San Salvatore Lara Puente"),
            Santo("San Salvio"),
            Santo("San Salvio di Albi"),
            Santo("San Salvio di Amiens"),
            Santo("San Samuele"),
            Santo("San Sebastiano"),
            Santo("San Silvestro I"),
            Santo("San Simone"),
            Santo("San Sisto II e compagni"),
            Santo("San Taddeo Liu Ruiting"),
            Santo("San Talaleo (Talleleo)"),
            Santo("San Tammaro"),
            Santo("San Tangwn"),
            Santo("San Tangwn ab Caradog"),
            Santo("San Tarasio"),
            Santo("San Tarsicio (o Tarcisio) di Roma"),
            Santo("San Taurino di Evreux"),
            Santo("San Taziano (Tazione) di Claudiopoli"),
            Santo("San Tecce"),
            Santo("San Tegai"),
            Santo("San Tegulo (Tegolo)"),
            Santo("San Tegwy"),
            Santo("San Telesforo"),
            Santo("San Teliavo (Teliano)"),
            Santo("San Temistocle di Licia"),
            Santo("San Teobaldo di Dorat"),
            Santo("San Teobaldo di Marly"),
            Santo("San Teobaldo di Provins"),
            Santo("San Teobaldo di Vienne"),
            Santo("San Teobaldo Roggeri"),
            Santo("San Teoctisto di Caccamo"),
            Santo("San Teodardo di Narbona"),
            Santo("San Teodardo di Tongress"),
            Santo("San Teodemiro di Cordova"),
            Santo("San Teodgaro"),
            Santo("San Timoteo"),
            Santo("San Tito"),
            Santo("San Tommaso"),
            Santo("San Tommaso Becket"),
            Santo("San Tommaso d'Aquino"),
            Santo("San Tommaso Khuong"),
            Santo("San Tommaso Moro"),
            Santo("San Turibio de Mogrovejo"),
            Santo("San Valdeberto"),
            Santo("San Valdo (o Gaudo) di Evreux"),
            Santo("San Valentiniano di Coira"),
            Santo("San Valentiniano di Salerno"),
            Santo("San Valentino"),
            Santo("San Valentino di Genova"),
            Santo("San Valentino di Roma"),
            Santo("San Valentino di Terni"),
            Santo("San Valentino di Treviri"),
            Santo("San Valenzio (o Valente) di Verona"),
            Santo("San Valeriano"),
            Santo("San Valeriano di Aquileia"),
            Santo("San Valeriano di Avensano"),
            Santo("San Valeriano di Cimiez"),
            Santo("San Valeriano di Tournus"),
            Santo("San Valerico"),
            Santo("San Valerico (Valerio) di Leuconay"),
            Santo("San Valerio"),
            Santo("San Valerio (Valero) di Saragozza"),
            Santo("San Valerio di Langres"),
            Santo("San Valerio di Ravenna"),
            Santo("San Valerio di Treviri"),
            Santo("San Valero"),
            Santo("San Valstano di Bawburgh"),
            Santo("San Vamberto"),
            Santo("San Vandregisilo"),
            Santo("San Varnerio (Werner) di Oberwesel"),
            Santo("San Varo e compagni"),
            Santo("San Vasnulfo (Vasnolfo)"),
            Santo("San Vedasto (Gastone) di Arras"),
            Santo("San Venceslao"),
            Santo("San Vincenzo de' Paoli"),
            Santo("San Vincenzo di Saragozza"),
            Santo("San Vincenzo Do Yen"),
            Santo("San Vincenzo Ferrer"),
            Santo("San Walhero (Walhère)"),
            Santo("San Walter (Gualtiero, Gualterio) di S. Martino di Pontoise"),
            Santo("San Wando (Vandone)"),
            Santo("San Wilfrido (Walfredo) della Gherardesca"),
            Santo("San Wirone (Wiro)"),
            Santo("San Witesindo di Cordova"),
            Santo("San Witta (o Vitta o Albino)"),
            Santo("San Wolbodo di Liegi"),
            Santo("San Wunibald di Heidenheim (Vunibaldo)"),
            Santo("San Xacatur di Tigranakert"),
            Santo("San Xi Guizi"),
            Santo("San Zaccaria"),
            Santo("San Zaccaria del Mercurion"),
            Santo("San Zaccaria di Vienne"),
            Santo("San Zaccheo"),
            Santo("San Zama"),
            Santo("San Zeffirino (o Zefirino)"),
            Santo("San Zeno (Zenone) di Verona"),
            Santo("San Zenobio"),
            Santo("San Zenobio (Zanobi)"),
            Santo("San Zenobio di Sidone"),
            Santo("San Zenone di Maiuma"),
            Santo("San Zenone di Roma"),
            Santo("San Zenone e figli"),
            Santo("San Zhang Huailu"),
            Santo("San Zoello"),
            Santo("San Zoilo di Cordova"),
            Santo("San Zosimo"),
            Santo("San Zosimo di Siracusa"),
            Santo("San Zota (Ioata, Ioathas)"),
            Santo("San Zotico di Costantinopoli"),
            Santo("Sant' Abacuc"),
            Santo("Sant' Abbondio"),
            Santo("Sant' Abbondio di Cordova"),
            Santo("Sant' Abbone (o Goerico) di Metz"),
            Santo("Sant' Abbone di Fleury"),
            Santo("Sant' Abdia"),
            Santo("Sant' Abercio di Geropoli"),
            Santo("Sant' Abgar V Ukama (il Nero)"),
            Santo("Sant' Abibo di Edessa"),
            Santo("Sant' Ableberto (Emeberto)"),
            Santo("Sant' Abo di Tiflis"),
            Santo("Sant' Abramo"),
            Santo("Sant' Abramo di St-Cirgue"),
            Santo("Sant' Abreha"),
            Santo("Sant' Abruncolo"),
            Santo("Sant' Abruncolo di Langres"),
            Santo("Sant' Abudemio"),
            Santo("Sant' Acacio (Acazio) di Mileto"),
            Santo("Sant' Acacio di Amida"),
            Santo("Sant' Acardo"),
            Santo("Sant' Acardo (Aicardo) di Jumieges"),
            Santo("Sant' Acario di Noyon e Tournai"),
            Santo("Sant' Achilleo"),
            Santo("Sant' Ada (Adreilde) di Le Mans"),
            Santo("Sant' Adalardo di Corbie"),
            Santo("Sant' Adalbaldo"),
            Santo("Sant' Adalberto di Praga"),
            Santo("Sant' Agata"),
            Santo("Sant' Agnese"),
            Santo("Sant' Agostino"),
            Santo("Sant' Agostino di Canterbury"),
            Santo("Sant' Alberto Magno"),
            Santo("Sant' Alfonso Maria de' Liguori"),
            Santo("Sant' Ambrogio"),
            Santo("Sant' Andrea"),
            Santo("Sant' Angela Merici"),
            Santo("Sant' Anna"),
            Santo("Sant' Anselmo d'Aosta"),
            Santo("Sant' Antonio"),
            Santo("Sant' Antonio di Padova"),
            Santo("Sant' Antonio Maria Claret"),
            Santo("Sant' Antonio Maria Zaccaria"),
            Santo("Sant' Apollinare di Ravenna"),
            Santo("Sant' Atanasio"),
            Santo("Sant' Augusto Chapdelaine"),
            Santo("Sant' Earconvaldo"),
            Santo("Sant' Eata di Hexham"),
            Santo("Sant' Ebba di Coldingham"),
            Santo("Sant' Ebregisilo (Evergislo) di Colonia"),
            Santo("Sant' Ebrulfo (Ebrolfo) di Ouche"),
            Santo("Sant' Ecclesio Celio di Ravenna"),
            Santo("Sant' Edberto (Egberto)"),
            Santo("Sant' Edberto di Lindisfarne"),
            Santo("Sant' Edda di Winchester"),
            Santo("Sant' Edesio"),
            Santo("Sant' Edgaro il Pacifico"),
            Santo("Sant' Edisto"),
            Santo("Sant' Edmondo"),
            Santo("Sant' Edmondo Arrowsmith"),
            Santo("Sant' Edmondo Campion"),
            Santo("Sant' Edmondo di Scozia"),
            Santo("Sant' Edmondo Rich"),
            Santo("Sant' Ednyfed"),
            Santo("Sant' Edoardo II il Martire"),
            Santo("Sant' Edoardo III il Confessore"),
            Santo("Sant' Edvige"),
            Santo("Sant' Efrem"),
            Santo("Sant' Elisabetta d'Ungheria"),
            Santo("Sant' Elisabetta di Portogallo"),
            Santo("Sant' Enrico II"),
            Santo("Sant' Eusebio di Vercelli"),
            Santo("Sant' Habib"),
            Santo("Sant' Ida (Idda) di Fischingen"),
            Santo("Sant' Ida (Ita)"),
            Santo("Sant' Ida di Herzfeld"),
            Santo("Sant' Idulfo (Idolfo) di Moyenmoutier"),
            Santo("Sant' Igino"),
            Santo("Sant' Ignazio"),
            Santo("Sant' Ignazio Clemente Delgado"),
            Santo("Sant' Ignazio da Laconi"),
            Santo("Sant' Ignazio da Santhià"),
            Santo("Sant' Ignazio di Antiochia"),
            Santo("Sant' Ignazio di Loyola"),
            Santo("Sant' Igor di Russia"),
            Santo("Sant' Ilario (Illario) di Padova"),
            Santo("Sant' Ilario di Arles"),
            Santo("Sant' Ilario di Carcassonne"),
            Santo("Sant' Ilario di Magonza"),
            Santo("Sant' Ilario di Poitiers"),
            Santo("Sant' Ilario di Tolosa"),
            Santo("Sant' Ilarione di Gaza"),
            Santo("Sant' Ilarione di Moglena"),
            Santo("Sant' Ilarione di Pelecete"),
            Santo("Sant' Ilarione il Giovane"),
            Santo("Sant' Ilarione Jugskie"),
            Santo("Sant' Ilaro"),
            Santo("Sant' Ilaro (Ilario) di Javols"),
            Santo("Sant' Ilda"),
            Santo("Sant' Ildebrando di Bagnoregio"),
            Santo("Sant' Ildefonso (Idelfonso) da Toledo"),
            Santo("Sant' Ildegarda di Bingen"),
            Santo("Sant' Ippolito"),
            Santo("Sant' Ireneo di Lione"),
            Santo("Sant' Isidoro di Siviglia"),
            Santo("Sant' Obizio da Niardo"),
            Santo("Sant' Oceano"),
            Santo("Sant' Oddone di Cluny"),
            Santo("Sant' Oddone di Urgel"),
            Santo("Sant' Odegonda"),
            Santo("Sant' Odgero"),
            Santo("Sant' Odilia"),
            Santo("Sant' Odilia (Ottilia) di Hohenbourg"),
            Santo("Sant' Odilone di Cluny"),
            Santo("Sant' Odolfo"),
            Santo("Sant' Odorisio I (Oderisio) di Montecassino"),
            Santo("Sant' Odran (Otterano) di Iona"),
            Santo("Sant' Odulfo di Utrecht"),
            Santo("Sant' Oengus il Culdeo"),
            Santo("Sant' Olav (Olaf)"),
            Santo("Sant' Olav di Svezia"),
            Santo("Sant' Olcese (Ursicino)"),
            Santo("Sant' Olga di Kiev"),
            Santo("Sant' Olimpia (Olimpiade)"),
            Santo("Sant' Olimpiade di Amelia"),
            Santo("Sant' Oliva di Palermo"),
            Santo("Sant' Oliviero Plunkett"),
            Santo("Sant' Ollegario di Tarragona"),
            Santo("Sant' Omobono di Cremona"),
            Santo("Sant' Onesiforo"),
            Santo("Sant' Onesimo"),
            Santo("Sant' Onofrio"),
            Santo("Sant' Onorata di Pavia"),
            Santo("Sant' Onorato di Amiens"),
            Santo("Sant' Onorato di Arles"),
            Santo("Sant' Onorato di Buzançais"),
            Santo("Sant' Onorato di Fondi"),
            Santo("Sant' Onorato di Milano"),
            Santo("Sant' Onorato di Subiaco"),
            Santo("Sant' Onorato di Tolosa"),
            Santo("Sant' Oscar (Ansgario)"),
            Santo("Sant' Ubaldo di Gubbio"),
            Santo("Sant' Uberto di Bretigny"),
            Santo("Sant' Uberto di Tongeren-Maastricht"),
            Santo("Sant' Ugo Canefri da Genova"),
            Santo("Sant' Ugo d'Anzy-le-Duc"),
            Santo("Sant' Ugo di Cluny"),
            Santo("Sant' Ugo di Grenoble"),
            Santo("Sant' Ugo di Lincoln"),
            Santo("Sant' Ugo di Novara di Sicilia"),
            Santo("Sant' Ugo di Rouen"),
            Santo("Sant' Ugolina di Vercelli"),
            Santo("Sant' Ulpiano di Tiro"),
            Santo("Sant' Ulrico"),
            Santo("Sant' Ulrico (Ulderico)"),
            Santo("Sant' Umberto di Maroilles"),
            Santo("Sant' Umile da Bisignano"),
            Santo("Sant' Una (Huna)"),
            Santo("Sant' Unfrido di Therouanne"),
            Santo("Sant' Ungero di Utrecht"),
            Santo("Sant' Urbano di Teano"),
            Santo("Sant' Urbano I"),
            Santo("Sant' Yves (Ivo) Hélory de Kermartin"),
            Santo("Sant' Ywi"),
            Santo("Santa Balbina di Roma"),
            Santo("Santa Balda di Jouarre"),
            Santo("Santa Balsamia"),
            Santo("Santa Barbara"),
            Santo("Santa Barbara Cui Lianzhi"),
            Santo("Santa Bartolomea Capitanio"),
            Santo("Santa Battista (Camilla) Varano"),
            Santo("Santa Brigida di Svezia"),
            Santo("Santa Camilla di Auxerre"),
            Santo("Santa Candida"),
            Santo("Santa Candida di Napoli"),
            Santo("Santa Candida di Roma"),
            Santo(
                "Santa Candida Maria di Gesù Cipitria (Giovanna Giuseppa Cipitria y Barriola)"
            ),
            Santo("Santa Canna"),
            Santo("Santa Canonica"),
            Santo("Santa Caterina d'Alessandria"),
            Santo("Santa Caterina da Siena"),
            Santo("Santa Caterina Tekakwitha"),
            Santo("Santa Cecilia"),
            Santo("Santa Chiara"),
            Santo("Santa Dafrosa di Roma"),
            Santo("Santa Damaride"),
            Santo("Santa Darerca (Monenna) di Killeavy"),
            Santo("Santa Daria"),
            Santo("Santa Edith di Wilton"),
            Santo("Santa Fabiola di Roma"),
            Santo("Santa Fara (Burgundofara)"),
            Santo("Santa Farailde di Gand"),
            Santo("Santa Fausta"),
            Santo("Santa Fausta di Narni"),
            Santo("Santa Fausta Romana"),
            Santo("Santa Faustina"),
            Santo("Santa Faustina di Cizico"),
            Santo("Santa Faustina di Como"),
            Santo("Santa Febe (Phoebe)"),
            Santo("Santa Febronia"),
            Santo("Santa Fede di Agen"),
            Santo("Santa Francesca Romana"),
            Santo("Santa Galla di Roma"),
            Santo("Santa Gaudenzia"),
            Santo("Santa Geltrude (Gertrude) la Grande"),
            Santo("Santa Giovanna Francesca de Chantal"),
            Santo("Santa Giulia"),
            Santo("Santa Giulia Billiart"),
            Santo("Santa Giuseppina Bakhita"),
            Santo("Santa Hunna"),
            Santo("Santa Ia"),
            Santo("Santa Kinga (Cunegonda)"),
            Santo("Santa Landrada"),
            Santo("Santa Laura di Cordova"),
            Santo(
                "Santa Laura di Santa Caterina da Siena (Maria Laura de Jesús Montoya y Upegui)"
            ),
            Santo("Santa Laura e 52 compagne"),
            Santo("Santa Lucia"),
            Santo("Santa Lucia Yi Zhenmei"),
            Santo("Santa Machita"),
            Santo("Santa Macrina l'Anziana"),
            Santo("Santa Macrina la Giovane"),
            Santo("Santa Maddalena da Nagasaki"),
            Santo("Santa Maddalena di Canossa"),
            Santo("Santa Maddalena Sofia Barat"),
            Santo("Santa Madelberta"),
            Santo("Santa Madrun"),
            Santo("Santa Margherita di Scozia"),
            Santo("Santa Margherita Maria Alacoque"),
            Santo("Santa Maria Goretti"),
            Santo("Santa Maria Maddalena (di Magdala)"),
            Santo("Santa Maria Maddalena de' Pazzi"),
            Santo("Santa Marta di Betania"),
            Santo("Santa Monica"),
            Santo("Santa Narcisa di Gesù Martillo y Moràn"),
            Santo("Santa Natalia di Tolosa"),
            Santo("Santa Natalia e compagni"),
            Santo(
                "Santa Nazaria Ignazia di Santa Teresa di Gesù (Nazaria Ignacia March Mesa)"
            ),
            Santo("Santa Neosnadia (o Neomaye)"),
            Santo("Santa Nicarete (Niceras) di Costantinopoli"),
            Santo("Santa Odrada"),
            Santo("Santa Oliva di Anagni"),
            Santo("Santa Paola (la Barbuta)"),
            Santo("Santa Paola di S. Giuseppe Calasanzio (Paola Montal y Fornes)"),
            Santo("Santa Paola Elisabetta (Costanza) Cerioli"),
            Santo("Santa Paola Frassinetti"),
            Santo("Santa Paola Romana"),
            Santo("Santa Paolina"),
            Santo("Santa Paolina del Cuore Agonizzante di Gesù (Amabile Visintainer)"),
            Santo("Santa Paolina e familiari"),
            Santo("Santa Quinta (Cointa) dAlessandria"),
            Santo("Santa Quiteria"),
            Santo("Santa Radegonda"),
            Santo("Santa Raffaella Maria del Sacro Cuore (Rafaela Porras y Aillón)"),
            Santo("Santa Ragenfreda (Ragenfrida)"),
            Santo("Santa Rita da Cascia"),
            Santo("Santa Rosa da Lima"),
            Santo("Santa Sabina"),
            Santo("Santa Sabina di Jouarre"),
            Santo("Santa Sabina e sorelle"),
            Santo("Santa Sabrina (Savina, Sabina)"),
            Santo("Santa Salaberga"),
            Santo("Santa Salomè"),
            Santo("Santa Sara"),
            Santo("Santa Scolastica"),
            Santo("Santa Tabìta di Ioppe"),
            Santo("Santa Taisia (Taide)"),
            Santo("Santa Talla"),
            Santo("Santa Talulla"),
            Santo("Santa Tanca"),
            Santo("Santa Tarsicia"),
            Santo("Santa Tarsilia (o Tarsilla)"),
            Santo("Santa Taziana di Roma"),
            Santo("Santa Teca"),
            Santo("Santa Tecla"),
            Santo("Santa Tecla di Iconio"),
            Santo("Santa Tecla di Kitzingen"),
            Santo("Santa Teodechilde (Telchilde)"),
            Santo("Santa Teresa Benedetta della Croce (Edith Stein)"),
            Santo("Santa Teresa di Gesù (d'Avila)"),
            Santo("Santa Teresa di Gesù Bambino (di Lisieux)"),
            Santo("Santa Ubaldesca Taccini"),
            Santo("Santa Ulpia Candida"),
            Santo("Santa Ulpia Vittoria"),
            Santo("Santa Umiltà"),
            Santo("Santa Valburga (Valpurga)"),
            Santo("Santa Valdetrude (Waldetruda)"),
            Santo("Santa Valentina"),
            Santo("Santa Valeria"),
            Santo("Santa Valeria di Limoges"),
            Santo("Santa Valeriana e compagne"),
            Santo("Santa Wivine (Vivina)"),
            Santo("Santa Xenia (Eusebia di Milasa)"),
            Santo("Santa Zaira"),
            Santo("Santa Zdislava"),
            Santo("Santa Zita (Cita)"),
            Santo("Sante Barbara Kim e Barbara Yi"),
            Santo("Sante Daria e Derbilia del Connaught"),
            Santo("Sante Magnanzia e Massima"),
            Santo("Sante Palazia e Laurenzia"),
            Santo("Sante Perpetua e Felicita"),
            Santo("Sante Valeria e compagne"),
            Santo("Santi Abati di Agauno"),
            Santo("Santi Abbondio, Abbondanzio, Marciano e Giovanni"),
            Santo("Santi Abda e Ebedieso"),
            Santo("Santi Abdon e Sennen"),
            Santo("Santi Abramo e Coren"),
            Santo(
                "Santi Acindino (Acendino), Pegasio, Aftonio, Elpidiforo, Anempodisto e compagni"
            ),
            Santo("Santi Acisclo e Vittoria"),
            Santo("Santi Aconzio, Nonno, Ercolano e Taurino"),
            Santo("Santi Angeli Custodi"),
            Santo("Santi Babila, Urbano, Prilidano ed Epolono"),
            Santo("Santi Bambini e Giovani"),
            Santo("Santi Banto e Beato"),
            Santo("Santi Baronto (Baronzio) e Desiderio"),
            Santo("Santi Basilio Magno e Gregorio Nazianzeno"),
            Santo("Santi Caio e Cremenzio di Saragozza"),
            Santo("Santi Caio ed Alessandro"),
            Santo("Santi Callinico e Basilissa"),
            Santo("Santi Callinico e compagni"),
            Santo("Santi Carlo Lwanga e 12 compagni"),
            Santo("Santi Cirillo e Metodio"),
            Santo("Santi Cornelio e Cipriano"),
            Santo("Santi Cosma e Damiano"),
            Santo("Santi Dario, Zosimo, Paolo e Secondo di Nicea"),
            Santo("Santi Edmondo Gennings e Swithun Wells"),
            Santo("Santi Fabriciano (Fabrizio) e Filiberto"),
            Santo("Santi Facondo e Primitivo"),
            Santo("Santi Faustino e Giovita"),
            Santo("Santi Fausto, Dio (Divo) e Ammonio"),
            Santo("Santi Fausto, Gennaro e Marziale"),
            Santo("Santi Filippo e Giacomo il Minore"),
            Santo("Santi Galazione ed Episteme"),
            Santo("Santi Giorgio, martire e Adalberto di Praga, Vescovo e martire"),
            Santo("Santi Ierone e compagni"),
            Santo("Santi Ilario e Taziano"),
            Santo("Santi Innocenti"),
            Santo("Santi Lang Yangzhi e Paolo Lang Fu"),
            Santo("Santi Macario, Rufino, Giusto e Teofilo"),
            Santo("Santi Maccabei, Sette fratelli"),
            Santo("Santi Macedonio, Patrizia e Modesta di Nicomedia"),
            Santo("Santi Macedonio, Teodulo e Taziano"),
            Santo("Santi Maddalena Yi Yŏng-hŭi e 7 compagni"),
            Santo("Santi Magi dOriente"),
            Santo("Santi Marcellino e Pietro"),
            Santo("Santi Michele, Gabriele e Raffaele"),
            Santo("Santi Nabore e Felice"),
            Santo("Santi Namfamone e compagni"),
            Santo("Santi Nazario e Celso"),
            Santo(
                "Santi Nemesiano, Felice, Lucio, Litteo, Poliano, Vittore, Iader e Dativo"
            ),
            Santo("Santi Nemorio (Memorio) e compagni"),
            Santo("Santi Nicandro ed Ermeo (Ermete)"),
            Santo("Santi Nicandro, Gregorio, Pietro, Demetrio ed Elisabetta"),
            Santo("Santi Nicasio, Quirino, Scubicolo e Pienza"),
            Santo("Santi Padri Mercedari di Avignone"),
            Santo("Santi Pietro Chanel e Luigi Maria (Grignion) da Montfort"),
            Santo("Santi Pietro e Paolo"),
            Santo("Santi Quarto e Quinto"),
            Santo("Santi Quattro Coronati"),
            Santo("Santi Quinto, Simplicio e compagni"),
            Santo("Santi Quirino e Candido"),
            Santo("Santi Raimondo di San Vittore e Guglielmo di San Leonardo"),
            Santo("Santi Raimondo Li Quanzhen e Pietro Li Quanhui"),
            Santo("Santi Sabiniano e Potenziano"),
            Santo("Santi Sadoth e centoventotto compagni"),
            Santo("Santi Salvio e Superio"),
            Santo(
                "Santi Sette Fondatori dell'Ordine dei Servi della Beata Vergine Maria"
            ),
            Santo("Santi Simone e Giuda"),
            Santo("Santi Tancredi, Torthred e Tova"),
            Santo("Santi Taraco, Probo e Andronico"),
            Santo("Santi Teobaldo d'Inghilterra e Compagno"),
            Santo("Santi Timoteo e Tito"),
            Santo("Santi Valentino e Ilario di Viterbo"),
            Santo("Santi Valeriano e LXXX compagni"),
            Santo("Santi Valerio e Rufino"),
            Santo("Santi Vardan e compagni"),
            Santo("Santi Zenobio e Zenobia"),
            Santo("Santi Zenone e Zena"),
            Santo("Santi Zotico e compagni"),
            Santo("Santissimo Nome di Gesù"),
            Santo("Santo Stanislao"),
            Santo("Santo Stefano"),
            Santo("Santo Stefano di Ungheria"),
            Santo("Sant Abbone (Abbo o Albone)"),
            Santo("Sant Abbone di Auxerre"),
            Santo("Sant Abele di Reims"),
            Santo("Sant Acacio di Militene"),
            Santo("Sant Acca di Hexham"),
            Santo("Sant Achea"),
            Santo("Sant Achilleo (Achilio) il Taumaturgo"),
            Santo("Sant Eberwin di Helfenstein"),
            Santo("Sant Ebregisilo di Meaux"),
            Santo("Sant Iarlugh di Lismore"),
            Santo("Sant Ido"),
            Santo("Sant Ugo di Glazinis (o di Marsiglia)"),
            Santo("Sant Ulrico di Losanna"),
            Santo("Tutti i Santi"),
        ]
