"""Tab components."""

from pynecone.components.libs.chakra import ChakraComponent
from pynecone.var import Var


class Tabs(ChakraComponent):
    """An accessible tabs component that provides keyboard interactions and ARIA attributes described in the WAI-ARIA Tabs Design Pattern. Tabs, provides context and state for all components."""

    tag = "Tabs"

    # The alignment of the tabs ("center" | "end" | "start").
    align: Var[str]

    # The initial index of the selected tab (in uncontrolled mode).
    default_index: Var[int]

    # The id of the tab.
    id_: Var[str]

    # If true, tabs will stretch to width of the tablist.
    is_fitted: Var[bool]

    # Performance booster. If true, rendering of the tab panel's will be deferred until it is selected.
    is_lazy: Var[bool]

    # If true, the tabs will be manually activated and display its panel by pressing Space or Enter. If false, the tabs will be automatically activated and their panel is displayed when they receive focus.
    is_manual: Var[bool]

    # The orientation of the tab list.
    orientation: Var[str]

    # "line" | "enclosed" | "enclosed-colored" | "soft-rounded" | "solid-rounded" | "unstyled"
    variant: Var[str]


class Tab(ChakraComponent):
    """An element that serves as a label for one of the tab panels and can be activated to display that panel.."""

    tag = "Tab"

    # If true, the Tab won't be toggleable.
    is_disabled: Var[bool]

    # If true, the Tab will be selected.
    is_selected: Var[bool]

    # The id of the tab.
    id_: Var[str]

    # The id of the panel.
    panel_id: Var[str]


class TabList(ChakraComponent):
    """Wrapper for the Tab components."""

    tag = "TabList"


class TabPanels(ChakraComponent):
    """Wrapper for the Tab components."""

    tag = "TabPanels"


class TabPanel(ChakraComponent):
    """An element that contains the content associated with a tab."""

    tag = "TabPanel"
