# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixAwsTgwPeeringArgs', 'AviatrixAwsTgwPeering']

@pulumi.input_type
class AviatrixAwsTgwPeeringArgs:
    def __init__(__self__, *,
                 tgw_name1: pulumi.Input[str],
                 tgw_name2: pulumi.Input[str]):
        """
        The set of arguments for constructing a AviatrixAwsTgwPeering resource.
        :param pulumi.Input[str] tgw_name1: This parameter represents name of the first AWS TGW to make a peer pair.
        :param pulumi.Input[str] tgw_name2: This parameter represents name of the second AWS TGW to make a peer pair.
        """
        pulumi.set(__self__, "tgw_name1", tgw_name1)
        pulumi.set(__self__, "tgw_name2", tgw_name2)

    @property
    @pulumi.getter(name="tgwName1")
    def tgw_name1(self) -> pulumi.Input[str]:
        """
        This parameter represents name of the first AWS TGW to make a peer pair.
        """
        return pulumi.get(self, "tgw_name1")

    @tgw_name1.setter
    def tgw_name1(self, value: pulumi.Input[str]):
        pulumi.set(self, "tgw_name1", value)

    @property
    @pulumi.getter(name="tgwName2")
    def tgw_name2(self) -> pulumi.Input[str]:
        """
        This parameter represents name of the second AWS TGW to make a peer pair.
        """
        return pulumi.get(self, "tgw_name2")

    @tgw_name2.setter
    def tgw_name2(self, value: pulumi.Input[str]):
        pulumi.set(self, "tgw_name2", value)


@pulumi.input_type
class _AviatrixAwsTgwPeeringState:
    def __init__(__self__, *,
                 tgw_name1: Optional[pulumi.Input[str]] = None,
                 tgw_name2: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixAwsTgwPeering resources.
        :param pulumi.Input[str] tgw_name1: This parameter represents name of the first AWS TGW to make a peer pair.
        :param pulumi.Input[str] tgw_name2: This parameter represents name of the second AWS TGW to make a peer pair.
        """
        if tgw_name1 is not None:
            pulumi.set(__self__, "tgw_name1", tgw_name1)
        if tgw_name2 is not None:
            pulumi.set(__self__, "tgw_name2", tgw_name2)

    @property
    @pulumi.getter(name="tgwName1")
    def tgw_name1(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents name of the first AWS TGW to make a peer pair.
        """
        return pulumi.get(self, "tgw_name1")

    @tgw_name1.setter
    def tgw_name1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tgw_name1", value)

    @property
    @pulumi.getter(name="tgwName2")
    def tgw_name2(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents name of the second AWS TGW to make a peer pair.
        """
        return pulumi.get(self, "tgw_name2")

    @tgw_name2.setter
    def tgw_name2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tgw_name2", value)


class AviatrixAwsTgwPeering(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 tgw_name1: Optional[pulumi.Input[str]] = None,
                 tgw_name2: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The **aviatrix_aws_tgw_peering** resource allows the creation and management of Aviatrix-created inter-region peerings between AWS TGWs.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix AWS Tgw Peering
        test = aviatrix.AviatrixAwsTgwPeering("test",
            tgw_name1="tgw1",
            tgw_name2="tgw2")
        ```

        ## Import

        **aws_tgw_peering** can be imported using the `tgw_name1` and `tgw_name2`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixAwsTgwPeering:AviatrixAwsTgwPeering test tgw_name1~tgw_name2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] tgw_name1: This parameter represents name of the first AWS TGW to make a peer pair.
        :param pulumi.Input[str] tgw_name2: This parameter represents name of the second AWS TGW to make a peer pair.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixAwsTgwPeeringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_aws_tgw_peering** resource allows the creation and management of Aviatrix-created inter-region peerings between AWS TGWs.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix AWS Tgw Peering
        test = aviatrix.AviatrixAwsTgwPeering("test",
            tgw_name1="tgw1",
            tgw_name2="tgw2")
        ```

        ## Import

        **aws_tgw_peering** can be imported using the `tgw_name1` and `tgw_name2`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixAwsTgwPeering:AviatrixAwsTgwPeering test tgw_name1~tgw_name2
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixAwsTgwPeeringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixAwsTgwPeeringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 tgw_name1: Optional[pulumi.Input[str]] = None,
                 tgw_name2: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixAwsTgwPeeringArgs.__new__(AviatrixAwsTgwPeeringArgs)

            if tgw_name1 is None and not opts.urn:
                raise TypeError("Missing required property 'tgw_name1'")
            __props__.__dict__["tgw_name1"] = tgw_name1
            if tgw_name2 is None and not opts.urn:
                raise TypeError("Missing required property 'tgw_name2'")
            __props__.__dict__["tgw_name2"] = tgw_name2
        super(AviatrixAwsTgwPeering, __self__).__init__(
            'aviatrix:index/aviatrixAwsTgwPeering:AviatrixAwsTgwPeering',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            tgw_name1: Optional[pulumi.Input[str]] = None,
            tgw_name2: Optional[pulumi.Input[str]] = None) -> 'AviatrixAwsTgwPeering':
        """
        Get an existing AviatrixAwsTgwPeering resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] tgw_name1: This parameter represents name of the first AWS TGW to make a peer pair.
        :param pulumi.Input[str] tgw_name2: This parameter represents name of the second AWS TGW to make a peer pair.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixAwsTgwPeeringState.__new__(_AviatrixAwsTgwPeeringState)

        __props__.__dict__["tgw_name1"] = tgw_name1
        __props__.__dict__["tgw_name2"] = tgw_name2
        return AviatrixAwsTgwPeering(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="tgwName1")
    def tgw_name1(self) -> pulumi.Output[str]:
        """
        This parameter represents name of the first AWS TGW to make a peer pair.
        """
        return pulumi.get(self, "tgw_name1")

    @property
    @pulumi.getter(name="tgwName2")
    def tgw_name2(self) -> pulumi.Output[str]:
        """
        This parameter represents name of the second AWS TGW to make a peer pair.
        """
        return pulumi.get(self, "tgw_name2")

