# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixControllerConfigArgs', 'AviatrixControllerConfig']

@pulumi.input_type
class AviatrixControllerConfigArgs:
    def __init__(__self__, *,
                 aws_guard_duty_scanning_interval: Optional[pulumi.Input[int]] = None,
                 backup_account_name: Optional[pulumi.Input[str]] = None,
                 backup_bucket_name: Optional[pulumi.Input[str]] = None,
                 backup_cloud_type: Optional[pulumi.Input[int]] = None,
                 backup_configuration: Optional[pulumi.Input[bool]] = None,
                 backup_container_name: Optional[pulumi.Input[str]] = None,
                 backup_region: Optional[pulumi.Input[str]] = None,
                 backup_storage_name: Optional[pulumi.Input[str]] = None,
                 ca_certificate_file: Optional[pulumi.Input[str]] = None,
                 ca_certificate_file_path: Optional[pulumi.Input[str]] = None,
                 enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
                 fqdn_exception_rule: Optional[pulumi.Input[bool]] = None,
                 http_access: Optional[pulumi.Input[bool]] = None,
                 manage_gateway_upgrades: Optional[pulumi.Input[bool]] = None,
                 multiple_backups: Optional[pulumi.Input[bool]] = None,
                 server_private_key_file: Optional[pulumi.Input[str]] = None,
                 server_private_key_file_path: Optional[pulumi.Input[str]] = None,
                 server_public_certificate_file: Optional[pulumi.Input[str]] = None,
                 server_public_certificate_file_path: Optional[pulumi.Input[str]] = None,
                 target_version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixControllerConfig resource.
        :param pulumi.Input[int] aws_guard_duty_scanning_interval: Configure the AWS Guard Duty scanning interval. Valid values: 5, 10, 15, 30 or 60. Default value: 60. Available as of provider version R2.18+.
        :param pulumi.Input[str] backup_account_name: Name of the cloud account in the Aviatrix controller.
        :param pulumi.Input[str] backup_bucket_name: Bucket Name. Required to enable configuration backup for AWS, AWSGov, GCP and OCI.
        :param pulumi.Input[int] backup_cloud_type: Type of cloud service provider, requires an integer value. Use 1 for AWS, 4 for GCP, 8 for Azure, 16 for OCI, and 256 for AWSGov.
        :param pulumi.Input[bool] backup_configuration: Switch to enable/disable controller CloudN backup config. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] backup_container_name: Container name. Required to enable configuration backup for Azure.
        :param pulumi.Input[str] backup_region: Name of region. Required to enable configuration backup for Azure and OCI.
        :param pulumi.Input[str] backup_storage_name: Storage name. Required to enable configuration backup for Azure.
        :param pulumi.Input[str] ca_certificate_file: CA certificate. To read certificate file from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        :param pulumi.Input[str] ca_certificate_file_path: File path to CA certificate. Available as of provider version R2.18+.
        :param pulumi.Input[bool] enable_vpc_dns_server: Enable VPC/VNET DNS Server for the controller. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] fqdn_exception_rule: Enable/disable packets without an SNI field to pass through gateway(s). Valid values: true, false. Default value: true. For more information on this setting, please see [here](https://docs.aviatrix.com/HowTos/FQDN_Whitelists_Ref_Design.html#exception-rule)
        :param pulumi.Input[bool] http_access: Switch for HTTP access. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] manage_gateway_upgrades: If true, AviatrixControllerConfig will upgrade all gateways when target_version is set. If false, only the controller will be upgraded when target_version is set. In that case gateway upgrades should be handled in each gateway resource individually using the software_version and image_version attributes. Type: boolean. Default: true. Available as of provider version R2.20.0+.
        :param pulumi.Input[bool] multiple_backups: Switch to enable the Controller to backup up to a maximum of 3 rotating backups. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] server_private_key_file: Server private key. To read the private key from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        :param pulumi.Input[str] server_private_key_file_path: File path to server private key. Available as of provider version R2.18+.
        :param pulumi.Input[str] server_public_certificate_file: Server public certificate. To read certificate file from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        :param pulumi.Input[str] server_public_certificate_file_path: File path to the server public certificate. Available as of provider version R2.18+.
        :param pulumi.Input[str] target_version: The release version number to which the controller will be upgraded to. If not specified, controller will not be upgraded. If set to "latest", controller will be upgraded to the latest release. Please see the [Controller upgrade guide](https://docs.aviatrix.com/HowTos/inline_upgrade.html) for more information.
        """
        if aws_guard_duty_scanning_interval is not None:
            pulumi.set(__self__, "aws_guard_duty_scanning_interval", aws_guard_duty_scanning_interval)
        if backup_account_name is not None:
            pulumi.set(__self__, "backup_account_name", backup_account_name)
        if backup_bucket_name is not None:
            pulumi.set(__self__, "backup_bucket_name", backup_bucket_name)
        if backup_cloud_type is not None:
            pulumi.set(__self__, "backup_cloud_type", backup_cloud_type)
        if backup_configuration is not None:
            pulumi.set(__self__, "backup_configuration", backup_configuration)
        if backup_container_name is not None:
            pulumi.set(__self__, "backup_container_name", backup_container_name)
        if backup_region is not None:
            pulumi.set(__self__, "backup_region", backup_region)
        if backup_storage_name is not None:
            pulumi.set(__self__, "backup_storage_name", backup_storage_name)
        if ca_certificate_file is not None:
            pulumi.set(__self__, "ca_certificate_file", ca_certificate_file)
        if ca_certificate_file_path is not None:
            pulumi.set(__self__, "ca_certificate_file_path", ca_certificate_file_path)
        if enable_vpc_dns_server is not None:
            pulumi.set(__self__, "enable_vpc_dns_server", enable_vpc_dns_server)
        if fqdn_exception_rule is not None:
            pulumi.set(__self__, "fqdn_exception_rule", fqdn_exception_rule)
        if http_access is not None:
            pulumi.set(__self__, "http_access", http_access)
        if manage_gateway_upgrades is not None:
            pulumi.set(__self__, "manage_gateway_upgrades", manage_gateway_upgrades)
        if multiple_backups is not None:
            pulumi.set(__self__, "multiple_backups", multiple_backups)
        if server_private_key_file is not None:
            pulumi.set(__self__, "server_private_key_file", server_private_key_file)
        if server_private_key_file_path is not None:
            pulumi.set(__self__, "server_private_key_file_path", server_private_key_file_path)
        if server_public_certificate_file is not None:
            pulumi.set(__self__, "server_public_certificate_file", server_public_certificate_file)
        if server_public_certificate_file_path is not None:
            pulumi.set(__self__, "server_public_certificate_file_path", server_public_certificate_file_path)
        if target_version is not None:
            pulumi.set(__self__, "target_version", target_version)

    @property
    @pulumi.getter(name="awsGuardDutyScanningInterval")
    def aws_guard_duty_scanning_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Configure the AWS Guard Duty scanning interval. Valid values: 5, 10, 15, 30 or 60. Default value: 60. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "aws_guard_duty_scanning_interval")

    @aws_guard_duty_scanning_interval.setter
    def aws_guard_duty_scanning_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "aws_guard_duty_scanning_interval", value)

    @property
    @pulumi.getter(name="backupAccountName")
    def backup_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the cloud account in the Aviatrix controller.
        """
        return pulumi.get(self, "backup_account_name")

    @backup_account_name.setter
    def backup_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_account_name", value)

    @property
    @pulumi.getter(name="backupBucketName")
    def backup_bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        Bucket Name. Required to enable configuration backup for AWS, AWSGov, GCP and OCI.
        """
        return pulumi.get(self, "backup_bucket_name")

    @backup_bucket_name.setter
    def backup_bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_bucket_name", value)

    @property
    @pulumi.getter(name="backupCloudType")
    def backup_cloud_type(self) -> Optional[pulumi.Input[int]]:
        """
        Type of cloud service provider, requires an integer value. Use 1 for AWS, 4 for GCP, 8 for Azure, 16 for OCI, and 256 for AWSGov.
        """
        return pulumi.get(self, "backup_cloud_type")

    @backup_cloud_type.setter
    def backup_cloud_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_cloud_type", value)

    @property
    @pulumi.getter(name="backupConfiguration")
    def backup_configuration(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable/disable controller CloudN backup config. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "backup_configuration")

    @backup_configuration.setter
    def backup_configuration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_configuration", value)

    @property
    @pulumi.getter(name="backupContainerName")
    def backup_container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Container name. Required to enable configuration backup for Azure.
        """
        return pulumi.get(self, "backup_container_name")

    @backup_container_name.setter
    def backup_container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_container_name", value)

    @property
    @pulumi.getter(name="backupRegion")
    def backup_region(self) -> Optional[pulumi.Input[str]]:
        """
        Name of region. Required to enable configuration backup for Azure and OCI.
        """
        return pulumi.get(self, "backup_region")

    @backup_region.setter
    def backup_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_region", value)

    @property
    @pulumi.getter(name="backupStorageName")
    def backup_storage_name(self) -> Optional[pulumi.Input[str]]:
        """
        Storage name. Required to enable configuration backup for Azure.
        """
        return pulumi.get(self, "backup_storage_name")

    @backup_storage_name.setter
    def backup_storage_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_storage_name", value)

    @property
    @pulumi.getter(name="caCertificateFile")
    def ca_certificate_file(self) -> Optional[pulumi.Input[str]]:
        """
        CA certificate. To read certificate file from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        """
        return pulumi.get(self, "ca_certificate_file")

    @ca_certificate_file.setter
    def ca_certificate_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate_file", value)

    @property
    @pulumi.getter(name="caCertificateFilePath")
    def ca_certificate_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        File path to CA certificate. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "ca_certificate_file_path")

    @ca_certificate_file_path.setter
    def ca_certificate_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate_file_path", value)

    @property
    @pulumi.getter(name="enableVpcDnsServer")
    def enable_vpc_dns_server(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable VPC/VNET DNS Server for the controller. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_vpc_dns_server")

    @enable_vpc_dns_server.setter
    def enable_vpc_dns_server(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vpc_dns_server", value)

    @property
    @pulumi.getter(name="fqdnExceptionRule")
    def fqdn_exception_rule(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable/disable packets without an SNI field to pass through gateway(s). Valid values: true, false. Default value: true. For more information on this setting, please see [here](https://docs.aviatrix.com/HowTos/FQDN_Whitelists_Ref_Design.html#exception-rule)
        """
        return pulumi.get(self, "fqdn_exception_rule")

    @fqdn_exception_rule.setter
    def fqdn_exception_rule(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fqdn_exception_rule", value)

    @property
    @pulumi.getter(name="httpAccess")
    def http_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch for HTTP access. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "http_access")

    @http_access.setter
    def http_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http_access", value)

    @property
    @pulumi.getter(name="manageGatewayUpgrades")
    def manage_gateway_upgrades(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, AviatrixControllerConfig will upgrade all gateways when target_version is set. If false, only the controller will be upgraded when target_version is set. In that case gateway upgrades should be handled in each gateway resource individually using the software_version and image_version attributes. Type: boolean. Default: true. Available as of provider version R2.20.0+.
        """
        return pulumi.get(self, "manage_gateway_upgrades")

    @manage_gateway_upgrades.setter
    def manage_gateway_upgrades(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_gateway_upgrades", value)

    @property
    @pulumi.getter(name="multipleBackups")
    def multiple_backups(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable the Controller to backup up to a maximum of 3 rotating backups. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "multiple_backups")

    @multiple_backups.setter
    def multiple_backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multiple_backups", value)

    @property
    @pulumi.getter(name="serverPrivateKeyFile")
    def server_private_key_file(self) -> Optional[pulumi.Input[str]]:
        """
        Server private key. To read the private key from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        """
        return pulumi.get(self, "server_private_key_file")

    @server_private_key_file.setter
    def server_private_key_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_private_key_file", value)

    @property
    @pulumi.getter(name="serverPrivateKeyFilePath")
    def server_private_key_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        File path to server private key. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "server_private_key_file_path")

    @server_private_key_file_path.setter
    def server_private_key_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_private_key_file_path", value)

    @property
    @pulumi.getter(name="serverPublicCertificateFile")
    def server_public_certificate_file(self) -> Optional[pulumi.Input[str]]:
        """
        Server public certificate. To read certificate file from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        """
        return pulumi.get(self, "server_public_certificate_file")

    @server_public_certificate_file.setter
    def server_public_certificate_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_public_certificate_file", value)

    @property
    @pulumi.getter(name="serverPublicCertificateFilePath")
    def server_public_certificate_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        File path to the server public certificate. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "server_public_certificate_file_path")

    @server_public_certificate_file_path.setter
    def server_public_certificate_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_public_certificate_file_path", value)

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> Optional[pulumi.Input[str]]:
        """
        The release version number to which the controller will be upgraded to. If not specified, controller will not be upgraded. If set to "latest", controller will be upgraded to the latest release. Please see the [Controller upgrade guide](https://docs.aviatrix.com/HowTos/inline_upgrade.html) for more information.
        """
        return pulumi.get(self, "target_version")

    @target_version.setter
    def target_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_version", value)


@pulumi.input_type
class _AviatrixControllerConfigState:
    def __init__(__self__, *,
                 aws_guard_duty_scanning_interval: Optional[pulumi.Input[int]] = None,
                 backup_account_name: Optional[pulumi.Input[str]] = None,
                 backup_bucket_name: Optional[pulumi.Input[str]] = None,
                 backup_cloud_type: Optional[pulumi.Input[int]] = None,
                 backup_configuration: Optional[pulumi.Input[bool]] = None,
                 backup_container_name: Optional[pulumi.Input[str]] = None,
                 backup_region: Optional[pulumi.Input[str]] = None,
                 backup_storage_name: Optional[pulumi.Input[str]] = None,
                 ca_certificate_file: Optional[pulumi.Input[str]] = None,
                 ca_certificate_file_path: Optional[pulumi.Input[str]] = None,
                 current_version: Optional[pulumi.Input[str]] = None,
                 enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
                 fqdn_exception_rule: Optional[pulumi.Input[bool]] = None,
                 http_access: Optional[pulumi.Input[bool]] = None,
                 manage_gateway_upgrades: Optional[pulumi.Input[bool]] = None,
                 multiple_backups: Optional[pulumi.Input[bool]] = None,
                 previous_version: Optional[pulumi.Input[str]] = None,
                 server_private_key_file: Optional[pulumi.Input[str]] = None,
                 server_private_key_file_path: Optional[pulumi.Input[str]] = None,
                 server_public_certificate_file: Optional[pulumi.Input[str]] = None,
                 server_public_certificate_file_path: Optional[pulumi.Input[str]] = None,
                 target_version: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixControllerConfig resources.
        :param pulumi.Input[int] aws_guard_duty_scanning_interval: Configure the AWS Guard Duty scanning interval. Valid values: 5, 10, 15, 30 or 60. Default value: 60. Available as of provider version R2.18+.
        :param pulumi.Input[str] backup_account_name: Name of the cloud account in the Aviatrix controller.
        :param pulumi.Input[str] backup_bucket_name: Bucket Name. Required to enable configuration backup for AWS, AWSGov, GCP and OCI.
        :param pulumi.Input[int] backup_cloud_type: Type of cloud service provider, requires an integer value. Use 1 for AWS, 4 for GCP, 8 for Azure, 16 for OCI, and 256 for AWSGov.
        :param pulumi.Input[bool] backup_configuration: Switch to enable/disable controller CloudN backup config. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] backup_container_name: Container name. Required to enable configuration backup for Azure.
        :param pulumi.Input[str] backup_region: Name of region. Required to enable configuration backup for Azure and OCI.
        :param pulumi.Input[str] backup_storage_name: Storage name. Required to enable configuration backup for Azure.
        :param pulumi.Input[str] ca_certificate_file: CA certificate. To read certificate file from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        :param pulumi.Input[str] ca_certificate_file_path: File path to CA certificate. Available as of provider version R2.18+.
        :param pulumi.Input[str] current_version: Current version of the controller including the build number. Example: "6.5.123". Available as of provider version R2.20.0+.
        :param pulumi.Input[bool] enable_vpc_dns_server: Enable VPC/VNET DNS Server for the controller. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] fqdn_exception_rule: Enable/disable packets without an SNI field to pass through gateway(s). Valid values: true, false. Default value: true. For more information on this setting, please see [here](https://docs.aviatrix.com/HowTos/FQDN_Whitelists_Ref_Design.html#exception-rule)
        :param pulumi.Input[bool] http_access: Switch for HTTP access. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] manage_gateway_upgrades: If true, AviatrixControllerConfig will upgrade all gateways when target_version is set. If false, only the controller will be upgraded when target_version is set. In that case gateway upgrades should be handled in each gateway resource individually using the software_version and image_version attributes. Type: boolean. Default: true. Available as of provider version R2.20.0+.
        :param pulumi.Input[bool] multiple_backups: Switch to enable the Controller to backup up to a maximum of 3 rotating backups. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] previous_version: Previous version of the controller including the build number. Example: "6.5.123". Available as of provider version R2.20.0+.
        :param pulumi.Input[str] server_private_key_file: Server private key. To read the private key from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        :param pulumi.Input[str] server_private_key_file_path: File path to server private key. Available as of provider version R2.18+.
        :param pulumi.Input[str] server_public_certificate_file: Server public certificate. To read certificate file from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        :param pulumi.Input[str] server_public_certificate_file_path: File path to the server public certificate. Available as of provider version R2.18+.
        :param pulumi.Input[str] target_version: The release version number to which the controller will be upgraded to. If not specified, controller will not be upgraded. If set to "latest", controller will be upgraded to the latest release. Please see the [Controller upgrade guide](https://docs.aviatrix.com/HowTos/inline_upgrade.html) for more information.
        :param pulumi.Input[str] version: Current version of the controller without build number. Example: "6.5"
        """
        if aws_guard_duty_scanning_interval is not None:
            pulumi.set(__self__, "aws_guard_duty_scanning_interval", aws_guard_duty_scanning_interval)
        if backup_account_name is not None:
            pulumi.set(__self__, "backup_account_name", backup_account_name)
        if backup_bucket_name is not None:
            pulumi.set(__self__, "backup_bucket_name", backup_bucket_name)
        if backup_cloud_type is not None:
            pulumi.set(__self__, "backup_cloud_type", backup_cloud_type)
        if backup_configuration is not None:
            pulumi.set(__self__, "backup_configuration", backup_configuration)
        if backup_container_name is not None:
            pulumi.set(__self__, "backup_container_name", backup_container_name)
        if backup_region is not None:
            pulumi.set(__self__, "backup_region", backup_region)
        if backup_storage_name is not None:
            pulumi.set(__self__, "backup_storage_name", backup_storage_name)
        if ca_certificate_file is not None:
            pulumi.set(__self__, "ca_certificate_file", ca_certificate_file)
        if ca_certificate_file_path is not None:
            pulumi.set(__self__, "ca_certificate_file_path", ca_certificate_file_path)
        if current_version is not None:
            pulumi.set(__self__, "current_version", current_version)
        if enable_vpc_dns_server is not None:
            pulumi.set(__self__, "enable_vpc_dns_server", enable_vpc_dns_server)
        if fqdn_exception_rule is not None:
            pulumi.set(__self__, "fqdn_exception_rule", fqdn_exception_rule)
        if http_access is not None:
            pulumi.set(__self__, "http_access", http_access)
        if manage_gateway_upgrades is not None:
            pulumi.set(__self__, "manage_gateway_upgrades", manage_gateway_upgrades)
        if multiple_backups is not None:
            pulumi.set(__self__, "multiple_backups", multiple_backups)
        if previous_version is not None:
            pulumi.set(__self__, "previous_version", previous_version)
        if server_private_key_file is not None:
            pulumi.set(__self__, "server_private_key_file", server_private_key_file)
        if server_private_key_file_path is not None:
            pulumi.set(__self__, "server_private_key_file_path", server_private_key_file_path)
        if server_public_certificate_file is not None:
            pulumi.set(__self__, "server_public_certificate_file", server_public_certificate_file)
        if server_public_certificate_file_path is not None:
            pulumi.set(__self__, "server_public_certificate_file_path", server_public_certificate_file_path)
        if target_version is not None:
            pulumi.set(__self__, "target_version", target_version)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="awsGuardDutyScanningInterval")
    def aws_guard_duty_scanning_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Configure the AWS Guard Duty scanning interval. Valid values: 5, 10, 15, 30 or 60. Default value: 60. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "aws_guard_duty_scanning_interval")

    @aws_guard_duty_scanning_interval.setter
    def aws_guard_duty_scanning_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "aws_guard_duty_scanning_interval", value)

    @property
    @pulumi.getter(name="backupAccountName")
    def backup_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the cloud account in the Aviatrix controller.
        """
        return pulumi.get(self, "backup_account_name")

    @backup_account_name.setter
    def backup_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_account_name", value)

    @property
    @pulumi.getter(name="backupBucketName")
    def backup_bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        Bucket Name. Required to enable configuration backup for AWS, AWSGov, GCP and OCI.
        """
        return pulumi.get(self, "backup_bucket_name")

    @backup_bucket_name.setter
    def backup_bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_bucket_name", value)

    @property
    @pulumi.getter(name="backupCloudType")
    def backup_cloud_type(self) -> Optional[pulumi.Input[int]]:
        """
        Type of cloud service provider, requires an integer value. Use 1 for AWS, 4 for GCP, 8 for Azure, 16 for OCI, and 256 for AWSGov.
        """
        return pulumi.get(self, "backup_cloud_type")

    @backup_cloud_type.setter
    def backup_cloud_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_cloud_type", value)

    @property
    @pulumi.getter(name="backupConfiguration")
    def backup_configuration(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable/disable controller CloudN backup config. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "backup_configuration")

    @backup_configuration.setter
    def backup_configuration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_configuration", value)

    @property
    @pulumi.getter(name="backupContainerName")
    def backup_container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Container name. Required to enable configuration backup for Azure.
        """
        return pulumi.get(self, "backup_container_name")

    @backup_container_name.setter
    def backup_container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_container_name", value)

    @property
    @pulumi.getter(name="backupRegion")
    def backup_region(self) -> Optional[pulumi.Input[str]]:
        """
        Name of region. Required to enable configuration backup for Azure and OCI.
        """
        return pulumi.get(self, "backup_region")

    @backup_region.setter
    def backup_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_region", value)

    @property
    @pulumi.getter(name="backupStorageName")
    def backup_storage_name(self) -> Optional[pulumi.Input[str]]:
        """
        Storage name. Required to enable configuration backup for Azure.
        """
        return pulumi.get(self, "backup_storage_name")

    @backup_storage_name.setter
    def backup_storage_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_storage_name", value)

    @property
    @pulumi.getter(name="caCertificateFile")
    def ca_certificate_file(self) -> Optional[pulumi.Input[str]]:
        """
        CA certificate. To read certificate file from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        """
        return pulumi.get(self, "ca_certificate_file")

    @ca_certificate_file.setter
    def ca_certificate_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate_file", value)

    @property
    @pulumi.getter(name="caCertificateFilePath")
    def ca_certificate_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        File path to CA certificate. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "ca_certificate_file_path")

    @ca_certificate_file_path.setter
    def ca_certificate_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate_file_path", value)

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> Optional[pulumi.Input[str]]:
        """
        Current version of the controller including the build number. Example: "6.5.123". Available as of provider version R2.20.0+.
        """
        return pulumi.get(self, "current_version")

    @current_version.setter
    def current_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_version", value)

    @property
    @pulumi.getter(name="enableVpcDnsServer")
    def enable_vpc_dns_server(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable VPC/VNET DNS Server for the controller. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_vpc_dns_server")

    @enable_vpc_dns_server.setter
    def enable_vpc_dns_server(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vpc_dns_server", value)

    @property
    @pulumi.getter(name="fqdnExceptionRule")
    def fqdn_exception_rule(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable/disable packets without an SNI field to pass through gateway(s). Valid values: true, false. Default value: true. For more information on this setting, please see [here](https://docs.aviatrix.com/HowTos/FQDN_Whitelists_Ref_Design.html#exception-rule)
        """
        return pulumi.get(self, "fqdn_exception_rule")

    @fqdn_exception_rule.setter
    def fqdn_exception_rule(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fqdn_exception_rule", value)

    @property
    @pulumi.getter(name="httpAccess")
    def http_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch for HTTP access. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "http_access")

    @http_access.setter
    def http_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http_access", value)

    @property
    @pulumi.getter(name="manageGatewayUpgrades")
    def manage_gateway_upgrades(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, AviatrixControllerConfig will upgrade all gateways when target_version is set. If false, only the controller will be upgraded when target_version is set. In that case gateway upgrades should be handled in each gateway resource individually using the software_version and image_version attributes. Type: boolean. Default: true. Available as of provider version R2.20.0+.
        """
        return pulumi.get(self, "manage_gateway_upgrades")

    @manage_gateway_upgrades.setter
    def manage_gateway_upgrades(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_gateway_upgrades", value)

    @property
    @pulumi.getter(name="multipleBackups")
    def multiple_backups(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable the Controller to backup up to a maximum of 3 rotating backups. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "multiple_backups")

    @multiple_backups.setter
    def multiple_backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multiple_backups", value)

    @property
    @pulumi.getter(name="previousVersion")
    def previous_version(self) -> Optional[pulumi.Input[str]]:
        """
        Previous version of the controller including the build number. Example: "6.5.123". Available as of provider version R2.20.0+.
        """
        return pulumi.get(self, "previous_version")

    @previous_version.setter
    def previous_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "previous_version", value)

    @property
    @pulumi.getter(name="serverPrivateKeyFile")
    def server_private_key_file(self) -> Optional[pulumi.Input[str]]:
        """
        Server private key. To read the private key from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        """
        return pulumi.get(self, "server_private_key_file")

    @server_private_key_file.setter
    def server_private_key_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_private_key_file", value)

    @property
    @pulumi.getter(name="serverPrivateKeyFilePath")
    def server_private_key_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        File path to server private key. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "server_private_key_file_path")

    @server_private_key_file_path.setter
    def server_private_key_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_private_key_file_path", value)

    @property
    @pulumi.getter(name="serverPublicCertificateFile")
    def server_public_certificate_file(self) -> Optional[pulumi.Input[str]]:
        """
        Server public certificate. To read certificate file from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        """
        return pulumi.get(self, "server_public_certificate_file")

    @server_public_certificate_file.setter
    def server_public_certificate_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_public_certificate_file", value)

    @property
    @pulumi.getter(name="serverPublicCertificateFilePath")
    def server_public_certificate_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        File path to the server public certificate. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "server_public_certificate_file_path")

    @server_public_certificate_file_path.setter
    def server_public_certificate_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_public_certificate_file_path", value)

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> Optional[pulumi.Input[str]]:
        """
        The release version number to which the controller will be upgraded to. If not specified, controller will not be upgraded. If set to "latest", controller will be upgraded to the latest release. Please see the [Controller upgrade guide](https://docs.aviatrix.com/HowTos/inline_upgrade.html) for more information.
        """
        return pulumi.get(self, "target_version")

    @target_version.setter
    def target_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_version", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Current version of the controller without build number. Example: "6.5"
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class AviatrixControllerConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_guard_duty_scanning_interval: Optional[pulumi.Input[int]] = None,
                 backup_account_name: Optional[pulumi.Input[str]] = None,
                 backup_bucket_name: Optional[pulumi.Input[str]] = None,
                 backup_cloud_type: Optional[pulumi.Input[int]] = None,
                 backup_configuration: Optional[pulumi.Input[bool]] = None,
                 backup_container_name: Optional[pulumi.Input[str]] = None,
                 backup_region: Optional[pulumi.Input[str]] = None,
                 backup_storage_name: Optional[pulumi.Input[str]] = None,
                 ca_certificate_file: Optional[pulumi.Input[str]] = None,
                 ca_certificate_file_path: Optional[pulumi.Input[str]] = None,
                 enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
                 fqdn_exception_rule: Optional[pulumi.Input[bool]] = None,
                 http_access: Optional[pulumi.Input[bool]] = None,
                 manage_gateway_upgrades: Optional[pulumi.Input[bool]] = None,
                 multiple_backups: Optional[pulumi.Input[bool]] = None,
                 server_private_key_file: Optional[pulumi.Input[str]] = None,
                 server_private_key_file_path: Optional[pulumi.Input[str]] = None,
                 server_public_certificate_file: Optional[pulumi.Input[str]] = None,
                 server_public_certificate_file_path: Optional[pulumi.Input[str]] = None,
                 target_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The **aviatrix_controller_config** resource allows management of an Aviatrix Controller's configurations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Controller Config
        test_controller_config = aviatrix.AviatrixControllerConfig("testControllerConfig",
            fqdn_exception_rule=False,
            http_access=True)
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Controller Config with Controller Upgrade Without Upgrading Gateways
        test_controller_config = aviatrix.AviatrixControllerConfig("testControllerConfig",
            fqdn_exception_rule=False,
            http_access=True,
            manage_gateway_upgrades=False,
            target_version="latest")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Controller Config with Controller Upgrade + Upgrade All Gateways
        test_controller_config = aviatrix.AviatrixControllerConfig("testControllerConfig",
            fqdn_exception_rule=False,
            http_access=True,
            target_version="latest")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Controller Config with Cloudn Backup Configuration Enabled
        test_controller_config = aviatrix.AviatrixControllerConfig("testControllerConfig",
            backup_account_name="account_example",
            backup_bucket_name="bucket_example",
            backup_cloud_type=1,
            backup_configuration=True)
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Controller Config and import HTTPS certificates
        test_controller_config = aviatrix.AviatrixControllerConfig("testControllerConfig",
            ca_certificate_file_path="/path/to/ca_certificate.pem",
            server_private_key_file_path="/path/to/server.key",
            server_public_certificate_file_path="/path/to/server.crt")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Controller Config and configure the AWS Guard Duty Scanning Interval
        test_controller_config = aviatrix.AviatrixControllerConfig("testControllerConfig", aws_guard_duty_scanning_interval=10)
        ```

        ## Import

        Instance controller_config can be imported using controller IP, e.g. controller IP is 10.11.12.13

        ```sh
         $ pulumi import aviatrix:index/aviatrixControllerConfig:AviatrixControllerConfig test 10-11-12-13
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] aws_guard_duty_scanning_interval: Configure the AWS Guard Duty scanning interval. Valid values: 5, 10, 15, 30 or 60. Default value: 60. Available as of provider version R2.18+.
        :param pulumi.Input[str] backup_account_name: Name of the cloud account in the Aviatrix controller.
        :param pulumi.Input[str] backup_bucket_name: Bucket Name. Required to enable configuration backup for AWS, AWSGov, GCP and OCI.
        :param pulumi.Input[int] backup_cloud_type: Type of cloud service provider, requires an integer value. Use 1 for AWS, 4 for GCP, 8 for Azure, 16 for OCI, and 256 for AWSGov.
        :param pulumi.Input[bool] backup_configuration: Switch to enable/disable controller CloudN backup config. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] backup_container_name: Container name. Required to enable configuration backup for Azure.
        :param pulumi.Input[str] backup_region: Name of region. Required to enable configuration backup for Azure and OCI.
        :param pulumi.Input[str] backup_storage_name: Storage name. Required to enable configuration backup for Azure.
        :param pulumi.Input[str] ca_certificate_file: CA certificate. To read certificate file from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        :param pulumi.Input[str] ca_certificate_file_path: File path to CA certificate. Available as of provider version R2.18+.
        :param pulumi.Input[bool] enable_vpc_dns_server: Enable VPC/VNET DNS Server for the controller. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] fqdn_exception_rule: Enable/disable packets without an SNI field to pass through gateway(s). Valid values: true, false. Default value: true. For more information on this setting, please see [here](https://docs.aviatrix.com/HowTos/FQDN_Whitelists_Ref_Design.html#exception-rule)
        :param pulumi.Input[bool] http_access: Switch for HTTP access. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] manage_gateway_upgrades: If true, AviatrixControllerConfig will upgrade all gateways when target_version is set. If false, only the controller will be upgraded when target_version is set. In that case gateway upgrades should be handled in each gateway resource individually using the software_version and image_version attributes. Type: boolean. Default: true. Available as of provider version R2.20.0+.
        :param pulumi.Input[bool] multiple_backups: Switch to enable the Controller to backup up to a maximum of 3 rotating backups. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] server_private_key_file: Server private key. To read the private key from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        :param pulumi.Input[str] server_private_key_file_path: File path to server private key. Available as of provider version R2.18+.
        :param pulumi.Input[str] server_public_certificate_file: Server public certificate. To read certificate file from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        :param pulumi.Input[str] server_public_certificate_file_path: File path to the server public certificate. Available as of provider version R2.18+.
        :param pulumi.Input[str] target_version: The release version number to which the controller will be upgraded to. If not specified, controller will not be upgraded. If set to "latest", controller will be upgraded to the latest release. Please see the [Controller upgrade guide](https://docs.aviatrix.com/HowTos/inline_upgrade.html) for more information.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AviatrixControllerConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_controller_config** resource allows management of an Aviatrix Controller's configurations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Controller Config
        test_controller_config = aviatrix.AviatrixControllerConfig("testControllerConfig",
            fqdn_exception_rule=False,
            http_access=True)
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Controller Config with Controller Upgrade Without Upgrading Gateways
        test_controller_config = aviatrix.AviatrixControllerConfig("testControllerConfig",
            fqdn_exception_rule=False,
            http_access=True,
            manage_gateway_upgrades=False,
            target_version="latest")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Controller Config with Controller Upgrade + Upgrade All Gateways
        test_controller_config = aviatrix.AviatrixControllerConfig("testControllerConfig",
            fqdn_exception_rule=False,
            http_access=True,
            target_version="latest")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Controller Config with Cloudn Backup Configuration Enabled
        test_controller_config = aviatrix.AviatrixControllerConfig("testControllerConfig",
            backup_account_name="account_example",
            backup_bucket_name="bucket_example",
            backup_cloud_type=1,
            backup_configuration=True)
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Controller Config and import HTTPS certificates
        test_controller_config = aviatrix.AviatrixControllerConfig("testControllerConfig",
            ca_certificate_file_path="/path/to/ca_certificate.pem",
            server_private_key_file_path="/path/to/server.key",
            server_public_certificate_file_path="/path/to/server.crt")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Controller Config and configure the AWS Guard Duty Scanning Interval
        test_controller_config = aviatrix.AviatrixControllerConfig("testControllerConfig", aws_guard_duty_scanning_interval=10)
        ```

        ## Import

        Instance controller_config can be imported using controller IP, e.g. controller IP is 10.11.12.13

        ```sh
         $ pulumi import aviatrix:index/aviatrixControllerConfig:AviatrixControllerConfig test 10-11-12-13
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixControllerConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixControllerConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_guard_duty_scanning_interval: Optional[pulumi.Input[int]] = None,
                 backup_account_name: Optional[pulumi.Input[str]] = None,
                 backup_bucket_name: Optional[pulumi.Input[str]] = None,
                 backup_cloud_type: Optional[pulumi.Input[int]] = None,
                 backup_configuration: Optional[pulumi.Input[bool]] = None,
                 backup_container_name: Optional[pulumi.Input[str]] = None,
                 backup_region: Optional[pulumi.Input[str]] = None,
                 backup_storage_name: Optional[pulumi.Input[str]] = None,
                 ca_certificate_file: Optional[pulumi.Input[str]] = None,
                 ca_certificate_file_path: Optional[pulumi.Input[str]] = None,
                 enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
                 fqdn_exception_rule: Optional[pulumi.Input[bool]] = None,
                 http_access: Optional[pulumi.Input[bool]] = None,
                 manage_gateway_upgrades: Optional[pulumi.Input[bool]] = None,
                 multiple_backups: Optional[pulumi.Input[bool]] = None,
                 server_private_key_file: Optional[pulumi.Input[str]] = None,
                 server_private_key_file_path: Optional[pulumi.Input[str]] = None,
                 server_public_certificate_file: Optional[pulumi.Input[str]] = None,
                 server_public_certificate_file_path: Optional[pulumi.Input[str]] = None,
                 target_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixControllerConfigArgs.__new__(AviatrixControllerConfigArgs)

            __props__.__dict__["aws_guard_duty_scanning_interval"] = aws_guard_duty_scanning_interval
            __props__.__dict__["backup_account_name"] = backup_account_name
            __props__.__dict__["backup_bucket_name"] = backup_bucket_name
            __props__.__dict__["backup_cloud_type"] = backup_cloud_type
            __props__.__dict__["backup_configuration"] = backup_configuration
            __props__.__dict__["backup_container_name"] = backup_container_name
            __props__.__dict__["backup_region"] = backup_region
            __props__.__dict__["backup_storage_name"] = backup_storage_name
            __props__.__dict__["ca_certificate_file"] = None if ca_certificate_file is None else pulumi.Output.secret(ca_certificate_file)
            __props__.__dict__["ca_certificate_file_path"] = ca_certificate_file_path
            __props__.__dict__["enable_vpc_dns_server"] = enable_vpc_dns_server
            __props__.__dict__["fqdn_exception_rule"] = fqdn_exception_rule
            __props__.__dict__["http_access"] = http_access
            __props__.__dict__["manage_gateway_upgrades"] = manage_gateway_upgrades
            __props__.__dict__["multiple_backups"] = multiple_backups
            __props__.__dict__["server_private_key_file"] = None if server_private_key_file is None else pulumi.Output.secret(server_private_key_file)
            __props__.__dict__["server_private_key_file_path"] = server_private_key_file_path
            __props__.__dict__["server_public_certificate_file"] = None if server_public_certificate_file is None else pulumi.Output.secret(server_public_certificate_file)
            __props__.__dict__["server_public_certificate_file_path"] = server_public_certificate_file_path
            __props__.__dict__["target_version"] = target_version
            __props__.__dict__["current_version"] = None
            __props__.__dict__["previous_version"] = None
            __props__.__dict__["version"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["caCertificateFile", "serverPrivateKeyFile", "serverPublicCertificateFile"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AviatrixControllerConfig, __self__).__init__(
            'aviatrix:index/aviatrixControllerConfig:AviatrixControllerConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_guard_duty_scanning_interval: Optional[pulumi.Input[int]] = None,
            backup_account_name: Optional[pulumi.Input[str]] = None,
            backup_bucket_name: Optional[pulumi.Input[str]] = None,
            backup_cloud_type: Optional[pulumi.Input[int]] = None,
            backup_configuration: Optional[pulumi.Input[bool]] = None,
            backup_container_name: Optional[pulumi.Input[str]] = None,
            backup_region: Optional[pulumi.Input[str]] = None,
            backup_storage_name: Optional[pulumi.Input[str]] = None,
            ca_certificate_file: Optional[pulumi.Input[str]] = None,
            ca_certificate_file_path: Optional[pulumi.Input[str]] = None,
            current_version: Optional[pulumi.Input[str]] = None,
            enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
            fqdn_exception_rule: Optional[pulumi.Input[bool]] = None,
            http_access: Optional[pulumi.Input[bool]] = None,
            manage_gateway_upgrades: Optional[pulumi.Input[bool]] = None,
            multiple_backups: Optional[pulumi.Input[bool]] = None,
            previous_version: Optional[pulumi.Input[str]] = None,
            server_private_key_file: Optional[pulumi.Input[str]] = None,
            server_private_key_file_path: Optional[pulumi.Input[str]] = None,
            server_public_certificate_file: Optional[pulumi.Input[str]] = None,
            server_public_certificate_file_path: Optional[pulumi.Input[str]] = None,
            target_version: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'AviatrixControllerConfig':
        """
        Get an existing AviatrixControllerConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] aws_guard_duty_scanning_interval: Configure the AWS Guard Duty scanning interval. Valid values: 5, 10, 15, 30 or 60. Default value: 60. Available as of provider version R2.18+.
        :param pulumi.Input[str] backup_account_name: Name of the cloud account in the Aviatrix controller.
        :param pulumi.Input[str] backup_bucket_name: Bucket Name. Required to enable configuration backup for AWS, AWSGov, GCP and OCI.
        :param pulumi.Input[int] backup_cloud_type: Type of cloud service provider, requires an integer value. Use 1 for AWS, 4 for GCP, 8 for Azure, 16 for OCI, and 256 for AWSGov.
        :param pulumi.Input[bool] backup_configuration: Switch to enable/disable controller CloudN backup config. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] backup_container_name: Container name. Required to enable configuration backup for Azure.
        :param pulumi.Input[str] backup_region: Name of region. Required to enable configuration backup for Azure and OCI.
        :param pulumi.Input[str] backup_storage_name: Storage name. Required to enable configuration backup for Azure.
        :param pulumi.Input[str] ca_certificate_file: CA certificate. To read certificate file from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        :param pulumi.Input[str] ca_certificate_file_path: File path to CA certificate. Available as of provider version R2.18+.
        :param pulumi.Input[str] current_version: Current version of the controller including the build number. Example: "6.5.123". Available as of provider version R2.20.0+.
        :param pulumi.Input[bool] enable_vpc_dns_server: Enable VPC/VNET DNS Server for the controller. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] fqdn_exception_rule: Enable/disable packets without an SNI field to pass through gateway(s). Valid values: true, false. Default value: true. For more information on this setting, please see [here](https://docs.aviatrix.com/HowTos/FQDN_Whitelists_Ref_Design.html#exception-rule)
        :param pulumi.Input[bool] http_access: Switch for HTTP access. Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] manage_gateway_upgrades: If true, AviatrixControllerConfig will upgrade all gateways when target_version is set. If false, only the controller will be upgraded when target_version is set. In that case gateway upgrades should be handled in each gateway resource individually using the software_version and image_version attributes. Type: boolean. Default: true. Available as of provider version R2.20.0+.
        :param pulumi.Input[bool] multiple_backups: Switch to enable the Controller to backup up to a maximum of 3 rotating backups. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] previous_version: Previous version of the controller including the build number. Example: "6.5.123". Available as of provider version R2.20.0+.
        :param pulumi.Input[str] server_private_key_file: Server private key. To read the private key from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        :param pulumi.Input[str] server_private_key_file_path: File path to server private key. Available as of provider version R2.18+.
        :param pulumi.Input[str] server_public_certificate_file: Server public certificate. To read certificate file from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        :param pulumi.Input[str] server_public_certificate_file_path: File path to the server public certificate. Available as of provider version R2.18+.
        :param pulumi.Input[str] target_version: The release version number to which the controller will be upgraded to. If not specified, controller will not be upgraded. If set to "latest", controller will be upgraded to the latest release. Please see the [Controller upgrade guide](https://docs.aviatrix.com/HowTos/inline_upgrade.html) for more information.
        :param pulumi.Input[str] version: Current version of the controller without build number. Example: "6.5"
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixControllerConfigState.__new__(_AviatrixControllerConfigState)

        __props__.__dict__["aws_guard_duty_scanning_interval"] = aws_guard_duty_scanning_interval
        __props__.__dict__["backup_account_name"] = backup_account_name
        __props__.__dict__["backup_bucket_name"] = backup_bucket_name
        __props__.__dict__["backup_cloud_type"] = backup_cloud_type
        __props__.__dict__["backup_configuration"] = backup_configuration
        __props__.__dict__["backup_container_name"] = backup_container_name
        __props__.__dict__["backup_region"] = backup_region
        __props__.__dict__["backup_storage_name"] = backup_storage_name
        __props__.__dict__["ca_certificate_file"] = ca_certificate_file
        __props__.__dict__["ca_certificate_file_path"] = ca_certificate_file_path
        __props__.__dict__["current_version"] = current_version
        __props__.__dict__["enable_vpc_dns_server"] = enable_vpc_dns_server
        __props__.__dict__["fqdn_exception_rule"] = fqdn_exception_rule
        __props__.__dict__["http_access"] = http_access
        __props__.__dict__["manage_gateway_upgrades"] = manage_gateway_upgrades
        __props__.__dict__["multiple_backups"] = multiple_backups
        __props__.__dict__["previous_version"] = previous_version
        __props__.__dict__["server_private_key_file"] = server_private_key_file
        __props__.__dict__["server_private_key_file_path"] = server_private_key_file_path
        __props__.__dict__["server_public_certificate_file"] = server_public_certificate_file
        __props__.__dict__["server_public_certificate_file_path"] = server_public_certificate_file_path
        __props__.__dict__["target_version"] = target_version
        __props__.__dict__["version"] = version
        return AviatrixControllerConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsGuardDutyScanningInterval")
    def aws_guard_duty_scanning_interval(self) -> pulumi.Output[Optional[int]]:
        """
        Configure the AWS Guard Duty scanning interval. Valid values: 5, 10, 15, 30 or 60. Default value: 60. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "aws_guard_duty_scanning_interval")

    @property
    @pulumi.getter(name="backupAccountName")
    def backup_account_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the cloud account in the Aviatrix controller.
        """
        return pulumi.get(self, "backup_account_name")

    @property
    @pulumi.getter(name="backupBucketName")
    def backup_bucket_name(self) -> pulumi.Output[Optional[str]]:
        """
        Bucket Name. Required to enable configuration backup for AWS, AWSGov, GCP and OCI.
        """
        return pulumi.get(self, "backup_bucket_name")

    @property
    @pulumi.getter(name="backupCloudType")
    def backup_cloud_type(self) -> pulumi.Output[Optional[int]]:
        """
        Type of cloud service provider, requires an integer value. Use 1 for AWS, 4 for GCP, 8 for Azure, 16 for OCI, and 256 for AWSGov.
        """
        return pulumi.get(self, "backup_cloud_type")

    @property
    @pulumi.getter(name="backupConfiguration")
    def backup_configuration(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable/disable controller CloudN backup config. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "backup_configuration")

    @property
    @pulumi.getter(name="backupContainerName")
    def backup_container_name(self) -> pulumi.Output[Optional[str]]:
        """
        Container name. Required to enable configuration backup for Azure.
        """
        return pulumi.get(self, "backup_container_name")

    @property
    @pulumi.getter(name="backupRegion")
    def backup_region(self) -> pulumi.Output[Optional[str]]:
        """
        Name of region. Required to enable configuration backup for Azure and OCI.
        """
        return pulumi.get(self, "backup_region")

    @property
    @pulumi.getter(name="backupStorageName")
    def backup_storage_name(self) -> pulumi.Output[Optional[str]]:
        """
        Storage name. Required to enable configuration backup for Azure.
        """
        return pulumi.get(self, "backup_storage_name")

    @property
    @pulumi.getter(name="caCertificateFile")
    def ca_certificate_file(self) -> pulumi.Output[Optional[str]]:
        """
        CA certificate. To read certificate file from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        """
        return pulumi.get(self, "ca_certificate_file")

    @property
    @pulumi.getter(name="caCertificateFilePath")
    def ca_certificate_file_path(self) -> pulumi.Output[Optional[str]]:
        """
        File path to CA certificate. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "ca_certificate_file_path")

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> pulumi.Output[str]:
        """
        Current version of the controller including the build number. Example: "6.5.123". Available as of provider version R2.20.0+.
        """
        return pulumi.get(self, "current_version")

    @property
    @pulumi.getter(name="enableVpcDnsServer")
    def enable_vpc_dns_server(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable VPC/VNET DNS Server for the controller. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "enable_vpc_dns_server")

    @property
    @pulumi.getter(name="fqdnExceptionRule")
    def fqdn_exception_rule(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable/disable packets without an SNI field to pass through gateway(s). Valid values: true, false. Default value: true. For more information on this setting, please see [here](https://docs.aviatrix.com/HowTos/FQDN_Whitelists_Ref_Design.html#exception-rule)
        """
        return pulumi.get(self, "fqdn_exception_rule")

    @property
    @pulumi.getter(name="httpAccess")
    def http_access(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch for HTTP access. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "http_access")

    @property
    @pulumi.getter(name="manageGatewayUpgrades")
    def manage_gateway_upgrades(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, AviatrixControllerConfig will upgrade all gateways when target_version is set. If false, only the controller will be upgraded when target_version is set. In that case gateway upgrades should be handled in each gateway resource individually using the software_version and image_version attributes. Type: boolean. Default: true. Available as of provider version R2.20.0+.
        """
        return pulumi.get(self, "manage_gateway_upgrades")

    @property
    @pulumi.getter(name="multipleBackups")
    def multiple_backups(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable the Controller to backup up to a maximum of 3 rotating backups. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "multiple_backups")

    @property
    @pulumi.getter(name="previousVersion")
    def previous_version(self) -> pulumi.Output[str]:
        """
        Previous version of the controller including the build number. Example: "6.5.123". Available as of provider version R2.20.0+.
        """
        return pulumi.get(self, "previous_version")

    @property
    @pulumi.getter(name="serverPrivateKeyFile")
    def server_private_key_file(self) -> pulumi.Output[Optional[str]]:
        """
        Server private key. To read the private key from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        """
        return pulumi.get(self, "server_private_key_file")

    @property
    @pulumi.getter(name="serverPrivateKeyFilePath")
    def server_private_key_file_path(self) -> pulumi.Output[Optional[str]]:
        """
        File path to server private key. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "server_private_key_file_path")

    @property
    @pulumi.getter(name="serverPublicCertificateFile")
    def server_public_certificate_file(self) -> pulumi.Output[Optional[str]]:
        """
        Server public certificate. To read certificate file from a file, please use the built-in `file` function. Available as of provider version R2.21.2+.
        """
        return pulumi.get(self, "server_public_certificate_file")

    @property
    @pulumi.getter(name="serverPublicCertificateFilePath")
    def server_public_certificate_file_path(self) -> pulumi.Output[Optional[str]]:
        """
        File path to the server public certificate. Available as of provider version R2.18+.
        """
        return pulumi.get(self, "server_public_certificate_file_path")

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> pulumi.Output[Optional[str]]:
        """
        The release version number to which the controller will be upgraded to. If not specified, controller will not be upgraded. If set to "latest", controller will be upgraded to the latest release. Please see the [Controller upgrade guide](https://docs.aviatrix.com/HowTos/inline_upgrade.html) for more information.
        """
        return pulumi.get(self, "target_version")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Current version of the controller without build number. Example: "6.5"
        """
        return pulumi.get(self, "version")

