# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixCopilotAssociationArgs', 'AviatrixCopilotAssociation']

@pulumi.input_type
class AviatrixCopilotAssociationArgs:
    def __init__(__self__, *,
                 copilot_address: pulumi.Input[str]):
        """
        The set of arguments for constructing a AviatrixCopilotAssociation resource.
        :param pulumi.Input[str] copilot_address: CoPilot instance IP Address or Hostname.
        """
        pulumi.set(__self__, "copilot_address", copilot_address)

    @property
    @pulumi.getter(name="copilotAddress")
    def copilot_address(self) -> pulumi.Input[str]:
        """
        CoPilot instance IP Address or Hostname.
        """
        return pulumi.get(self, "copilot_address")

    @copilot_address.setter
    def copilot_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "copilot_address", value)


@pulumi.input_type
class _AviatrixCopilotAssociationState:
    def __init__(__self__, *,
                 copilot_address: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixCopilotAssociation resources.
        :param pulumi.Input[str] copilot_address: CoPilot instance IP Address or Hostname.
        """
        if copilot_address is not None:
            pulumi.set(__self__, "copilot_address", copilot_address)

    @property
    @pulumi.getter(name="copilotAddress")
    def copilot_address(self) -> Optional[pulumi.Input[str]]:
        """
        CoPilot instance IP Address or Hostname.
        """
        return pulumi.get(self, "copilot_address")

    @copilot_address.setter
    def copilot_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "copilot_address", value)


class AviatrixCopilotAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copilot_address: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The **aviatrix_copilot_association** resource allows management of controller CoPilot Association. This resource is available as of provider version R2.19+.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create a CoPilot Association
        test_copilot_association = aviatrix.AviatrixCopilotAssociation("testCopilotAssociation", copilot_address="copilot.aviatrix.com")
        ```

        ## Import

        **aviatrix_copilot_association** can be imported using controller IP, e.g. controller IP is 10.11.12.13

        ```sh
         $ pulumi import aviatrix:index/aviatrixCopilotAssociation:AviatrixCopilotAssociation test_copilot_association 10-11-12-13
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] copilot_address: CoPilot instance IP Address or Hostname.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixCopilotAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_copilot_association** resource allows management of controller CoPilot Association. This resource is available as of provider version R2.19+.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create a CoPilot Association
        test_copilot_association = aviatrix.AviatrixCopilotAssociation("testCopilotAssociation", copilot_address="copilot.aviatrix.com")
        ```

        ## Import

        **aviatrix_copilot_association** can be imported using controller IP, e.g. controller IP is 10.11.12.13

        ```sh
         $ pulumi import aviatrix:index/aviatrixCopilotAssociation:AviatrixCopilotAssociation test_copilot_association 10-11-12-13
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixCopilotAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixCopilotAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 copilot_address: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixCopilotAssociationArgs.__new__(AviatrixCopilotAssociationArgs)

            if copilot_address is None and not opts.urn:
                raise TypeError("Missing required property 'copilot_address'")
            __props__.__dict__["copilot_address"] = copilot_address
        super(AviatrixCopilotAssociation, __self__).__init__(
            'aviatrix:index/aviatrixCopilotAssociation:AviatrixCopilotAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            copilot_address: Optional[pulumi.Input[str]] = None) -> 'AviatrixCopilotAssociation':
        """
        Get an existing AviatrixCopilotAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] copilot_address: CoPilot instance IP Address or Hostname.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixCopilotAssociationState.__new__(_AviatrixCopilotAssociationState)

        __props__.__dict__["copilot_address"] = copilot_address
        return AviatrixCopilotAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="copilotAddress")
    def copilot_address(self) -> pulumi.Output[str]:
        """
        CoPilot instance IP Address or Hostname.
        """
        return pulumi.get(self, "copilot_address")

