# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixFirewallPolicyInitArgs', 'AviatrixFirewallPolicy']

@pulumi.input_type
class AviatrixFirewallPolicyInitArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 dst_ip: pulumi.Input[str],
                 gw_name: pulumi.Input[str],
                 port: pulumi.Input[str],
                 src_ip: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 log_enabled: Optional[pulumi.Input[bool]] = None,
                 position: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixFirewallPolicy resource.
        :param pulumi.Input[str] action: Valid values: "allow", "deny" and "force-drop" (in stateful firewall rule to allow immediate packet dropping on established sessions).
        :param pulumi.Input[str] dst_ip: CIDRs separated by comma or tag names such "HR" or "marketing" etc. Example: "10.30.0.0/16,10.45.0.0/20". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        :param pulumi.Input[str] gw_name: Gateway name to attach firewall policy to.
        :param pulumi.Input[str] port: A single port or a range of port numbers. Example: "25", "25:1024".
        :param pulumi.Input[str] src_ip: CIDRs separated by comma or tag names such "HR" or "marketing" etc. Example: "10.30.0.0/16,10.45.0.0/20". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        :param pulumi.Input[str] description: Description of the policy. Example: "This is policy no.1".
        :param pulumi.Input[bool] log_enabled: Valid values: true, false. Default value: false.
        :param pulumi.Input[int] position: Position in the policy list, where the firewall policy will be inserted to. Valid values: any positive integer. Example: 2. If it is larger than the size of policy list, the policy will be inserted to the end.
        :param pulumi.Input[str] protocol: : "all", "tcp", "udp", "icmp", "sctp", "rdp", "dccp".
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "dst_ip", dst_ip)
        pulumi.set(__self__, "gw_name", gw_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "src_ip", src_ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if log_enabled is not None:
            pulumi.set(__self__, "log_enabled", log_enabled)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        Valid values: "allow", "deny" and "force-drop" (in stateful firewall rule to allow immediate packet dropping on established sessions).
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="dstIp")
    def dst_ip(self) -> pulumi.Input[str]:
        """
        CIDRs separated by comma or tag names such "HR" or "marketing" etc. Example: "10.30.0.0/16,10.45.0.0/20". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        """
        return pulumi.get(self, "dst_ip")

    @dst_ip.setter
    def dst_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "dst_ip", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Input[str]:
        """
        Gateway name to attach firewall policy to.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[str]:
        """
        A single port or a range of port numbers. Example: "25", "25:1024".
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[str]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="srcIp")
    def src_ip(self) -> pulumi.Input[str]:
        """
        CIDRs separated by comma or tag names such "HR" or "marketing" etc. Example: "10.30.0.0/16,10.45.0.0/20". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        """
        return pulumi.get(self, "src_ip")

    @src_ip.setter
    def src_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "src_ip", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the policy. Example: "This is policy no.1".
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="logEnabled")
    def log_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "log_enabled")

    @log_enabled.setter
    def log_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_enabled", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[int]]:
        """
        Position in the policy list, where the firewall policy will be inserted to. Valid values: any positive integer. Example: 2. If it is larger than the size of policy list, the policy will be inserted to the end.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        : "all", "tcp", "udp", "icmp", "sctp", "rdp", "dccp".
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class _AviatrixFirewallPolicyState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dst_ip: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 log_enabled: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 position: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 src_ip: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixFirewallPolicy resources.
        :param pulumi.Input[str] action: Valid values: "allow", "deny" and "force-drop" (in stateful firewall rule to allow immediate packet dropping on established sessions).
        :param pulumi.Input[str] description: Description of the policy. Example: "This is policy no.1".
        :param pulumi.Input[str] dst_ip: CIDRs separated by comma or tag names such "HR" or "marketing" etc. Example: "10.30.0.0/16,10.45.0.0/20". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        :param pulumi.Input[str] gw_name: Gateway name to attach firewall policy to.
        :param pulumi.Input[bool] log_enabled: Valid values: true, false. Default value: false.
        :param pulumi.Input[str] port: A single port or a range of port numbers. Example: "25", "25:1024".
        :param pulumi.Input[int] position: Position in the policy list, where the firewall policy will be inserted to. Valid values: any positive integer. Example: 2. If it is larger than the size of policy list, the policy will be inserted to the end.
        :param pulumi.Input[str] protocol: : "all", "tcp", "udp", "icmp", "sctp", "rdp", "dccp".
        :param pulumi.Input[str] src_ip: CIDRs separated by comma or tag names such "HR" or "marketing" etc. Example: "10.30.0.0/16,10.45.0.0/20". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dst_ip is not None:
            pulumi.set(__self__, "dst_ip", dst_ip)
        if gw_name is not None:
            pulumi.set(__self__, "gw_name", gw_name)
        if log_enabled is not None:
            pulumi.set(__self__, "log_enabled", log_enabled)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if src_ip is not None:
            pulumi.set(__self__, "src_ip", src_ip)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        Valid values: "allow", "deny" and "force-drop" (in stateful firewall rule to allow immediate packet dropping on established sessions).
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the policy. Example: "This is policy no.1".
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dstIp")
    def dst_ip(self) -> Optional[pulumi.Input[str]]:
        """
        CIDRs separated by comma or tag names such "HR" or "marketing" etc. Example: "10.30.0.0/16,10.45.0.0/20". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        """
        return pulumi.get(self, "dst_ip")

    @dst_ip.setter
    def dst_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dst_ip", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gateway name to attach firewall policy to.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="logEnabled")
    def log_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "log_enabled")

    @log_enabled.setter
    def log_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_enabled", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[str]]:
        """
        A single port or a range of port numbers. Example: "25", "25:1024".
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[int]]:
        """
        Position in the policy list, where the firewall policy will be inserted to. Valid values: any positive integer. Example: 2. If it is larger than the size of policy list, the policy will be inserted to the end.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        : "all", "tcp", "udp", "icmp", "sctp", "rdp", "dccp".
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="srcIp")
    def src_ip(self) -> Optional[pulumi.Input[str]]:
        """
        CIDRs separated by comma or tag names such "HR" or "marketing" etc. Example: "10.30.0.0/16,10.45.0.0/20". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        """
        return pulumi.get(self, "src_ip")

    @src_ip.setter
    def src_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "src_ip", value)


class AviatrixFirewallPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dst_ip: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 log_enabled: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 position: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 src_ip: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Stateful Firewall Policy
        test_firewall_policy = aviatrix.AviatrixFirewallPolicy("testFirewallPolicy",
            gw_name=aviatrix_firewall["test_firewall"]["gw_name"],
            src_ip="10.15.0.224/32",
            dst_ip="10.12.0.172/32",
            protocol="tcp",
            port="0:65535",
            action="allow",
            log_enabled=True,
            description="Test policy.")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Stateful Firewall Policy and insert it to a specific position
        test_firewall_policy = aviatrix.AviatrixFirewallPolicy("testFirewallPolicy",
            gw_name=aviatrix_firewall["test_firewall"]["gw_name"],
            src_ip="10.15.0.225/32",
            dst_ip="10.12.0.173/32",
            protocol="tcp",
            port="0:65535",
            action="allow",
            log_enabled=True,
            description="Test policy.",
            position=2)
        ```

        ## Import

        **firewall_policy** can be imported using the `gw_name`, `src_ip`, `dst_ip`, `protocol`, `port` and `action` separated by `~`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixFirewallPolicy:AviatrixFirewallPolicy test "gw_name~src_ip~dst_ip~protocol~port~action"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: Valid values: "allow", "deny" and "force-drop" (in stateful firewall rule to allow immediate packet dropping on established sessions).
        :param pulumi.Input[str] description: Description of the policy. Example: "This is policy no.1".
        :param pulumi.Input[str] dst_ip: CIDRs separated by comma or tag names such "HR" or "marketing" etc. Example: "10.30.0.0/16,10.45.0.0/20". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        :param pulumi.Input[str] gw_name: Gateway name to attach firewall policy to.
        :param pulumi.Input[bool] log_enabled: Valid values: true, false. Default value: false.
        :param pulumi.Input[str] port: A single port or a range of port numbers. Example: "25", "25:1024".
        :param pulumi.Input[int] position: Position in the policy list, where the firewall policy will be inserted to. Valid values: any positive integer. Example: 2. If it is larger than the size of policy list, the policy will be inserted to the end.
        :param pulumi.Input[str] protocol: : "all", "tcp", "udp", "icmp", "sctp", "rdp", "dccp".
        :param pulumi.Input[str] src_ip: CIDRs separated by comma or tag names such "HR" or "marketing" etc. Example: "10.30.0.0/16,10.45.0.0/20". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixFirewallPolicyInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Stateful Firewall Policy
        test_firewall_policy = aviatrix.AviatrixFirewallPolicy("testFirewallPolicy",
            gw_name=aviatrix_firewall["test_firewall"]["gw_name"],
            src_ip="10.15.0.224/32",
            dst_ip="10.12.0.172/32",
            protocol="tcp",
            port="0:65535",
            action="allow",
            log_enabled=True,
            description="Test policy.")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Stateful Firewall Policy and insert it to a specific position
        test_firewall_policy = aviatrix.AviatrixFirewallPolicy("testFirewallPolicy",
            gw_name=aviatrix_firewall["test_firewall"]["gw_name"],
            src_ip="10.15.0.225/32",
            dst_ip="10.12.0.173/32",
            protocol="tcp",
            port="0:65535",
            action="allow",
            log_enabled=True,
            description="Test policy.",
            position=2)
        ```

        ## Import

        **firewall_policy** can be imported using the `gw_name`, `src_ip`, `dst_ip`, `protocol`, `port` and `action` separated by `~`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixFirewallPolicy:AviatrixFirewallPolicy test "gw_name~src_ip~dst_ip~protocol~port~action"
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixFirewallPolicyInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixFirewallPolicyInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dst_ip: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 log_enabled: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[str]] = None,
                 position: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 src_ip: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixFirewallPolicyInitArgs.__new__(AviatrixFirewallPolicyInitArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["description"] = description
            if dst_ip is None and not opts.urn:
                raise TypeError("Missing required property 'dst_ip'")
            __props__.__dict__["dst_ip"] = dst_ip
            if gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'gw_name'")
            __props__.__dict__["gw_name"] = gw_name
            __props__.__dict__["log_enabled"] = log_enabled
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            __props__.__dict__["position"] = position
            __props__.__dict__["protocol"] = protocol
            if src_ip is None and not opts.urn:
                raise TypeError("Missing required property 'src_ip'")
            __props__.__dict__["src_ip"] = src_ip
        super(AviatrixFirewallPolicy, __self__).__init__(
            'aviatrix:index/aviatrixFirewallPolicy:AviatrixFirewallPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dst_ip: Optional[pulumi.Input[str]] = None,
            gw_name: Optional[pulumi.Input[str]] = None,
            log_enabled: Optional[pulumi.Input[bool]] = None,
            port: Optional[pulumi.Input[str]] = None,
            position: Optional[pulumi.Input[int]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            src_ip: Optional[pulumi.Input[str]] = None) -> 'AviatrixFirewallPolicy':
        """
        Get an existing AviatrixFirewallPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: Valid values: "allow", "deny" and "force-drop" (in stateful firewall rule to allow immediate packet dropping on established sessions).
        :param pulumi.Input[str] description: Description of the policy. Example: "This is policy no.1".
        :param pulumi.Input[str] dst_ip: CIDRs separated by comma or tag names such "HR" or "marketing" etc. Example: "10.30.0.0/16,10.45.0.0/20". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        :param pulumi.Input[str] gw_name: Gateway name to attach firewall policy to.
        :param pulumi.Input[bool] log_enabled: Valid values: true, false. Default value: false.
        :param pulumi.Input[str] port: A single port or a range of port numbers. Example: "25", "25:1024".
        :param pulumi.Input[int] position: Position in the policy list, where the firewall policy will be inserted to. Valid values: any positive integer. Example: 2. If it is larger than the size of policy list, the policy will be inserted to the end.
        :param pulumi.Input[str] protocol: : "all", "tcp", "udp", "icmp", "sctp", "rdp", "dccp".
        :param pulumi.Input[str] src_ip: CIDRs separated by comma or tag names such "HR" or "marketing" etc. Example: "10.30.0.0/16,10.45.0.0/20". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixFirewallPolicyState.__new__(_AviatrixFirewallPolicyState)

        __props__.__dict__["action"] = action
        __props__.__dict__["description"] = description
        __props__.__dict__["dst_ip"] = dst_ip
        __props__.__dict__["gw_name"] = gw_name
        __props__.__dict__["log_enabled"] = log_enabled
        __props__.__dict__["port"] = port
        __props__.__dict__["position"] = position
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["src_ip"] = src_ip
        return AviatrixFirewallPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[str]:
        """
        Valid values: "allow", "deny" and "force-drop" (in stateful firewall rule to allow immediate packet dropping on established sessions).
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the policy. Example: "This is policy no.1".
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dstIp")
    def dst_ip(self) -> pulumi.Output[str]:
        """
        CIDRs separated by comma or tag names such "HR" or "marketing" etc. Example: "10.30.0.0/16,10.45.0.0/20". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        """
        return pulumi.get(self, "dst_ip")

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Output[str]:
        """
        Gateway name to attach firewall policy to.
        """
        return pulumi.get(self, "gw_name")

    @property
    @pulumi.getter(name="logEnabled")
    def log_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "log_enabled")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[str]:
        """
        A single port or a range of port numbers. Example: "25", "25:1024".
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def position(self) -> pulumi.Output[int]:
        """
        Position in the policy list, where the firewall policy will be inserted to. Valid values: any positive integer. Example: 2. If it is larger than the size of policy list, the policy will be inserted to the end.
        """
        return pulumi.get(self, "position")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[str]]:
        """
        : "all", "tcp", "udp", "icmp", "sctp", "rdp", "dccp".
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="srcIp")
    def src_ip(self) -> pulumi.Output[str]:
        """
        CIDRs separated by comma or tag names such "HR" or "marketing" etc. Example: "10.30.0.0/16,10.45.0.0/20". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        """
        return pulumi.get(self, "src_ip")

