# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixPeriodicPingArgs', 'AviatrixPeriodicPing']

@pulumi.input_type
class AviatrixPeriodicPingArgs:
    def __init__(__self__, *,
                 gw_name: pulumi.Input[str],
                 interval: pulumi.Input[int],
                 ip_address: pulumi.Input[str]):
        """
        The set of arguments for constructing a AviatrixPeriodicPing resource.
        :param pulumi.Input[str] gw_name: Name of the gateway.
        :param pulumi.Input[int] interval: Interval between pings in seconds.
        :param pulumi.Input[str] ip_address: IP Address to ping.
        """
        pulumi.set(__self__, "gw_name", gw_name)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Input[str]:
        """
        Name of the gateway.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Input[int]:
        """
        Interval between pings in seconds.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: pulumi.Input[int]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        IP Address to ping.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)


@pulumi.input_type
class _AviatrixPeriodicPingState:
    def __init__(__self__, *,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixPeriodicPing resources.
        :param pulumi.Input[str] gw_name: Name of the gateway.
        :param pulumi.Input[int] interval: Interval between pings in seconds.
        :param pulumi.Input[str] ip_address: IP Address to ping.
        """
        if gw_name is not None:
            pulumi.set(__self__, "gw_name", gw_name)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the gateway.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        Interval between pings in seconds.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP Address to ping.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)


class AviatrixPeriodicPing(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The **aviatrix_periodic_ping** resource manages the periodic ping feature for Aviatrix gateways.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Enable Periodic Ping for a Gateway
        test_ping = aviatrix.AviatrixPeriodicPing("testPing",
            gw_name="test-gw",
            interval=600,
            ip_address="127.0.0.1")
        ```

        ## Import

        **aviatrix_periodic_ping** can be imported using the `gw_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixPeriodicPing:AviatrixPeriodicPing test gw_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] gw_name: Name of the gateway.
        :param pulumi.Input[int] interval: Interval between pings in seconds.
        :param pulumi.Input[str] ip_address: IP Address to ping.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixPeriodicPingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_periodic_ping** resource manages the periodic ping feature for Aviatrix gateways.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Enable Periodic Ping for a Gateway
        test_ping = aviatrix.AviatrixPeriodicPing("testPing",
            gw_name="test-gw",
            interval=600,
            ip_address="127.0.0.1")
        ```

        ## Import

        **aviatrix_periodic_ping** can be imported using the `gw_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixPeriodicPing:AviatrixPeriodicPing test gw_name
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixPeriodicPingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixPeriodicPingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixPeriodicPingArgs.__new__(AviatrixPeriodicPingArgs)

            if gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'gw_name'")
            __props__.__dict__["gw_name"] = gw_name
            if interval is None and not opts.urn:
                raise TypeError("Missing required property 'interval'")
            __props__.__dict__["interval"] = interval
            if ip_address is None and not opts.urn:
                raise TypeError("Missing required property 'ip_address'")
            __props__.__dict__["ip_address"] = ip_address
        super(AviatrixPeriodicPing, __self__).__init__(
            'aviatrix:index/aviatrixPeriodicPing:AviatrixPeriodicPing',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            gw_name: Optional[pulumi.Input[str]] = None,
            interval: Optional[pulumi.Input[int]] = None,
            ip_address: Optional[pulumi.Input[str]] = None) -> 'AviatrixPeriodicPing':
        """
        Get an existing AviatrixPeriodicPing resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] gw_name: Name of the gateway.
        :param pulumi.Input[int] interval: Interval between pings in seconds.
        :param pulumi.Input[str] ip_address: IP Address to ping.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixPeriodicPingState.__new__(_AviatrixPeriodicPingState)

        __props__.__dict__["gw_name"] = gw_name
        __props__.__dict__["interval"] = interval
        __props__.__dict__["ip_address"] = ip_address
        return AviatrixPeriodicPing(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Output[str]:
        """
        Name of the gateway.
        """
        return pulumi.get(self, "gw_name")

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Output[int]:
        """
        Interval between pings in seconds.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        IP Address to ping.
        """
        return pulumi.get(self, "ip_address")

