# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixRbacGroupArgs', 'AviatrixRbacGroup']

@pulumi.input_type
class AviatrixRbacGroupArgs:
    def __init__(__self__, *,
                 group_name: pulumi.Input[str],
                 local_login: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AviatrixRbacGroup resource.
        :param pulumi.Input[str] group_name: This parameter represents the name of a RBAC group to be created.
        :param pulumi.Input[bool] local_login: Whether to allow members of an RBAC group to bypass LDAP/MFA for Duo login . Supported values: true, false. Default value: false. Available in provider version R2.17.1+.
        """
        pulumi.set(__self__, "group_name", group_name)
        if local_login is not None:
            pulumi.set(__self__, "local_login", local_login)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[str]:
        """
        This parameter represents the name of a RBAC group to be created.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="localLogin")
    def local_login(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow members of an RBAC group to bypass LDAP/MFA for Duo login . Supported values: true, false. Default value: false. Available in provider version R2.17.1+.
        """
        return pulumi.get(self, "local_login")

    @local_login.setter
    def local_login(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "local_login", value)


@pulumi.input_type
class _AviatrixRbacGroupState:
    def __init__(__self__, *,
                 group_name: Optional[pulumi.Input[str]] = None,
                 local_login: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering AviatrixRbacGroup resources.
        :param pulumi.Input[str] group_name: This parameter represents the name of a RBAC group to be created.
        :param pulumi.Input[bool] local_login: Whether to allow members of an RBAC group to bypass LDAP/MFA for Duo login . Supported values: true, false. Default value: false. Available in provider version R2.17.1+.
        """
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if local_login is not None:
            pulumi.set(__self__, "local_login", local_login)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of a RBAC group to be created.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="localLogin")
    def local_login(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allow members of an RBAC group to bypass LDAP/MFA for Duo login . Supported values: true, false. Default value: false. Available in provider version R2.17.1+.
        """
        return pulumi.get(self, "local_login")

    @local_login.setter
    def local_login(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "local_login", value)


class AviatrixRbacGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 local_login: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        The **aviatrix_rbac_group** resource allows the creation and management of [Aviatrix (Role-Based Access Control) RBAC groups](https://docs.aviatrix.com/HowTos/rbac_faq.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix RBAC Group
        test_group = aviatrix.AviatrixRbacGroup("testGroup", group_name="write_only")
        ```

        ## Import

        **rbac_group** can be imported using the `group_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixRbacGroup:AviatrixRbacGroup test group_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_name: This parameter represents the name of a RBAC group to be created.
        :param pulumi.Input[bool] local_login: Whether to allow members of an RBAC group to bypass LDAP/MFA for Duo login . Supported values: true, false. Default value: false. Available in provider version R2.17.1+.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixRbacGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_rbac_group** resource allows the creation and management of [Aviatrix (Role-Based Access Control) RBAC groups](https://docs.aviatrix.com/HowTos/rbac_faq.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix RBAC Group
        test_group = aviatrix.AviatrixRbacGroup("testGroup", group_name="write_only")
        ```

        ## Import

        **rbac_group** can be imported using the `group_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixRbacGroup:AviatrixRbacGroup test group_name
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixRbacGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixRbacGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 local_login: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixRbacGroupArgs.__new__(AviatrixRbacGroupArgs)

            if group_name is None and not opts.urn:
                raise TypeError("Missing required property 'group_name'")
            __props__.__dict__["group_name"] = group_name
            __props__.__dict__["local_login"] = local_login
        super(AviatrixRbacGroup, __self__).__init__(
            'aviatrix:index/aviatrixRbacGroup:AviatrixRbacGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_name: Optional[pulumi.Input[str]] = None,
            local_login: Optional[pulumi.Input[bool]] = None) -> 'AviatrixRbacGroup':
        """
        Get an existing AviatrixRbacGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_name: This parameter represents the name of a RBAC group to be created.
        :param pulumi.Input[bool] local_login: Whether to allow members of an RBAC group to bypass LDAP/MFA for Duo login . Supported values: true, false. Default value: false. Available in provider version R2.17.1+.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixRbacGroupState.__new__(_AviatrixRbacGroupState)

        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["local_login"] = local_login
        return AviatrixRbacGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[str]:
        """
        This parameter represents the name of a RBAC group to be created.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="localLogin")
    def local_login(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to allow members of an RBAC group to bypass LDAP/MFA for Duo login . Supported values: true, false. Default value: false. Available in provider version R2.17.1+.
        """
        return pulumi.get(self, "local_login")

