# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixRbacGroupUserAttachmentArgs', 'AviatrixRbacGroupUserAttachment']

@pulumi.input_type
class AviatrixRbacGroupUserAttachmentArgs:
    def __init__(__self__, *,
                 group_name: pulumi.Input[str],
                 user_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a AviatrixRbacGroupUserAttachment resource.
        :param pulumi.Input[str] group_name: This parameter represents the name of a RBAC group.
        :param pulumi.Input[str] user_name: Username of the account user.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[str]:
        """
        This parameter represents the name of a RBAC group.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[str]:
        """
        Username of the account user.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class _AviatrixRbacGroupUserAttachmentState:
    def __init__(__self__, *,
                 group_name: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixRbacGroupUserAttachment resources.
        :param pulumi.Input[str] group_name: This parameter represents the name of a RBAC group.
        :param pulumi.Input[str] user_name: Username of the account user.
        """
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of a RBAC group.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Username of the account user.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


class AviatrixRbacGroupUserAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The **aviatrix_rbac_group_user_attachment** resource allows the creation and management of user attachments to Aviatrix (Role-Based Access Control) RBAC groups.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix RBAC Group User Attachment
        test_attachment = aviatrix.AviatrixRbacGroupUserAttachment("testAttachment",
            group_name="write_only",
            user_name="user_name")
        ```

        ## Import

        **rbac_group_user_attachment** can be imported using the `group_name` and `user_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixRbacGroupUserAttachment:AviatrixRbacGroupUserAttachment test group_name~user_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_name: This parameter represents the name of a RBAC group.
        :param pulumi.Input[str] user_name: Username of the account user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixRbacGroupUserAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_rbac_group_user_attachment** resource allows the creation and management of user attachments to Aviatrix (Role-Based Access Control) RBAC groups.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix RBAC Group User Attachment
        test_attachment = aviatrix.AviatrixRbacGroupUserAttachment("testAttachment",
            group_name="write_only",
            user_name="user_name")
        ```

        ## Import

        **rbac_group_user_attachment** can be imported using the `group_name` and `user_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixRbacGroupUserAttachment:AviatrixRbacGroupUserAttachment test group_name~user_name
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixRbacGroupUserAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixRbacGroupUserAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixRbacGroupUserAttachmentArgs.__new__(AviatrixRbacGroupUserAttachmentArgs)

            if group_name is None and not opts.urn:
                raise TypeError("Missing required property 'group_name'")
            __props__.__dict__["group_name"] = group_name
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
        super(AviatrixRbacGroupUserAttachment, __self__).__init__(
            'aviatrix:index/aviatrixRbacGroupUserAttachment:AviatrixRbacGroupUserAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_name: Optional[pulumi.Input[str]] = None,
            user_name: Optional[pulumi.Input[str]] = None) -> 'AviatrixRbacGroupUserAttachment':
        """
        Get an existing AviatrixRbacGroupUserAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_name: This parameter represents the name of a RBAC group.
        :param pulumi.Input[str] user_name: Username of the account user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixRbacGroupUserAttachmentState.__new__(_AviatrixRbacGroupUserAttachmentState)

        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["user_name"] = user_name
        return AviatrixRbacGroupUserAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[str]:
        """
        This parameter represents the name of a RBAC group.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[str]:
        """
        Username of the account user.
        """
        return pulumi.get(self, "user_name")

