# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixSamlEndpointArgs', 'AviatrixSamlEndpoint']

@pulumi.input_type
class AviatrixSamlEndpointArgs:
    def __init__(__self__, *,
                 endpoint_name: pulumi.Input[str],
                 idp_metadata_type: pulumi.Input[str],
                 access_set_by: Optional[pulumi.Input[str]] = None,
                 controller_login: Optional[pulumi.Input[bool]] = None,
                 custom_entity_id: Optional[pulumi.Input[str]] = None,
                 custom_saml_request_template: Optional[pulumi.Input[str]] = None,
                 idp_metadata: Optional[pulumi.Input[str]] = None,
                 idp_metadata_url: Optional[pulumi.Input[str]] = None,
                 rbac_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sign_authn_requests: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AviatrixSamlEndpoint resource.
        :param pulumi.Input[str] endpoint_name: The SAML endpoint name.
        :param pulumi.Input[str] idp_metadata_type: The IDP Metadata type. Can be either "Text" or "URL".
        :param pulumi.Input[str] access_set_by: Access type. Valid values: "controller", "profile_attribute". Default value: "controller".
        :param pulumi.Input[bool] controller_login: Valid values: true, false. Default value: false. Set true for creating a saml endpoint for controller login.
        :param pulumi.Input[str] custom_entity_id: Custom Entity ID. Required to be non-empty for 'Custom' Entity ID type, empty for 'Hostname' Entity ID type.
        :param pulumi.Input[str] custom_saml_request_template: Custom SAML Request Template in string.
        :param pulumi.Input[str] idp_metadata: The IDP Metadata from SAML provider. Required if `idp_metadata_type` is "Text" and should be unset if type is "URL". Normally the metadata is in XML format which may contain special characters. Best practice is to use the file function to read from a local Metadata XML file.
        :param pulumi.Input[str] idp_metadata_url: The IDP Metadata URL from SAML provider. Required if `idp_metadata_type` is "URL" and should be unset if type is "Text".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rbac_groups: List of rbac groups. Required for controller login and "access_set_by" of "controller".
        :param pulumi.Input[bool] sign_authn_requests: Whether to sign SAML AuthnRequests
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "idp_metadata_type", idp_metadata_type)
        if access_set_by is not None:
            pulumi.set(__self__, "access_set_by", access_set_by)
        if controller_login is not None:
            pulumi.set(__self__, "controller_login", controller_login)
        if custom_entity_id is not None:
            pulumi.set(__self__, "custom_entity_id", custom_entity_id)
        if custom_saml_request_template is not None:
            pulumi.set(__self__, "custom_saml_request_template", custom_saml_request_template)
        if idp_metadata is not None:
            pulumi.set(__self__, "idp_metadata", idp_metadata)
        if idp_metadata_url is not None:
            pulumi.set(__self__, "idp_metadata_url", idp_metadata_url)
        if rbac_groups is not None:
            pulumi.set(__self__, "rbac_groups", rbac_groups)
        if sign_authn_requests is not None:
            pulumi.set(__self__, "sign_authn_requests", sign_authn_requests)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Input[str]:
        """
        The SAML endpoint name.
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter(name="idpMetadataType")
    def idp_metadata_type(self) -> pulumi.Input[str]:
        """
        The IDP Metadata type. Can be either "Text" or "URL".
        """
        return pulumi.get(self, "idp_metadata_type")

    @idp_metadata_type.setter
    def idp_metadata_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "idp_metadata_type", value)

    @property
    @pulumi.getter(name="accessSetBy")
    def access_set_by(self) -> Optional[pulumi.Input[str]]:
        """
        Access type. Valid values: "controller", "profile_attribute". Default value: "controller".
        """
        return pulumi.get(self, "access_set_by")

    @access_set_by.setter
    def access_set_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_set_by", value)

    @property
    @pulumi.getter(name="controllerLogin")
    def controller_login(self) -> Optional[pulumi.Input[bool]]:
        """
        Valid values: true, false. Default value: false. Set true for creating a saml endpoint for controller login.
        """
        return pulumi.get(self, "controller_login")

    @controller_login.setter
    def controller_login(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "controller_login", value)

    @property
    @pulumi.getter(name="customEntityId")
    def custom_entity_id(self) -> Optional[pulumi.Input[str]]:
        """
        Custom Entity ID. Required to be non-empty for 'Custom' Entity ID type, empty for 'Hostname' Entity ID type.
        """
        return pulumi.get(self, "custom_entity_id")

    @custom_entity_id.setter
    def custom_entity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_entity_id", value)

    @property
    @pulumi.getter(name="customSamlRequestTemplate")
    def custom_saml_request_template(self) -> Optional[pulumi.Input[str]]:
        """
        Custom SAML Request Template in string.
        """
        return pulumi.get(self, "custom_saml_request_template")

    @custom_saml_request_template.setter
    def custom_saml_request_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_saml_request_template", value)

    @property
    @pulumi.getter(name="idpMetadata")
    def idp_metadata(self) -> Optional[pulumi.Input[str]]:
        """
        The IDP Metadata from SAML provider. Required if `idp_metadata_type` is "Text" and should be unset if type is "URL". Normally the metadata is in XML format which may contain special characters. Best practice is to use the file function to read from a local Metadata XML file.
        """
        return pulumi.get(self, "idp_metadata")

    @idp_metadata.setter
    def idp_metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_metadata", value)

    @property
    @pulumi.getter(name="idpMetadataUrl")
    def idp_metadata_url(self) -> Optional[pulumi.Input[str]]:
        """
        The IDP Metadata URL from SAML provider. Required if `idp_metadata_type` is "URL" and should be unset if type is "Text".
        """
        return pulumi.get(self, "idp_metadata_url")

    @idp_metadata_url.setter
    def idp_metadata_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_metadata_url", value)

    @property
    @pulumi.getter(name="rbacGroups")
    def rbac_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of rbac groups. Required for controller login and "access_set_by" of "controller".
        """
        return pulumi.get(self, "rbac_groups")

    @rbac_groups.setter
    def rbac_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rbac_groups", value)

    @property
    @pulumi.getter(name="signAuthnRequests")
    def sign_authn_requests(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to sign SAML AuthnRequests
        """
        return pulumi.get(self, "sign_authn_requests")

    @sign_authn_requests.setter
    def sign_authn_requests(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sign_authn_requests", value)


@pulumi.input_type
class _AviatrixSamlEndpointState:
    def __init__(__self__, *,
                 access_set_by: Optional[pulumi.Input[str]] = None,
                 controller_login: Optional[pulumi.Input[bool]] = None,
                 custom_entity_id: Optional[pulumi.Input[str]] = None,
                 custom_saml_request_template: Optional[pulumi.Input[str]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 idp_metadata: Optional[pulumi.Input[str]] = None,
                 idp_metadata_type: Optional[pulumi.Input[str]] = None,
                 idp_metadata_url: Optional[pulumi.Input[str]] = None,
                 rbac_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sign_authn_requests: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering AviatrixSamlEndpoint resources.
        :param pulumi.Input[str] access_set_by: Access type. Valid values: "controller", "profile_attribute". Default value: "controller".
        :param pulumi.Input[bool] controller_login: Valid values: true, false. Default value: false. Set true for creating a saml endpoint for controller login.
        :param pulumi.Input[str] custom_entity_id: Custom Entity ID. Required to be non-empty for 'Custom' Entity ID type, empty for 'Hostname' Entity ID type.
        :param pulumi.Input[str] custom_saml_request_template: Custom SAML Request Template in string.
        :param pulumi.Input[str] endpoint_name: The SAML endpoint name.
        :param pulumi.Input[str] idp_metadata: The IDP Metadata from SAML provider. Required if `idp_metadata_type` is "Text" and should be unset if type is "URL". Normally the metadata is in XML format which may contain special characters. Best practice is to use the file function to read from a local Metadata XML file.
        :param pulumi.Input[str] idp_metadata_type: The IDP Metadata type. Can be either "Text" or "URL".
        :param pulumi.Input[str] idp_metadata_url: The IDP Metadata URL from SAML provider. Required if `idp_metadata_type` is "URL" and should be unset if type is "Text".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rbac_groups: List of rbac groups. Required for controller login and "access_set_by" of "controller".
        :param pulumi.Input[bool] sign_authn_requests: Whether to sign SAML AuthnRequests
        """
        if access_set_by is not None:
            pulumi.set(__self__, "access_set_by", access_set_by)
        if controller_login is not None:
            pulumi.set(__self__, "controller_login", controller_login)
        if custom_entity_id is not None:
            pulumi.set(__self__, "custom_entity_id", custom_entity_id)
        if custom_saml_request_template is not None:
            pulumi.set(__self__, "custom_saml_request_template", custom_saml_request_template)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if idp_metadata is not None:
            pulumi.set(__self__, "idp_metadata", idp_metadata)
        if idp_metadata_type is not None:
            pulumi.set(__self__, "idp_metadata_type", idp_metadata_type)
        if idp_metadata_url is not None:
            pulumi.set(__self__, "idp_metadata_url", idp_metadata_url)
        if rbac_groups is not None:
            pulumi.set(__self__, "rbac_groups", rbac_groups)
        if sign_authn_requests is not None:
            pulumi.set(__self__, "sign_authn_requests", sign_authn_requests)

    @property
    @pulumi.getter(name="accessSetBy")
    def access_set_by(self) -> Optional[pulumi.Input[str]]:
        """
        Access type. Valid values: "controller", "profile_attribute". Default value: "controller".
        """
        return pulumi.get(self, "access_set_by")

    @access_set_by.setter
    def access_set_by(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_set_by", value)

    @property
    @pulumi.getter(name="controllerLogin")
    def controller_login(self) -> Optional[pulumi.Input[bool]]:
        """
        Valid values: true, false. Default value: false. Set true for creating a saml endpoint for controller login.
        """
        return pulumi.get(self, "controller_login")

    @controller_login.setter
    def controller_login(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "controller_login", value)

    @property
    @pulumi.getter(name="customEntityId")
    def custom_entity_id(self) -> Optional[pulumi.Input[str]]:
        """
        Custom Entity ID. Required to be non-empty for 'Custom' Entity ID type, empty for 'Hostname' Entity ID type.
        """
        return pulumi.get(self, "custom_entity_id")

    @custom_entity_id.setter
    def custom_entity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_entity_id", value)

    @property
    @pulumi.getter(name="customSamlRequestTemplate")
    def custom_saml_request_template(self) -> Optional[pulumi.Input[str]]:
        """
        Custom SAML Request Template in string.
        """
        return pulumi.get(self, "custom_saml_request_template")

    @custom_saml_request_template.setter
    def custom_saml_request_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_saml_request_template", value)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[pulumi.Input[str]]:
        """
        The SAML endpoint name.
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter(name="idpMetadata")
    def idp_metadata(self) -> Optional[pulumi.Input[str]]:
        """
        The IDP Metadata from SAML provider. Required if `idp_metadata_type` is "Text" and should be unset if type is "URL". Normally the metadata is in XML format which may contain special characters. Best practice is to use the file function to read from a local Metadata XML file.
        """
        return pulumi.get(self, "idp_metadata")

    @idp_metadata.setter
    def idp_metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_metadata", value)

    @property
    @pulumi.getter(name="idpMetadataType")
    def idp_metadata_type(self) -> Optional[pulumi.Input[str]]:
        """
        The IDP Metadata type. Can be either "Text" or "URL".
        """
        return pulumi.get(self, "idp_metadata_type")

    @idp_metadata_type.setter
    def idp_metadata_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_metadata_type", value)

    @property
    @pulumi.getter(name="idpMetadataUrl")
    def idp_metadata_url(self) -> Optional[pulumi.Input[str]]:
        """
        The IDP Metadata URL from SAML provider. Required if `idp_metadata_type` is "URL" and should be unset if type is "Text".
        """
        return pulumi.get(self, "idp_metadata_url")

    @idp_metadata_url.setter
    def idp_metadata_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_metadata_url", value)

    @property
    @pulumi.getter(name="rbacGroups")
    def rbac_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of rbac groups. Required for controller login and "access_set_by" of "controller".
        """
        return pulumi.get(self, "rbac_groups")

    @rbac_groups.setter
    def rbac_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "rbac_groups", value)

    @property
    @pulumi.getter(name="signAuthnRequests")
    def sign_authn_requests(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to sign SAML AuthnRequests
        """
        return pulumi.get(self, "sign_authn_requests")

    @sign_authn_requests.setter
    def sign_authn_requests(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sign_authn_requests", value)


class AviatrixSamlEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_set_by: Optional[pulumi.Input[str]] = None,
                 controller_login: Optional[pulumi.Input[bool]] = None,
                 custom_entity_id: Optional[pulumi.Input[str]] = None,
                 custom_saml_request_template: Optional[pulumi.Input[str]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 idp_metadata: Optional[pulumi.Input[str]] = None,
                 idp_metadata_type: Optional[pulumi.Input[str]] = None,
                 idp_metadata_url: Optional[pulumi.Input[str]] = None,
                 rbac_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sign_authn_requests: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix AWS SAML Endpoint
        test_saml_endpoint = aviatrix.AviatrixSamlEndpoint("testSamlEndpoint",
            endpoint_name="saml-test",
            idp_metadata_type="Text",
            idp_metadata=(lambda path: open(path).read())("idp_metadata.xml"))
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix AWS SAML Endpoint using Metadata UDL
        test_saml_endpoint = aviatrix.AviatrixSamlEndpoint("testSamlEndpoint",
            endpoint_name="saml-test",
            idp_metadata_type="URL",
            idp_metadata_url="https://dev-xyzz.okta.com/app/asdfasdfwfwf/sso/saml/metadata")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix AWS SAML Endpoint for Controller Login
        test_saml_endpoint = aviatrix.AviatrixSamlEndpoint("testSamlEndpoint",
            access_set_by="controller",
            controller_login=True,
            endpoint_name="saml-test",
            idp_metadata=var["idp_metadata"],
            idp_metadata_type="Text",
            rbac_groups=[
                "admin",
                "read_only",
            ])
        ```

        ## Import

        **saml_endpoint** can be imported using the SAML `endpoint_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixSamlEndpoint:AviatrixSamlEndpoint test saml-test
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_set_by: Access type. Valid values: "controller", "profile_attribute". Default value: "controller".
        :param pulumi.Input[bool] controller_login: Valid values: true, false. Default value: false. Set true for creating a saml endpoint for controller login.
        :param pulumi.Input[str] custom_entity_id: Custom Entity ID. Required to be non-empty for 'Custom' Entity ID type, empty for 'Hostname' Entity ID type.
        :param pulumi.Input[str] custom_saml_request_template: Custom SAML Request Template in string.
        :param pulumi.Input[str] endpoint_name: The SAML endpoint name.
        :param pulumi.Input[str] idp_metadata: The IDP Metadata from SAML provider. Required if `idp_metadata_type` is "Text" and should be unset if type is "URL". Normally the metadata is in XML format which may contain special characters. Best practice is to use the file function to read from a local Metadata XML file.
        :param pulumi.Input[str] idp_metadata_type: The IDP Metadata type. Can be either "Text" or "URL".
        :param pulumi.Input[str] idp_metadata_url: The IDP Metadata URL from SAML provider. Required if `idp_metadata_type` is "URL" and should be unset if type is "Text".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rbac_groups: List of rbac groups. Required for controller login and "access_set_by" of "controller".
        :param pulumi.Input[bool] sign_authn_requests: Whether to sign SAML AuthnRequests
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixSamlEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix AWS SAML Endpoint
        test_saml_endpoint = aviatrix.AviatrixSamlEndpoint("testSamlEndpoint",
            endpoint_name="saml-test",
            idp_metadata_type="Text",
            idp_metadata=(lambda path: open(path).read())("idp_metadata.xml"))
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix AWS SAML Endpoint using Metadata UDL
        test_saml_endpoint = aviatrix.AviatrixSamlEndpoint("testSamlEndpoint",
            endpoint_name="saml-test",
            idp_metadata_type="URL",
            idp_metadata_url="https://dev-xyzz.okta.com/app/asdfasdfwfwf/sso/saml/metadata")
        ```
        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix AWS SAML Endpoint for Controller Login
        test_saml_endpoint = aviatrix.AviatrixSamlEndpoint("testSamlEndpoint",
            access_set_by="controller",
            controller_login=True,
            endpoint_name="saml-test",
            idp_metadata=var["idp_metadata"],
            idp_metadata_type="Text",
            rbac_groups=[
                "admin",
                "read_only",
            ])
        ```

        ## Import

        **saml_endpoint** can be imported using the SAML `endpoint_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixSamlEndpoint:AviatrixSamlEndpoint test saml-test
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixSamlEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixSamlEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_set_by: Optional[pulumi.Input[str]] = None,
                 controller_login: Optional[pulumi.Input[bool]] = None,
                 custom_entity_id: Optional[pulumi.Input[str]] = None,
                 custom_saml_request_template: Optional[pulumi.Input[str]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 idp_metadata: Optional[pulumi.Input[str]] = None,
                 idp_metadata_type: Optional[pulumi.Input[str]] = None,
                 idp_metadata_url: Optional[pulumi.Input[str]] = None,
                 rbac_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sign_authn_requests: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixSamlEndpointArgs.__new__(AviatrixSamlEndpointArgs)

            __props__.__dict__["access_set_by"] = access_set_by
            __props__.__dict__["controller_login"] = controller_login
            __props__.__dict__["custom_entity_id"] = custom_entity_id
            __props__.__dict__["custom_saml_request_template"] = custom_saml_request_template
            if endpoint_name is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_name'")
            __props__.__dict__["endpoint_name"] = endpoint_name
            __props__.__dict__["idp_metadata"] = idp_metadata
            if idp_metadata_type is None and not opts.urn:
                raise TypeError("Missing required property 'idp_metadata_type'")
            __props__.__dict__["idp_metadata_type"] = idp_metadata_type
            __props__.__dict__["idp_metadata_url"] = idp_metadata_url
            __props__.__dict__["rbac_groups"] = rbac_groups
            __props__.__dict__["sign_authn_requests"] = sign_authn_requests
        super(AviatrixSamlEndpoint, __self__).__init__(
            'aviatrix:index/aviatrixSamlEndpoint:AviatrixSamlEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_set_by: Optional[pulumi.Input[str]] = None,
            controller_login: Optional[pulumi.Input[bool]] = None,
            custom_entity_id: Optional[pulumi.Input[str]] = None,
            custom_saml_request_template: Optional[pulumi.Input[str]] = None,
            endpoint_name: Optional[pulumi.Input[str]] = None,
            idp_metadata: Optional[pulumi.Input[str]] = None,
            idp_metadata_type: Optional[pulumi.Input[str]] = None,
            idp_metadata_url: Optional[pulumi.Input[str]] = None,
            rbac_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            sign_authn_requests: Optional[pulumi.Input[bool]] = None) -> 'AviatrixSamlEndpoint':
        """
        Get an existing AviatrixSamlEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_set_by: Access type. Valid values: "controller", "profile_attribute". Default value: "controller".
        :param pulumi.Input[bool] controller_login: Valid values: true, false. Default value: false. Set true for creating a saml endpoint for controller login.
        :param pulumi.Input[str] custom_entity_id: Custom Entity ID. Required to be non-empty for 'Custom' Entity ID type, empty for 'Hostname' Entity ID type.
        :param pulumi.Input[str] custom_saml_request_template: Custom SAML Request Template in string.
        :param pulumi.Input[str] endpoint_name: The SAML endpoint name.
        :param pulumi.Input[str] idp_metadata: The IDP Metadata from SAML provider. Required if `idp_metadata_type` is "Text" and should be unset if type is "URL". Normally the metadata is in XML format which may contain special characters. Best practice is to use the file function to read from a local Metadata XML file.
        :param pulumi.Input[str] idp_metadata_type: The IDP Metadata type. Can be either "Text" or "URL".
        :param pulumi.Input[str] idp_metadata_url: The IDP Metadata URL from SAML provider. Required if `idp_metadata_type` is "URL" and should be unset if type is "Text".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rbac_groups: List of rbac groups. Required for controller login and "access_set_by" of "controller".
        :param pulumi.Input[bool] sign_authn_requests: Whether to sign SAML AuthnRequests
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixSamlEndpointState.__new__(_AviatrixSamlEndpointState)

        __props__.__dict__["access_set_by"] = access_set_by
        __props__.__dict__["controller_login"] = controller_login
        __props__.__dict__["custom_entity_id"] = custom_entity_id
        __props__.__dict__["custom_saml_request_template"] = custom_saml_request_template
        __props__.__dict__["endpoint_name"] = endpoint_name
        __props__.__dict__["idp_metadata"] = idp_metadata
        __props__.__dict__["idp_metadata_type"] = idp_metadata_type
        __props__.__dict__["idp_metadata_url"] = idp_metadata_url
        __props__.__dict__["rbac_groups"] = rbac_groups
        __props__.__dict__["sign_authn_requests"] = sign_authn_requests
        return AviatrixSamlEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessSetBy")
    def access_set_by(self) -> pulumi.Output[Optional[str]]:
        """
        Access type. Valid values: "controller", "profile_attribute". Default value: "controller".
        """
        return pulumi.get(self, "access_set_by")

    @property
    @pulumi.getter(name="controllerLogin")
    def controller_login(self) -> pulumi.Output[Optional[bool]]:
        """
        Valid values: true, false. Default value: false. Set true for creating a saml endpoint for controller login.
        """
        return pulumi.get(self, "controller_login")

    @property
    @pulumi.getter(name="customEntityId")
    def custom_entity_id(self) -> pulumi.Output[Optional[str]]:
        """
        Custom Entity ID. Required to be non-empty for 'Custom' Entity ID type, empty for 'Hostname' Entity ID type.
        """
        return pulumi.get(self, "custom_entity_id")

    @property
    @pulumi.getter(name="customSamlRequestTemplate")
    def custom_saml_request_template(self) -> pulumi.Output[Optional[str]]:
        """
        Custom SAML Request Template in string.
        """
        return pulumi.get(self, "custom_saml_request_template")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Output[str]:
        """
        The SAML endpoint name.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="idpMetadata")
    def idp_metadata(self) -> pulumi.Output[Optional[str]]:
        """
        The IDP Metadata from SAML provider. Required if `idp_metadata_type` is "Text" and should be unset if type is "URL". Normally the metadata is in XML format which may contain special characters. Best practice is to use the file function to read from a local Metadata XML file.
        """
        return pulumi.get(self, "idp_metadata")

    @property
    @pulumi.getter(name="idpMetadataType")
    def idp_metadata_type(self) -> pulumi.Output[str]:
        """
        The IDP Metadata type. Can be either "Text" or "URL".
        """
        return pulumi.get(self, "idp_metadata_type")

    @property
    @pulumi.getter(name="idpMetadataUrl")
    def idp_metadata_url(self) -> pulumi.Output[Optional[str]]:
        """
        The IDP Metadata URL from SAML provider. Required if `idp_metadata_type` is "URL" and should be unset if type is "Text".
        """
        return pulumi.get(self, "idp_metadata_url")

    @property
    @pulumi.getter(name="rbacGroups")
    def rbac_groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of rbac groups. Required for controller login and "access_set_by" of "controller".
        """
        return pulumi.get(self, "rbac_groups")

    @property
    @pulumi.getter(name="signAuthnRequests")
    def sign_authn_requests(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to sign SAML AuthnRequests
        """
        return pulumi.get(self, "sign_authn_requests")

