# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixSplunkLoggingArgs', 'AviatrixSplunkLogging']

@pulumi.input_type
class AviatrixSplunkLoggingArgs:
    def __init__(__self__, *,
                 custom_input_config: Optional[pulumi.Input[str]] = None,
                 custom_output_config_file: Optional[pulumi.Input[str]] = None,
                 excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 server: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixSplunkLogging resource.
        :param pulumi.Input[str] custom_input_config: Custom configuration.
        :param pulumi.Input[str] custom_output_config_file: Configuration file. Use the `filebase64` function to read from a file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_gateways: List of gateways to be excluded from logging. e.g.: ["gateway01", "gateway02", "gateway01-hagw"].
        :param pulumi.Input[int] port: Port number.
        :param pulumi.Input[str] server: Server IP.
        """
        if custom_input_config is not None:
            pulumi.set(__self__, "custom_input_config", custom_input_config)
        if custom_output_config_file is not None:
            pulumi.set(__self__, "custom_output_config_file", custom_output_config_file)
        if excluded_gateways is not None:
            pulumi.set(__self__, "excluded_gateways", excluded_gateways)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if server is not None:
            pulumi.set(__self__, "server", server)

    @property
    @pulumi.getter(name="customInputConfig")
    def custom_input_config(self) -> Optional[pulumi.Input[str]]:
        """
        Custom configuration.
        """
        return pulumi.get(self, "custom_input_config")

    @custom_input_config.setter
    def custom_input_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_input_config", value)

    @property
    @pulumi.getter(name="customOutputConfigFile")
    def custom_output_config_file(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration file. Use the `filebase64` function to read from a file.
        """
        return pulumi.get(self, "custom_output_config_file")

    @custom_output_config_file.setter
    def custom_output_config_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_output_config_file", value)

    @property
    @pulumi.getter(name="excludedGateways")
    def excluded_gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of gateways to be excluded from logging. e.g.: ["gateway01", "gateway02", "gateway01-hagw"].
        """
        return pulumi.get(self, "excluded_gateways")

    @excluded_gateways.setter
    def excluded_gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_gateways", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port number.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[str]]:
        """
        Server IP.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server", value)


@pulumi.input_type
class _AviatrixSplunkLoggingState:
    def __init__(__self__, *,
                 custom_input_config: Optional[pulumi.Input[str]] = None,
                 custom_output_config_file: Optional[pulumi.Input[str]] = None,
                 excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 server: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixSplunkLogging resources.
        :param pulumi.Input[str] custom_input_config: Custom configuration.
        :param pulumi.Input[str] custom_output_config_file: Configuration file. Use the `filebase64` function to read from a file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_gateways: List of gateways to be excluded from logging. e.g.: ["gateway01", "gateway02", "gateway01-hagw"].
        :param pulumi.Input[int] port: Port number.
        :param pulumi.Input[str] server: Server IP.
        :param pulumi.Input[str] status: The status of splunk logging.
        """
        if custom_input_config is not None:
            pulumi.set(__self__, "custom_input_config", custom_input_config)
        if custom_output_config_file is not None:
            pulumi.set(__self__, "custom_output_config_file", custom_output_config_file)
        if excluded_gateways is not None:
            pulumi.set(__self__, "excluded_gateways", excluded_gateways)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="customInputConfig")
    def custom_input_config(self) -> Optional[pulumi.Input[str]]:
        """
        Custom configuration.
        """
        return pulumi.get(self, "custom_input_config")

    @custom_input_config.setter
    def custom_input_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_input_config", value)

    @property
    @pulumi.getter(name="customOutputConfigFile")
    def custom_output_config_file(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration file. Use the `filebase64` function to read from a file.
        """
        return pulumi.get(self, "custom_output_config_file")

    @custom_output_config_file.setter
    def custom_output_config_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_output_config_file", value)

    @property
    @pulumi.getter(name="excludedGateways")
    def excluded_gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of gateways to be excluded from logging. e.g.: ["gateway01", "gateway02", "gateway01-hagw"].
        """
        return pulumi.get(self, "excluded_gateways")

    @excluded_gateways.setter
    def excluded_gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "excluded_gateways", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port number.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[str]]:
        """
        Server IP.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of splunk logging.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class AviatrixSplunkLogging(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_input_config: Optional[pulumi.Input[str]] = None,
                 custom_output_config_file: Optional[pulumi.Input[str]] = None,
                 excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 server: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The **aviatrix_splunk_logging** resource allows the enabling and disabling of splunk logging.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Enable splunk logging using server and port combination
        test_splunk_logging = aviatrix.AviatrixSplunkLogging("testSplunkLogging",
            port=10,
            server="1.2.3.4")
        ```

        ```python
        import pulumi
        import base64
        import pulumi_aviatrix as aviatrix

        # Enable splunk logging using configuration file
        test_splunk_logging = aviatrix.AviatrixSplunkLogging("testSplunkLogging", custom_output_config_file=(lambda path: base64.b64encode(open(path).read().encode()).decode())("/path/to/configuration.spl"))
        ```

        ## Import

        **splunk_logging** can be imported using `splunk_logging`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixSplunkLogging:AviatrixSplunkLogging test splunk_logging
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] custom_input_config: Custom configuration.
        :param pulumi.Input[str] custom_output_config_file: Configuration file. Use the `filebase64` function to read from a file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_gateways: List of gateways to be excluded from logging. e.g.: ["gateway01", "gateway02", "gateway01-hagw"].
        :param pulumi.Input[int] port: Port number.
        :param pulumi.Input[str] server: Server IP.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AviatrixSplunkLoggingArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_splunk_logging** resource allows the enabling and disabling of splunk logging.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Enable splunk logging using server and port combination
        test_splunk_logging = aviatrix.AviatrixSplunkLogging("testSplunkLogging",
            port=10,
            server="1.2.3.4")
        ```

        ```python
        import pulumi
        import base64
        import pulumi_aviatrix as aviatrix

        # Enable splunk logging using configuration file
        test_splunk_logging = aviatrix.AviatrixSplunkLogging("testSplunkLogging", custom_output_config_file=(lambda path: base64.b64encode(open(path).read().encode()).decode())("/path/to/configuration.spl"))
        ```

        ## Import

        **splunk_logging** can be imported using `splunk_logging`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixSplunkLogging:AviatrixSplunkLogging test splunk_logging
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixSplunkLoggingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixSplunkLoggingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_input_config: Optional[pulumi.Input[str]] = None,
                 custom_output_config_file: Optional[pulumi.Input[str]] = None,
                 excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 server: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixSplunkLoggingArgs.__new__(AviatrixSplunkLoggingArgs)

            __props__.__dict__["custom_input_config"] = custom_input_config
            __props__.__dict__["custom_output_config_file"] = custom_output_config_file
            __props__.__dict__["excluded_gateways"] = excluded_gateways
            __props__.__dict__["port"] = port
            __props__.__dict__["server"] = server
            __props__.__dict__["status"] = None
        super(AviatrixSplunkLogging, __self__).__init__(
            'aviatrix:index/aviatrixSplunkLogging:AviatrixSplunkLogging',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_input_config: Optional[pulumi.Input[str]] = None,
            custom_output_config_file: Optional[pulumi.Input[str]] = None,
            excluded_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            port: Optional[pulumi.Input[int]] = None,
            server: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'AviatrixSplunkLogging':
        """
        Get an existing AviatrixSplunkLogging resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] custom_input_config: Custom configuration.
        :param pulumi.Input[str] custom_output_config_file: Configuration file. Use the `filebase64` function to read from a file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] excluded_gateways: List of gateways to be excluded from logging. e.g.: ["gateway01", "gateway02", "gateway01-hagw"].
        :param pulumi.Input[int] port: Port number.
        :param pulumi.Input[str] server: Server IP.
        :param pulumi.Input[str] status: The status of splunk logging.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixSplunkLoggingState.__new__(_AviatrixSplunkLoggingState)

        __props__.__dict__["custom_input_config"] = custom_input_config
        __props__.__dict__["custom_output_config_file"] = custom_output_config_file
        __props__.__dict__["excluded_gateways"] = excluded_gateways
        __props__.__dict__["port"] = port
        __props__.__dict__["server"] = server
        __props__.__dict__["status"] = status
        return AviatrixSplunkLogging(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customInputConfig")
    def custom_input_config(self) -> pulumi.Output[Optional[str]]:
        """
        Custom configuration.
        """
        return pulumi.get(self, "custom_input_config")

    @property
    @pulumi.getter(name="customOutputConfigFile")
    def custom_output_config_file(self) -> pulumi.Output[Optional[str]]:
        """
        Configuration file. Use the `filebase64` function to read from a file.
        """
        return pulumi.get(self, "custom_output_config_file")

    @property
    @pulumi.getter(name="excludedGateways")
    def excluded_gateways(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of gateways to be excluded from logging. e.g.: ["gateway01", "gateway02", "gateway01-hagw"].
        """
        return pulumi.get(self, "excluded_gateways")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[int]]:
        """
        Port number.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def server(self) -> pulumi.Output[Optional[str]]:
        """
        Server IP.
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of splunk logging.
        """
        return pulumi.get(self, "status")

