# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixTransitFirenetPolicyArgs', 'AviatrixTransitFirenetPolicy']

@pulumi.input_type
class AviatrixTransitFirenetPolicyArgs:
    def __init__(__self__, *,
                 inspected_resource_name: pulumi.Input[str],
                 transit_firenet_gateway_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a AviatrixTransitFirenetPolicy resource.
        :param pulumi.Input[str] inspected_resource_name: The name of the resource which will be inspected.
        :param pulumi.Input[str] transit_firenet_gateway_name: Name of the Transit FireNet-enabled transit gateway. Currently supports AWS and Azure.
        """
        pulumi.set(__self__, "inspected_resource_name", inspected_resource_name)
        pulumi.set(__self__, "transit_firenet_gateway_name", transit_firenet_gateway_name)

    @property
    @pulumi.getter(name="inspectedResourceName")
    def inspected_resource_name(self) -> pulumi.Input[str]:
        """
        The name of the resource which will be inspected.
        """
        return pulumi.get(self, "inspected_resource_name")

    @inspected_resource_name.setter
    def inspected_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "inspected_resource_name", value)

    @property
    @pulumi.getter(name="transitFirenetGatewayName")
    def transit_firenet_gateway_name(self) -> pulumi.Input[str]:
        """
        Name of the Transit FireNet-enabled transit gateway. Currently supports AWS and Azure.
        """
        return pulumi.get(self, "transit_firenet_gateway_name")

    @transit_firenet_gateway_name.setter
    def transit_firenet_gateway_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_firenet_gateway_name", value)


@pulumi.input_type
class _AviatrixTransitFirenetPolicyState:
    def __init__(__self__, *,
                 inspected_resource_name: Optional[pulumi.Input[str]] = None,
                 transit_firenet_gateway_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixTransitFirenetPolicy resources.
        :param pulumi.Input[str] inspected_resource_name: The name of the resource which will be inspected.
        :param pulumi.Input[str] transit_firenet_gateway_name: Name of the Transit FireNet-enabled transit gateway. Currently supports AWS and Azure.
        """
        if inspected_resource_name is not None:
            pulumi.set(__self__, "inspected_resource_name", inspected_resource_name)
        if transit_firenet_gateway_name is not None:
            pulumi.set(__self__, "transit_firenet_gateway_name", transit_firenet_gateway_name)

    @property
    @pulumi.getter(name="inspectedResourceName")
    def inspected_resource_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource which will be inspected.
        """
        return pulumi.get(self, "inspected_resource_name")

    @inspected_resource_name.setter
    def inspected_resource_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inspected_resource_name", value)

    @property
    @pulumi.getter(name="transitFirenetGatewayName")
    def transit_firenet_gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Transit FireNet-enabled transit gateway. Currently supports AWS and Azure.
        """
        return pulumi.get(self, "transit_firenet_gateway_name")

    @transit_firenet_gateway_name.setter
    def transit_firenet_gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_firenet_gateway_name", value)


class AviatrixTransitFirenetPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 inspected_resource_name: Optional[pulumi.Input[str]] = None,
                 transit_firenet_gateway_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The **aviatrix_transit_firenet_policy** resource allows the creation and management of Aviatrix Transit FireNet policies that determine which resources should be inspected in the Transit FireNet solution.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Transit FireNet Policy
        test_transit_firenet_policy = aviatrix.AviatrixTransitFirenetPolicy("testTransitFirenetPolicy",
            inspected_resource_name="SPOKE:spokeGw1",
            transit_firenet_gateway_name="transitGw1")
        ```

        ## Import

        **transit_firenet_policy** can be imported using the `transit_firenet_gateway_name` and `inspected_resource_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixTransitFirenetPolicy:AviatrixTransitFirenetPolicy test transit_firenet_gateway_name~inspected_resource_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] inspected_resource_name: The name of the resource which will be inspected.
        :param pulumi.Input[str] transit_firenet_gateway_name: Name of the Transit FireNet-enabled transit gateway. Currently supports AWS and Azure.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixTransitFirenetPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_transit_firenet_policy** resource allows the creation and management of Aviatrix Transit FireNet policies that determine which resources should be inspected in the Transit FireNet solution.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Transit FireNet Policy
        test_transit_firenet_policy = aviatrix.AviatrixTransitFirenetPolicy("testTransitFirenetPolicy",
            inspected_resource_name="SPOKE:spokeGw1",
            transit_firenet_gateway_name="transitGw1")
        ```

        ## Import

        **transit_firenet_policy** can be imported using the `transit_firenet_gateway_name` and `inspected_resource_name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixTransitFirenetPolicy:AviatrixTransitFirenetPolicy test transit_firenet_gateway_name~inspected_resource_name
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixTransitFirenetPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixTransitFirenetPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 inspected_resource_name: Optional[pulumi.Input[str]] = None,
                 transit_firenet_gateway_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixTransitFirenetPolicyArgs.__new__(AviatrixTransitFirenetPolicyArgs)

            if inspected_resource_name is None and not opts.urn:
                raise TypeError("Missing required property 'inspected_resource_name'")
            __props__.__dict__["inspected_resource_name"] = inspected_resource_name
            if transit_firenet_gateway_name is None and not opts.urn:
                raise TypeError("Missing required property 'transit_firenet_gateway_name'")
            __props__.__dict__["transit_firenet_gateway_name"] = transit_firenet_gateway_name
        super(AviatrixTransitFirenetPolicy, __self__).__init__(
            'aviatrix:index/aviatrixTransitFirenetPolicy:AviatrixTransitFirenetPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            inspected_resource_name: Optional[pulumi.Input[str]] = None,
            transit_firenet_gateway_name: Optional[pulumi.Input[str]] = None) -> 'AviatrixTransitFirenetPolicy':
        """
        Get an existing AviatrixTransitFirenetPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] inspected_resource_name: The name of the resource which will be inspected.
        :param pulumi.Input[str] transit_firenet_gateway_name: Name of the Transit FireNet-enabled transit gateway. Currently supports AWS and Azure.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixTransitFirenetPolicyState.__new__(_AviatrixTransitFirenetPolicyState)

        __props__.__dict__["inspected_resource_name"] = inspected_resource_name
        __props__.__dict__["transit_firenet_gateway_name"] = transit_firenet_gateway_name
        return AviatrixTransitFirenetPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="inspectedResourceName")
    def inspected_resource_name(self) -> pulumi.Output[str]:
        """
        The name of the resource which will be inspected.
        """
        return pulumi.get(self, "inspected_resource_name")

    @property
    @pulumi.getter(name="transitFirenetGatewayName")
    def transit_firenet_gateway_name(self) -> pulumi.Output[str]:
        """
        Name of the Transit FireNet-enabled transit gateway. Currently supports AWS and Azure.
        """
        return pulumi.get(self, "transit_firenet_gateway_name")

