RU_NUMBER_SYSTEM_NAME = (
    'тысяч', 'миллион', 'миллиард', 'триллион',
    'квадриллион', 'квинтиллион', 'секстиллион',
    'септиллион', 'октиллион', 'нониллион', 'дециллион',
    'ундециллион', 'додециллион', 'тредециллион', 'кваттуордециллион',
    'квиндециллион', 'cедециллион', 'септдециллион', 'дуодевигинтиллион',
    'ундевигинтиллион', 'вигинтиллион', 'анвигинтиллион', 'дуовигинтиллион',
    'тревигинтиллион', 'кватторвигинтиллион', 'квинвигинтиллион',
    'сексвигинтиллион', 'септемвигинтиллион', 'октовигинтиллион',
    'новемвигинтиллион', 'тригинтиллион', 'антригинтиллион', 'гугол'
)


UA_NUMBER_SYSTEM_NAME = (
    'тисяч', 'мільйон', 'мільярд', 'трильйон',
    'квадрильйон', 'квінтильйон', 'секстильйон',
    'септильйон', 'октильйон', 'нонільйон', 'децильйон',
    'ундецильйон', 'додецильйон', 'тредецильйон', 'кватродецильйон',
    'квіндецильйон', 'сексдецильйон', 'септемдецильйон', 'октодецильйон',
    'новемдецильйон', 'вігінтильйон', 'анвигінтильйон', 'дуовігінтильйон',
    'тривігінтильйон', 'кватторвігінтильйон', 'квінвігінтильйон', 'сексвигінтильйон',
    'септемвігінтільйон', 'октовігінтильйон', 'новемвигінтільйон', 'тригінтильйон',
    'антригінтильйон', 'гугол'
)


NUMBER_SYSTEM_NAME = {
    "RU": dict(zip(range(2, 35), RU_NUMBER_SYSTEM_NAME)),
    "UA": dict(zip(range(2, 35), UA_NUMBER_SYSTEM_NAME)),
}


RU_NUMBER_NAME = (
    ('ноль', 'ноль', 'ноль'),
    (
        'один',
        (
            'десять', 'одиннадцать', 'двенадцать',
            'тринадцать', 'четырнадцать', 'пятнадцать',
            'шестнадцать', 'семнадцать', 'восемнадцать',
            'девятнадцать'
        ),
        'сто'
    ),
    ('два', 'двадцать', 'двести'),
    ('три', 'тридцать', 'триста'),
    ('четыре', 'сорок', 'четыреста'),
    ('пять', 'пятьдесят', 'пятьсот'),
    ('шесть', 'шестьдесят', 'шестьсот'),
    ('семь', 'семьдесят', 'семьсот'),
    ('восемь', 'восемьдесят', 'восемьсот'),
    ('девять', 'девяносто', 'девятьсот')
)


UA_NUMBER_NAME = (
    ('нуль','нуль','нуль'),
    (
        'один',
        (
            'десять', 'одинадцять', 'дванадцять',
            'тринадцять', 'чотирнадцять', "п'ятнадцять",
            'шістнадцять', 'сімнадцять', 'вісімнадцять',
            "дев'ятнадцять"
        ),
        'сто'
    ),
    ('два', 'двадцять', 'двісті'),
    ('три', 'тридцять', 'триста'),
    ('чотири', 'сорок', 'чотириста'),
    ("п'ять", "п'ятдесят", "п'ятсот"),
    ('шість', 'шістдесят', 'шістсот'),
    ('сім', 'сімдесят', 'сімсот'),
    ('вісім', 'вісімдесят', 'вісімсот'),
    ("дев'ять", "дев'яносто", "дев'ятсот")
)


NUMBER_DICTS = {
    "RU": {idx: num_name for idx, num_name in enumerate(RU_NUMBER_NAME)},
    "UA": {idx: num_name for idx, num_name in enumerate(UA_NUMBER_NAME)},
}


END_OF_NUMBER = {
    "RU": {
        "start_of_string": 'минус',
        "thousand": {
          'один': ('а', 'одна'),
          'два': ('и', 'две'),
          'три': ('и', 'три'),
          'четыре': ('и', 'четыре')
        },
        "million": {'один': '', 'два': 'а', 'три': 'а', 'четыре': 'а'},
        "end_of_string": 'ов',
        "float_end": {
            "int": ("целая", "целых"),
            "float":  (
                ("десятая", "десятых"),
                ("сотая", "сотых"),
                ("тысячная", "тысячных")
            )
        }
    },
    "UA": {
        "start_of_string": 'мінус',
        "thousand": {
          'один': ('а', 'одна'),
          'два': ('і', 'дві'),
          'три': ('и', 'три'),
          'чотири': ('и', 'чотири')
        },
        "million": {'один': '', 'два': 'а', 'три': 'а', 'чотири': 'а'},
        "end_of_string": 'ів',
        "float_end": {
            "int": ("ціла", "цілих"),
            "float":  (
                ("десята", "десятих"),
                ("сота", "сотих"),
                ("тисячна", "тисячних")
            )
        }
    }
}


ZEROS = "000"
