def subsystem_data() -> str:
    return '''>Translation (Ribosome)
        CHL00129 ribosomal protein L1
        CHL00052 ribosomal protein L2
        CHL00143 ribosomal protein L3
        CHL00147 ribosomal protein L4
        CHL00078 ribosomal protein L5
        CHL00140 ribosomal protein L6
        CHL00160 ribosomal protein L9
        CHL00127 ribosomal protein L11
        CHL00083 ribosomal protein L12
        CHL00159 ribosomal protein L13
        CHL00057 ribosomal protein L14
        TIGR01071 ribosomal protein L15
        CHL00044 ribosomal protein L16
        CHL00139 ribosomal protein L18
        CHL00084 ribosomal protein L19
        CHL00068 ribosomal protein L20
        CHL00075 ribosomal protein L21
        CHL00034 ribosomal protein L22
        CHL00030 ribosomal protein L23
        CHL00141 ribosomal protein L24
        PRK05943 ribosomal protein L25
        CHL00121 ribosomal protein L27
        CHL00112 ribosomal protein L28
        CHL00154 ribosomal protein L29
        CHL00136 ribosomal protein L31
        CHL00152 ribosomal protein L32
        CHL00104 ribosomal protein L33
        CHL00115 ribosomal protein L34
        CHL00103 ribosomal protein L35
        CHL00029 ribosomal protein L36
        PRK00087 ribosomal protein S1
        CHL00067 ribosomal protein S2
        CHL00048 ribosomal protein S3
        CHL00113 ribosomal protein S4
        CHL00138 ribosomal protein S5
        CHL00123 ribosomal protein S6
        CHL00053 ribosomal protein S7
        CHL00042 ribosomal protein S8
        CHL00079 ribosomal protein S9
        CHL00135 ribosomal protein S10
        CHL00041 ribosomal protein S11
        CHL00051 ribosomal protein S12
        CHL00137 ribosomal protein S13
        CHL00074 ribosomal protein S14
        CHL00027 ribosomal protein S15
        CHL00005 ribosomal protein S16
        CHL00142 ribosomal protein S17
        CHL00077 ribosomal protein S18
        CHL00050 ribosomal protein S19
        CHL00102 ribosomal protein S20

        >Translation (RNA polymerase)
        CHL00013 RNA polymerase subunit alpha (rpoA)
        CHL00001 RNA polymerase subunit beta (rpoB)
        CHL00018 RNA polymerase subunit beta' (rpoC1)
        CHL00117 RNA polymerase subunit beta' (rpoC2)
        TIGR02387 DNA-directed RNA polymerase, gamma subunit (rpoC1, cyanobacteria)
        TIGR02388 DNA-directed RNA polymerase, subunit beta'' (rpoC2, cyanobacteria)
        TIGR02389|cd02582 DNA-directed RNA polymerase subunit A' (archaea)
        TIGR02390|cd06528 DNA-directed RNA polymerase subunit A' (archaea)
        TIGR00448 DNA-directed RNA polymerase (rpoE, archaea/eukarya)
        TIGR03670 DNA-directed RNA polymerase subunit B (rpoB, archaea)
        cd06927 L subunit of archaeal RNA polymerase
        
        >Translocation Accross the Cytoplasmic Membrane, Sec 
        TIGR00963 preprotein translocase, subunit SecA
        TIGR00809 preprotein translocase, subunit SecB
        TIGR01129 preprotein translocase, subunit SecD
        TIGR00964 preprotein translocase, subunit SecE, bacteria
        TIGR00327 preprotein translocase, subunit SecE, archaea/eukarya
        TIGR00966 preprotein translocase, subunit SecF
        TIGR00810 preprotein translocase, subunit SecG
        TIGR00967 preprotein translocase, subunit SecY
        TIGR00869 preprotein translocase, subunit sec62
        
        >Translocation Accross the Cytoplasmic Membrane, Tat, for Folded Proteins
        TIGR01411 Twin arginine-targeting protein translocase, subunits TatAE
        TIGR01410 Twin arginine-targeting protein translocase, subunit TatB
        TIGR00945 Twin arginine targeting (Tat) protein translocase, subunit TatC
        TIGR01912 Twin arginine targeting (Tat) protein translocase, subunit TatC, archaea

        >Respiration, Complex I
        COG0838|PRK07756 NADH:ubiquinone oxidoreductase subunit 3 (NuoA)
        COG0377|PRK14816|PRK14817|PRK14819|PRK14820|PRK06411 NADH:ubiquinone oxidoreductase 20 kD subunit (NuoB)
        COG0852|PRK07735|PRK08491 NADH:ubiquinone oxidoreductase 27 kD subunit (NuoC)
        COG0649|PRK06075|PRK12322 NADH:ubiquinone oxidoreductase 49 kD subunit (NuoD)
        COG1905|PRK12373|PRK07539 NADH:ubiquinone oxidoreductase 24 kD subunit (NuoE)
        COG1894|PRK13596|PRK11278 NADH:ubiquinone oxidoreductase, NADH-binding 51 kD subunit (NuoF)
        COG1034|PRK08166|PRK08493 NADH dehydrogenase/NADH:ubiquinone oxidoreductase 75 kD subunit (NuoG)
        COG1005|PRK06076 NADH:ubiquinone oxidoreductase subunit 1 (NuoH)
        COG1143|PRK05888 NADH:ubiquinone oxidoreductase 23 kD subunit (NuoI)/Formate hydrogen lyase subunit 6
        COG0839|PRK06638 NADH:ubiquinone oxidoreductase subunit 6 (NuoJ)
        COG0713|PRK05715 NADH:ubiquinone oxidoreductase subunit 11 or 4L (NuoK)
        COG1009|PRK07376|PRK08168 NADH:ubiquinone oxidoreductase subunit 5 (NuoL)/Multisubunit Na+/H+ antiporter
        COG1008|PRK07363|PRK06473 NADH:ubiquinone oxidoreductase subunit 4 (NuoM)
        COG1007|PRK05777 NADH:ubiquinone oxidoreductase subunit 2 (NuoN)
        TIGR01936 NADH:ubiquinone oxidoreductase, Na(+)-translocating, subunit A (NqrA)
        TIGR01937 NADH:ubiquinone oxidoreductase, Na(+)-translocating, subunit B (NqrA)
        TIGR01938 NADH:ubiquinone oxidoreductase, Na(+)-translocating, subunit C (NqrA)
        TIGR01939 NADH:ubiquinone oxidoreductase, Na(+)-translocating, subunit D (NqrA)
        TIGR01940 NADH:ubiquinone oxidoreductase, Na(+)-translocating, subunit E (NqrA)
        TIGR01941 NADH:ubiquinone oxidoreductase, Na(+)-translocating, subunit F (NqrA)

        >Respiration, Complex III
        CHL00037 cytochrome b6/f complex, cytochrome f subunit (petA)
        CHL00070 cytochrome b6/f complex, cytochrome b6 subunit (petB)
        COG0723|TIGR01416|TIGR03171|cd03471	Rieske Fe-S protein subunit
        CHL00058 cytochrome b6/f complex subunit IV (petD)
        COG3794|TIGR02656 Plastocyanin  (PetE)
        CHL00134 cytochrome b6/f complex, Rieske Fe-S protein subunit (petF)
        CHL00008 cytochrome b6/f complex, subunit V (petG)
        CHL00183 cytochrome b6/f complex, cytochrome c553 (petJ)
        CHL00106 cytochrome b6/f complex, subunit VI	(petL)
        PRK11876 cytochrome b6/f complex, subunit (petM)
        CHL00009 cytochrome b6/f complex, subunit VIII (petN)
        
        >Respiration, Complex IV, Cytochrome aa3-600 Menaquinol Oxidase
        A0A0U2VZK9|A0A221MEU6|A0A2A1K7J4|A0R9Y2|A4WYS2|Q7AJU8 qoxA; cytochrome aa3-600 menaquinol oxidase subunit II (ec:7.1.1.5)
        A0A0X8CZ02|A0A1W6JX37|A0A1W6JZE1|A0A222WJG3 qoxB; cytochrome aa3-600 menaquinol oxidase subunit I (ec:7.1.1.5)
        F9VMK3|H6Q9C9 qoxB; cytochrome aa3-600 menaquinol oxidase subunit I,qoxC; cytochrome aa3-600 menaquinol oxidase subunit III

        >Respiration, Complex IV, Cytochrome o Ubiquinol Oxidase
        A0A097EHG4|A0A0A8UTR5|A0A0D5V2P3|A0A172ZLM6|A0A192B115|A0A1L4BQ94|A0A1P8PKM1|A0A1U7D7R5|A0A1U9JVH5|A0A1Z2SLT7|A0A222F2B4|A0A240UMI6|A0A291JV87|A0A2D2CXG4|A5FXH9|B1M7K1|C5WCZ4|C6BIR1|D6YUP9|E8TPS4|G0AVH7|I4C4Z3|J3TEC9|Q2SXM9|Q5H2D8|S5XMF9 cyoA; cytochrome o ubiquinol oxidase subunit II (ec:7.1.1.3)
        A0A023NSJ4|A0A059ZSC1|A0A078KDR7|A0A0A1FA44|A0A0A8E9I8|A0A0H2YWB0|A0A0H5AUQ0|A0A0K2JT60|A0A0U2WD68|A0A160FSJ9|A0A191ZJE6|A0A1B3PL43|A0A1D9H4D8|A0A1S6WS91|A0A1U9KMU4|A0A1U9UMI4|A0A240UMA8|A0A249E0Q2|A0A291G7Y5|A0A2H5F515|A0A2I8DQM8|B6EQE2|C4K8K5|C7JAX4|D6YUP6|E8RVP3|F5ZAK3|G2LPV6|L0KIZ4|M4WVV2|Q1QHW4|Q493G2|S5RPT2|U3QS46|W6I4L9 cyoD; cytochrome o ubiquinol oxidase subunit IV

        >Respiration, Complex IV, Cytochrome c Oxidase, cbb3-type
        A0A075RIF1|A0A0A2NI39|A0A0C4Y8D3|A0A0D5V311|A0A159Z724|A0A1Y0IVK8|A7H9N0|B9M1T5|C6XJR4|D2QYL5|D5CNV9|F8KSQ6|F8KV94|I3XE66|W0IPW3|W0J2D5 ccoN; cytochrome c oxidase cbb3-type subunit I (ec:1.9.3.1)
        A0A059XV30|A0A099UBY3|A0A0C4YR25|A0A0X8D1L6|A0A241TD95|A0A291LY32|A7H9N1|B0STR7|B3EK79|B5E914|C7PCY8|D6Z605|E4TR21|E8UCH5|G9A9L4|I3UCV3|S6ADG4|W0DU85 ccoO; cytochrome c oxidase cbb3-type subunit II
        A0A060DJX5|A0A068TA51|A0A075MK29|A0A0B4XIN2|A0A0B7J166|A0A0D6JHD6|A0A0M5KZX8|A0A0P1D185|A0A0S1AY67|A0A0S2JYI0|A0A0U3LI46|A0A0X8CHG4|A0A0X8K5E5|A0A127F8Y6|A0A127VFD6|A0A143DDK7|A0A167A3B5|A0A192D4L3|A0A1B1AJQ2|A0A1B8TXR0|A0A1L3I0M4|A0A1P8E3S7|A0A1P8RP97|A0A1Q2LGP8|A0A1W6D0I3|A0A1Y0CVH8|A0A223NQL5|A0A249MW70|A0A250K247|A1S6J3|A4XVJ7|A6Q6N2|A7I354|A8Z604|A9VX46|B4RN97|C1AE92|D0L1X6|E0UR49|F0P142|F6DAN4|G0J7G4|G2MDR3|G4QHF5|H0Q2Q3|I1XIF3|I3QGD7|I7J0X1|K7YZQ4|L0DZL9|Q04SS0|Q11G32|Q7UQF7|W0IXT5|W1N3B4|W8F0E9|W8G0P3 ccoP; cytochrome c oxidase cbb3-type subunit III
        
        >Respiration, Complex IV, Cytochrome bd Ubiquinol Oxidase
        A0A023WZV0|A0A023X3K5|A0A023X808|A0A074MWH1|A0A075V3H5|A0A076JIE4|A0A0A0NH72|A0A0E1CH71|A0A0M3UB39|A0A0N7JVW2|A0A0P0RRQ8|A0A0S2KMH7|A0A126ZZB5|A0A158RV18|A0A1D7VX34|A0A1L6R4H1|A0A1L7FD87|A0A1P8U6B0|A0A1S6IC32|A0A1U9UZM2|A0A220VGD5|A0A239YMG4|A0A291SIB3|A0RL14|A1S0C2|A2BMU6|A4WI49|A4WI50|A6W8I9|A8MAD2|B0TEW6|B7GK14|C1DWD9|D4H930|D5XD71|D6CQZ1|D6Z1R9|D6ZHN4|D7AA22|E1QVD4|E6SI73|E6VX01|E8T5J1|E8U7E0|F0QTK1|F0QX53|F5Y2R6|F8I7C6|G7TID1|I0GPJ8|I4C5B0|J9RG41|K0ADR1|L0AM69|M1N298|M4KZG3|M4ZYY7|Q28UF9|Q2JGE8|Q3JHM6|Q5NI13|Q7UKW7|Q7W4T1|Q97AR6|Q9Z979|R4YJK6|S0AQ02|S4XIA5|S6C0D6|W5WWJ4 cydA; cytochrome bd ubiquinol oxidase subunit I (ec:7.1.1.7)
        A0A023X3Q8|A0A059ZQT6|A0A0A8E2N0|A0A0B5FHL7|A0A0E1PFB0|A0A0H2X5S8|A0A0H3KQZ1|A0A0H4KNN0|A0A0K2DKQ8|A0A0M5JJQ6|A0A0P0RN43|A0A0S1YRD7|A0A0U5ESK1|A0A0X8JCD1|A0A133QST7|A0A173MAF1|A0A1A9GJ84|A0A1B2E2Y5|A0A1B2EHB4|A0A1C3K0E2|A0A1D7THQ4|A0A1D8INV9|A0A1L3J3V6|A0A1P8K8U9|A0A1P8NK08|A0A1S6EWH4|A0A1Y0C4V1|A0A1Y0IFD9|A0A1Z1NPK7|A0A1Z1SXB2|A0A220VGI7|A0A248YMX0|A0RCV4|A0RL15|A1AN69|A6W8I8|A7MEL0|B2UM68|B3QK51|B3QXC1|B7GK13|B8ESY7|C6DYH0|C7N0L6|C7QJB4|C9LSU7|D1BLA5|D3SRB5|D4GME4|D7BPD9|D7GHW6|E3EAD2|E4NTX4|E6SI74|E6X488|E8RC17|F2JXW8|F4CTK7|F4KL54|F5Y2R7|G0A5H4|G4NNW4|G8TS99|I0G1B7|I2AX33|I2DT00|K0FXJ1|M1RCG2|M1UEM9|M5B0Z1|Q1ILJ8|Q1J2Z7|Q2IFY9|Q2JQJ4|Q484A8|Q82LT6|Q8TS01|R4SJ24|R4W9P8|S0EYS2|S4XGN2|W0AEX4 cydB; cytochrome bd ubiquinol oxidase subunit II (ec:7.1.1.7)

        >Respiration, Complex IV, Cytochrome c Oxidase
        A0A060HMB4|A0A075JYJ7|A0A0F7JXB1|A0A0H3WS21|A0A0U2UPI0|A0A0U5EYB5|A0A142X4J4|A0A160M7N1|A0A1I7PI59|A0A1J0H702|A0A1L6HTB3|A0A1P8LLZ3|A0A1W6JZD9|A3MXJ8|A5URU0|A7HEB5|B3DY48|B9KYL2|B9LSP1|C7NVV4|D0KXM6|D3F348|D3SN67|D5HB34|E0UQH6|E6TV32|E8TQH0|F0RP62|F4F7U8|F4FYQ1|G0JKZ5|I7BT61|M0LJA2|O67937|Q1IUK7|Q3J6Y4|Q7U547|V9W468|W0EUI1|W0RFW9|W8Q4M7|W8RTB5 coxA, ctaD; cytochrome c oxidase subunit I (ec:1.9.3.1)
        A0A060DZV1|A0A060KYZ9|A0A068N0V9|A0A068NQ93|A0A089L5G0|A0A097EDZ0|A0A0A8UK50|A0A0B4XQA3|A0A0B4XS53|A0A0C5W1U2|A0A0D6E7E1|A0A0F6API0|A0A0H3A8G4|A0A0H3KV76|A0A0H5CDD2|A0A0K2H0W6|A0A0P0CSB0|A0A0S3TNR7|A0A142LCJ5|A0A142X4K0|A0A143BB99|A0A160DWQ3|A0A172U766|A0A182AIU0|A0A1A9I727|A0A1B1ALC5|A0A1B1UE94|A0A1B3Z730|A0A1C9VHX2|A0A1D7NKX0|A0A1I9Y2A4|A0A1J0H464|A0A1L6L249|A0A1L7I6D5|A0A1P8PR32|A0A1P8R253|A0A1Q1FM85|A0A1Q1G402|A0A1V0GNA2|A0A1V0N1V6|A0A1Y1CGV8|A0A1Y6KEH0|A0A1Y6KK56|A0A222EXM2|A0A249KPE5|A0A286RHQ9|A0A291GQ79|A0A291M0T3|A0A2C9D571|A0A2D2D5S3|A0A2I8VJU5|A1SLF8|A3N652|A4X9Z4|A4YE05|A6WD34|A7H8L3|A8F1H8|B0R3W3|B0RIL0|B0UJY9|B1M0S7|B1ZE59|B7VQY1|B9JT24|B9KLZ4|B9KWD2|C6WU65|C9YTU0|D1ATW6|D2UBE6|D3PP67|D3T139|D4HCM6|D5BZ81|D6XTJ8|D7B2A2|D7BA69|D8J5K0|E0UL91|E1VW82|E6SCC1|E6V6Z4|E8R2H3|F0J333|F4C3D8|F8D8F0|F8J980|G0A8M5|G0JKZ6|G2LKF0|G7DLQ7|G8NPV0|G8NZY6|H9ZNT4|I2ET74|I3R5C9|I7CEX6|J7QPA0|J9S5Q9|K0ADY5|K2FLF8|K6Z3Y3|K9PA84|K9UYY2|K9XMC4|K9YR43|L0EAT3|M0LI64|M1WM78|Q04PG8|Q13IJ7|Q1J1C4|Q2IK63|Q3JBQ1|Q5P900|Q9K9N0|S6AJK3|V5SAX0|W0DG61|W0IGQ2|W0JA31|W0RIU5|W5Y7V1|W8RV07 coxB, ctaC; cytochrome c oxidase subunit II (ec:1.9.3.1)
        Q13IT3 coxA, ctaD; cytochrome c oxidase subunit I,coxAC; cytochrome c oxidase subunit I+III
        A0A067CHW0|A0A075RBB2|A0A087SDE7|A0A088EWH3|A0A088MY12|A0A0B6KN84|A0A0E3VA60|A0A0F6YMY4|A0A0M4H8I5|A0A0S2K8P3|A0A125UGF3|A0A128A3P4|A0A173LL85|A0A194QWG6|A0A1A8A3N2|A0A1A9I9S5|A0A1D7V1A8|A0A1D8IN75|A0A1J1E5M5|A0A1L3LJL2|A0A1L6L8L8|A0A1Q1G0S8|A0A1X0TXX2|A0A1Y0I140|A0A1Z3HK51|A0A223D4S3|A0A249JWD2|A0A2H3XJC6|A0RZ28|A1SY55|A4I0M3|B1HST2|B1I6G5|B6EQE1|C1AA25|C3MQD0|D2RZE9|D3EIR7|D3SMX8|D5AWT0|D5HBV5|E0VG80|E3J0T4|E5ALY9|E6R5R9|E8R2V7|E8TQH1|F0RLH9|F2KNM4|F2L0R7|F9WWB2|G2LPV5|G2MPL1|G8BSG8|G8N080|G8P172|I4AIH4|J7LF64|K7IRR7|M4V5N6|M4X4R6|Q31C87|Q4N2S9|Q5HAA6|Q6BKW6|Q6KZG0|Q6L147|Q970T4|R7SI70|W0J8S2|W4KD02|W6KB63 COX10, ctaB, cyoE; heme o synthase (ec:2.5.1.141)

        >ATP synthase
        TIGR01042 vacuolar ATPase V1, subunit A
        TIGR01040 vacuolar ATPase V1, subunit B
        TIGR02923 vacuolar or A0/A1 ATPase, subunit C
        TIGR00309 vacuolar ATP synthase, subunit D
        TIGR01100 vacuolar ATP synthase, proteolipid
        TIGR01101 vacuolar ATP synthase, subunit F
        TIGR01147 vacuolar ATP synthase, subunit G
        TIGR02926 vacuolar or A0/A1 ATPase, subunit H
        TIGR01131 ATP synthase, subunit F0 A
        TIGR01144 ATP synthase, subunit F0 B
        TIGR01260 ATP synthase, subunit F0 c
        TIGR00962 ATP synthase, subunit F1 alpha
        TIGR01039 ATP synthase, subunit F1 beta
        TIGR01146 ATP synthase, F1 subunit gamma
        TIGR01145 ATP synthase, F1 subunit delta
        TIGR01216 ATP synthase, F1 subunit epsilon
        TIGR03306 alternate ATP synthase, subunit F0 A
        TIGR03321 alternate ATP synthase, subunit F0 B
        TIGR03322|cd00313 alternate ATP synthase, subunit F0 C
        TIGR03324 alternate ATP synthase, subunit F1 alpha
        TIGR03305 alternate ATP synthase, subunit F1 beta
        TIGR03323 alternate ATP synthase, subunit F1 gamma
        TIGR03166 alternate ATP synthase, subunit F1 epsilon
        TIGR01043 archaeal ATP synthase, subunit A
        TIGR01041 archaeal ATP synthase, subunit B
        cd00313 archaeal ATP synthase, subunit F0 C

        >Respiration, Anaerobic, Dissimilatory Sulfate Reduction, Sulfate -> H2S
        PRK04149|COG2046|TIGR00339 sulfate adenylyltransferase (sat, ec:2.7.7.4)
        A0A0A7GDN9|A8MAT5|C8X4M7|C9RCT3|D5HFN4|F3YTT0|S6BVC5|W0SI19 aprA; adenylylsulfate reductase, subunit A (ec:1.8.99.2)
        A0A0M3TU33|A0A1K1LH60|A6M118|B1I2U0|C7NE97|C8X4M8|D3S0V2|F0QUP4|G4RNG3|L0KB20|N0BP05 aprB; adenylylsulfate reductase, subunit B (ec:1.8.99.2)
        TIGR02064 dsrA; dissimilatory sulfite reductase alpha subunit (ec:1.8.99.5)
        TIGR02066 dsrB; dissimilatory sulfite reductase beta subunit (ec:1.8.99.5)

        >Assimilation, Sulfite Reduction, Sulfite -> H2S
        PRK15055|TIGR02910 anaerobic sulfite reductase subunit A (asrA)
        PRK08221|TIGR02911 anaerobic sulfite reductase subunit B (asrB)
        TIGR02912 anaerobic sulfite reductase subunit C (asrC)

        >Respiration, Anaerobic, Dissimilatory Sulfur Reduction, Sulfur -> H2S
        C3MV16 sulfur reductase molybdopterin subunit (sreA)
        C3MP29 sulfur reductase FeS subunit (sreB)
        C3N2N9 sulfur reductase membrane anchor (sreC)

        >Respiration, Anaerobic, Thiosulfate reduction, Thiosulfate -> H2S
        A0A0A8B468|A0A0K2SJC4|A0A1D7TP18|A0A1D8S6A5|A0L1C2|A0LNF8|A4ARY1|A7GZQ7|B3EPP4|B5YL37|B8DNR9|C6BWV8|C7MM00|D1B0I3|D4H8U3|E1QMF2|E4U7L0|E6VR87|F8E8N9|Q24QK7|Q2IL71|Q313L9|Q72FP0 thiosulfate reductase / polysulfide reductase chain A (phsA, psrA, ec:1.8.5.5)
        A9MLM9 thiosulfate reductase electron transport protein (phsB)
        A0A0S2HYL0|A0A1D8MUJ0|A0A1Z1SYV4 thiosulfate reductase cytochrome b subunit (phsC)

        >Assimilation, Sulfate Reduction, Sulfate  -> H2S
        PRK05124|TIGR02034 sulfate adenylyltransferase subunit 1 (cysN, ec:2.7.7.4)
        PRK05253|PRK12563|TIGR02039 sulfate adenylyltransferase subunit 2 (cysD, ec:2.7.7.4)
        PRK10953|TIGR01931 sulfite reductase (NADPH) flavoprotein alpha-component (cysJ, ec:1.8.1.2)
        TIGR02041 sulfite reductase (NADPH) hemoprotein beta-component (cysI, ec:1.8.1.2)
        TIGR00434 phosphoadenosine phosphosulfate reductase (cysH, ec:1.8.4.8, 1.8.4.10)
        TIGR02042 sulfite reductase (ferredoxin) (sir, ec:1.8.7.1)
        PRK03846|PRK00889 adenylylsulfate kinase (cysC, ec:2.7.1.25)
        PRK05506|PRK05537 bifunctional bifunctional sulfate adenylyltransferase/adenylylsulfate kinase (CysN+CysC, ec:2.7.7.4,2.7.1.25)
        A0A074ZH81|A9G7W0|Q4S2V0|R7Q5H4 PAPSS; 3'-phosphoadenosine 5'-phosphosulfate synthase (ec:2.7.7.4, 2.7.1.25)

        >Respiration, Sulfide Oxidation, H2S -> Persulfide or sulfur
        A0A023X4Q2|A0A023X6M3|A0A060HRF5|A0A0B5HNV5|A0A0E3M9K3|A0A0F6Z3Z5|A0A0F7D3R5|A0A0H2WJ53|A0A0M5JN41|A0A0P0N343|A0A1B3LJN3|A0A1D8TNE1|A0A1J0LT30|A0A1L3J8W3|A0A1N5TG20|A0A220YKS7|A0A2K5ANR2|A0LS86|A1WXL7|A4SCE6|A4WJD5|A4YGC9|A6Q1T1|A9A3Y1|B9KU62|C3MJE8|D1BHR0|D3T1V6|D6ZJB9|D7E7D8|D9Q2N8|E3IW84|E4U9A4|F2L0A3|F2L312|F8I3L4|G0JQP3|G0JTE8|G0L3L6|G2Z772|G4RJT9|G8RST0|H1XSZ6|H6RTJ6|H6SNT6|I0A0U3|K0JVG3|K9T817|L0ADJ1|L0FC26|L0GLS2|M1RCW4|Q1DFV9|Q3B3U2|Q978F6|S0AB89|U5WRN5|W0DHG7|W8X932 sqr; sulfide:quinone oxidoreductase (ec:1.8.5.4)
        A0A0D5L3Z8|D0L1U4|Q8KAS4 fccB; sulfide dehydrogenase (flavocytochrome c) flavoprotein chain (ec:1.8.2.3)
        A0KLX0|B4S944|L0GYT5|Q3AP22|Q87QC8 fccA; cytochrome subunit of sulfide dehydrogenase

        >Respiration, Sulfur Oxidation, Sulfur -> Sulfite
        A0A0F8AD05|A0A0L8HDL9|A0A1E7FA36|C3Z8H4|I1M2S7|T1EG80 ETHE1; sulfur dioxygenase (ec:1.13.11.18)
        A0A191ZEW9|O66762|Q972K4 sor; sulfur oxygenase/reductase (ec:1.13.11.55)

        >Respiration, Thiosulfate Oxidation, SOX complex, Thiosulfate -> Sulfate
        TIGR04484 sulfur-oxidizing protein SoxA (soxA, ec:2.8.5.2)
        TIGR04485 sulfur-oxidizing protein SoxX (soxX, ec:2.8.5.2)
        TIGR04486 thiosulfohydrolase (soxB, ec:3.1.6.20)
        TIGR04555|cd02113 sulfite dehydrogenase (soxC)
        PRK07474 sulfur-oxidizing protein SoxY (soxY)
        TIGR04490 thiosulfate oxidation carrier protein (soxZ)
        TIGR04557 quinoprotein dehydrogenase-associated carrier (SoxYZ-like)
        cd02113 S-disulfanyl-L-cysteine oxidoreductase SoxD (soxD, ec:1.8.2.6)

        >Respiration, Sulfite Oxidation, Sulfite -> Sulfate
        A0A0M4MFR7|A0A1J1EEW2|D5X0P6 soeA; sulfite dehydrogenase (quinone) subunit SoeA (ec:1.8.5.6)
        A0A167GH90|A0A1D8S599|F4B4W1 soeB; sulfite dehydrogenase (quinone) subunit SoeB
        A0A023NVR9|A0A1B1PNP7|A0A1C9VK46|A0A1D8IKM6|A0A1J1E581|A0A1L3I1S2|B8GUS5|D3DK32|G0JPZ2|G8B0M7|Q2W1C8|Q98BE5|S6BBV4 soeC; sulfite dehydrogenase (quinone) subunit SoeC
        WP_011764874|WP_011803507|Q7P1Q4 sorB; sulfite dehydrogenase (cytochrome C) subunit B
        A0A075AI71|A0A0H3MDW2|A0A0S2EWV4|A0A179H534|A0A1I8MUV9|A0A1W4XXR1|A0A2H3WXQ7|A3KJG7|A7SP42|A8P4J6|B8NU07|C1HA82|D0NKC6|D8TX78|E3RMG9|G0S2S8|I1RGK9|Q54XJ8 SUOX; sulfite oxidase (ec:1.8.3.1)

        >Respiration, Nitrification, Ammonia Oxidation, Aerobic
        A0RUM1|WP_011330982|WP_041357108|WP_090742150|PLY22682|A0A0S4KUL9|A0A1Y0CHI7|A9QPD9|WP_084572913|WP_014892304|ANC58167|ANC58118|AEF98753 pmoA/amoA; methane/ammonia monooxygenase subunit A
        A0A1Q2SP28|A0A1W6MQF7|A9QPE0|E7BQU6|Q0ADP8|Q6MZ16 pmoB/amoB; methane/ammonia monooxygenase subunit B
        A0A1W6MT79|A0A1Y0CHN4|A9A4U4|A9QPE5|F9ZJ63 pmoC/amoC; methane/ammonia monooxygenase subunit C
        A0A1B4V6X4|A0A1Q2SL48 hao; hydroxylamine dehydrogenase (ec:1.7.2.6)
        A0A0B5GVF0|A0A0U3NDF4|A0A0U5N0A2|A0A0X8K2K6|A0A168G368|D5MLH7|F8D6S2|Q2SXG4|Q9YCG9|A0A1W1I2B6|Q1QHW9 nxrA; nitrate reductase / nitrite oxidoreductase, alpha subunit Nitrobacter (ec:1.7.5.1)
        A0A0H3GNX1|A0A1Y0HZR5|A8M8C4|D2PSR0|J7LAS1|L0JX22|Q1QHX1|A0A1W1I5Y1 nxrB; nitrate reductase / nitrite oxidoreductase, beta subunit (ec:1.7.5.1)

        >Assimilation, Urea, Cyanate, Nitrile Hydrolysis  
        PRK13207|PRK13206|PRK13308|PRK13309|TIGR01792 urease subunit alpha (ureC, ec:3.5.1.5)
        PRK13198|PRK13201|PRK13202|PRK13203|PRK13204|PRK13205|PRK13986|TIGR00192 urease subunit beta (ureB, ec:3.5.1.5)
        PRK13241|PRK13242|PRK13985|TIGR00193 urease subunit gamma (ureA, ec:3.5.1.5)
        PRK13261|PRK13262|PRK13263|PRK14112|PRK14113|PRK14711 urease accessory protein (UreE, ec:3.5.1.5)
        TIGR03407 urea ABC transporter, urea binding protein (urtA)
        TIGR03409 urea ABC transporter, permease protein (urtB)
        TIGR03408 urea ABC transporter, permease protein (urtC)
        TIGR03411 urea ABC transporter, ATP-binding protein (urtD)
        TIGR03410 urea ABC transporter, ATP-binding protein (urtE)     
        A0A061H0T4|A0A0A8EXF5|A0A0C6FYZ2|A0A0J9UYN3|A0A0M4QLG3|A0A220YCS7|A0A2H3XKK4|E1ZMV9|F2JIW8|I3UP61|J3U6N7|K0INW1|K1XT98|M2XY85|O66587|Q07HM9 cynS; cyanate lyase (ec:4.2.1.104)
        A0A0M3UBQ9|A0A222E9L4|D2SH15|E3I8A7|H6MWW1|K9SJ64 nthA; nitrile hydratase subunit alpha (ec:4.2.1.84)
        A0A0A1DRF3|A0A0M4Q303|A0A126NXW7|B0ULZ7|E6VIG6|E6WMT2|F0QD97|F4CK12|F4CU20|F7ZB22|I7EYU4|K9UG14|R4WKY7|T1X8I4 nthB; nitrile hydratase subunit beta (ec:4.2.1.84)

        >Respiration, Anaerobic, Nitrate Reduction, Nitrate -> Nitrite
        COG5013 nitrate reductase alpha subunit (NarG)
        COG2181 nitrate reductase gamma subunit (narI, narV, ec:1.7.5.1)
        PRK13532|TIGR01706 periplasmic nitrate reductase (NapA)
        COG3043|cl01153 periplasmic nitrate reductase (NapB)

        >Respiration, Anaerobic, Denitrification, Nitrite -> N2
        A0A0F6Z3B6|A0A0K0XU36|A7NPI4|C7RR96|R4YN15 nitrite reductase (NO-forming) / hydroxylamine reductase (nirS, ec:1.7.2.1, 1.7.99.1)
        A0A075TX59|A0A0D5C031|A0A0D5L9A8|A0A0G3G6R0|A0A0K2GJ77|A0A0K2HAK1|A0A0S2TH06|A0A0X8K2L5|A0A128A0R2|A0A1Q1FME2|A0A1Q2TQW5|A0A1S6FCE7|A0A291G5N2|A3P6P0|D3P4B7|D8JSS7|E1VIX6|E1W6F5|E6SGG5|F4GPW7|K0IEZ7|Q47L45|S5TI99 nitrite reductase (NO-forming) (nirK, ec:1.7.2.1)
        A0A1B1A7P4|A1U5B9|A4AQU4|B8FSS4|D3DFZ9|E8WM69|Q30P24|Q3JA29 nitric oxide reductase subunit C (norC)
        A0A0A1GWK3|A0A0K1F6V9|A0A127NSQ8|A0A163CMH9|A0A1Y0FSP0|A4WI80|A8EUI6|B4U7D0|C3NAP3|C6E2V3|D3RR47|D5WR65|D9Q165|F8D2Z9|G4SUM4|I3Z5R6|K9U1Y4|Q21X91|Q5ZTC6|W0E8H3|X8CIV6 nitric oxide reductase subunit B (norB, ec:1.7.2.5)
        A0A0P1D116|A3N9S4|B1ZWX6|C1A867|E4NU60|E6X0P5|F2KF53|G7VIA2|L0DUN0|M4ZFB5|Q21TJ5|Q7M9H5 nitrous-oxide reductase (nosZ, ec:1.7.2.4)

        >Respiration, Anaerobic, Dissimilatory Nitrite Reduction, Nitrite -> NH3
        A0A0D8IC34|A0A0K1HDZ8|A0A1J0LKT9|A0A1P8WRL5|A0A1Q2MC47|A0A1Q2TNY1|A0A1S6IWG1|A0A1X9SLI3|A0KXS3|A0R7Y5|A1WWS9|A8FZS5|B0TFE5|B4UK71|B8FQW1|C8WLS6|D5ER81|D6XSM9|F4EZ22|I3XVV4|I9DE44|Q1DA92|Q4QLL8|TIGR04315 otr; octaheme c-type cytochrome, tetrathionate reductase (ec:1.7.2.2)
        TIGR03152|PRK11125|cd00548 cytochrome c nitrite reductase large/C552 subunit (nrfA)
        TIGR03146 cytochrome c nitrite reductase pentaheme subunit (NrfB)
        TIGR03149 cytochrome c nitrite reductase Fe-S protein (NrfC)
        TIGR03153 cytochrome c nitrite reductase small subunit (nrfH)
        A0A094RZ96|A0A0H3DVH9|A0A0K0WQA8|A0A140NIM1|A0A172SRS0|A0A1D7TNS2|A8FZ92|B7VGR3|J7KUN7|Q65RI7 NrfD; protein NrfD

        >Assimilatory nitrate reduction, nitrate -> ammonia
        PRK09567 nirA; ferredoxin-nitrite reductase (ec:1.7.7.1)
        COG1251|cd19943|cd19944 nirB; nitrite reductase (NADH) large subunit (ec:1.7.1.15)
        COG2146|TIGR02378|PRK09511 nirD; nitrite reductase (NADH) small subunit (ec:1.7.1.15)
        A0A059VVY1|A0A099D9S6|A0A0B5I5Z1|A0A0F7N6A0|A0A143Q946|A0A1H1DF26|A0A1Y0HU88|A0A1Z3LHE8|D1A3S3|E1VZM8|F4CQU0|F4FC77|G2NWN9 nasB; assimilatory nitrate reductase electron transfer subunit
        A0A1A9IA83|C0QPT0|D2QF24|K9RRX3 narB; ferredoxin-nitrate reductase (ec:1.7.7.2)
        A0A0B4XNV5|A0A0B4Y0K1|A0A0C5VVE2|A0A0C5WSM9|A0A0C5XIS5|A0A0D6ECT2|A0A0H3FAQ8|A0A0S2FBU1|A0A0U5LKU9|A0A0X8LLJ8|A0A143PGT0|A0A144P391|A0A193GHE7|A0A1J0GLM5|A0A1P8UQ19|A0A1V0UAY8|A0A1Z1NJE2|A0A240UP03|A0A2H5A1X8|A6QAE2|A8H3J3|B0T0K2|B0UDN6|B1KPJ1|B1LXT5|B9LNQ5|C1CX85|C4L0G5|D0KZS5|D2R303|D2TL93|D5UHP1|E0SKC8|E1VMR6|F4ANS3|F5XN92|G8LF68|J7QR06|Q127U9|Q6FB27|Q87HA0|Q9KF71 nasA; assimilatory nitrate reductase catalytic subunit
        A0A061H168|A0A177DHT0|A0A1E7ENY3|A0A1Z5RNB1|A8PD06|B8CEC4|C5PJ79|F7W5I7|F8MIZ1|M3AQ53|P08619|R0GDA6|R7Q9D4 NR; nitrate reductase (NAD(P)H) (ec:1.7.1.1,1.7.1.2,1.7.1.3)
        A0A010QDC5|A8PD04|F7W036|F8NVU0|G0SA68|P38681 NIT-6; nitrite reductase (NAD(P)H) (ec:1.7.1.4)

        >Respiration, Anammox, Ammonia + Nitrite -> N2
        KQ1Q0T4 hzsB; Hydrazine synthase subunit beta (EC:1.7.2.7) (ec:1.7.2.7)
        Q1Q0T3 hzsG; Hydrazine synthase subunit gamma (EC:1.7.2.7)  (ec:1.7.2.7)
        ALI93542|KHE92665 hzsA; hydrazine synthase subunit A (ec:1.7.2.7)
        Q1PW30 hdh, HzoA ; Hydrazine dehydrogenase, hydroxylamine oxidoreductase (ec:1.7.2.8)

        >Assimilation, Nitrogen Fixation, N2 -> Ammonia
        TIGR01282 nitrogenase molybdenum-iron protein alpha chain (nifD)
        TIGR01284 alternate nitrogenase molybdenum-iron protein alpha chain, V-Fe, Fe-Fe (nifD)
        TIGR01286 nitrogenase molybdenum-iron protein beta chain (nifK)
        TIGR01862 nitrogenase component I, alpha chain
        TIGR01290 nitrogenase cofactor biosynthesis protein (nifB)
        PRK14476|TIGR01283|TIGR01285 nitrogenase molybdenum-cofactor biosynthesis protein (nifE, nifN)
        PRK13232|PRK13233|PRK13234|PRK13235|PRK13236|TIGR01287 nitrogenase reductase, iron protein (nifH)
        PRK00810|PRK14102 nitrogenase stabilizing/protective protein (nifW)

        >Respiration, Carbon Monoxide Oxidation CO<=>CO2
        COG2080 aerobic carbon-monoxide dehydrogenase small subunit (coxS, ec:1.2.5.3)
        pfam06240 aerobic carbon-monoxide dehydrogenase subunit G (coxG)
        COG1319 aerobic carbon-monoxide or xanthine dehydrogenase, FAD-binding subunit (coxM, ec:1.2.5.3)
        A0A068STM5|A0A0B5E084|A0A0F2KWV3|A0A0K0XC89|A0A0K2DIW5|A0A0M5KPF9|A0A0S3PQQ7|A0A0U5MFJ0|A0A167GY46|A0A1B1N9R1|A0A1B3NHP3|A0A1S6ICP8|A0A1W6ZY51|A0A1W6ZY57|A0A1W7A121|A0A291LXN2|A0A2D2H1W4|A0QWI0|B1YD71|D2BCX6|F0QTX8|F2J394|F2L5F1|F4CTR1|G8MFU4|G9AJG2|I4BPP0|I4F486|L0NI64|M4ZW95|M9RHU6|Q0A8C6|Q1AUV4|Q2IVG0|Q2KW69|Q6N7R2|Q89E16|Q96Y29|R4SXV3|U3QS63|W0K2B1|X4Z9L5 coxL, cutL; aerobic carbon-monoxide dehydrogenase large subunit (ec:1.2.5.3)

        >Respiration, Aerobic Methane oxidation, Methane -> Formaldehyde
        TIGR03080 particulate methane monooxygenase/ammonia monooxygenase, subunit A (pmmoA)
        TIGR03079 particulate methane monooxygenase/ammonia monooxygenase, subunit B (pmmoB)
        TIGR03078|cd19412|cd22188|cl04829|pfam04896 particulate methane monooxygenase/ammonia monooxygenase, subunit C (pmmoC)
        G8RLF7 mmoX; soluble methane monooxygenase component A alpha chain (ec:1.14.13.25)
        TIGR04550 soluble methane monooxygenase-binding protein (mmoD)
        A0A1W6N1N0|B2HJD1 soluble methane monooxygenase component A beta chain (mmoY. ec:1.14.13.25)
        A0A1W6MWT4|G8RLG2 soluble methane monooxygenase component A gamma chain (mmoZ, ec:1.14.13.25)
        ABE50581|WP_015824267|WP_020494391|YP_003205093|YP_002497622|EAV46784|YP_007912793 xoxF5; methanol dehydrogenase (cytochrome c) subunit 1 (ec:1.1.2.7)
        A0A160DSL2|A1WIX2 mdh2, mxaI; methanol dehydrogenase (cytochrome c) subunit 2 (ec:1.1.2.7)
        A8P437|G4N5G7|M2M3K0|R7SWA7|W4JTB1|W4KD28 MOX; alcohol oxidase (ec:1.1.3.13)
        TIGR04266|WP_003349822 mdh; methanol dehydrogenase (EC:1.1.1.244) (ec:1.1.1.244)

        >Respiration, Aerobic Formaldehyde and Formate Oxidation => CO2
        A0A0E3S0U7|A0A0U2TW35|D3T938|F6BE19|G7WPV7|H2ILU8|I3ZUG7|Q5JHW0 fdhA; formate dehydrogenase (coenzyme F420) alpha subunit (ec:1.17.98.3,1.8.98.6)
        A0A0E3QYB1|A0A0E3SFK2|A0A126R0R5|F3Z2F5|F6B9C3|Q2FKZ7|R9SH18 fdhB; formate dehydrogenase (coenzyme F420) beta subunit (ec:1.17.98.3,1.8.98.6)
        A0A1D7VYV8|A0A1D8UYA1|A0A1L6L960|Q2T435 fdhA; glutathione-independent formaldehyde dehydrogenase (ec:1.2.1.46)
        A0A072TLN4|A0A075AI99|A0A0D4DRT2|A0A0D4DU08|A0A0G3BL94|A0A0N7GSZ5|A0A0N9UG39|A0A1S3CMH6|A0A223S4F0|A0A238UBL7|A0A2I7YCN4|A0QRJ4|A0QXQ6|A1RCH0|A2BSH4|B3QIY4|B6JE72|B9KZ54|C5MIE3|D2AYW6|D5UTJ6|D8RVY7|E3IWK7|F2RIT6|F4CXK3|G4YYD7|G8N5E9|G8RJY5|I0IG60|I4F569|Q0RF44|Q24T09|Q9S247|R4UTE1|V4MF99 frmA, ADH5, adhC; S-(hydroxymethyl)glutathione dehydrogenase / alcohol dehydrogenase (ec:1.1.1.284,1.1.1.1)
        A0A067BP47|A0A076K2E6|A0A0E1CBI4|A0A0P0DR48|A0A1U6GPM3|A0A1U8KZK1|A0A1U9KWX9|A0A1W6SSV6|B4GL76|F0Q5P0|F8NDK2|G0V7N5|J9JXA8|K8Z4L7|Q7RXB4|R7Q7V5 frmB, ESD, fghA; S-formylglutathione hydrolase (ec:3.1.2.12)
        A0A0H4KNW2 E1.1.1.306; S-(hydroxymethyl)mycothiol dehydrogenase (EC:1.1.1.306) (ec:1.1.1.306)
        A0A088T3F5|G2IT80|G3J8I7|T1Y6K1|W3X3E6 FDH; formate dehydrogenase (ec:1.17.1.9)
        A0A023X718|A0A068N9Q3|A0A0B6RZM4|A0A0C6FTJ4|A0A0D6JJF6|A0A0E3MGR3|A0A0F6SQ63|A0A0K2DDG9|A0A0M5ME63|A0A0S4PYI0|A0A0U5LF32|A0A1B3NK24|A0A1D7U0F1|A0A1D7W8Z2|A0A1D8GA19|A0A1D9GJZ1|A0A1N7CR67|A0A1P8F5L2|A3MT64|A5G6W3|A7H0E9|A9BF64|B0S2H9|B2UA19|B2UJH6|B4UMJ7|B8DLA6|B8DQZ4|B9LN92|C0QAZ5|C0QLZ4|C1B585|C5CWS8|C7MPH8|D1CF24|D5AQH0|D5WB02|D7CNB2|D8J9A1|D9S0A1|E1QIG7|F2KRH5|F6B9K3|F8BUM2|G0LGB2|G8LXD8|I0IQ25|I3ZCM8|I4BYB4|J9YVK1|O59078|Q1LJP2|Q3ADY7|Q609M3|Q65UM1|Q9HL15|W0JWZ6 fdoG, fdhF, fdwA; formate dehydrogenase major subunit (ec:1.17.1.9)
        A0A0A8K7Y2|A0A0K1JD12|A0A142XBS7|A1WBG0|B9MEW2 fdwB; formate dehydrogenase beta subunit (ec:1.17.1.9)
        A0A0F2L431|A0A126T7A4|A0A142XDM2|A0A142YF20|A0A1C7HH88|A0A1L7CRZ4|A0A1P8F5R7|A0A220UHP8|A0A2C8FCT2|A5D1I8|A6W8F0|B1XTZ4|B8DQZ5|B8FUK5|B9M612|C6E0Q1|C7LUC7|D6XSE6|G4RJU7|I0ENQ6|K4LIF1|M0LVJ8|O67147|Q728X1|S5YGD5 fdoH, fdsB; formate dehydrogenase iron-sulfur subunit
        A0A024EGH5|A0A024HFB9|A0A060NKW1|A0A068SU23|A0A089NZR5|A0A089WUU7|A0A0D5LJE0|A0A0D6E357|A0A0K0X3B0|A0A126RDI4|A0A127K8P6|A0A1A9EXX0|A0A1U7D4X3|A0A1W6MZN1|A0A1X9UHW5|A0A231UKL4|A4XP97|B8EJ51|D7DMN0|F6ARL2|F7YGJ3|G0AID7|G8AQF4|G9A1M7|Q1MB09|Q2KWI9|Q608V0|S5XRM5|W0PGQ4|W8PK66 fdsD; formate dehydrogenase subunit delta (ec:1.17.1.9)
        A0A060NJC6|A0A0A7RXW0|A0A0B5BHM3|A0A0F2KQQ8|A0A0H4VFT6|A0A0K1DZV1|A0A0K1HEJ5|A0A0M4L4C3|A0A0X8K9Z7|A0A169PT59|A0A172YES7|A0A193KCS9|A0A1B1NDY3|A0A1C7HGP7|A0A1C7HH10|A0A1D7TN59|A0A1P8XRZ5|A0A1Q5Y4G9|A0A1W6RHI0|A0A220USF5|A0A291PJX9|A0A2I8DS98|A1KB89|A1RQW0|A5G6W1|A6VCR5|A6X2W9|A7HBW7|A8GZN1|A8LNU6|B1M0X9|B9L5R4|C7Q9Q5|D3NYR7|E1SP78|E3JDM4|E5ANN0|F3Z0C2|I3TJC0|I3U9W4|I7GT51|J7IXV2|Q1QW89|Q8EAI0|S5PCZ3|S6BAQ8|W0DFV4 fdoI, fdsG; formate dehydrogenase subunit gamma

        >Assimilation, Formaldehyde via Ribulose Monophosphate pathway
        TIGR03128|cd04726 3-hexulose-6-phosphate synthase (hxlA, ec:4.1.2.43, 5.3.1.27)
        TIGR03127 6-phospho 3-hexuloisomerase (hxlB)
        cl00774 Formaldehyde-activating enzyme and bifunctional enzymes (fae/hps, ec:4.2.1.147, 4.1.2.43)

        >Assimilation, Formaldehyde via Serine pathway
        PRK13580|cd00378 glycine hydroxymethyltransferase (glyA, SHMT, ec:2.1.2.1)
        B8EKC4 malate-CoA ligase subunit alpha (mtkB, ec:6.2.1.9)
        PRK14046 malate-CoA ligase subunit beta (mtkA, ec:6.2.1.9)

        >Assimilation, CO2 via Reductive Pentose Phosphate Cycle (Calvin cycle)
        PLN02318|PLN02348|PRK07429|PRK15453|COG3954 phosphoribulokinase (prkB, ec:2.7.1.19)
        CHL00040|COG1850|PRK04208|PRK13475 ribulose-bisphosphate carboxylase (RuBisCO) large subunit (rbcL, ec:4.1.1.39)
        CHL00130|COG4451|cl29940|PLN02289 ribulose-bisphosphate carboxylase (RuBisCO) small subunit (rbcS, ec:4.1.1.39)

        >Assimilation, CO2 via Reductive Citrate (TCA, Arnon-Buchanan) Cycle
        COG0674|PRK08367|PRK09622 pyruvate ferredoxin oxidoreductase alpha subunit (porA, ec:1.2.7.1)
        COG1013 pyruvate ferredoxin oxidoreductase beta subunit (porB, ec:1.2.7.1)
        COG1144|PRK09624|PRK09624 pyruvate ferredoxin oxidoreductase delta subunit (porD, ec:1.2.7.1)
        COG1014 pyruvate ferredoxin oxidoreductase gamma subunit (porG, ec:1.2.7.1)
        PRK08659|PRK09627 2-oxoacid:acceptor oxidoreductase, alpha subunit (por/kor/oorA)
        TIGR02177|PRK09628 2-oxoacid:acceptor oxidoreductase, beta subunit (por/kor/oorB)
        TIGR02175|PRK08441 2-oxoacid:acceptor oxidoreductase, gamma subunit (por/kor/oorC)
        TIGR02179|PRK09626 2-oxoacid:acceptor oxidoreductase, delta subunit (por/kor/oorD)
        B3QY35|F0S092 ATP-citrate lyase alpha-subunit (aclA, ec:2.3.3.8)
        A0A222SIX7|E0UV43 ATP-citrate lyase beta-subunit (aclB, ec:2.3.3.8)

        >Assimilation, CO2 via Acetyl-CoA (Wood-Ljungdahl) Pathway
        COG1152|TIGR00314 acetyl-CoA decarbonylase/synthase complex subunit alpha (cdhA, ec:2.1.1.245)
        TIGR00315 acetyl-CoA decarbonylase/synthase complex subunit epsilon (cdhB, ec:2.1.1.245)
        COG1614|TIGR00316|cl11685 acetyl-CoA decarbonylase/synthase complex subunit beta (cdhC, ec:2.1.1.245)
        COG2069|TIGR00381 acetyl-CoA decarbonylase/synthase complex subunit delta (cdhD, acsD, ec:2.1.1.245)
        COG1456 acetyl-CoA decarbonylase/synthase complex subunit gamma (cdhE, ec:2.1.1.245)
        PLN02759|PRK13505|PRK13506|PRK13507 formate--tetrahydrofolate ligase
        PLN02540|PRK09432 methylenetetrahydrofolate reductase (metF)
        PRK10792|PRK14168|PRK14169|PRK14170|PRK14171|PRK14175|PRK14177|PRK14178|PRK14179|PRK14181|PRK14185|PRK14186|PRK14187|PRK14188|PRK14189|PRK14191|PRK14192|PRK14194 bifunctional methylenetetrahydrofolate dehydrogenase/methenyltetrahydrofolate cyclohydrolase (FolD)

        >Assimilation, CO2 via Dicarboxylate-hydroxybutyrate Cycle
        D0KSG7|F2L5Y3 K14465; succinate semialdehyde reductase (NADPH)

        >Assimilation, CO2 via 3-Hydroxypropionate Bi-Cycle
        A0A0B6SBX1|H6SIV6|Q2W044 malyl-CoA/(S)-citramalyl-CoA lyase (mcl, ec:4.1.3.24, 4.1.3.25)

        >Methanogenesis
        A0A088RCA2|A0A0E3L5N0|A0A0E3LCE4|A0A0E3LD37|A0A0E3NNR9|A0A0X8V1W3|A3DJ56|D5XDX7|D7DQV5|F6D4A6 mtaA; (methyl-Co(III) methanol-specific corrinoid protein):coenzyme M methyltransferase (ec:2.1.1.246)
        COG1152|TIGR00314 acetyl-CoA decarbonylase/synthase complex subunit alpha (cdhA, ec:2.1.1.245)
        TIGR00315 acetyl-CoA decarbonylase/synthase complex subunit epsilon (cdhB, ec:2.1.1.245)
        COG1614|TIGR00316|cl11685 acetyl-CoA decarbonylase/synthase complex subunit beta (cdhC, ec:2.1.1.245)
        COG2069|TIGR00381 acetyl-CoA decarbonylase/synthase complex subunit delta (cdhD, acsD, ec:2.1.1.245)
        COG1456 acetyl-CoA decarbonylase/synthase complex subunit gamma (cdhE, ec:2.1.1.245)
        A0A0F7IHA4|A0A0F8VLF9|A0A142Y8V1|A0A1D3L4W6|A0A2I8EUK4|Q0BU24|U6EE53 formylmethanofuran--tetrahydromethanopterin N-formyltransferase (ftr, ec:2.3.1.101)
        A0A0B7IU20|A0A0D6JAU5|A0A0F8XX17|A0A2I8VLY2|B2JX37|D1YZT8|F0SK26|H8I6Y9|K4MUB8|Q2FT11|Q2NEY8|W0EEI3 methenyltetrahydromethanopterin cyclohydrolase (mch, ec:3.5.4.27)
        A0A0A1F7T2|A0A0H3DAA9|A0A0K0SVU2|B2T9X3|Q7UF74 5,6,7,8-tetrahydromethanopterin hydro-lyase (fae, ec:4.2.1.147)
        D7E8X7 methyl-coenzyme M reductase subunit alpha (mcrA, ec:2.8.4.1)
        Q60390 methyl-coenzyme M reductase subunit beta (mcrB, ec:2.8.4.1)
        G7WN56 methyl-coenzyme M reductase subunit C (mcrC, ec:2.8.4.1)
        A0A0P9HYJ0|A0A0X3BMY4|C9RHJ9 methyl-coenzyme M reductase subunit gamma (mcrG, ec:2.8.4.1)
        Q12UC0 (methyl-Co(III) methylamine-specific corrinoid protein): coenzyme M methyltransferase (mtbA, ec:2.1.1.247)
        A0A0S2KDX2|A0A0U5EVY4|A0A143QKN5|F4ANA5|G4RF04 methylamine dehydrogenase light chain (mauA, ec:1.4.9.1)
        A0A0B5DX78|A0A0C4YG08|A0A1B3E829|A0A291N2S9|A0A291PDR0|A1BB97|B5ZF45|E1TJR4|F6IE79|K0CBH2 methylamine dehydrogenase heavy chain (mauB, ec:1.4.9.1)

        >Respiration, Hydrogenases Fe-Fe
        WP_002568840 FeFehyd; hydrogenase, group A1
        WP_002727095 FeFehyd; hydrogenase, group A2
        WP_016268012 FeFehyd; hydrogenase, group A3
        WP_007063270 FeFehyd; hydrogenase, group A4
        AIO18483 FeFehyd; hydrogenase, group B
        WP_002572006 FeFehyd; hydrogenase, group C1
        WP_002848484 FeFehyd; hydrogenase, group C2
        AIO18481 FeFehyd; hydrogenase, group C3
        WP_004030875 FeFehyd; hydrogenase, group Fe

        >Respiration, Hydrogenases NI-Fe
        WP_015407385 NiFehyd; hydrogenase, group Ia
        WP_012675774 NiFehyd; hydrogenase, group Ib
        WP_011688559 NiFehyd; hydrogenase, group Ic
        WP_023457248 NiFehyd; hydrogenase, group Id
        WP_008030254 NiFehyd; hydrogenase, group Ie
        WP_015898101 NiFehyd; hydrogenase, group If
        WP_011822511 NiFehyd; hydrogenase, group Ig
        WP_014267363 NiFehyd; hydrogenase, group Ih
        WP_022740096 NiFehyd; hydrogenase, group Ii
        WP_010878877 NiFehyd; hydrogenase, group Ij
        WP_012036281 NiFehyd; hydrogenase, group Ik
        WP_011603008 NiFehyd; hydrogenase, group IIa
        WP_011714112 NiFehyd; hydrogenase, group IIb
        WP_011383527.1 NiFehyd; hydrogenase, group IIc
        WP_010880487 NiFehyd; hydrogenase, group IId
        WP_012020882.1 NiFehyd; hydrogenase, group IIe
        WP_022846160 NiFehyd; hydrogenase, group IIIa
        WP_011719855 NiFehyd; hydrogenase, group IIIb
        WP_013637988 NiFehyd; hydrogenase, group IIIc
        WP_011686721 NiFehyd; hydrogenase, group IIId
        WP_022739022 NiFehyd; hydrogenase, group IVa
        WP_011388069 NiFehyd; hydrogenase, group IVb
        WP_026783288 NiFehyd; hydrogenase, group IVc
        WP_014122750 NiFehyd; hydrogenase, group IVd
        WP_022739883 NiFehyd; hydrogenase, group IVe
        WP_018133527 NiFehyd; hydrogenase, group IVf
        WP_013129492 NiFehyd; hydrogenase, group IVg
        WP_011018833 NiFehyd; hydrogenase, group IVh
        WP_004029221 NiFehyd; hydrogenase, group IVi
        
        >Respiration, Anaerobic, Chlorite and related
        TIGR02486|A0A1D7TK12 rdh, pceA ; Tetrachloroethene reductive dehalogenase catalytic subunit PceA (ec:1.21.99.5)
        A0A0K2GA28|E8U2K5 cld; chlorite dismutase (ec:1.13.11.49)
        A0A010QQR5|A0A023X3G8|A0A075NSL2|A0A0A0NVR2|A0A0A8K457|A0A0B4XYA8|A0A0C5JWN0|A0A0C6FGZ0|A0A0C6P4N1|A0A0D6AZD9|A0A0D6B7L6|A0A0E3M7Y3|A0A0E3UWD1|A0A0F7NGK3|A0A0H3ASS6|A0A0H4P959|A0A0K2RUF9|A0A0P0NKY6|A0A0P0SD48|A0A0U2ZPC8|A0A0U4WMJ1|A0A0X8HBL9|A0A125T1W0|A0A142FS08|A0A160MXF1|A0A177DII8|A0A1B1M4N1|A0A1B1NCN6|A0A1B1PS83|A0A1B1ZSC7|A0A1B8U488|A0A1C7G6Z9|A0A1D7TZH5|A0A1D7W922|A0A1G4G9T9|A0A1H1CXY2|A0A1P8JRK4|A0A1P8PS40|A0A1X2L6D9|A0A2C9EK06|A0PNB6|A1SH73|A2R5H8|A2RHX2|A4YEQ5|A4YND9|A9IHN5|A9KS99|A9WF98|B1W2I1|B1XSM3|B3QPT1|B6HDU6|C5ANF9|C5CUA9|C6X4K2|D2PJB0|D3HJT1|D5E2F6|D5H197|D5VEH1|D7B7U4|D8J8M7|D8NH98|E1T4S6|E3RZ26|E6SBJ1|E6X9T8|E9EX80|F4B0I5|F4GZQ5|F7ZHD1|G0AAT0|G2PB02|G2SNQ7|G6YA49|G8R7U2|H5T021|H6RT83|I1S094|I2C0W1|I3WYX0|J7JFJ0|J9S6F8|K1WQQ7|K1X2R4|K9U250|M5AHI6|M9RCC2|Q01RF3|Q0SK70|Q1K7R5|Q213S4|Q24XU3|Q2W483|Q3JJY3|Q46PC7|Q4A097|Q5JEG7|Q5P813|Q6MLH1|Q72Q35|Q9RJT2|R4V003|R8BKV2|S3E9B1|U5MV00|V9XID6|X4ZEI9 dehII; 2-haloacid dehalogenase (ec:3.8.1.2)

        >Respiration, Anaerobic, Selenium Reduction
        A8ZSU1|C0QP50|E4NV35|tigr03479 pcrB; DMSO reductase family type II enzyme, molybdopterin subunit / Perchlorate reductase subunit alpha (EC:1.97.1.-)
        tigr03478|A8ZSU3 clrb, serB; selenate/chlorate reductase subunit beta (EC:1.97.1.9,1.97.1.1)
        WP_013516312.1 serC, clrC; selenate/chlorate reductase subunit gamma (EC:1.97.1.9,1.97.1.1)
        A0A0K2JAE8|A0A0S2I2D6|A0A1B2I589|A0A1J0GK47|A0A1J1CAE2|G8QZ37|Q6LQS9 ygfK; putative selenate reductase (ec:1.97.1.9)
        A0A1Y6K5H4|A0KK96 xdhD; putative selenate reductase molybdopterin-binding subunit
        A0A097R6V1|A0A0E0U3Z4|A0A0S2SMH4|A0A241TB99 ygfM; putative selenate reductase FAD-binding subunit

        >Respiration, Arsenate Oxidation
        A0A090K7L5|A0A0H3KQK3|A0A1W6JYC8|A4FT62|D5VKE0|H6NEV1|I3Y0F6|L0NMC5|M1RRM5|Q9Y8S0 aoxA; arsenite oxidase small subunit (ec:1.20.2.1,1.20.9.1)
        A0A023X8B4|A0A059WBK9|A0A075WGL7|A0A089ZC49|A0A0A7GCW9|A0A0C5X9J1|A0A0D6JGT6|A0A0E3UIU6|A0A0H4PE33|A0A0N9Z081|A0A0S2I1E2|A0A0X8UWZ7|A0A127HQT6|A0A142CSS0|A0A142XB88|A0A1B3NHF9|A0A1C9VAG6|A0A1P8KQ15|A0A1P8U4Q8|A0A1W1I7G0|A0A1W6ZQC9|A0A1Y0HLH5|A0A1Z4AD61|A0A223Z2L1|A0A248VV55|A0A2H1E8F1|A4FZ17|A4SF91|A4SZ94|A5WEJ8|B4UGE2|B6XU82|B8GPA1|B9E2B9|C6BHE7|C8WST2|D5BEU1|D7GG31|E6X102|F2GD98|F2NJ13|F4BT63|F7YWS8|F8E6C3|F9ZUW7|G0IY79|G8M097|H6SQE3|H9UJY3|K7S4I1|K9PDA7|L0DJD2|M9RNT4|O66910|Q3ZA56|Q9RZ30|T2G9A1|U5QHB2|W0E000|W1NB98 ARSC2, arsC; arsenate reductase (ec:1.20.4.4)
        A0A126V5W9|A0A1B2EMS1|A4FT63|B7VRR1|H6Q795|I3Y0F7|M1RIM3|Q96XX7 aoxB; arsenite oxidase large subunit (ec:1.20.2.1,1.20.9.1)

        >Respiration, Decaheme Cytochromes
        TIGR03507 MtrC ; decaheme c-type cytochrome, OmcA/MtrC family
        TIGR03509 MtrB ; decaheme-associated outer membrane protein, MtrB/PioB family
    
        >Light, Photosystem I
        CHL00056|TIGR01335 photosystem I, P700 chlorophyll a A1 (psaA)
        CHL00054|TIGR01336 photosystem I, P700 chlorophyll a A2 (PsaB)
        CHL00065 photosystem I, subunit VII (PsaC)
        CHL00145 photosystem I, subunit II (PsaD)
        CHL00125 photosystem I, subunit IV (PsaE)
        CHL00132 photosystem I, subunit III (PsaF)
        TIGR03051 plant photosystem I reaction center subunit V (PsaG)
        CHL00186|TIGR03052 photosystem I, subunit VIII (PsaI)
        CHL00105 photosystem I, subunit IX (PsaJ)
        CHL00164|TIGR03049 photosystem I, subunit X; (PsaK)
        CHL00120 photosystem I, subunit XI; (PsaL)
        CHL00190|TIGR03053 photosystem I, subunit XII; (PsaM)
        TIGR03059 plant photosystem I subunit (PsaO)
                
        >Light, Photosystem II
        CHL00003|TIGR01151 photosystem II, subunit D1 (PsbA)
        CHL00062|TIGR03039 photosystem II, 47 kDa subunit (PsbB)
        CHL00035|TIGR01153|TIGR03041 photosystem II, 44 kDa subunit (PsbC)
        CHL00004|TIGR01152 photosystem II, subunit D2 (PsbD)
        CHL00064 photosystem II, subunit V (PsbE)
        CHL00039 photosystem II, subunit VI (PsbF)
        CHL00066|PRK02624 photosystem II, subunit H (PsbH)
        CHL00024|PRK02655 photosystem II, subunit I (PsbI)
        CHL00108|PRK02565 photosystem II, subunit J (PsbJ)
        CHL00047|PRK02553 photosystem II, subunit K (PsbK)
        CHL00038|PRK00753 photosystem II, subunit L (PsbL)
        CHL00080|PRK04989|TIGR03038 photosystem II, subunit M (PsbM)
        CHL00020|PRK13183 photosystem II, subunit N (PsbN)
        TIGR03042 photosystem II, subunit Q (PsbQ)
        CHL00031|PRK11875 photosystem II, subunit T (PsbT)
        CHL00133 photosystem II, cytochrome c550 subunit (PsbV)
        CHL00128 photosystem II, subunit W (PsbW)
        CHL00114 photosystem II, subunit X (PsbX)
        CHL00196|PRK13240 photosystem II, subunit Y (PsbY)
        CHL00082|PRK02576|TIGR03043 photosystem II, subunit Z (PsbZ)
        TIGR03044 photosystem II subunit Psb27
        
        >Light, Proton Pumps
        COG5524|NF038020|cd14965|cd15028 Bacteriorhodopsin and similar
                
        >Metabolism, Glycolysis
        PTZ00107|PLN02914|PLN02596|PLN02405|PLN02362|COG4809|PRK00292|PRK12408|PRK14038|PRK14039|PRK14101|PTZ00288 hexokinase/glucokinase
        PLN02649|PRK00179|PRK00973|PRK03868|PRK04190|PRK14095|PRK14096|PRK14097|PTZ00430|TIGR02128|cd02218 glucose-6-phosphate-isomerase
        COG4809|COG0205|COG4809|PLN02251|PLN02564|PLN02884|PRK03202|PRK03979|PRK06830|PRK09513|PRK10294|PRK14071|PTZ00287|PTZ00468|TIGR02045|TIGR02477|TIGR02478|TIGR02482|TIGR02483|TIGR03168|TIGR03828 phosphofructokinase
        NF033379|PLN02227|PLN02425|PLN02455|PLN02858|PRK07226|PRK07315|PRK07709|PRK08610|PRK09196|PRK09197|PRK09250|PRK13399|PTZ00019|TIGR01520|TIGR01521 fructose-bisphosphate aldolase
        PLN02429|PLN02561|PRK00042|PRK04302|PRK13962|PRK14565|PRK14566|PRK14567|PRK14905|PRK15492|PTZ00333|TIGR00160 triosephosphate isomerase
        PLN00412|PLN02237|PLN02272|PLN02358|PLN03096|PRK04207|PRK07403|PRK07729|PRK08289|PRK08955|PRK15425|PTZ00023|PTZ00353|TIGR01546 glyceraldehyde-3-phosphate dehydrogenase
        COG0126|COG2074|PLN02282|PLN03034|PRK00073|PRK04220|PRK12337|PRK13962|PTZ00005|cl00198 phosphoglycerate kinase
        COG3635|PLN02538|PRK01112|PRK03482|PRK04024|PRK04135|PRK04200|PRK05434|PRK14115|PRK14116|PRK14118|PTZ00122|PTZ00123|TIGR00306|TIGR01258|TIGR01307 phosphoglycerate mutase
        PLN00191|PRK00077|PTZ00081|TIGR01060|cd03313 phosphopyruvate hydratase/enolase
        PLN02461|PLN02623|PLN02762|PLN02765|PRK05826|PRK06247|PRK06354|PRK06739|PRK08187|PRK09206|PRK14725|PTZ00066|PTZ00300|TIGR01064 pyruvate kinase

        >Metabolism, Pentose Phosphate pathway
        PRK12853|TIGR03554 glucose-6-phosphate dehydrogenase
        COG0363|COG2706|PLN02360|PRK11028|TIGR01198 6-phosphogluconolactonase
        COG0362|COG1023|PRK12490|PTZ00142|TIGR00872|TIGR00873 6-phosphogluconate dehydrogenase
        PLN02384|PRK00702|PRK05571|COG0120|TIGR00021|TIGR00689 ribose-5-phosphate isomerase
        COG3623|PRK13209|PRK13210|PTZ00170|cd00429|TIGR01163 ribulose-5-phosphate 3-epimerase
        COG0021|PLN02790|PRK05899|PRK12753|PRK12754|PTZ00089|TIGR00232 transketolase
        COG0176|PRK03343|PRK03903|PRK05269|PRK09533|PRK12309|PRK12346|TIGR00874 transaldolase
                
        >Metabolism, Citric Acid/Krebs/TCA cycle
        COG0372|PLN02456|PRK05614||PRK12349|PRK12350|PRK14032|PRK14034|PRK14035|PRK14036|PRK14037|TIGR01793|TIGR01798 citrate synthase
        COG1048|COG1049|TIGR00117|TIGR01340|TIGR01341 aconitase
        COG0538|COG2838|COG4579|PLN00096|PLN00103|PLN00118|PLN00123|PLN03065|PRK06451|PRK07006|PRK07362|PRK08299|PRK08997PRK09222|PTZ00435|TIGR00127 isocitrate dehydrogenase
        COG0567|PRK09404|TIGR00239|cl39092 2-oxoglutarate dehydrogenase, dehydrogenase (E1) component
        COG0508|PLN02226|TIGR01347|TIGR02927 pyruvate/2-oxoglutarate dehydrogenase, dihydrolipoamide acyltransferase (E2) component
        COG1249 pyruvate/2-oxoglutarate dehydrogenase, dihydrolipoamide dehydrogenase (E3) component
        COG0074|PRK05678|PTZ00187|TIGR01019 succinyl-CoA synthetase, alpha subunit (SucD)
        COG0045|TIGR01016 succinyl-CoA synthetase, beta subunit (SucC)
        COG1053|PLN00128|PRK05675|PRK05945|PRK06069|TIGR01811|TIGR01812|TIGR01816 succinate dehydrogenase (respiratory complex II), flavoprotein subunit (SdhA)
        COG0479|PLN00129|PRK05950|PRK06259|PRK07570|TIGR00384 succinate dehydrogenase (respiratory complex II), Fe-S protein subunit (SdhB)
        COG2009|PLN00126|PLN00127|PRK09487|TIGR02046 succinate dehydrogenase (respiratory complex II), cytochrome b subunit (SdhC)
        COG2142|PRK09488|TIGR02968 succinate dehydrogenase (respiratory complex II), hydrophobic anchor subunit (SdhD)
        COG0114|PLN00134|PRK00485|PRK12425|PRK15389|PRK15390|PRK15391|PRK15392PTZ00226|cd01362|TIGR00979 fumarate hydratase
        PLN00106|PLN00112|PLN00135|PRK05086|PRK05442|PRK06223|PRK14025|PTZ00117|PTZ00325 malate dehydrogenase

        >Metabolism, Pyruvate
        COG2609|PRK09405 pyruvate dehydrogenase, dehydrogenase (E1) component
        COG0508|PLN02226|TIGR01347|TIGR02927 pyruvate/2-oxoglutarate dehydrogenase, dihydrolipoamide acyltransferase (E2) component
        COG1249 pyruvate/2-oxoglutarate dehydrogenase, dihydrolipoamide dehydrogenase (E3) component
        COG0674|cd07034 pyrovate/oxoglutarate:ferredoxin oxidoreductase, subunit alpha (PorA)
        COG1013|TIGR02177 pyrovate/oxoglutarate:ferredoxin oxidoreductase, subunit beta (PorB)
        COG1014|TIGR02175 pyrovate/oxoglutarate:ferredoxin oxidoreductase, subunit gamma (PorG)
        COG1144|TIGR02179 pyrovate/oxoglutarate:ferredoxin oxidoreductase, subunit delta (PorD)
        COG0039|COG1052|NF033901|PLN00105|PLN02602|PRK11197 lactate dehydrogenase
        cd01678|cd01677|COG1882 pyruvate formate lyase

        >Metabolism, Hydrocarbons
        AlkB AlkB alkane hydrolase
        AlmA_GroupI AlmA_GroupI flavin-binding alkane monooxygenase
        AlmA_GroupIII AlmA_GroupIII flavin-binding alkane monooxygenase
        CYP153 CYP153 alkane oxidizing cytochrome P450
        LadA_alpha LadA_alpha long-chain alkane hydrolase
        LadA_beta LadA_beta long-chain alkane hydrolase
        LadB LadB long-chain alkane hydrolase
        pBmoA pBmoA membrane-bound alkane monooxygenase subunit A
        pBmoB pBmoB membrane-bound alkane monooxygenase subunit B
        pBmoC pBmoC membrane-bound alkane monooxygenase subunit C
        PrmA PrmA propane 2-monooxygenase large subunit
        PrmC PrmC propane 2-monooxygenase small subunit
        sBmoX sBmoX soluble alkane monooxygenase subunit A
        sBmoY sBmoY soluble alkane monooxygenase subunit B
        DmpO DmpO phenol/toluene 2-monooxygenase (NADH dependent)
        DszC DszC dibenzothiophene monooxygenase
        MAH_alpha MAH_alpha benzene/toluene/naphtalene dioxygenase subunit alpha
        MAH_beta MAH_beta benzene/toluene/naphtalene dioxygenase subunit beta
        NdoB NdoB benzene/toluene/naphtalene dioxygenase subunit alpha
        non_NdoB_type non_NdoB_type similar to benzene/toluene/naphtalene dioxygenase subunit alpha
        NdoC NdoC benzene/toluene/naphtalene dioxygenase subunit beta
        TmoA_BmoA TmoA_BmoA toluene monooxygenase subunit A
        TmoB_BmoB TmoB_BmoB toluene monooxygenase subunit B
        TmoE TmoE toluene monooxygenase system protein E
        TomA1 TomA1 phenol/toluene monooxygenase/hydroxylase (NADH dependent)
        TomA3 TomA3 phenol/toluene monooxygenase/hydroxylase (NADH dependent)
        TomA4 TomA4 phenol/toluene monooxygenase/hydroxylase (NADH dependent)
        ahyA ahyA molybdopterin-family alkane C2 methylene hydroxylase
        AssA AssA alkylsuccinate synthase
        AbcA_1 AbcA_1 benzene carboxylase
        BssA BssA benzylsuccinate synthase
        CmdA CmdA molybdopterin-family ethylbenzene dehydrogenase subunit alpha
        EbdA EbdA molybdopterin-family ethylbenzene dehydrogenase subunit alpha
        K27540 K27540 naphtalene carboxylase
        NmsA NmsA naphtylmethyl succinate synthase
        
        >Metabolism, Fatty Acids
        TIGR01749 beta-hydroxyacyl-(acyl-carrier-protein) dehydratase (FabA)
        TIGR00128 malonyl CoA-acyl carrier protein transacylase (FabD)
        TIGR03150 beta-ketoacyl-acyl-carrier-protein synthase II (FabF)
        TIGR00747 3-oxoacyl-[acyl-carrier-protein] synthase III (FabH)
        TIGR01750 beta-hydroxyacyl-(acyl-carrier-protein) dehydratase (FabZ)
        TIGR02445 acetyl-CoA C-acyltransferase (FadA)
        TIGR02437 fatty oxidation complex, alpha subunit (FadB)
        TIGR03151 enoyl-[acyl-carrier-protein] reductase (FabK)
        PRK05653 3-oxoacyl-[acyl-carrier protein] reductase   (FabG)
        PRK08594 enoyl-ACP reductase (FabI)
        PRK08063 enoyl-[acyl-carrier-protein] reductase (FabL)
        PRK13656 enoyl-[acyl-carrier-protein] reductase (FabV)
        
        >Metabolism, Inositol Phosphate Biosynthesis
        pfam16670|PLN02222|PLN02223|PLN02230|PLN02952	phosphoinositide phospholipase C (EC 3.1.4.11)
        pfam16726 inositol polyphosphate 5-phosphatase clathrin binding domain
        PRK10757 inositol-1-monophosphatase (SuhB)
        COG1260 Myo-inositol-1-phosphate synthase
        PLN02438 inositol-3-phosphate synthase
        TIGR04380|cl40708 inositol 2-dehydrogenase (IolG EC:1.1.1.181, EC:1.1.369)
        PRK04302 triosephosphate isomerase
        TIGR01859 fructose-1,6-bisphosphate aldolase (IolJ, EC:4.1.2.29)
        TIGR03396 phospholipase C, phosphocholine-specific
        
        >Metabolism, Tetraether Biosynthesis
        PRK00843 NAD(P)-dependent glycerol-1-phosphate dehydrogenase
        TIGR04147 putative phosphoglycerol geranylgeranyltransferase
        PRK12882 geranylgeranylglycerol-phosphate geranylgeranyltransferase
        PRK04032 CDP-2,3-bis-(O-geranylgeranyl)-sn-glycerol synthase
        TIGR04217 archaetidylserine synthase
        
        >Metabolism, Isoprenoid Biosynthesis
        COG0578 Glycerol-3-phosphate dehydrogenase (GlpA, EC:1.1.1.8)
        COG0240 Glycerol-3-phosphate dehydrogenase (GpsA, EC:1.1.1.8)
        COG2376 Dihydroxyacetone kinase (DAK1, EC:2.7.1.29)
        COG0371 Glycerol dehydrogenase or related enzyme, iron-containing ADH family (GldA, EC:1.1.1.6)
        COG3425 3-hydroxy-3-methylglutaryl CoA synthase	(PksG, EC:2.3.3.10)
        COG1257 Hydroxymethylglutaryl-CoA reductase (HMG1, EC:1.1.1.34)
        COG1577 Mevalonate kinase (ERG12, EC:2.7.1.36)
        COG3890 Phosphomevalonate kinase (ERG8, EC:2.7.4.2)
        COG3407 Mevalonate pyrophosphate decarboxylase (MVD1, EC:4.1.1.33)
        COG1443 Isopentenyldiphosphate isomerase (Idi, EC:5.3.3.2)
        COG1304 FMN-dependent dehydrogenase, includes L-lactate dehydrogenase and type II isopentenyl diphosphate isomerase	(LldD, EC:1.1.2.3)
        COG0743 1-deoxy-D-xylulose 5-phosphate reductoisomerase (Dxr, EC:1.1.1.267)
        COG0142 Geranylgeranyl pyrophosphate synthase (IspA, EC:2.5.1.1)
        COG1211 2-C-methyl-D-erythritol 4-phosphate cytidylyltransferase (IspD, EC:2.7.7.60)
        COG1947 4-diphosphocytidyl-2C-methyl-D-erythritol kinase (IspE, EC:2.7.1.148)
        COG0245 2C-methyl-D-erythritol 2,4-cyclodiphosphate synthase (IspF, EC:4.6.1.12)
        COG0821 4-hydroxy-3-methylbut-2-enyl diphosphate synthase (IspG/GcpE, EC:1.17.4.3)
        COG0761 4-Hydroxy-3-methylbut-2-enyl diphosphate reductase (IspH, EC:1.17.1.2)
        '''