#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# ricecooker documentation build configuration file, created by
# sphinx-quickstart on Wed Sep 21 19:57:19 2016.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.
# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# sys.path.insert(0, os.path.abspath('.'))
import os
import sys
from datetime import datetime

from ricecooker import __version__ as current_ricecooker_version

sys.path.insert(0, os.path.abspath(".."))
# from recommonmark.parser import CommonMarkParser


# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.napoleon",
    "sphinx.ext.doctest",
    "sphinx.ext.intersphinx",
    "sphinx.ext.todo",
    "sphinx.ext.mathjax",
    "sphinx.ext.viewcode",
    "recommonmark",
    "nbsphinx",
    "sphinx_rtd_theme",
    "notfound.extension",
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The encoding of source files.
#
# source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "ricecooker"
copyright = u"{year:d}, Learning Equality".format(year=datetime.now().year)
author = "Learning Equality Content Team"

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = current_ricecooker_version
# The full version, including alpha/beta/rc tags.
release = current_ricecooker_version

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#
# today = ''
#
# Else, today_fmt is used as the format for a strftime call.
#
# today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This patterns also effect to html_static_path and html_extra_path
exclude_patterns = ["examples/.ipynb_checkpoints", "examples/drafts", "_build", "build"]

# The reST default role (used for this markup: `text`) to use for all
# documents.
#
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "sphinx"

# A list of ignored prefixes for module index sorting.
# modindex_common_prefix = []

# If true, keep warnings as "system message" paragraphs in the built documents.
# keep_warnings = False

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "sphinx_rtd_theme"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom themes here, relative to this directory.
# html_theme_path = []

# The name for this set of Sphinx documents.
# "<project> v<release> documentation" by default.
#
# html_title = 'ricecooker v0.0.1'

# A shorter title for the navigation bar.  Default is the same as html_title.
#
# html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
#
html_logo = "figures/kolibri_logo.png"

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = "figures/logo.ico"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = []  # ['_static']

# Add any extra paths that contain custom files (such as robots.txt or
# .htaccess) here, relative to this directory. These files are copied
# directly to the root of the documentation.
# html_extra_path = ["extras"]

# If not None, a 'Last updated on:' timestamp is inserted at every page
# bottom, using the given strftime format.
# The empty string is equivalent to '%b %d, %Y'.
#
# html_last_updated_fmt = ''

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#
# html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
#
# html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#
# html_additional_pages = {}

# If false, no module index is generated.
#
# html_domain_indices = True

# If false, no index is generated.
#
# html_use_index = True

# If true, the index is split into individual pages for each letter.
#
# html_split_index = False

# If true, links to the reST sources are added to the pages.
#
html_show_sourcelink = False

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
#
html_show_sphinx = False

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
#
html_show_copyright = False

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#
# html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
# html_file_suffix = None

# Language to be used for generating the HTML full-text search index.
# Sphinx supports the following languages:
#   'da', 'de', 'en', 'es', 'fi', 'fr', 'h', 'it', 'ja'
#   'nl', 'no', 'pt', 'ro', 'r', 'sv', 'tr', 'zh'
#
# html_search_language = 'en'

# A dictionary with options for the search language support, empty by default.
# 'ja' uses this config value.
# 'zh' user can custom change `jieba` dictionary path.
#
# html_search_options = {'type': 'default'}

# The name of a javascript file (relative to the configuration directory) that
# implements a search results scorer. If empty, the default will be used.
#
# html_search_scorer = 'scorer.js'

# Output file base name for HTML help builder.
htmlhelp_basename = "ricecookerdoc"

# -- Options for LaTeX output ---------------------------------------------

# latex_engine = 'xelatex' FUTURE

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    "papersize": "letterpaper",
    "fncychap": "\\usepackage{fncychap}",
    "fontpkg": "\\usepackage[default]{lato}\\usepackage[T1]{fontenc}",
    "figure_align": "htbp",
    # The font size ('10pt', '11pt' or '12pt').
    #
    "pointsize": "11pt",
    "extraclassoptions": "oneside",
    # The font size ('10pt', '11pt' or '12pt').
    # 'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    "preamble": r"""
        %%% FRONTMATTER %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %
        %%%add number to subsubsection 2=subsection, 3=subsubsection
        \setcounter{secnumdepth}{3}
        %
        %%%% Table of content upto 2=subsection, 3=subsubsection
        \setcounter{tocdepth}{2}
        %\usepackage{amsmath,amsfonts,amssymb,amsthm}   % not needed since we don't math
        %\usepackage{graphicx}                          % not needed here because imported in sphinx.sty
        %
        %%% reduce spaces for Table of contents, figures and tables
        %%% it is used "\addtocontents{toc}{\vskip -1.2cm}" etc. in the document
        \usepackage[notlot,nottoc,notlof]{}

        % \usepackage{color}                            % not needed here because imported in sphinx.sty
        % \usepackage{transparent}
        % \usepackage{eso-pic}
        % \usepackage{lipsum}

        %% spacing between line
        \usepackage{setspace}
        \onehalfspacing
        % \doublespacing
        % \singlespacing

        %%% datetime
        \usepackage{datetime}
        \newdateformat{MonthYearFormat}{\monthname[\THEMONTH], \THEYEAR}



        %%% HEADERS TEXT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        \usepackage{fancyhdr}
        % plain = first-page of each chapter
        \fancypagestyle{plain}{
            \fancyhf{}
            \fancyhead{}
            \renewcommand{\headrulewidth}{0pt}
            \renewcommand{\footrulewidth}{0pt}
            \fancyfoot[C]{{\small\thepage}}
        }
        % normal = subclass of plain = applies to rest of pages
        \fancypagestyle{normal}{
            \fancyhead{}
            \fancyhead[L]{\small\rightmark}
            \fancyhead[R]{{\small\thepage}}
            \renewcommand{\headrulewidth}{0.4pt}
            \renewcommand{\footrulewidth}{0pt}
            \fancyfoot[C]{{}}  % undo the \fancyfoot[C]{{\small\thepage}} in the base class
            %   \fancyfoot[R]{\ifthenelse{\isodd{\value{page}}}{{\tiny Learning Equality} }{\href{https://learningequality.org}{\tiny learningequality.org}}}
            %%% Alternating Footer for two side
            %%% \fancyfoot[RO, RE]{\scriptsize Learning Equality (info@learningequality.org)}
        }
        %% callback that changes document header text
        %%                                               = section number counter (\thesection)
        %%                                                          + the section title
        \renewcommand{\sectionmark}[1]{\markboth{}{\emph{\thesection~#1}}}
        %%%% optional: uncomment next line to change header on every \section and not on \subsection
        %%%% \renewcommand{\subsectionmark}[1]{}


        %%reduce spacing for itemize ???
        \usepackage{enumitem}
        \setlist{nosep}

        %%%%%%%%%%% Quote Styles at the top of chapter ???
        \usepackage{epigraph}
        \setlength{\epigraphwidth}{0.8\columnwidth}
        \newcommand{\chapterquote}[2]{\epigraphhead[60]{\epigraph{\textit{#1}}{\textbf {\textit{--#2}}}}}
        %%%%%%%%%%% Quote for all places except Chapter
        \newcommand{\sectionquote}[2]{{\quote{\textit{``#1''}}{\textbf {\textit{--#2}}}}}

        \usepackage{newunicodechar}
        \newunicodechar{🐟}{fish}
        \newunicodechar{🍣}{sushi}
        \newunicodechar{🍱}{lunchbox}

    """,
    "maketitle": r"""

        %%% SET PDF INFO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % Note: this has to be after preamble where \title and \author are defined
        \makeatletter
        \hypersetup{
            pdftitle=\@title,
            pdfauthor=\@author,
            pdfkeywords={Ricecooker, Kolibri Studio, Kolibri, offline learning, open educational resources, ETL},
            pdfsubject={Ricecooker},
            pdfstartview=Fit,   % default value
            pdfstartpage=1,     % default value
            % other available options:
            % pdfstartview={FitH},
            % pdfpagelayout=SinglePage,
            % pdfpagelabels=true,
            % bookmarksopen=true,
            % bookmarksopenlevel=0
        }
        \makeatother

        %%%  COVER PAGE  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        \pagenumbering{Roman} %%% to avoid page 1 conflict with actual page 1

        \begin{titlepage}
            \centering
            \vspace*{20mm} %%% * is used to give space from top

            \vfill

            \vspace{0mm}
            \textbf{\Huge {Ricecooker}} \\
            \vspace{4mm}
            \textbf{\large {Kolibri Content Integration Tools}} \\

            \vfill

            \begin{figure}[!h]
            \centering
            \includegraphics[width=\textwidth]{content_pipeline_diagram_with_highlight.png}
            \end{figure}

            \vspace{1cm}

            \small Published by Learning Equality \\
            \vspace{2mm}
            \small \textit{Also available online at }{\href{https://ricecooker.readthedocs.io/}{ricecooker.readthedocs.io}}
        \end{titlepage}

        \clearpage
        \pagenumbering{roman}
        \tableofcontents
        % \listoffigures
        % \listoftables
        \clearpage
        \pagenumbering{arabic}
        """,
    # Latex figure (float) alignment
    # 'figure_align': 'htbp',
    #
    # GLOBAL OPTIONS FOR THE sphynx.sty STYLE CLASS ############################
    "sphinxsetup": "hmargin={1in,1in}, vmargin={1.2in,0.7in}, \
        TitleColor={rgb}{0,0,0}, \
        InnerLinkColor={rgb}{0,0,1}, \
        OuterLinkColor={rgb}{0,0,1}, \
        verbatimwithframe=false, \
        VerbatimColor={rgb}{0.95,0.95,0.95}, \
        verbatimvisiblespace={}, \
        verbatimcontinued={}",
    "tableofcontents": " ",
}
# other sphinxsetup options:
#       verbatimwithframe=true, \
#       VerbatimColor={named}{OldLace}, \
#       verbatimsep=3pt
#       hintBorderColor={named}{LightCoral},
#
#       attentionborder=3pt,
#       attentionBorderColor={named}{Crimson},
#       attentionBgColor={named}{FloralWhite},
#
#       noteborder=2pt,
#       noteBorderColor={named}{Olive},
#
#       cautionborder=3pt,
#       cautionBorderColor={named}{Cyan},
#       cautionBgColor={named}{LightCyan}}
############################################################################


# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (
        master_doc,  # source start file,
        "ricecooker.tex",  # target name,
        "ricecooker docs",  # title,
        "Learning Equality Content Team",  # author,
        "manual",  # documentclass [howto, manual, or own class])
    )
]


# The name of an image file (relative to this directory) to place at the top of
# the title page.
#
latex_logo = "figures/content_pipeline_diagram_with_highlight.png"

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
#
# latex_use_parts = False

# If true, show page references after internal links.
#
# latex_show_pagerefs = False

# If true, show URL addresses after external links.
#
# latex_show_urls = False

# Documents to append as an appendix to all manuals.
#
# latex_appendices = []

# It false, will not define \strong, \code, 	itleref, \crossref ... but only
# \sphinxstrong, ..., \sphinxtitleref, ... To help avoid clash with user added
# packages.
#
# latex_keep_old_macro_names = True

# If false, no module index is generated.
#
# latex_domain_indices = True


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, "ricecooker", "ricecooker Documentation", [author], 1)]

# If true, show URL addresses after external links.
#
# man_show_urls = False


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "ricecooker",
        "ricecooker Documentation",
        author,
        "ricecooker",
        "One line description of project.",
        "Miscellaneous",
    )
]

# Documents to append as an appendix to all manuals.
#
# texinfo_appendices = []

# If false, no module index is generated.
#
# texinfo_domain_indices = True

# How to display URL addresses: 'footnote', 'no', or 'inline'.
#
texinfo_show_urls = "inline"

# If true, do not generate a @detailmenu in the "Top" node's menu.
#
# texinfo_no_detailmenu = False


# -- Options for Epub output ----------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project
epub_author = author
epub_publisher = author
epub_copyright = copyright

# The basename for the epub file. It defaults to the project name.
# epub_basename = project

# The HTML theme for the epub output. Since the default themes are not
# optimized for small screen space, using the same theme for HTML and epub
# output is usually not wise. This defaults to 'epub', a theme designed to save
# visual space.
#
# epub_theme = 'epub'

# The language of the text. It defaults to the language option
# or 'en' if the language is not set.
#
# epub_language = ''

# The scheme of the identifier. Typical schemes are ISBN or URL.
# epub_scheme = ''

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A tuple containing the cover image and cover page html template filenames.
#
# epub_cover = ()

# A sequence of (type, uri, title) tuples for the guide element of content.opf.
#
# epub_guide = ()

# HTML files that should be inserted before the pages created by sphinx.
# The format is a list of tuples containing the path and title.
#
# epub_pre_files = []

# HTML files that should be inserted after the pages created by sphinx.
# The format is a list of tuples containing the path and title.
#
# epub_post_files = []

# A list of files that should not be packed into the epub file.
epub_exclude_files = ["search.html"]

# The depth of the table of contents in toc.ncx.
#
# epub_tocdepth = 3

# Allow duplicate toc entries.
#
# epub_tocdup = True

# Choose between 'default' and 'includehidden'.
#
# epub_tocscope = 'default'

# Fix unsupported image types using the Pillow.
#
# epub_fix_images = False

# Scale large images.
#
# epub_max_image_width = 0

# How to display URL addresses: 'footnote', 'no', or 'inline'.
#
# epub_show_urls = 'inline'

# If false, no index is generated.
#
# epub_use_index = True


# Configuration for intersphinx for various LE projects

intersphinx_mapping = {
    "python": ("https://docs.python.org/3.6/", None),
    "django": ("https://django.readthedocs.io/en/latest/", None),
    "kolibri-user": ("http://kolibri.readthedocs.io/en/latest/", None),
    "kolibri": ("http://kolibri-dev.readthedocs.io/en/latest/", None),
    "studio-user": ("https://kolibri-studio.readthedocs.io/en/latest/", None),
}


# Also accept .md files  (via https://github.com/rtfd/recommonmark)
source_suffix = [".md", ".rst", ".ipynb"]

autodoc_default_options = {
    # Make sure that any autodoc declarations show the right members
    "members": None,
    "inherited-members": None,
    "undoc-members": None,
    # "private-members": True,
    "show-inheritance": None,
}
