import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AccessContextManagerAccessLevelConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the AccessLevel and its use. Does not affect behavior.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#description AccessContextManagerAccessLevel#description}
    */
    readonly description?: string;
    /**
    * Resource name for the Access Level. The short_name component must begin
  with a letter and only include alphanumeric and '_'.
  Format: accessPolicies/{policy_id}/accessLevels/{short_name}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#name AccessContextManagerAccessLevel#name}
    */
    readonly name: string;
    /**
    * The AccessPolicy this AccessLevel lives in.
  Format: accessPolicies/{policy_id}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#parent AccessContextManagerAccessLevel#parent}
    */
    readonly parent: string;
    /**
    * Human readable title. Must be unique within the Policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#title AccessContextManagerAccessLevel#title}
    */
    readonly title: string;
    /**
    * basic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#basic AccessContextManagerAccessLevel#basic}
    */
    readonly basic?: AccessContextManagerAccessLevelBasic;
    /**
    * custom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#custom AccessContextManagerAccessLevel#custom}
    */
    readonly custom?: AccessContextManagerAccessLevelCustom;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#timeouts AccessContextManagerAccessLevel#timeouts}
    */
    readonly timeouts?: AccessContextManagerAccessLevelTimeouts;
}
export interface AccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints {
    /**
    * The minimum allowed OS version. If not set, any version
  of this OS satisfies the constraint.
  Format: "major.minor.patch" such as "10.5.301", "9.2.1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#minimum_version AccessContextManagerAccessLevel#minimum_version}
    */
    readonly minimumVersion?: string;
    /**
    * The operating system type of the device. Possible values: ["OS_UNSPECIFIED", "DESKTOP_MAC", "DESKTOP_WINDOWS", "DESKTOP_LINUX", "DESKTOP_CHROME_OS", "ANDROID", "IOS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#os_type AccessContextManagerAccessLevel#os_type}
    */
    readonly osType: string;
    /**
    * If you specify DESKTOP_CHROME_OS for osType, you can optionally include requireVerifiedChromeOs to require Chrome Verified Access.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#require_verified_chrome_os AccessContextManagerAccessLevel#require_verified_chrome_os}
    */
    readonly requireVerifiedChromeOs?: boolean | cdktf.IResolvable;
}
export declare function accessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraintsToTerraform(struct?: AccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints | cdktf.IResolvable): any;
export interface AccessContextManagerAccessLevelBasicConditionsDevicePolicy {
    /**
    * A list of allowed device management levels.
  An empty list allows all management levels. Possible values: ["MANAGEMENT_UNSPECIFIED", "NONE", "BASIC", "COMPLETE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#allowed_device_management_levels AccessContextManagerAccessLevel#allowed_device_management_levels}
    */
    readonly allowedDeviceManagementLevels?: string[];
    /**
    * A list of allowed encryptions statuses.
  An empty list allows all statuses. Possible values: ["ENCRYPTION_UNSPECIFIED", "ENCRYPTION_UNSUPPORTED", "UNENCRYPTED", "ENCRYPTED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#allowed_encryption_statuses AccessContextManagerAccessLevel#allowed_encryption_statuses}
    */
    readonly allowedEncryptionStatuses?: string[];
    /**
    * Whether the device needs to be approved by the customer admin.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#require_admin_approval AccessContextManagerAccessLevel#require_admin_approval}
    */
    readonly requireAdminApproval?: boolean | cdktf.IResolvable;
    /**
    * Whether the device needs to be corp owned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#require_corp_owned AccessContextManagerAccessLevel#require_corp_owned}
    */
    readonly requireCorpOwned?: boolean | cdktf.IResolvable;
    /**
    * Whether or not screenlock is required for the DevicePolicy
  to be true. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#require_screen_lock AccessContextManagerAccessLevel#require_screen_lock}
    */
    readonly requireScreenLock?: boolean | cdktf.IResolvable;
    /**
    * os_constraints block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#os_constraints AccessContextManagerAccessLevel#os_constraints}
    */
    readonly osConstraints?: AccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints[] | cdktf.IResolvable;
}
export declare function accessContextManagerAccessLevelBasicConditionsDevicePolicyToTerraform(struct?: AccessContextManagerAccessLevelBasicConditionsDevicePolicyOutputReference | AccessContextManagerAccessLevelBasicConditionsDevicePolicy): any;
export declare class AccessContextManagerAccessLevelBasicConditionsDevicePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerAccessLevelBasicConditionsDevicePolicy | undefined;
    set internalValue(value: AccessContextManagerAccessLevelBasicConditionsDevicePolicy | undefined);
    private _allowedDeviceManagementLevels?;
    get allowedDeviceManagementLevels(): string[];
    set allowedDeviceManagementLevels(value: string[]);
    resetAllowedDeviceManagementLevels(): void;
    get allowedDeviceManagementLevelsInput(): string[] | undefined;
    private _allowedEncryptionStatuses?;
    get allowedEncryptionStatuses(): string[];
    set allowedEncryptionStatuses(value: string[]);
    resetAllowedEncryptionStatuses(): void;
    get allowedEncryptionStatusesInput(): string[] | undefined;
    private _requireAdminApproval?;
    get requireAdminApproval(): boolean | cdktf.IResolvable;
    set requireAdminApproval(value: boolean | cdktf.IResolvable);
    resetRequireAdminApproval(): void;
    get requireAdminApprovalInput(): boolean | cdktf.IResolvable | undefined;
    private _requireCorpOwned?;
    get requireCorpOwned(): boolean | cdktf.IResolvable;
    set requireCorpOwned(value: boolean | cdktf.IResolvable);
    resetRequireCorpOwned(): void;
    get requireCorpOwnedInput(): boolean | cdktf.IResolvable | undefined;
    private _requireScreenLock?;
    get requireScreenLock(): boolean | cdktf.IResolvable;
    set requireScreenLock(value: boolean | cdktf.IResolvable);
    resetRequireScreenLock(): void;
    get requireScreenLockInput(): boolean | cdktf.IResolvable | undefined;
    private _osConstraints?;
    get osConstraints(): AccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints[] | cdktf.IResolvable;
    set osConstraints(value: AccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints[] | cdktf.IResolvable);
    resetOsConstraints(): void;
    get osConstraintsInput(): cdktf.IResolvable | AccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints[] | undefined;
}
export interface AccessContextManagerAccessLevelBasicConditions {
    /**
    * A list of CIDR block IP subnetwork specification. May be IPv4
  or IPv6.
  Note that for a CIDR IP address block, the specified IP address
  portion must be properly truncated (i.e. all the host bits must
  be zero) or the input is considered malformed. For example,
  "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
  for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
  is not. The originating IP of a request must be in one of the
  listed subnets in order for this Condition to be true.
  If empty, all IP addresses are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#ip_subnetworks AccessContextManagerAccessLevel#ip_subnetworks}
    */
    readonly ipSubnetworks?: string[];
    /**
    * An allowed list of members (users, service accounts).
  Using groups is not supported yet.
  
  The signed-in user originating the request must be a part of one
  of the provided members. If not specified, a request may come
  from any user (logged in/not logged in, not present in any
  groups, etc.).
  Formats: 'user:{emailid}', 'serviceAccount:{emailid}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#members AccessContextManagerAccessLevel#members}
    */
    readonly members?: string[];
    /**
    * Whether to negate the Condition. If true, the Condition becomes
  a NAND over its non-empty fields, each field must be false for
  the Condition overall to be satisfied. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#negate AccessContextManagerAccessLevel#negate}
    */
    readonly negate?: boolean | cdktf.IResolvable;
    /**
    * The request must originate from one of the provided
  countries/regions.
  Format: A valid ISO 3166-1 alpha-2 code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#regions AccessContextManagerAccessLevel#regions}
    */
    readonly regions?: string[];
    /**
    * A list of other access levels defined in the same Policy,
  referenced by resource name. Referencing an AccessLevel which
  does not exist is an error. All access levels listed must be
  granted for the Condition to be true.
  Format: accessPolicies/{policy_id}/accessLevels/{short_name}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#required_access_levels AccessContextManagerAccessLevel#required_access_levels}
    */
    readonly requiredAccessLevels?: string[];
    /**
    * device_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#device_policy AccessContextManagerAccessLevel#device_policy}
    */
    readonly devicePolicy?: AccessContextManagerAccessLevelBasicConditionsDevicePolicy;
}
export declare function accessContextManagerAccessLevelBasicConditionsToTerraform(struct?: AccessContextManagerAccessLevelBasicConditions | cdktf.IResolvable): any;
export interface AccessContextManagerAccessLevelBasic {
    /**
    * How the conditions list should be combined to determine if a request
  is granted this AccessLevel. If AND is used, each Condition in
  conditions must be satisfied for the AccessLevel to be applied. If
  OR is used, at least one Condition in conditions must be satisfied
  for the AccessLevel to be applied. Default value: "AND" Possible values: ["AND", "OR"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#combining_function AccessContextManagerAccessLevel#combining_function}
    */
    readonly combiningFunction?: string;
    /**
    * conditions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#conditions AccessContextManagerAccessLevel#conditions}
    */
    readonly conditions: AccessContextManagerAccessLevelBasicConditions[] | cdktf.IResolvable;
}
export declare function accessContextManagerAccessLevelBasicToTerraform(struct?: AccessContextManagerAccessLevelBasicOutputReference | AccessContextManagerAccessLevelBasic): any;
export declare class AccessContextManagerAccessLevelBasicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerAccessLevelBasic | undefined;
    set internalValue(value: AccessContextManagerAccessLevelBasic | undefined);
    private _combiningFunction?;
    get combiningFunction(): string;
    set combiningFunction(value: string);
    resetCombiningFunction(): void;
    get combiningFunctionInput(): string | undefined;
    private _conditions?;
    get conditions(): AccessContextManagerAccessLevelBasicConditions[] | cdktf.IResolvable;
    set conditions(value: AccessContextManagerAccessLevelBasicConditions[] | cdktf.IResolvable);
    get conditionsInput(): cdktf.IResolvable | AccessContextManagerAccessLevelBasicConditions[] | undefined;
}
export interface AccessContextManagerAccessLevelCustomExpr {
    /**
    * Description of the expression
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#description AccessContextManagerAccessLevel#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#expression AccessContextManagerAccessLevel#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#location AccessContextManagerAccessLevel#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#title AccessContextManagerAccessLevel#title}
    */
    readonly title?: string;
}
export declare function accessContextManagerAccessLevelCustomExprToTerraform(struct?: AccessContextManagerAccessLevelCustomExprOutputReference | AccessContextManagerAccessLevelCustomExpr): any;
export declare class AccessContextManagerAccessLevelCustomExprOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerAccessLevelCustomExpr | undefined;
    set internalValue(value: AccessContextManagerAccessLevelCustomExpr | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface AccessContextManagerAccessLevelCustom {
    /**
    * expr block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#expr AccessContextManagerAccessLevel#expr}
    */
    readonly expr: AccessContextManagerAccessLevelCustomExpr;
}
export declare function accessContextManagerAccessLevelCustomToTerraform(struct?: AccessContextManagerAccessLevelCustomOutputReference | AccessContextManagerAccessLevelCustom): any;
export declare class AccessContextManagerAccessLevelCustomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerAccessLevelCustom | undefined;
    set internalValue(value: AccessContextManagerAccessLevelCustom | undefined);
    private _expr;
    get expr(): AccessContextManagerAccessLevelCustomExprOutputReference;
    putExpr(value: AccessContextManagerAccessLevelCustomExpr): void;
    get exprInput(): AccessContextManagerAccessLevelCustomExpr | undefined;
}
export interface AccessContextManagerAccessLevelTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#create AccessContextManagerAccessLevel#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#delete AccessContextManagerAccessLevel#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level#update AccessContextManagerAccessLevel#update}
    */
    readonly update?: string;
}
export declare function accessContextManagerAccessLevelTimeoutsToTerraform(struct?: AccessContextManagerAccessLevelTimeoutsOutputReference | AccessContextManagerAccessLevelTimeouts | cdktf.IResolvable): any;
export declare class AccessContextManagerAccessLevelTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerAccessLevelTimeouts | undefined;
    set internalValue(value: AccessContextManagerAccessLevelTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level google_access_context_manager_access_level}
*/
export declare class AccessContextManagerAccessLevel extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_access_context_manager_access_level";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level google_access_context_manager_access_level} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AccessContextManagerAccessLevelConfig
    */
    constructor(scope: Construct, id: string, config: AccessContextManagerAccessLevelConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _basic;
    get basic(): AccessContextManagerAccessLevelBasicOutputReference;
    putBasic(value: AccessContextManagerAccessLevelBasic): void;
    resetBasic(): void;
    get basicInput(): AccessContextManagerAccessLevelBasic | undefined;
    private _custom;
    get custom(): AccessContextManagerAccessLevelCustomOutputReference;
    putCustom(value: AccessContextManagerAccessLevelCustom): void;
    resetCustom(): void;
    get customInput(): AccessContextManagerAccessLevelCustom | undefined;
    private _timeouts;
    get timeouts(): AccessContextManagerAccessLevelTimeoutsOutputReference;
    putTimeouts(value: AccessContextManagerAccessLevelTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AccessContextManagerAccessLevelTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
