import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeFirewallPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource. Provide this property when you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy#description ComputeFirewallPolicy#description}
    */
    readonly description?: string;
    /**
    * The parent of the firewall policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy#parent ComputeFirewallPolicy#parent}
    */
    readonly parent: string;
    /**
    * User-provided name of the Organization firewall policy. The name should be unique in the organization in which the firewall policy is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy#short_name ComputeFirewallPolicy#short_name}
    */
    readonly shortName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy#timeouts ComputeFirewallPolicy#timeouts}
    */
    readonly timeouts?: ComputeFirewallPolicyTimeouts;
}
export interface ComputeFirewallPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy#create ComputeFirewallPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy#delete ComputeFirewallPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy#update ComputeFirewallPolicy#update}
    */
    readonly update?: string;
}
export declare function computeFirewallPolicyTimeoutsToTerraform(struct?: ComputeFirewallPolicyTimeoutsOutputReference | ComputeFirewallPolicyTimeouts | cdktf.IResolvable): any;
export declare class ComputeFirewallPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeFirewallPolicyTimeouts | undefined;
    set internalValue(value: ComputeFirewallPolicyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy google_compute_firewall_policy}
*/
export declare class ComputeFirewallPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_firewall_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy google_compute_firewall_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeFirewallPolicyConfig
    */
    constructor(scope: Construct, id: string, config: ComputeFirewallPolicyConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get fingerprint(): string;
    get firewallPolicyId(): string;
    get id(): string;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    get ruleTupleCount(): number;
    get selfLink(): string;
    get selfLinkWithId(): string;
    private _shortName?;
    get shortName(): string;
    set shortName(value: string);
    get shortNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): ComputeFirewallPolicyTimeoutsOutputReference;
    putTimeouts(value: ComputeFirewallPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeFirewallPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
