import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRegionTargetHttpProxyConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_http_proxy#description ComputeRegionTargetHttpProxy#description}
    */
    readonly description?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_http_proxy#name ComputeRegionTargetHttpProxy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_http_proxy#project ComputeRegionTargetHttpProxy#project}
    */
    readonly project?: string;
    /**
    * The Region in which the created target https proxy should reside.
  If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_http_proxy#region ComputeRegionTargetHttpProxy#region}
    */
    readonly region?: string;
    /**
    * A reference to the RegionUrlMap resource that defines the mapping from URL
  to the BackendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_http_proxy#url_map ComputeRegionTargetHttpProxy#url_map}
    */
    readonly urlMap: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_http_proxy#timeouts ComputeRegionTargetHttpProxy#timeouts}
    */
    readonly timeouts?: ComputeRegionTargetHttpProxyTimeouts;
}
export interface ComputeRegionTargetHttpProxyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_http_proxy#create ComputeRegionTargetHttpProxy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_http_proxy#delete ComputeRegionTargetHttpProxy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_http_proxy#update ComputeRegionTargetHttpProxy#update}
    */
    readonly update?: string;
}
export declare function computeRegionTargetHttpProxyTimeoutsToTerraform(struct?: ComputeRegionTargetHttpProxyTimeoutsOutputReference | ComputeRegionTargetHttpProxyTimeouts | cdktf.IResolvable): any;
export declare class ComputeRegionTargetHttpProxyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionTargetHttpProxyTimeouts | undefined;
    set internalValue(value: ComputeRegionTargetHttpProxyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_http_proxy google_compute_region_target_http_proxy}
*/
export declare class ComputeRegionTargetHttpProxy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_target_http_proxy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_target_http_proxy google_compute_region_target_http_proxy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeRegionTargetHttpProxyConfig
    */
    constructor(scope: Construct, id: string, config: ComputeRegionTargetHttpProxyConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get proxyId(): number;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _urlMap?;
    get urlMap(): string;
    set urlMap(value: string);
    get urlMapInput(): string | undefined;
    private _timeouts;
    get timeouts(): ComputeRegionTargetHttpProxyTimeoutsOutputReference;
    putTimeouts(value: ComputeRegionTargetHttpProxyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeRegionTargetHttpProxyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
