import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleProjectOrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/project_organization_policy#constraint DataGoogleProjectOrganizationPolicy#constraint}
    */
    readonly constraint: string;
    /**
    * The project ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/project_organization_policy#project DataGoogleProjectOrganizationPolicy#project}
    */
    readonly project: string;
}
export interface DataGoogleProjectOrganizationPolicyBooleanPolicy {
}
export declare function dataGoogleProjectOrganizationPolicyBooleanPolicyToTerraform(struct?: DataGoogleProjectOrganizationPolicyBooleanPolicy): any;
export declare class DataGoogleProjectOrganizationPolicyBooleanPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleProjectOrganizationPolicyBooleanPolicy | undefined;
    set internalValue(value: DataGoogleProjectOrganizationPolicyBooleanPolicy | undefined);
    get enforced(): cdktf.IResolvable;
}
export declare class DataGoogleProjectOrganizationPolicyBooleanPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleProjectOrganizationPolicyBooleanPolicyOutputReference;
}
export interface DataGoogleProjectOrganizationPolicyListPolicyAllow {
}
export declare function dataGoogleProjectOrganizationPolicyListPolicyAllowToTerraform(struct?: DataGoogleProjectOrganizationPolicyListPolicyAllow): any;
export declare class DataGoogleProjectOrganizationPolicyListPolicyAllowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleProjectOrganizationPolicyListPolicyAllow | undefined;
    set internalValue(value: DataGoogleProjectOrganizationPolicyListPolicyAllow | undefined);
    get all(): cdktf.IResolvable;
    get values(): string[];
}
export declare class DataGoogleProjectOrganizationPolicyListPolicyAllowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleProjectOrganizationPolicyListPolicyAllowOutputReference;
}
export interface DataGoogleProjectOrganizationPolicyListPolicyDeny {
}
export declare function dataGoogleProjectOrganizationPolicyListPolicyDenyToTerraform(struct?: DataGoogleProjectOrganizationPolicyListPolicyDeny): any;
export declare class DataGoogleProjectOrganizationPolicyListPolicyDenyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleProjectOrganizationPolicyListPolicyDeny | undefined;
    set internalValue(value: DataGoogleProjectOrganizationPolicyListPolicyDeny | undefined);
    get all(): cdktf.IResolvable;
    get values(): string[];
}
export declare class DataGoogleProjectOrganizationPolicyListPolicyDenyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleProjectOrganizationPolicyListPolicyDenyOutputReference;
}
export interface DataGoogleProjectOrganizationPolicyListPolicy {
}
export declare function dataGoogleProjectOrganizationPolicyListPolicyToTerraform(struct?: DataGoogleProjectOrganizationPolicyListPolicy): any;
export declare class DataGoogleProjectOrganizationPolicyListPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleProjectOrganizationPolicyListPolicy | undefined;
    set internalValue(value: DataGoogleProjectOrganizationPolicyListPolicy | undefined);
    private _allow;
    get allow(): DataGoogleProjectOrganizationPolicyListPolicyAllowList;
    private _deny;
    get deny(): DataGoogleProjectOrganizationPolicyListPolicyDenyList;
    get inheritFromParent(): cdktf.IResolvable;
    get suggestedValue(): string;
}
export declare class DataGoogleProjectOrganizationPolicyListPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleProjectOrganizationPolicyListPolicyOutputReference;
}
export interface DataGoogleProjectOrganizationPolicyRestorePolicy {
}
export declare function dataGoogleProjectOrganizationPolicyRestorePolicyToTerraform(struct?: DataGoogleProjectOrganizationPolicyRestorePolicy): any;
export declare class DataGoogleProjectOrganizationPolicyRestorePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleProjectOrganizationPolicyRestorePolicy | undefined;
    set internalValue(value: DataGoogleProjectOrganizationPolicyRestorePolicy | undefined);
    get default(): cdktf.IResolvable;
}
export declare class DataGoogleProjectOrganizationPolicyRestorePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleProjectOrganizationPolicyRestorePolicyOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/project_organization_policy google_project_organization_policy}
*/
export declare class DataGoogleProjectOrganizationPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_project_organization_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/project_organization_policy google_project_organization_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleProjectOrganizationPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleProjectOrganizationPolicyConfig);
    private _booleanPolicy;
    get booleanPolicy(): DataGoogleProjectOrganizationPolicyBooleanPolicyList;
    private _constraint?;
    get constraint(): string;
    set constraint(value: string);
    get constraintInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _listPolicy;
    get listPolicy(): DataGoogleProjectOrganizationPolicyListPolicyList;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _restorePolicy;
    get restorePolicy(): DataGoogleProjectOrganizationPolicyRestorePolicyList;
    get updateTime(): string;
    get version(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
