import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivatecaCaPoolIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_binding#ca_pool PrivatecaCaPoolIamBinding#ca_pool}
    */
    readonly caPool: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_binding#location PrivatecaCaPoolIamBinding#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_binding#members PrivatecaCaPoolIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_binding#project PrivatecaCaPoolIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_binding#role PrivatecaCaPoolIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_binding#condition PrivatecaCaPoolIamBinding#condition}
    */
    readonly condition?: PrivatecaCaPoolIamBindingCondition;
}
export interface PrivatecaCaPoolIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_binding#description PrivatecaCaPoolIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_binding#expression PrivatecaCaPoolIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_binding#title PrivatecaCaPoolIamBinding#title}
    */
    readonly title: string;
}
export declare function privatecaCaPoolIamBindingConditionToTerraform(struct?: PrivatecaCaPoolIamBindingConditionOutputReference | PrivatecaCaPoolIamBindingCondition): any;
export declare class PrivatecaCaPoolIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCaPoolIamBindingCondition | undefined;
    set internalValue(value: PrivatecaCaPoolIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_binding google_privateca_ca_pool_iam_binding}
*/
export declare class PrivatecaCaPoolIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_privateca_ca_pool_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/privateca_ca_pool_iam_binding google_privateca_ca_pool_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrivatecaCaPoolIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: PrivatecaCaPoolIamBindingConfig);
    private _caPool?;
    get caPool(): string;
    set caPool(value: string);
    get caPoolInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): PrivatecaCaPoolIamBindingConditionOutputReference;
    putCondition(value: PrivatecaCaPoolIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): PrivatecaCaPoolIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
