import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SourcerepoRepositoryIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_policy#policy_data SourcerepoRepositoryIamPolicy#policy_data}
    */
    readonly policyData: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_policy#project SourcerepoRepositoryIamPolicy#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_policy#repository SourcerepoRepositoryIamPolicy#repository}
    */
    readonly repository: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_policy google_sourcerepo_repository_iam_policy}
*/
export declare class SourcerepoRepositoryIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_sourcerepo_repository_iam_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/sourcerepo_repository_iam_policy google_sourcerepo_repository_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SourcerepoRepositoryIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: SourcerepoRepositoryIamPolicyConfig);
    get etag(): string;
    get id(): string;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _repository?;
    get repository(): string;
    set repository(value: string);
    get repositoryInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
