import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpannerDatabaseIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database_iam_member#database SpannerDatabaseIamMember#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database_iam_member#instance SpannerDatabaseIamMember#instance}
    */
    readonly instance: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database_iam_member#member SpannerDatabaseIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database_iam_member#project SpannerDatabaseIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database_iam_member#role SpannerDatabaseIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database_iam_member#condition SpannerDatabaseIamMember#condition}
    */
    readonly condition?: SpannerDatabaseIamMemberCondition;
}
export interface SpannerDatabaseIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database_iam_member#description SpannerDatabaseIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database_iam_member#expression SpannerDatabaseIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/spanner_database_iam_member#title SpannerDatabaseIamMember#title}
    */
    readonly title: string;
}
export declare function spannerDatabaseIamMemberConditionToTerraform(struct?: SpannerDatabaseIamMemberConditionOutputReference | SpannerDatabaseIamMemberCondition): any;
export declare class SpannerDatabaseIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpannerDatabaseIamMemberCondition | undefined;
    set internalValue(value: SpannerDatabaseIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/spanner_database_iam_member google_spanner_database_iam_member}
*/
export declare class SpannerDatabaseIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_spanner_database_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/spanner_database_iam_member google_spanner_database_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpannerDatabaseIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: SpannerDatabaseIamMemberConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): SpannerDatabaseIamMemberConditionOutputReference;
    putCondition(value: SpannerDatabaseIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): SpannerDatabaseIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
