import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudbuildTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Human-readable description of the trigger.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#description CloudbuildTrigger#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Whether the trigger is disabled or not. If true, the trigger will never result in a build.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#disabled CloudbuildTrigger#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * Path, from the source root, to a file whose contents is used for the template.
     *
     * Either a filename or build template must be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#filename CloudbuildTrigger#filename}
     *
     * @stability stable
     */
    readonly filename?: string;
    /**
     * ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match extended with support for '**'.
     *
     * If ignoredFiles and changed files are both empty, then they are not
     * used to determine whether or not to trigger a build.
     *
     * If ignoredFiles is not empty, then we ignore any files that match any
     * of the ignored_file globs. If the change has no files that are outside
     * of the ignoredFiles globs, then we do not trigger a build.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#ignored_files CloudbuildTrigger#ignored_files}
     *
     * @stability stable
     */
    readonly ignoredFiles?: string[];
    /**
     * ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match extended with support for '**'.
     *
     * If any of the files altered in the commit pass the ignoredFiles filter
     * and includedFiles is empty, then as far as this filter is concerned, we
     * should trigger the build.
     *
     * If any of the files altered in the commit pass the ignoredFiles filter
     * and includedFiles is not empty, then we make sure that at least one of
     * those files matches a includedFiles glob. If not, then we do not trigger
     * a build.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#included_files CloudbuildTrigger#included_files}
     *
     * @stability stable
     */
    readonly includedFiles?: string[];
    /**
     * Name of the trigger. Must be unique within the project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#name CloudbuildTrigger#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#project CloudbuildTrigger#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The service account used for all user-controlled operations including triggers.patch, triggers.run, builds.create, and builds.cancel.
     *
     * If no service account is set, then the standard Cloud Build service account
     * ([PROJECT_NUM]@system.gserviceaccount.com) will be used instead.
     *
     * Format: projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#service_account CloudbuildTrigger#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: string;
    /**
     * Substitutions data for Build resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#substitutions CloudbuildTrigger#substitutions}
     *
     * @stability stable
     */
    readonly substitutions?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Tags for annotation of a BuildTrigger.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#tags CloudbuildTrigger#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * build block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#build CloudbuildTrigger#build}
     *
     * @stability stable
     */
    readonly buildAttribute?: CloudbuildTriggerBuild;
    /**
     * github block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#github CloudbuildTrigger#github}
     *
     * @stability stable
     */
    readonly github?: CloudbuildTriggerGithub;
    /**
     * pubsub_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#pubsub_config CloudbuildTrigger#pubsub_config}
     *
     * @stability stable
     */
    readonly pubsubConfig?: CloudbuildTriggerPubsubConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#timeouts CloudbuildTrigger#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CloudbuildTriggerTimeouts;
    /**
     * trigger_template block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#trigger_template CloudbuildTrigger#trigger_template}
     *
     * @stability stable
     */
    readonly triggerTemplate?: CloudbuildTriggerTriggerTemplate;
    /**
     * webhook_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#webhook_config CloudbuildTrigger#webhook_config}
     *
     * @stability stable
     */
    readonly webhookConfig?: CloudbuildTriggerWebhookConfig;
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerBuildArtifactsObjects {
    /**
     * Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/".
     *
     * Files in the workspace matching any path pattern will be uploaded to Cloud Storage with
     * this location as a prefix.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#location CloudbuildTrigger#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Path globs used to match files in the build's workspace.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#paths CloudbuildTrigger#paths}
     *
     * @stability stable
     */
    readonly paths?: string[];
}
/**
 * @stability stable
 */
export declare class CloudbuildTriggerBuildArtifactsObjectsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _location?;
    /**
     * @stability stable
     */
    get location(): string | undefined;
    /**
     * @stability stable
     */
    set location(value: string | undefined);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _paths?;
    /**
     * @stability stable
     */
    get paths(): string[] | undefined;
    /**
     * @stability stable
     */
    set paths(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetPaths(): void;
    /**
     * @stability stable
     */
    get pathsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerBuildArtifacts {
    /**
     * A list of images to be pushed upon the successful completion of all build steps.
     *
     * The images will be pushed using the builder service account's credentials.
     *
     * The digests of the pushed images will be stored in the Build resource's results field.
     *
     * If any of the images fail to be pushed, the build is marked FAILURE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#images CloudbuildTrigger#images}
     *
     * @stability stable
     */
    readonly images?: string[];
    /**
     * objects block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#objects CloudbuildTrigger#objects}
     *
     * @stability stable
     */
    readonly objects?: CloudbuildTriggerBuildArtifactsObjects;
}
/**
 * @stability stable
 */
export declare class CloudbuildTriggerBuildArtifactsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _images?;
    /**
     * @stability stable
     */
    get images(): string[] | undefined;
    /**
     * @stability stable
     */
    set images(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetImages(): void;
    /**
     * @stability stable
     */
    get imagesInput(): string[] | undefined;
    private _objects?;
    private __objectsOutput;
    /**
     * @stability stable
     */
    get objects(): CloudbuildTriggerBuildArtifactsObjectsOutputReference;
    /**
     * @stability stable
     */
    putObjects(value: CloudbuildTriggerBuildArtifactsObjects | undefined): void;
    /**
     * @stability stable
     */
    resetObjects(): void;
    /**
     * @stability stable
     */
    get objectsInput(): CloudbuildTriggerBuildArtifactsObjects | undefined;
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerBuildOptionsVolumes {
    /**
     * Name of the volume to mount.
     *
     * Volume names must be unique per build step and must be valid names for Docker volumes.
     * Each named volume must be used by at least two build steps.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#name CloudbuildTrigger#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Path at which to mount the volume.
     *
     * Paths must be absolute and cannot conflict with other volume paths on the same
     * build step or with certain reserved volume paths.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#path CloudbuildTrigger#path}
     *
     * @stability stable
     */
    readonly path?: string;
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerBuildOptions {
    /**
     * Requested disk size for the VM that runs the build.
     *
     * Note that this is NOT "disk free";
     * some of the space will be used by the operating system and build utilities.
     * Also note that this is the minimum disk size that will be allocated for the build --
     * the build may run with a larger disk than requested. At present, the maximum disk size
     * is 1000GB; builds that request more than the maximum are rejected with an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#disk_size_gb CloudbuildTrigger#disk_size_gb}
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Option to specify whether or not to apply bash style string operations to the substitutions.
     *
     * NOTE this is always enabled for triggered builds and cannot be overridden in the build configuration file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#dynamic_substitutions CloudbuildTrigger#dynamic_substitutions}
     *
     * @stability stable
     */
    readonly dynamicSubstitutions?: boolean | cdktf.IResolvable;
    /**
     * A list of global environment variable definitions that will exist for all build steps in this build.
     *
     * If a variable is defined in both globally and in a build step,
     * the variable will use the build step value.
     *
     * The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#env CloudbuildTrigger#env}
     *
     * @stability stable
     */
    readonly env?: string[];
    /**
     * Option to define build log streaming behavior to Google Cloud Storage. Possible values: ["STREAM_DEFAULT", "STREAM_ON", "STREAM_OFF"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#log_streaming_option CloudbuildTrigger#log_streaming_option}
     *
     * @stability stable
     */
    readonly logStreamingOption?: string;
    /**
     * Option to specify the logging mode, which determines if and where build logs are stored.
     *
     * Possible values: ["LOGGING_UNSPECIFIED", "LEGACY", "GCS_ONLY", "STACKDRIVER_ONLY", "NONE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#logging CloudbuildTrigger#logging}
     *
     * @stability stable
     */
    readonly logging?: string;
    /**
     * Compute Engine machine type on which to run the build. Possible values: ["UNSPECIFIED", "N1_HIGHCPU_8", "N1_HIGHCPU_32", "E2_HIGHCPU_8", "E2_HIGHCPU_32"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#machine_type CloudbuildTrigger#machine_type}
     *
     * @stability stable
     */
    readonly machineType?: string;
    /**
     * Requested verifiability options. Possible values: ["NOT_VERIFIED", "VERIFIED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#requested_verify_option CloudbuildTrigger#requested_verify_option}
     *
     * @stability stable
     */
    readonly requestedVerifyOption?: string;
    /**
     * A list of global environment variables, which are encrypted using a Cloud Key Management Service crypto key.
     *
     * These values must be specified in the build's Secret. These variables
     * will be available to all build steps in this build.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#secret_env CloudbuildTrigger#secret_env}
     *
     * @stability stable
     */
    readonly secretEnv?: string[];
    /**
     * Requested hash for SourceProvenance. Possible values: ["NONE", "SHA256", "MD5"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#source_provenance_hash CloudbuildTrigger#source_provenance_hash}
     *
     * @stability stable
     */
    readonly sourceProvenanceHash?: string[];
    /**
     * Option to specify behavior when there is an error in the substitution checks.
     *
     * NOTE this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden
     * in the build configuration file. Possible values: ["MUST_MATCH", "ALLOW_LOOSE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#substitution_option CloudbuildTrigger#substitution_option}
     *
     * @stability stable
     */
    readonly substitutionOption?: string;
    /**
     * Option to specify a WorkerPool for the build. Format projects/{project}/workerPools/{workerPool}.
     *
     * This field is experimental.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#worker_pool CloudbuildTrigger#worker_pool}
     *
     * @stability stable
     */
    readonly workerPool?: string;
    /**
     * volumes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#volumes CloudbuildTrigger#volumes}
     *
     * @stability stable
     */
    readonly volumes?: CloudbuildTriggerBuildOptionsVolumes[];
}
/**
 * @stability stable
 */
export declare class CloudbuildTriggerBuildOptionsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _diskSizeGb?;
    /**
     * @stability stable
     */
    get diskSizeGb(): number | undefined;
    /**
     * @stability stable
     */
    set diskSizeGb(value: number | undefined);
    /**
     * @stability stable
     */
    resetDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get diskSizeGbInput(): number | undefined;
    private _dynamicSubstitutions?;
    /**
     * @stability stable
     */
    get dynamicSubstitutions(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set dynamicSubstitutions(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDynamicSubstitutions(): void;
    /**
     * @stability stable
     */
    get dynamicSubstitutionsInput(): boolean | cdktf.IResolvable | undefined;
    private _env?;
    /**
     * @stability stable
     */
    get env(): string[] | undefined;
    /**
     * @stability stable
     */
    set env(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetEnv(): void;
    /**
     * @stability stable
     */
    get envInput(): string[] | undefined;
    private _logStreamingOption?;
    /**
     * @stability stable
     */
    get logStreamingOption(): string | undefined;
    /**
     * @stability stable
     */
    set logStreamingOption(value: string | undefined);
    /**
     * @stability stable
     */
    resetLogStreamingOption(): void;
    /**
     * @stability stable
     */
    get logStreamingOptionInput(): string | undefined;
    private _logging?;
    /**
     * @stability stable
     */
    get logging(): string | undefined;
    /**
     * @stability stable
     */
    set logging(value: string | undefined);
    /**
     * @stability stable
     */
    resetLogging(): void;
    /**
     * @stability stable
     */
    get loggingInput(): string | undefined;
    private _machineType?;
    /**
     * @stability stable
     */
    get machineType(): string | undefined;
    /**
     * @stability stable
     */
    set machineType(value: string | undefined);
    /**
     * @stability stable
     */
    resetMachineType(): void;
    /**
     * @stability stable
     */
    get machineTypeInput(): string | undefined;
    private _requestedVerifyOption?;
    /**
     * @stability stable
     */
    get requestedVerifyOption(): string | undefined;
    /**
     * @stability stable
     */
    set requestedVerifyOption(value: string | undefined);
    /**
     * @stability stable
     */
    resetRequestedVerifyOption(): void;
    /**
     * @stability stable
     */
    get requestedVerifyOptionInput(): string | undefined;
    private _secretEnv?;
    /**
     * @stability stable
     */
    get secretEnv(): string[] | undefined;
    /**
     * @stability stable
     */
    set secretEnv(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSecretEnv(): void;
    /**
     * @stability stable
     */
    get secretEnvInput(): string[] | undefined;
    private _sourceProvenanceHash?;
    /**
     * @stability stable
     */
    get sourceProvenanceHash(): string[] | undefined;
    /**
     * @stability stable
     */
    set sourceProvenanceHash(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSourceProvenanceHash(): void;
    /**
     * @stability stable
     */
    get sourceProvenanceHashInput(): string[] | undefined;
    private _substitutionOption?;
    /**
     * @stability stable
     */
    get substitutionOption(): string | undefined;
    /**
     * @stability stable
     */
    set substitutionOption(value: string | undefined);
    /**
     * @stability stable
     */
    resetSubstitutionOption(): void;
    /**
     * @stability stable
     */
    get substitutionOptionInput(): string | undefined;
    private _workerPool?;
    /**
     * @stability stable
     */
    get workerPool(): string | undefined;
    /**
     * @stability stable
     */
    set workerPool(value: string | undefined);
    /**
     * @stability stable
     */
    resetWorkerPool(): void;
    /**
     * @stability stable
     */
    get workerPoolInput(): string | undefined;
    private _volumes?;
    /**
     * @stability stable
     */
    get volumes(): CloudbuildTriggerBuildOptionsVolumes[] | undefined;
    /**
     * @stability stable
     */
    set volumes(value: CloudbuildTriggerBuildOptionsVolumes[] | undefined);
    /**
     * @stability stable
     */
    resetVolumes(): void;
    /**
     * @stability stable
     */
    get volumesInput(): CloudbuildTriggerBuildOptionsVolumes[] | undefined;
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerBuildSecret {
    /**
     * Cloud KMS key name to use to decrypt these envs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#kms_key_name CloudbuildTrigger#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName: string;
    /**
     * Map of environment variable name to its encrypted value.
     *
     * Secret environment variables must be unique across all of a build's secrets,
     * and must be used by at least one build step. Values can be at most 64 KB in size.
     * There can be at most 100 secret values across all of a build's secrets.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#secret_env CloudbuildTrigger#secret_env}
     *
     * @stability stable
     */
    readonly secretEnv?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerBuildSourceRepoSource {
    /**
     * Regex matching branches to build.
     *
     * Exactly one a of branch name, tag, or commit SHA must be provided.
     * The syntax of the regular expressions accepted is the syntax accepted by RE2 and
     * described at https://github.com/google/re2/wiki/Syntax
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#branch_name CloudbuildTrigger#branch_name}
     *
     * @stability stable
     */
    readonly branchName?: string;
    /**
     * Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#commit_sha CloudbuildTrigger#commit_sha}
     *
     * @stability stable
     */
    readonly commitSha?: string;
    /**
     * Directory, relative to the source root, in which to run the build.
     *
     * This must be a relative path. If a step's dir is specified and is an absolute path,
     * this value is ignored for that step's execution.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#dir CloudbuildTrigger#dir}
     *
     * @stability stable
     */
    readonly dir?: string;
    /**
     * Only trigger a build if the revision regex does NOT match the revision regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#invert_regex CloudbuildTrigger#invert_regex}
     *
     * @stability stable
     */
    readonly invertRegex?: boolean | cdktf.IResolvable;
    /**
     * ID of the project that owns the Cloud Source Repository.
     *
     * If omitted, the project ID requesting the build is assumed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#project_id CloudbuildTrigger#project_id}
     *
     * @stability stable
     */
    readonly projectId?: string;
    /**
     * Name of the Cloud Source Repository.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#repo_name CloudbuildTrigger#repo_name}
     *
     * @stability stable
     */
    readonly repoName: string;
    /**
     * Substitutions to use in a triggered build. Should only be used with triggers.run.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#substitutions CloudbuildTrigger#substitutions}
     *
     * @stability stable
     */
    readonly substitutions?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Regex matching tags to build.
     *
     * Exactly one a of branch name, tag, or commit SHA must be provided.
     * The syntax of the regular expressions accepted is the syntax accepted by RE2 and
     * described at https://github.com/google/re2/wiki/Syntax
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#tag_name CloudbuildTrigger#tag_name}
     *
     * @stability stable
     */
    readonly tagName?: string;
}
/**
 * @stability stable
 */
export declare class CloudbuildTriggerBuildSourceRepoSourceOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _branchName?;
    /**
     * @stability stable
     */
    get branchName(): string | undefined;
    /**
     * @stability stable
     */
    set branchName(value: string | undefined);
    /**
     * @stability stable
     */
    resetBranchName(): void;
    /**
     * @stability stable
     */
    get branchNameInput(): string | undefined;
    private _commitSha?;
    /**
     * @stability stable
     */
    get commitSha(): string | undefined;
    /**
     * @stability stable
     */
    set commitSha(value: string | undefined);
    /**
     * @stability stable
     */
    resetCommitSha(): void;
    /**
     * @stability stable
     */
    get commitShaInput(): string | undefined;
    private _dir?;
    /**
     * @stability stable
     */
    get dir(): string | undefined;
    /**
     * @stability stable
     */
    set dir(value: string | undefined);
    /**
     * @stability stable
     */
    resetDir(): void;
    /**
     * @stability stable
     */
    get dirInput(): string | undefined;
    private _invertRegex?;
    /**
     * @stability stable
     */
    get invertRegex(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set invertRegex(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetInvertRegex(): void;
    /**
     * @stability stable
     */
    get invertRegexInput(): boolean | cdktf.IResolvable | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string | undefined;
    /**
     * @stability stable
     */
    set projectId(value: string | undefined);
    /**
     * @stability stable
     */
    resetProjectId(): void;
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _repoName?;
    /**
     * @stability stable
     */
    get repoName(): string;
    /**
     * @stability stable
     */
    set repoName(value: string);
    /**
     * @stability stable
     */
    get repoNameInput(): string | undefined;
    private _substitutions?;
    /**
     * @stability stable
     */
    get substitutions(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set substitutions(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetSubstitutions(): void;
    /**
     * @stability stable
     */
    get substitutionsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _tagName?;
    /**
     * @stability stable
     */
    get tagName(): string | undefined;
    /**
     * @stability stable
     */
    set tagName(value: string | undefined);
    /**
     * @stability stable
     */
    resetTagName(): void;
    /**
     * @stability stable
     */
    get tagNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerBuildSourceStorageSource {
    /**
     * Google Cloud Storage bucket containing the source.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#bucket CloudbuildTrigger#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Google Cloud Storage generation for the object.  If the generation is omitted, the latest generation will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#generation CloudbuildTrigger#generation}
     *
     * @stability stable
     */
    readonly generation?: string;
    /**
     * Google Cloud Storage object containing the source. This object must be a gzipped archive file (.tar.gz) containing source to build.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#object CloudbuildTrigger#object}
     *
     * @stability stable
     */
    readonly object: string;
}
/**
 * @stability stable
 */
export declare class CloudbuildTriggerBuildSourceStorageSourceOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    private _generation?;
    /**
     * @stability stable
     */
    get generation(): string | undefined;
    /**
     * @stability stable
     */
    set generation(value: string | undefined);
    /**
     * @stability stable
     */
    resetGeneration(): void;
    /**
     * @stability stable
     */
    get generationInput(): string | undefined;
    private _object?;
    /**
     * @stability stable
     */
    get object(): string;
    /**
     * @stability stable
     */
    set object(value: string);
    /**
     * @stability stable
     */
    get objectInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerBuildSource {
    /**
     * repo_source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#repo_source CloudbuildTrigger#repo_source}
     *
     * @stability stable
     */
    readonly repoSource?: CloudbuildTriggerBuildSourceRepoSource;
    /**
     * storage_source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#storage_source CloudbuildTrigger#storage_source}
     *
     * @stability stable
     */
    readonly storageSource?: CloudbuildTriggerBuildSourceStorageSource;
}
/**
 * @stability stable
 */
export declare class CloudbuildTriggerBuildSourceOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _repoSource?;
    private __repoSourceOutput;
    /**
     * @stability stable
     */
    get repoSource(): CloudbuildTriggerBuildSourceRepoSourceOutputReference;
    /**
     * @stability stable
     */
    putRepoSource(value: CloudbuildTriggerBuildSourceRepoSource | undefined): void;
    /**
     * @stability stable
     */
    resetRepoSource(): void;
    /**
     * @stability stable
     */
    get repoSourceInput(): CloudbuildTriggerBuildSourceRepoSource | undefined;
    private _storageSource?;
    private __storageSourceOutput;
    /**
     * @stability stable
     */
    get storageSource(): CloudbuildTriggerBuildSourceStorageSourceOutputReference;
    /**
     * @stability stable
     */
    putStorageSource(value: CloudbuildTriggerBuildSourceStorageSource | undefined): void;
    /**
     * @stability stable
     */
    resetStorageSource(): void;
    /**
     * @stability stable
     */
    get storageSourceInput(): CloudbuildTriggerBuildSourceStorageSource | undefined;
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerBuildStepVolumes {
    /**
     * Name of the volume to mount.
     *
     * Volume names must be unique per build step and must be valid names for
     * Docker volumes. Each named volume must be used by at least two build steps.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#name CloudbuildTrigger#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Path at which to mount the volume.
     *
     * Paths must be absolute and cannot conflict with other volume paths on
     * the same build step or with certain reserved volume paths.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#path CloudbuildTrigger#path}
     *
     * @stability stable
     */
    readonly path: string;
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerBuildStep {
    /**
     * A list of arguments that will be presented to the step when it is started.
     *
     * If the image used to run the step's container has an entrypoint, the args
     * are used as arguments to that entrypoint. If the image does not define an
     * entrypoint, the first element in args is used as the entrypoint, and the
     * remainder will be used as arguments.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#args CloudbuildTrigger#args}
     *
     * @stability stable
     */
    readonly args?: string[];
    /**
     * Working directory to use when running this step's container.
     *
     * If this value is a relative path, it is relative to the build's working
     * directory. If this value is absolute, it may be outside the build's working
     * directory, in which case the contents of the path may not be persisted
     * across build step executions, unless a 'volume' for that path is specified.
     *
     * If the build specifies a 'RepoSource' with 'dir' and a step with a
     * 'dir',
     * which specifies an absolute path, the 'RepoSource' 'dir' is ignored
     * for the step's execution.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#dir CloudbuildTrigger#dir}
     *
     * @stability stable
     */
    readonly dir?: string;
    /**
     * Entrypoint to be used instead of the build step image's default entrypoint. If unset, the image's default entrypoint is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#entrypoint CloudbuildTrigger#entrypoint}
     *
     * @stability stable
     */
    readonly entrypoint?: string;
    /**
     * A list of environment variable definitions to be used when running a step.
     *
     * The elements are of the form "KEY=VALUE" for the environment variable
     * "KEY" being given the value "VALUE".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#env CloudbuildTrigger#env}
     *
     * @stability stable
     */
    readonly env?: string[];
    /**
     * Unique identifier for this build step, used in 'wait_for' to reference this build step as a dependency.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#id CloudbuildTrigger#id}
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * The name of the container image that will run this particular build step.
     *
     * If the image is available in the host's Docker daemon's cache, it will be
     * run directly. If not, the host will attempt to pull the image first, using
     * the builder service account's credentials if necessary.
     *
     * The Docker daemon's cache will already have the latest versions of all of
     * the officially supported build steps (see https://github.com/GoogleCloudPlatform/cloud-builders
     * for images and examples).
     * The Docker daemon will also have cached many of the layers for some popular
     * images, like "ubuntu", "debian", but they will be refreshed at the time
     * you attempt to use them.
     *
     * If you built an image in a previous build step, it will be stored in the
     * host's Docker daemon's cache and is available to use as the name for a
     * later build step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#name CloudbuildTrigger#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * A list of environment variables which are encrypted using a Cloud Key Management Service crypto key.
     *
     * These values must be specified in
     * the build's 'Secret'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#secret_env CloudbuildTrigger#secret_env}
     *
     * @stability stable
     */
    readonly secretEnv?: string[];
    /**
     * Time limit for executing this build step.
     *
     * If not defined,
     * the step has no
     * time limit and will be allowed to continue to run until either it
     * completes or the build itself times out.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#timeout CloudbuildTrigger#timeout}
     *
     * @stability stable
     */
    readonly timeout?: string;
    /**
     * Output only. Stores timing information for executing this build step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#timing CloudbuildTrigger#timing}
     *
     * @stability stable
     */
    readonly timing?: string;
    /**
     * The ID(s) of the step(s) that this build step depends on.
     *
     * This build step will not start until all the build steps in 'wait_for'
     * have completed successfully. If 'wait_for' is empty, this build step
     * will start when all previous build steps in the 'Build.Steps' list
     * have completed successfully.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#wait_for CloudbuildTrigger#wait_for}
     *
     * @stability stable
     */
    readonly waitFor?: string[];
    /**
     * volumes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#volumes CloudbuildTrigger#volumes}
     *
     * @stability stable
     */
    readonly volumes?: CloudbuildTriggerBuildStepVolumes[];
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerBuild {
    /**
     * A list of images to be pushed upon the successful completion of all build steps.
     *
     * The images are pushed using the builder service account's credentials.
     * The digests of the pushed images will be stored in the Build resource's results field.
     * If any of the images fail to be pushed, the build status is marked FAILURE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#images CloudbuildTrigger#images}
     *
     * @stability stable
     */
    readonly images?: string[];
    /**
     * Google Cloud Storage bucket where logs should be written.  Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#logs_bucket CloudbuildTrigger#logs_bucket}
     *
     * @stability stable
     */
    readonly logsBucket?: string;
    /**
     * TTL in queue for this build.
     *
     * If provided and the build is enqueued longer than this value,
     * the build will expire and the build status will be EXPIRED.
     * The TTL starts ticking from createTime.
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#queue_ttl CloudbuildTrigger#queue_ttl}
     *
     * @stability stable
     */
    readonly queueTtl?: string;
    /**
     * Substitutions data for Build resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#substitutions CloudbuildTrigger#substitutions}
     *
     * @stability stable
     */
    readonly substitutions?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Tags for annotation of a Build. These are not docker tags.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#tags CloudbuildTrigger#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * Amount of time that this build should be allowed to run, to second granularity.
     *
     * If this amount of time elapses, work on the build will cease and the build status will be TIMEOUT.
     * This timeout must be equal to or greater than the sum of the timeouts for build steps within the build.
     * The expected format is the number of seconds followed by s.
     * Default time is ten minutes (600s).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#timeout CloudbuildTrigger#timeout}
     *
     * @stability stable
     */
    readonly timeout?: string;
    /**
     * artifacts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#artifacts CloudbuildTrigger#artifacts}
     *
     * @stability stable
     */
    readonly artifacts?: CloudbuildTriggerBuildArtifacts;
    /**
     * options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#options CloudbuildTrigger#options}
     *
     * @stability stable
     */
    readonly options?: CloudbuildTriggerBuildOptions;
    /**
     * secret block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#secret CloudbuildTrigger#secret}
     *
     * @stability stable
     */
    readonly secret?: CloudbuildTriggerBuildSecret[];
    /**
     * source block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#source CloudbuildTrigger#source}
     *
     * @stability stable
     */
    readonly source?: CloudbuildTriggerBuildSource;
    /**
     * step block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#step CloudbuildTrigger#step}
     *
     * @stability stable
     */
    readonly step: CloudbuildTriggerBuildStep[];
}
/**
 * @stability stable
 */
export declare class CloudbuildTriggerBuildOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _images?;
    /**
     * @stability stable
     */
    get images(): string[] | undefined;
    /**
     * @stability stable
     */
    set images(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetImages(): void;
    /**
     * @stability stable
     */
    get imagesInput(): string[] | undefined;
    private _logsBucket?;
    /**
     * @stability stable
     */
    get logsBucket(): string | undefined;
    /**
     * @stability stable
     */
    set logsBucket(value: string | undefined);
    /**
     * @stability stable
     */
    resetLogsBucket(): void;
    /**
     * @stability stable
     */
    get logsBucketInput(): string | undefined;
    private _queueTtl?;
    /**
     * @stability stable
     */
    get queueTtl(): string | undefined;
    /**
     * @stability stable
     */
    set queueTtl(value: string | undefined);
    /**
     * @stability stable
     */
    resetQueueTtl(): void;
    /**
     * @stability stable
     */
    get queueTtlInput(): string | undefined;
    private _substitutions?;
    /**
     * @stability stable
     */
    get substitutions(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set substitutions(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetSubstitutions(): void;
    /**
     * @stability stable
     */
    get substitutionsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[] | undefined;
    /**
     * @stability stable
     */
    set tags(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _timeout?;
    /**
     * @stability stable
     */
    get timeout(): string | undefined;
    /**
     * @stability stable
     */
    set timeout(value: string | undefined);
    /**
     * @stability stable
     */
    resetTimeout(): void;
    /**
     * @stability stable
     */
    get timeoutInput(): string | undefined;
    private _artifacts?;
    private __artifactsOutput;
    /**
     * @stability stable
     */
    get artifacts(): CloudbuildTriggerBuildArtifactsOutputReference;
    /**
     * @stability stable
     */
    putArtifacts(value: CloudbuildTriggerBuildArtifacts | undefined): void;
    /**
     * @stability stable
     */
    resetArtifacts(): void;
    /**
     * @stability stable
     */
    get artifactsInput(): CloudbuildTriggerBuildArtifacts | undefined;
    private _options?;
    private __optionsOutput;
    /**
     * @stability stable
     */
    get options(): CloudbuildTriggerBuildOptionsOutputReference;
    /**
     * @stability stable
     */
    putOptions(value: CloudbuildTriggerBuildOptions | undefined): void;
    /**
     * @stability stable
     */
    resetOptions(): void;
    /**
     * @stability stable
     */
    get optionsInput(): CloudbuildTriggerBuildOptions | undefined;
    private _secret?;
    /**
     * @stability stable
     */
    get secret(): CloudbuildTriggerBuildSecret[] | undefined;
    /**
     * @stability stable
     */
    set secret(value: CloudbuildTriggerBuildSecret[] | undefined);
    /**
     * @stability stable
     */
    resetSecret(): void;
    /**
     * @stability stable
     */
    get secretInput(): CloudbuildTriggerBuildSecret[] | undefined;
    private _source?;
    private __sourceOutput;
    /**
     * @stability stable
     */
    get source(): CloudbuildTriggerBuildSourceOutputReference;
    /**
     * @stability stable
     */
    putSource(value: CloudbuildTriggerBuildSource | undefined): void;
    /**
     * @stability stable
     */
    resetSource(): void;
    /**
     * @stability stable
     */
    get sourceInput(): CloudbuildTriggerBuildSource | undefined;
    private _step?;
    /**
     * @stability stable
     */
    get step(): CloudbuildTriggerBuildStep[];
    /**
     * @stability stable
     */
    set step(value: CloudbuildTriggerBuildStep[]);
    /**
     * @stability stable
     */
    get stepInput(): CloudbuildTriggerBuildStep[] | undefined;
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerGithubPullRequest {
    /**
     * Regex of branches to match.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#branch CloudbuildTrigger#branch}
     *
     * @stability stable
     */
    readonly branch: string;
    /**
     * Whether to block builds on a "/gcbrun" comment from a repository owner or collaborator. Possible values: ["COMMENTS_DISABLED", "COMMENTS_ENABLED", "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#comment_control CloudbuildTrigger#comment_control}
     *
     * @stability stable
     */
    readonly commentControl?: string;
    /**
     * If true, branches that do NOT match the git_ref will trigger a build.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#invert_regex CloudbuildTrigger#invert_regex}
     *
     * @stability stable
     */
    readonly invertRegex?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class CloudbuildTriggerGithubPullRequestOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _branch?;
    /**
     * @stability stable
     */
    get branch(): string;
    /**
     * @stability stable
     */
    set branch(value: string);
    /**
     * @stability stable
     */
    get branchInput(): string | undefined;
    private _commentControl?;
    /**
     * @stability stable
     */
    get commentControl(): string | undefined;
    /**
     * @stability stable
     */
    set commentControl(value: string | undefined);
    /**
     * @stability stable
     */
    resetCommentControl(): void;
    /**
     * @stability stable
     */
    get commentControlInput(): string | undefined;
    private _invertRegex?;
    /**
     * @stability stable
     */
    get invertRegex(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set invertRegex(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetInvertRegex(): void;
    /**
     * @stability stable
     */
    get invertRegexInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerGithubPush {
    /**
     * Regex of branches to match.  Specify only one of branch or tag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#branch CloudbuildTrigger#branch}
     *
     * @stability stable
     */
    readonly branch?: string;
    /**
     * When true, only trigger a build if the revision regex does NOT match the git_ref regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#invert_regex CloudbuildTrigger#invert_regex}
     *
     * @stability stable
     */
    readonly invertRegex?: boolean | cdktf.IResolvable;
    /**
     * Regex of tags to match.  Specify only one of branch or tag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#tag CloudbuildTrigger#tag}
     *
     * @stability stable
     */
    readonly tag?: string;
}
/**
 * @stability stable
 */
export declare class CloudbuildTriggerGithubPushOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _branch?;
    /**
     * @stability stable
     */
    get branch(): string | undefined;
    /**
     * @stability stable
     */
    set branch(value: string | undefined);
    /**
     * @stability stable
     */
    resetBranch(): void;
    /**
     * @stability stable
     */
    get branchInput(): string | undefined;
    private _invertRegex?;
    /**
     * @stability stable
     */
    get invertRegex(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set invertRegex(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetInvertRegex(): void;
    /**
     * @stability stable
     */
    get invertRegexInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): string | undefined;
    /**
     * @stability stable
     */
    set tag(value: string | undefined);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerGithub {
    /**
     * Name of the repository. For example: The name for https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#name CloudbuildTrigger#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Owner of the repository. For example: The owner for https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#owner CloudbuildTrigger#owner}
     *
     * @stability stable
     */
    readonly owner?: string;
    /**
     * pull_request block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#pull_request CloudbuildTrigger#pull_request}
     *
     * @stability stable
     */
    readonly pullRequest?: CloudbuildTriggerGithubPullRequest;
    /**
     * push block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#push CloudbuildTrigger#push}
     *
     * @stability stable
     */
    readonly push?: CloudbuildTriggerGithubPush;
}
/**
 * @stability stable
 */
export declare class CloudbuildTriggerGithubOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _owner?;
    /**
     * @stability stable
     */
    get owner(): string | undefined;
    /**
     * @stability stable
     */
    set owner(value: string | undefined);
    /**
     * @stability stable
     */
    resetOwner(): void;
    /**
     * @stability stable
     */
    get ownerInput(): string | undefined;
    private _pullRequest?;
    private __pullRequestOutput;
    /**
     * @stability stable
     */
    get pullRequest(): CloudbuildTriggerGithubPullRequestOutputReference;
    /**
     * @stability stable
     */
    putPullRequest(value: CloudbuildTriggerGithubPullRequest | undefined): void;
    /**
     * @stability stable
     */
    resetPullRequest(): void;
    /**
     * @stability stable
     */
    get pullRequestInput(): CloudbuildTriggerGithubPullRequest | undefined;
    private _push?;
    private __pushOutput;
    /**
     * @stability stable
     */
    get push(): CloudbuildTriggerGithubPushOutputReference;
    /**
     * @stability stable
     */
    putPush(value: CloudbuildTriggerGithubPush | undefined): void;
    /**
     * @stability stable
     */
    resetPush(): void;
    /**
     * @stability stable
     */
    get pushInput(): CloudbuildTriggerGithubPush | undefined;
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerPubsubConfig {
    /**
     * Service account that will make the push request.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#service_account_email CloudbuildTrigger#service_account_email}
     *
     * @stability stable
     */
    readonly serviceAccountEmail?: string;
    /**
     * The name of the topic from which this subscription is receiving messages.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#topic CloudbuildTrigger#topic}
     *
     * @stability stable
     */
    readonly topic: string;
}
/**
 * @stability stable
 */
export declare class CloudbuildTriggerPubsubConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _serviceAccountEmail?;
    /**
     * @stability stable
     */
    get serviceAccountEmail(): string | undefined;
    /**
     * @stability stable
     */
    set serviceAccountEmail(value: string | undefined);
    /**
     * @stability stable
     */
    resetServiceAccountEmail(): void;
    /**
     * @stability stable
     */
    get serviceAccountEmailInput(): string | undefined;
    private _topic?;
    /**
     * @stability stable
     */
    get topic(): string;
    /**
     * @stability stable
     */
    set topic(value: string);
    /**
     * @stability stable
     */
    get topicInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#create CloudbuildTrigger#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#delete CloudbuildTrigger#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#update CloudbuildTrigger#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class CloudbuildTriggerTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerTriggerTemplate {
    /**
     * Name of the branch to build.
     *
     * Exactly one a of branch name, tag, or commit SHA must be provided.
     * This field is a regular expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#branch_name CloudbuildTrigger#branch_name}
     *
     * @stability stable
     */
    readonly branchName?: string;
    /**
     * Explicit commit SHA to build. Exactly one of a branch name, tag, or commit SHA must be provided.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#commit_sha CloudbuildTrigger#commit_sha}
     *
     * @stability stable
     */
    readonly commitSha?: string;
    /**
     * Directory, relative to the source root, in which to run the build.
     *
     * This must be a relative path. If a step's dir is specified and
     * is an absolute path, this value is ignored for that step's
     * execution.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#dir CloudbuildTrigger#dir}
     *
     * @stability stable
     */
    readonly dir?: string;
    /**
     * Only trigger a build if the revision regex does NOT match the revision regex.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#invert_regex CloudbuildTrigger#invert_regex}
     *
     * @stability stable
     */
    readonly invertRegex?: boolean | cdktf.IResolvable;
    /**
     * ID of the project that owns the Cloud Source Repository. If omitted, the project ID requesting the build is assumed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#project_id CloudbuildTrigger#project_id}
     *
     * @stability stable
     */
    readonly projectId?: string;
    /**
     * Name of the Cloud Source Repository. If omitted, the name "default" is assumed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#repo_name CloudbuildTrigger#repo_name}
     *
     * @stability stable
     */
    readonly repoName?: string;
    /**
     * Name of the tag to build.
     *
     * Exactly one of a branch name, tag, or commit SHA must be provided.
     * This field is a regular expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#tag_name CloudbuildTrigger#tag_name}
     *
     * @stability stable
     */
    readonly tagName?: string;
}
/**
 * @stability stable
 */
export declare class CloudbuildTriggerTriggerTemplateOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _branchName?;
    /**
     * @stability stable
     */
    get branchName(): string | undefined;
    /**
     * @stability stable
     */
    set branchName(value: string | undefined);
    /**
     * @stability stable
     */
    resetBranchName(): void;
    /**
     * @stability stable
     */
    get branchNameInput(): string | undefined;
    private _commitSha?;
    /**
     * @stability stable
     */
    get commitSha(): string | undefined;
    /**
     * @stability stable
     */
    set commitSha(value: string | undefined);
    /**
     * @stability stable
     */
    resetCommitSha(): void;
    /**
     * @stability stable
     */
    get commitShaInput(): string | undefined;
    private _dir?;
    /**
     * @stability stable
     */
    get dir(): string | undefined;
    /**
     * @stability stable
     */
    set dir(value: string | undefined);
    /**
     * @stability stable
     */
    resetDir(): void;
    /**
     * @stability stable
     */
    get dirInput(): string | undefined;
    private _invertRegex?;
    /**
     * @stability stable
     */
    get invertRegex(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set invertRegex(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetInvertRegex(): void;
    /**
     * @stability stable
     */
    get invertRegexInput(): boolean | cdktf.IResolvable | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string | undefined;
    /**
     * @stability stable
     */
    set projectId(value: string | undefined);
    /**
     * @stability stable
     */
    resetProjectId(): void;
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _repoName?;
    /**
     * @stability stable
     */
    get repoName(): string | undefined;
    /**
     * @stability stable
     */
    set repoName(value: string | undefined);
    /**
     * @stability stable
     */
    resetRepoName(): void;
    /**
     * @stability stable
     */
    get repoNameInput(): string | undefined;
    private _tagName?;
    /**
     * @stability stable
     */
    get tagName(): string | undefined;
    /**
     * @stability stable
     */
    set tagName(value: string | undefined);
    /**
     * @stability stable
     */
    resetTagName(): void;
    /**
     * @stability stable
     */
    get tagNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface CloudbuildTriggerWebhookConfig {
    /**
     * Resource name for the secret required as a URL parameter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html#secret CloudbuildTrigger#secret}
     *
     * @stability stable
     */
    readonly secret: string;
}
/**
 * @stability stable
 */
export declare class CloudbuildTriggerWebhookConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _secret?;
    /**
     * @stability stable
     */
    get secret(): string;
    /**
     * @stability stable
     */
    set secret(value: string);
    /**
     * @stability stable
     */
    get secretInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html google_cloudbuild_trigger}.
 *
 * @stability stable
 */
export declare class CloudbuildTrigger extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_trigger.html google_cloudbuild_trigger} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: CloudbuildTriggerConfig);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _disabled?;
    /**
     * @stability stable
     */
    get disabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set disabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDisabled(): void;
    /**
     * @stability stable
     */
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string | undefined;
    /**
     * @stability stable
     */
    set filename(value: string | undefined);
    /**
     * @stability stable
     */
    resetFilename(): void;
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ignoredFiles?;
    /**
     * @stability stable
     */
    get ignoredFiles(): string[] | undefined;
    /**
     * @stability stable
     */
    set ignoredFiles(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetIgnoredFiles(): void;
    /**
     * @stability stable
     */
    get ignoredFilesInput(): string[] | undefined;
    private _includedFiles?;
    /**
     * @stability stable
     */
    get includedFiles(): string[] | undefined;
    /**
     * @stability stable
     */
    set includedFiles(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetIncludedFiles(): void;
    /**
     * @stability stable
     */
    get includedFilesInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _serviceAccount?;
    /**
     * @stability stable
     */
    get serviceAccount(): string | undefined;
    /**
     * @stability stable
     */
    set serviceAccount(value: string | undefined);
    /**
     * @stability stable
     */
    resetServiceAccount(): void;
    /**
     * @stability stable
     */
    get serviceAccountInput(): string | undefined;
    private _substitutions?;
    /**
     * @stability stable
     */
    get substitutions(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set substitutions(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetSubstitutions(): void;
    /**
     * @stability stable
     */
    get substitutionsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[] | undefined;
    /**
     * @stability stable
     */
    set tags(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get triggerId(): string;
    private _build?;
    private __buildOutput;
    /**
     * @stability stable
     */
    get buildAttribute(): CloudbuildTriggerBuildOutputReference;
    /**
     * @stability stable
     */
    putBuildAttribute(value: CloudbuildTriggerBuild | undefined): void;
    /**
     * @stability stable
     */
    resetBuildAttribute(): void;
    /**
     * @stability stable
     */
    get buildAttributeInput(): CloudbuildTriggerBuild | undefined;
    private _github?;
    private __githubOutput;
    /**
     * @stability stable
     */
    get github(): CloudbuildTriggerGithubOutputReference;
    /**
     * @stability stable
     */
    putGithub(value: CloudbuildTriggerGithub | undefined): void;
    /**
     * @stability stable
     */
    resetGithub(): void;
    /**
     * @stability stable
     */
    get githubInput(): CloudbuildTriggerGithub | undefined;
    private _pubsubConfig?;
    private __pubsubConfigOutput;
    /**
     * @stability stable
     */
    get pubsubConfig(): CloudbuildTriggerPubsubConfigOutputReference;
    /**
     * @stability stable
     */
    putPubsubConfig(value: CloudbuildTriggerPubsubConfig | undefined): void;
    /**
     * @stability stable
     */
    resetPubsubConfig(): void;
    /**
     * @stability stable
     */
    get pubsubConfigInput(): CloudbuildTriggerPubsubConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): CloudbuildTriggerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CloudbuildTriggerTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CloudbuildTriggerTimeouts | undefined;
    private _triggerTemplate?;
    private __triggerTemplateOutput;
    /**
     * @stability stable
     */
    get triggerTemplate(): CloudbuildTriggerTriggerTemplateOutputReference;
    /**
     * @stability stable
     */
    putTriggerTemplate(value: CloudbuildTriggerTriggerTemplate | undefined): void;
    /**
     * @stability stable
     */
    resetTriggerTemplate(): void;
    /**
     * @stability stable
     */
    get triggerTemplateInput(): CloudbuildTriggerTriggerTemplate | undefined;
    private _webhookConfig?;
    private __webhookConfigOutput;
    /**
     * @stability stable
     */
    get webhookConfig(): CloudbuildTriggerWebhookConfigOutputReference;
    /**
     * @stability stable
     */
    putWebhookConfig(value: CloudbuildTriggerWebhookConfig | undefined): void;
    /**
     * @stability stable
     */
    resetWebhookConfig(): void;
    /**
     * @stability stable
     */
    get webhookConfigInput(): CloudbuildTriggerWebhookConfig | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
