import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleKmsSecretConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_secret.html#additional_authenticated_data DataGoogleKmsSecret#additional_authenticated_data}.
     *
     * @stability stable
     */
    readonly additionalAuthenticatedData?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_secret.html#ciphertext DataGoogleKmsSecret#ciphertext}.
     *
     * @stability stable
     */
    readonly ciphertext: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_secret.html#crypto_key DataGoogleKmsSecret#crypto_key}.
     *
     * @stability stable
     */
    readonly cryptoKey: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/kms_secret.html google_kms_secret}.
 *
 * @stability stable
 */
export declare class DataGoogleKmsSecret extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/kms_secret.html google_kms_secret} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleKmsSecretConfig);
    private _additionalAuthenticatedData?;
    /**
     * @stability stable
     */
    get additionalAuthenticatedData(): string | undefined;
    /**
     * @stability stable
     */
    set additionalAuthenticatedData(value: string | undefined);
    /**
     * @stability stable
     */
    resetAdditionalAuthenticatedData(): void;
    /**
     * @stability stable
     */
    get additionalAuthenticatedDataInput(): string | undefined;
    private _ciphertext?;
    /**
     * @stability stable
     */
    get ciphertext(): string;
    /**
     * @stability stable
     */
    set ciphertext(value: string);
    /**
     * @stability stable
     */
    get ciphertextInput(): string | undefined;
    private _cryptoKey?;
    /**
     * @stability stable
     */
    get cryptoKey(): string;
    /**
     * @stability stable
     */
    set cryptoKey(value: string);
    /**
     * @stability stable
     */
    get cryptoKeyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get plaintext(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
