from nautobot.core.apps import NavMenuAddButton, NavMenuGroup, NavMenuItem, NavMenuImportButton, NavMenuTab


menu_items = (
    NavMenuTab(
        name="Virtualization",
        weight=400,
        groups=(
            NavMenuGroup(
                name="Virtual Machines",
                weight=100,
                items=(
                    NavMenuItem(
                        link="virtualization:virtualmachine_list",
                        name="Virtual Machines",
                        weight=100,
                        permissions=[
                            "virtualization.view_virtualmachine",
                        ],
                        buttons=(
                            NavMenuAddButton(
                                link="virtualization:virtualmachine_add",
                                permissions=[
                                    "virtualization.add_virtualmachine",
                                ],
                            ),
                            NavMenuImportButton(
                                link="virtualization:virtualmachine_import",
                                permissions=[
                                    "virtualization.add_virtualmachine",
                                ],
                            ),
                        ),
                    ),
                    NavMenuItem(
                        link="virtualization:vminterface_list",
                        name="Interfaces",
                        weight=200,
                        permissions=[
                            "virtualization.view_vminterface",
                        ],
                        buttons=(
                            NavMenuImportButton(
                                link="virtualization:vminterface_import",
                                permissions=[
                                    "virtualization.add_vminterface",
                                ],
                            ),
                        ),
                    ),
                ),
            ),
            NavMenuGroup(
                name="Clusters",
                weight=200,
                items=(
                    NavMenuItem(
                        link="virtualization:cluster_list",
                        name="Clusters",
                        weight=100,
                        permissions=[
                            "virtualization.view_cluster",
                        ],
                        buttons=(
                            NavMenuAddButton(
                                link="virtualization:cluster_add",
                                permissions=[
                                    "virtualization.add_cluster",
                                ],
                            ),
                            NavMenuImportButton(
                                link="virtualization:cluster_import",
                                permissions=[
                                    "virtualization.add_cluster",
                                ],
                            ),
                        ),
                    ),
                    NavMenuItem(
                        link="virtualization:clustertype_list",
                        name="Cluster Types",
                        weight=200,
                        permissions=[
                            "virtualization.view_clustertype",
                        ],
                        buttons=(
                            NavMenuAddButton(
                                link="virtualization:clustertype_add",
                                permissions=[
                                    "virtualization.add_clustertype",
                                ],
                            ),
                            NavMenuImportButton(
                                link="virtualization:clustertype_import",
                                permissions=[
                                    "virtualization.add_clustertype",
                                ],
                            ),
                        ),
                    ),
                    NavMenuItem(
                        link="virtualization:clustergroup_list",
                        name="Cluster Groups",
                        weight=300,
                        permissions=[
                            "virtualization.view_clustergroup",
                        ],
                        buttons=(
                            NavMenuAddButton(
                                link="virtualization:clustergroup_add",
                                permissions=[
                                    "virtualization.add_clustergroup",
                                ],
                            ),
                            NavMenuImportButton(
                                link="virtualization:clustergroup_import",
                                permissions=[
                                    "virtualization.add_clustergroup",
                                ],
                            ),
                        ),
                    ),
                ),
            ),
        ),
    ),
)
