import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppEngineApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
     * The domain to authenticate users with when using App Engine's User API.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#auth_domain AppEngineApplication#auth_domain}
     *
     * @stability stable
     */
    readonly authDomain?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#database_type AppEngineApplication#database_type}.
     *
     * @stability stable
     */
    readonly databaseType?: string;
    /**
     * The location to serve the app from.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#location_id AppEngineApplication#location_id}
     *
     * @stability stable
     */
    readonly locationId: string;
    /**
     * The project ID to create the application under.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#project AppEngineApplication#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The serving status of the app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#serving_status AppEngineApplication#serving_status}
     *
     * @stability stable
     */
    readonly servingStatus?: string;
    /**
     * feature_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#feature_settings AppEngineApplication#feature_settings}
     *
     * @stability stable
     */
    readonly featureSettings?: AppEngineApplicationFeatureSettings;
    /**
     * iap block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#iap AppEngineApplication#iap}
     *
     * @stability stable
     */
    readonly iap?: AppEngineApplicationIap;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#timeouts AppEngineApplication#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppEngineApplicationTimeouts;
}
/**
 * @stability stable
 */
export declare class AppEngineApplicationUrlDispatchRule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get domain(): string;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    get service(): string;
}
/**
 * @stability stable
 */
export interface AppEngineApplicationFeatureSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#split_health_checks AppEngineApplication#split_health_checks}.
     *
     * @stability stable
     */
    readonly splitHealthChecks: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class AppEngineApplicationFeatureSettingsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _splitHealthChecks?;
    /**
     * @stability stable
     */
    get splitHealthChecks(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set splitHealthChecks(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get splitHealthChecksInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineApplicationIap {
    /**
     * Adapted for use with the app.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#enabled AppEngineApplication#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * OAuth2 client ID to use for the authentication flow.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#oauth2_client_id AppEngineApplication#oauth2_client_id}
     *
     * @stability stable
     */
    readonly oauth2ClientId: string;
    /**
     * OAuth2 client secret to use for the authentication flow.
     *
     * The SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#oauth2_client_secret AppEngineApplication#oauth2_client_secret}
     *
     * @stability stable
     */
    readonly oauth2ClientSecret: string;
}
/**
 * @stability stable
 */
export declare class AppEngineApplicationIapOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _oauth2ClientId?;
    /**
     * @stability stable
     */
    get oauth2ClientId(): string;
    /**
     * @stability stable
     */
    set oauth2ClientId(value: string);
    /**
     * @stability stable
     */
    get oauth2ClientIdInput(): string | undefined;
    private _oauth2ClientSecret?;
    /**
     * @stability stable
     */
    get oauth2ClientSecret(): string;
    /**
     * @stability stable
     */
    set oauth2ClientSecret(value: string);
    /**
     * @stability stable
     */
    get oauth2ClientSecretInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineApplicationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#create AppEngineApplication#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html#update AppEngineApplication#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class AppEngineApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html google_app_engine_application}.
 *
 * @stability stable
 */
export declare class AppEngineApplication extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_application.html google_app_engine_application} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppEngineApplicationConfig);
    /**
     * @stability stable
     */
    get appId(): string;
    private _authDomain?;
    /**
     * @stability stable
     */
    get authDomain(): string | undefined;
    /**
     * @stability stable
     */
    set authDomain(value: string | undefined);
    /**
     * @stability stable
     */
    resetAuthDomain(): void;
    /**
     * @stability stable
     */
    get authDomainInput(): string | undefined;
    /**
     * @stability stable
     */
    get codeBucket(): string;
    private _databaseType?;
    /**
     * @stability stable
     */
    get databaseType(): string | undefined;
    /**
     * @stability stable
     */
    set databaseType(value: string | undefined);
    /**
     * @stability stable
     */
    resetDatabaseType(): void;
    /**
     * @stability stable
     */
    get databaseTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get defaultBucket(): string;
    /**
     * @stability stable
     */
    get defaultHostname(): string;
    /**
     * @stability stable
     */
    get gcrDomain(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _locationId?;
    /**
     * @stability stable
     */
    get locationId(): string;
    /**
     * @stability stable
     */
    set locationId(value: string);
    /**
     * @stability stable
     */
    get locationIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _servingStatus?;
    /**
     * @stability stable
     */
    get servingStatus(): string | undefined;
    /**
     * @stability stable
     */
    set servingStatus(value: string | undefined);
    /**
     * @stability stable
     */
    resetServingStatus(): void;
    /**
     * @stability stable
     */
    get servingStatusInput(): string | undefined;
    /**
     * @stability stable
     */
    urlDispatchRule(index: string): AppEngineApplicationUrlDispatchRule;
    private _featureSettings?;
    private __featureSettingsOutput;
    /**
     * @stability stable
     */
    get featureSettings(): AppEngineApplicationFeatureSettingsOutputReference;
    /**
     * @stability stable
     */
    putFeatureSettings(value: AppEngineApplicationFeatureSettings | undefined): void;
    /**
     * @stability stable
     */
    resetFeatureSettings(): void;
    /**
     * @stability stable
     */
    get featureSettingsInput(): AppEngineApplicationFeatureSettings | undefined;
    private _iap?;
    private __iapOutput;
    /**
     * @stability stable
     */
    get iap(): AppEngineApplicationIapOutputReference;
    /**
     * @stability stable
     */
    putIap(value: AppEngineApplicationIap | undefined): void;
    /**
     * @stability stable
     */
    resetIap(): void;
    /**
     * @stability stable
     */
    get iapInput(): AppEngineApplicationIap | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): AppEngineApplicationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppEngineApplicationTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppEngineApplicationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
