import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BigtableInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether or not to allow Terraform to destroy the instance.
     *
     * Unless this field is set to false in Terraform state, a terraform destroy or terraform apply that would delete the instance will fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance.html#deletion_protection BigtableInstance#deletion_protection}
     *
     * @stability stable
     */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
     * The human-readable display name of the Bigtable instance. Defaults to the instance name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance.html#display_name BigtableInstance#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * The instance type to create. One of "DEVELOPMENT" or "PRODUCTION". Defaults to "PRODUCTION".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance.html#instance_type BigtableInstance#instance_type}
     *
     * @stability stable
     */
    readonly instanceType?: string;
    /**
     * A mapping of labels to assign to the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance.html#labels BigtableInstance#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The name (also called Instance Id in the Cloud Console) of the Cloud Bigtable instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance.html#name BigtableInstance#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance.html#project BigtableInstance#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * cluster block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance.html#cluster BigtableInstance#cluster}
     *
     * @stability stable
     */
    readonly cluster?: BigtableInstanceCluster[];
}
/**
 * @stability stable
 */
export interface BigtableInstanceCluster {
    /**
     * The ID of the Cloud Bigtable cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance.html#cluster_id BigtableInstance#cluster_id}
     *
     * @stability stable
     */
    readonly clusterId: string;
    /**
     * Describes the Cloud KMS encryption key that will be used to protect the destination Bigtable cluster.
     *
     * The requirements for this key are: 1) The Cloud Bigtable service account associated with the project that contains this cluster must be granted the cloudkms.cryptoKeyEncrypterDecrypter role on the CMEK key. 2) Only regional keys can be used and the region of the CMEK key must match the region of the cluster. 3) All clusters within an instance must use the same CMEK key. Values are of the form projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance.html#kms_key_name BigtableInstance#kms_key_name}
     *
     * @stability stable
     */
    readonly kmsKeyName?: string;
    /**
     * The number of nodes in your Cloud Bigtable cluster.
     *
     * Required, with a minimum of 1 for a PRODUCTION instance. Must be left unset for a DEVELOPMENT instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance.html#num_nodes BigtableInstance#num_nodes}
     *
     * @stability stable
     */
    readonly numNodes?: number;
    /**
     * The storage type to use. One of "SSD" or "HDD". Defaults to "SSD".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance.html#storage_type BigtableInstance#storage_type}
     *
     * @stability stable
     */
    readonly storageType?: string;
    /**
     * The zone to create the Cloud Bigtable cluster in.
     *
     * Each cluster must have a different zone in the same region. Zones that support Bigtable instances are noted on the Cloud Bigtable locations page.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance.html#zone BigtableInstance#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance.html google_bigtable_instance}.
 *
 * @stability stable
 */
export declare class BigtableInstance extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance.html google_bigtable_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BigtableInstanceConfig);
    private _deletionProtection?;
    /**
     * @stability stable
     */
    get deletionProtection(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set deletionProtection(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDeletionProtection(): void;
    /**
     * @stability stable
     */
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string | undefined;
    /**
     * @stability stable
     */
    set displayName(value: string | undefined);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instanceType?;
    /**
     * @stability stable
     */
    get instanceType(): string | undefined;
    /**
     * @stability stable
     */
    set instanceType(value: string | undefined);
    /**
     * @stability stable
     */
    resetInstanceType(): void;
    /**
     * @stability stable
     */
    get instanceTypeInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _cluster?;
    /**
     * @stability stable
     */
    get cluster(): BigtableInstanceCluster[] | undefined;
    /**
     * @stability stable
     */
    set cluster(value: BigtableInstanceCluster[] | undefined);
    /**
     * @stability stable
     */
    resetCluster(): void;
    /**
     * @stability stable
     */
    get clusterInput(): BigtableInstanceCluster[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
