import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleServiceNetworkingPeeredDnsDomainConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_networking_peered_dns_domain.html#name DataGoogleServiceNetworkingPeeredDnsDomain#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_networking_peered_dns_domain.html#network DataGoogleServiceNetworkingPeeredDnsDomain#network}.
     *
     * @stability stable
     */
    readonly network: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_networking_peered_dns_domain.html#project DataGoogleServiceNetworkingPeeredDnsDomain#project}.
     *
     * @stability stable
     */
    readonly project: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_networking_peered_dns_domain.html#service DataGoogleServiceNetworkingPeeredDnsDomain#service}.
     *
     * @stability stable
     */
    readonly service: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/service_networking_peered_dns_domain.html google_service_networking_peered_dns_domain}.
 *
 * @stability stable
 */
export declare class DataGoogleServiceNetworkingPeeredDnsDomain extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/service_networking_peered_dns_domain.html google_service_networking_peered_dns_domain} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleServiceNetworkingPeeredDnsDomainConfig);
    /**
     * @stability stable
     */
    get dnsSuffix(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    /**
     * @stability stable
     */
    get parent(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
