import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ProjectOrganizationPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Constraint the Policy is configuring, for example, serviceuser.services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#constraint ProjectOrganizationPolicy#constraint}
     *
     * @stability stable
     */
    readonly constraint: string;
    /**
     * The project ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#project ProjectOrganizationPolicy#project}
     *
     * @stability stable
     */
    readonly project: string;
    /**
     * Version of the Policy. Default version is 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#version ProjectOrganizationPolicy#version}
     *
     * @stability stable
     */
    readonly version?: number;
    /**
     * boolean_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#boolean_policy ProjectOrganizationPolicy#boolean_policy}
     *
     * @stability stable
     */
    readonly booleanPolicy?: ProjectOrganizationPolicyBooleanPolicy;
    /**
     * list_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#list_policy ProjectOrganizationPolicy#list_policy}
     *
     * @stability stable
     */
    readonly listPolicy?: ProjectOrganizationPolicyListPolicy;
    /**
     * restore_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#restore_policy ProjectOrganizationPolicy#restore_policy}
     *
     * @stability stable
     */
    readonly restorePolicy?: ProjectOrganizationPolicyRestorePolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#timeouts ProjectOrganizationPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ProjectOrganizationPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface ProjectOrganizationPolicyBooleanPolicy {
    /**
     * If true, then the Policy is enforced. If false, then any configuration is acceptable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#enforced ProjectOrganizationPolicy#enforced}
     *
     * @stability stable
     */
    readonly enforced: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class ProjectOrganizationPolicyBooleanPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _enforced?;
    /**
     * @stability stable
     */
    get enforced(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enforced(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enforcedInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ProjectOrganizationPolicyListPolicyAllow {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#all ProjectOrganizationPolicy#all}
     *
     * @stability stable
     */
    readonly all?: boolean | cdktf.IResolvable;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#values ProjectOrganizationPolicy#values}
     *
     * @stability stable
     */
    readonly values?: string[];
}
/**
 * @stability stable
 */
export declare class ProjectOrganizationPolicyListPolicyAllowOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _all?;
    /**
     * @stability stable
     */
    get all(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set all(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAll(): void;
    /**
     * @stability stable
     */
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[] | undefined;
    /**
     * @stability stable
     */
    set values(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetValues(): void;
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ProjectOrganizationPolicyListPolicyDeny {
    /**
     * The policy allows or denies all values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#all ProjectOrganizationPolicy#all}
     *
     * @stability stable
     */
    readonly all?: boolean | cdktf.IResolvable;
    /**
     * The policy can define specific values that are allowed or denied.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#values ProjectOrganizationPolicy#values}
     *
     * @stability stable
     */
    readonly values?: string[];
}
/**
 * @stability stable
 */
export declare class ProjectOrganizationPolicyListPolicyDenyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _all?;
    /**
     * @stability stable
     */
    get all(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set all(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAll(): void;
    /**
     * @stability stable
     */
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[] | undefined;
    /**
     * @stability stable
     */
    set values(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetValues(): void;
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ProjectOrganizationPolicyListPolicy {
    /**
     * If set to true, the values from the effective Policy of the parent resource are inherited, meaning the values set in this Policy are added to the values inherited up the hierarchy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#inherit_from_parent ProjectOrganizationPolicy#inherit_from_parent}
     *
     * @stability stable
     */
    readonly inheritFromParent?: boolean | cdktf.IResolvable;
    /**
     * The Google Cloud Console will try to default to a configuration that matches the value specified in this field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#suggested_value ProjectOrganizationPolicy#suggested_value}
     *
     * @stability stable
     */
    readonly suggestedValue?: string;
    /**
     * allow block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#allow ProjectOrganizationPolicy#allow}
     *
     * @stability stable
     */
    readonly allow?: ProjectOrganizationPolicyListPolicyAllow;
    /**
     * deny block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#deny ProjectOrganizationPolicy#deny}
     *
     * @stability stable
     */
    readonly deny?: ProjectOrganizationPolicyListPolicyDeny;
}
/**
 * @stability stable
 */
export declare class ProjectOrganizationPolicyListPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _inheritFromParent?;
    /**
     * @stability stable
     */
    get inheritFromParent(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set inheritFromParent(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetInheritFromParent(): void;
    /**
     * @stability stable
     */
    get inheritFromParentInput(): boolean | cdktf.IResolvable | undefined;
    private _suggestedValue?;
    /**
     * @stability stable
     */
    get suggestedValue(): string | undefined;
    /**
     * @stability stable
     */
    set suggestedValue(value: string | undefined);
    /**
     * @stability stable
     */
    resetSuggestedValue(): void;
    /**
     * @stability stable
     */
    get suggestedValueInput(): string | undefined;
    private _allow?;
    private __allowOutput;
    /**
     * @stability stable
     */
    get allow(): ProjectOrganizationPolicyListPolicyAllowOutputReference;
    /**
     * @stability stable
     */
    putAllow(value: ProjectOrganizationPolicyListPolicyAllow | undefined): void;
    /**
     * @stability stable
     */
    resetAllow(): void;
    /**
     * @stability stable
     */
    get allowInput(): ProjectOrganizationPolicyListPolicyAllow | undefined;
    private _deny?;
    private __denyOutput;
    /**
     * @stability stable
     */
    get deny(): ProjectOrganizationPolicyListPolicyDenyOutputReference;
    /**
     * @stability stable
     */
    putDeny(value: ProjectOrganizationPolicyListPolicyDeny | undefined): void;
    /**
     * @stability stable
     */
    resetDeny(): void;
    /**
     * @stability stable
     */
    get denyInput(): ProjectOrganizationPolicyListPolicyDeny | undefined;
}
/**
 * @stability stable
 */
export interface ProjectOrganizationPolicyRestorePolicy {
    /**
     * May only be set to true. If set, then the default Policy is restored.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#default ProjectOrganizationPolicy#default}
     *
     * @stability stable
     */
    readonly default: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class ProjectOrganizationPolicyRestorePolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _default?;
    /**
     * @stability stable
     */
    get default(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set default(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get defaultInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ProjectOrganizationPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#create ProjectOrganizationPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#delete ProjectOrganizationPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#read ProjectOrganizationPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html#update ProjectOrganizationPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class ProjectOrganizationPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string | undefined;
    /**
     * @stability stable
     */
    set read(value: string | undefined);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html google_project_organization_policy}.
 *
 * @stability stable
 */
export declare class ProjectOrganizationPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/project_organization_policy.html google_project_organization_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ProjectOrganizationPolicyConfig);
    private _constraint?;
    /**
     * @stability stable
     */
    get constraint(): string;
    /**
     * @stability stable
     */
    set constraint(value: string);
    /**
     * @stability stable
     */
    get constraintInput(): string | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateTime(): string;
    private _version?;
    /**
     * @stability stable
     */
    get version(): number | undefined;
    /**
     * @stability stable
     */
    set version(value: number | undefined);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): number | undefined;
    private _booleanPolicy?;
    private __booleanPolicyOutput;
    /**
     * @stability stable
     */
    get booleanPolicy(): ProjectOrganizationPolicyBooleanPolicyOutputReference;
    /**
     * @stability stable
     */
    putBooleanPolicy(value: ProjectOrganizationPolicyBooleanPolicy | undefined): void;
    /**
     * @stability stable
     */
    resetBooleanPolicy(): void;
    /**
     * @stability stable
     */
    get booleanPolicyInput(): ProjectOrganizationPolicyBooleanPolicy | undefined;
    private _listPolicy?;
    private __listPolicyOutput;
    /**
     * @stability stable
     */
    get listPolicy(): ProjectOrganizationPolicyListPolicyOutputReference;
    /**
     * @stability stable
     */
    putListPolicy(value: ProjectOrganizationPolicyListPolicy | undefined): void;
    /**
     * @stability stable
     */
    resetListPolicy(): void;
    /**
     * @stability stable
     */
    get listPolicyInput(): ProjectOrganizationPolicyListPolicy | undefined;
    private _restorePolicy?;
    private __restorePolicyOutput;
    /**
     * @stability stable
     */
    get restorePolicy(): ProjectOrganizationPolicyRestorePolicyOutputReference;
    /**
     * @stability stable
     */
    putRestorePolicy(value: ProjectOrganizationPolicyRestorePolicy | undefined): void;
    /**
     * @stability stable
     */
    resetRestorePolicy(): void;
    /**
     * @stability stable
     */
    get restorePolicyInput(): ProjectOrganizationPolicyRestorePolicy | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ProjectOrganizationPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ProjectOrganizationPolicyTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ProjectOrganizationPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
