"""Added error table

Revision ID: 184bb7a71ada
Revises: 06a5ec0a1af0
Create Date: 2021-09-28 11:06:02.808351

"""
from alembic import op
import sqlalchemy as sa

from vwsfriend.model.datetime_decorator import DatetimeDecorator


# revision identifiers, used by Alembic.
revision = '184bb7a71ada'
down_revision = '06a5ec0a1af0'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('weconnect_errors',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('datetime', DatetimeDecorator(timezone=True), nullable=False),
                    sa.Column('errortype', sa.Enum('HTTP', 'TIMEOUT', 'CONNECTION', 'ALL', name='erroreventtype'), nullable=True),
                    sa.Column('detail', sa.String(), nullable=True),
                    sa.PrimaryKeyConstraint('id')
                    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('weconnect_errors')
    # ### end Alembic commands ###
