# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceACLEntriesv1Args', 'ServiceACLEntriesv1']

@pulumi.input_type
class ServiceACLEntriesv1Args:
    def __init__(__self__, *,
                 acl_id: pulumi.Input[str],
                 service_id: pulumi.Input[str],
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceACLEntriesv1EntryArgs']]]] = None):
        """
        The set of arguments for constructing a ServiceACLEntriesv1 resource.
        :param pulumi.Input[str] acl_id: The ID of the ACL that the items belong to
        :param pulumi.Input[str] service_id: The ID of the Service that the ACL belongs to
        :param pulumi.Input[Sequence[pulumi.Input['ServiceACLEntriesv1EntryArgs']]] entries: ACL Entries
        """
        pulumi.set(__self__, "acl_id", acl_id)
        pulumi.set(__self__, "service_id", service_id)
        if entries is not None:
            pulumi.set(__self__, "entries", entries)

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> pulumi.Input[str]:
        """
        The ID of the ACL that the items belong to
        """
        return pulumi.get(self, "acl_id")

    @acl_id.setter
    def acl_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "acl_id", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[str]:
        """
        The ID of the Service that the ACL belongs to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceACLEntriesv1EntryArgs']]]]:
        """
        ACL Entries
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceACLEntriesv1EntryArgs']]]]):
        pulumi.set(self, "entries", value)


@pulumi.input_type
class _ServiceACLEntriesv1State:
    def __init__(__self__, *,
                 acl_id: Optional[pulumi.Input[str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceACLEntriesv1EntryArgs']]]] = None,
                 service_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServiceACLEntriesv1 resources.
        :param pulumi.Input[str] acl_id: The ID of the ACL that the items belong to
        :param pulumi.Input[Sequence[pulumi.Input['ServiceACLEntriesv1EntryArgs']]] entries: ACL Entries
        :param pulumi.Input[str] service_id: The ID of the Service that the ACL belongs to
        """
        if acl_id is not None:
            pulumi.set(__self__, "acl_id", acl_id)
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the ACL that the items belong to
        """
        return pulumi.get(self, "acl_id")

    @acl_id.setter
    def acl_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl_id", value)

    @property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceACLEntriesv1EntryArgs']]]]:
        """
        ACL Entries
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceACLEntriesv1EntryArgs']]]]):
        pulumi.set(self, "entries", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Service that the ACL belongs to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)


class ServiceACLEntriesv1(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_id: Optional[pulumi.Input[str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceACLEntriesv1EntryArgs']]]]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Defines a set of Fastly ACL entries that can be used to populate a service ACL.  This resource will populate an ACL with the entries and will track their state.

        > **Warning:** This provider will take precedence over any changes you make in the UI or API. Such changes are likely to be reversed if you run the provider again.

        If this provider is being used to populate the initial content of an ACL which you intend to manage via API or UI, then the lifecycle `ignore_changes` field can be used with the resource.  An example of this configuration is provided below.

        ## Example Usage
        ### Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        config = pulumi.Config()
        myacl_name = config.get("myaclName")
        if myacl_name is None:
            myacl_name = "My ACL"
        myservice = fastly.Servicev1("myservice",
            domains=[fastly.Servicev1DomainArgs(
                name="demo.notexample.com",
                comment="demo",
            )],
            backends=[fastly.Servicev1BackendArgs(
                address="demo.notexample.com.s3-website-us-west-2.amazonaws.com",
                name="AWS S3 hosting",
                port=80,
            )],
            acls=[fastly.Servicev1AclArgs(
                name=myacl_name,
            )],
            force_destroy=True)
        entries = []
        for range in [{"key": k, "value": v} for [k, v] in enumerate({d.name: d for d in myservice.acls if d.name == myacl_name})]:
            entries.append(fastly.ServiceACLEntriesv1(f"entries-{range['key']}",
                service_id=myservice.id,
                acl_id=range["value"],
                entries=[fastly.ServiceACLEntriesv1EntryArgs(
                    ip="127.0.0.1",
                    subnet="24",
                    negated=False,
                    comment="ALC Entry 1",
                )]))
        ```

        ## Import

        This is an example of the import command being applied to the resource named `fastly_service_acl_entries_v1.entries` The resource ID is a combined value of the `service_id` and `acl_id` separated by a forward slash.

        ```sh
         $ pulumi import fastly:index/serviceACLEntriesv1:ServiceACLEntriesv1 entries xxxxxxxxxxxxxxxxxxxx/xxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl_id: The ID of the ACL that the items belong to
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceACLEntriesv1EntryArgs']]]] entries: ACL Entries
        :param pulumi.Input[str] service_id: The ID of the Service that the ACL belongs to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceACLEntriesv1Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Defines a set of Fastly ACL entries that can be used to populate a service ACL.  This resource will populate an ACL with the entries and will track their state.

        > **Warning:** This provider will take precedence over any changes you make in the UI or API. Such changes are likely to be reversed if you run the provider again.

        If this provider is being used to populate the initial content of an ACL which you intend to manage via API or UI, then the lifecycle `ignore_changes` field can be used with the resource.  An example of this configuration is provided below.

        ## Example Usage
        ### Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        config = pulumi.Config()
        myacl_name = config.get("myaclName")
        if myacl_name is None:
            myacl_name = "My ACL"
        myservice = fastly.Servicev1("myservice",
            domains=[fastly.Servicev1DomainArgs(
                name="demo.notexample.com",
                comment="demo",
            )],
            backends=[fastly.Servicev1BackendArgs(
                address="demo.notexample.com.s3-website-us-west-2.amazonaws.com",
                name="AWS S3 hosting",
                port=80,
            )],
            acls=[fastly.Servicev1AclArgs(
                name=myacl_name,
            )],
            force_destroy=True)
        entries = []
        for range in [{"key": k, "value": v} for [k, v] in enumerate({d.name: d for d in myservice.acls if d.name == myacl_name})]:
            entries.append(fastly.ServiceACLEntriesv1(f"entries-{range['key']}",
                service_id=myservice.id,
                acl_id=range["value"],
                entries=[fastly.ServiceACLEntriesv1EntryArgs(
                    ip="127.0.0.1",
                    subnet="24",
                    negated=False,
                    comment="ALC Entry 1",
                )]))
        ```

        ## Import

        This is an example of the import command being applied to the resource named `fastly_service_acl_entries_v1.entries` The resource ID is a combined value of the `service_id` and `acl_id` separated by a forward slash.

        ```sh
         $ pulumi import fastly:index/serviceACLEntriesv1:ServiceACLEntriesv1 entries xxxxxxxxxxxxxxxxxxxx/xxxxxxxxxxxxxxxxxxxx
        ```

        :param str resource_name: The name of the resource.
        :param ServiceACLEntriesv1Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceACLEntriesv1Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_id: Optional[pulumi.Input[str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceACLEntriesv1EntryArgs']]]]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceACLEntriesv1Args.__new__(ServiceACLEntriesv1Args)

            if acl_id is None and not opts.urn:
                raise TypeError("Missing required property 'acl_id'")
            __props__.__dict__["acl_id"] = acl_id
            __props__.__dict__["entries"] = entries
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
        super(ServiceACLEntriesv1, __self__).__init__(
            'fastly:index/serviceACLEntriesv1:ServiceACLEntriesv1',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_id: Optional[pulumi.Input[str]] = None,
            entries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceACLEntriesv1EntryArgs']]]]] = None,
            service_id: Optional[pulumi.Input[str]] = None) -> 'ServiceACLEntriesv1':
        """
        Get an existing ServiceACLEntriesv1 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl_id: The ID of the ACL that the items belong to
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceACLEntriesv1EntryArgs']]]] entries: ACL Entries
        :param pulumi.Input[str] service_id: The ID of the Service that the ACL belongs to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceACLEntriesv1State.__new__(_ServiceACLEntriesv1State)

        __props__.__dict__["acl_id"] = acl_id
        __props__.__dict__["entries"] = entries
        __props__.__dict__["service_id"] = service_id
        return ServiceACLEntriesv1(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> pulumi.Output[str]:
        """
        The ID of the ACL that the items belong to
        """
        return pulumi.get(self, "acl_id")

    @property
    @pulumi.getter
    def entries(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceACLEntriesv1Entry']]]:
        """
        ACL Entries
        """
        return pulumi.get(self, "entries")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[str]:
        """
        The ID of the Service that the ACL belongs to
        """
        return pulumi.get(self, "service_id")

