import pytest

from ..utils import name2title


@pytest.mark.parametrize(
    "name,title",
    [
        ("relatedResource", "Related Resource"),
        ("identifier", "Identifier"),
        ("wasGeneratedBy", "Was Generated by"),
        ("sameAs", "Same as"),
        ("includeInCitation", "Include in Citation"),
        ("anExtraField", "An Extra Field"),
        ("propertyID", "Property ID"),
        ("fieldINeed", "Field I Need"),
        ("needsADatum", "Needs a Datum"),
        ("contentUrl", "Content URL"),
        ("ContactPoint", "Contact Point"),
    ],
)
def test_name2title(name, title):
    assert name2title(name) == title
