# coding: utf-8

"""
    Cashfree Payment Gateway APIs

    Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.

    The version of the OpenAPI document: 2022-09-01
    Contact: developers@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from cashfree_pg.configuration import Configuration
from cashfree_pg.api_response import ApiResponse
from cashfree_pg.exceptions import (  # noqa: F401
    ApiException,
    ApiTypeError,
    ApiValueError
)

import atexit
import datetime as dt
from dateutil.parser import parse
import json
import mimetypes
from multiprocessing.pool import ThreadPool
import os
import re
import tempfile
import warnings
from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated
from typing import overload, Optional, Union, Awaitable
from pydantic import Field, StrictStr

from cashfree_pg.configuration import Configuration
from cashfree_pg.api_response import ApiResponse
from cashfree_pg.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)

from urllib.parse import quote

from cashfree_pg.configuration import Configuration
from cashfree_pg.api_response import ApiResponse
import cashfree_pg.models
from cashfree_pg import rest

from cashfree_pg.models.api_error import *
from cashfree_pg.models.api_error404 import *
from cashfree_pg.models.api_error409 import *
from cashfree_pg.models.api_error502 import *
from cashfree_pg.models.app import *
from cashfree_pg.models.app_payment_method import *
from cashfree_pg.models.authentication_error import *
from cashfree_pg.models.authorization_in_payments_entity import *
from cashfree_pg.models.authorize_order_request import *
from cashfree_pg.models.bad_request_error import *
from cashfree_pg.models.card import *
from cashfree_pg.models.card_emi import *
from cashfree_pg.models.card_emi_payment_method import *
from cashfree_pg.models.card_offer import *
from cashfree_pg.models.card_payment_method import *
from cashfree_pg.models.cardless_emi import *
from cashfree_pg.models.cardless_emi_entity import *
from cashfree_pg.models.cardless_emi_payment_method import *
from cashfree_pg.models.cardless_emi_queries import *
from cashfree_pg.models.cashback_details import *
from cashfree_pg.models.create_link_request import *
from cashfree_pg.models.create_offer_request import *
from cashfree_pg.models.create_order_request import *
from cashfree_pg.models.create_terminal_request import *
from cashfree_pg.models.create_terminal_request_terminal_meta import *
from cashfree_pg.models.create_terminal_transaction_request import *
from cashfree_pg.models.cryptogram_entity import *
from cashfree_pg.models.customer_details import *
from cashfree_pg.models.customer_details_cardless_emi import *
from cashfree_pg.models.discount_details import *
from cashfree_pg.models.emi_offer import *
from cashfree_pg.models.emi_plans_array import *
from cashfree_pg.models.eligibility_cardless_emi_entity import *
from cashfree_pg.models.eligibility_fetch_cardless_emi_request import *
from cashfree_pg.models.eligibility_fetch_offers_request import *
from cashfree_pg.models.eligibility_fetch_paylater_request import *
from cashfree_pg.models.eligibility_fetch_payment_methods_request import *
from cashfree_pg.models.eligibility_offer_entity import *
from cashfree_pg.models.eligibility_paylater_entity import *
from cashfree_pg.models.eligibility_payment_methods_entity import *
from cashfree_pg.models.eligibility_payment_methods_entity_entity_details import *
from cashfree_pg.models.error_details_in_payments_entity import *
from cashfree_pg.models.fetch_recon_request import *
from cashfree_pg.models.fetch_recon_request_filters import *
from cashfree_pg.models.fetch_recon_request_pagination import *
from cashfree_pg.models.fetch_settlements_request import *
from cashfree_pg.models.fetch_settlements_request_filters import *
from cashfree_pg.models.fetch_settlements_request_pagination import *
from cashfree_pg.models.fetch_terminal_qr_codes_entity import *
from cashfree_pg.models.idempotency_error import *
from cashfree_pg.models.instrument_entity import *
from cashfree_pg.models.instrument_webhook import *
from cashfree_pg.models.instrument_webhook_data import *
from cashfree_pg.models.instrument_webhook_data_entity import *
from cashfree_pg.models.link_customer_details_entity import *
from cashfree_pg.models.link_entity import *
from cashfree_pg.models.link_meta_entity import *
from cashfree_pg.models.link_notify_entity import *
from cashfree_pg.models.net_banking_payment_method import *
from cashfree_pg.models.netbanking import *
from cashfree_pg.models.offer_all import *
from cashfree_pg.models.offer_card import *
from cashfree_pg.models.offer_details import *
from cashfree_pg.models.offer_emi import *
from cashfree_pg.models.offer_entity import *
from cashfree_pg.models.offer_filters import *
from cashfree_pg.models.offer_meta import *
from cashfree_pg.models.offer_nb import *
from cashfree_pg.models.offer_nb_netbanking import *
from cashfree_pg.models.offer_paylater import *
from cashfree_pg.models.offer_queries import *
from cashfree_pg.models.offer_tnc import *
from cashfree_pg.models.offer_type import *
from cashfree_pg.models.offer_upi import *
from cashfree_pg.models.offer_validations import *
from cashfree_pg.models.offer_validations_payment_method import *
from cashfree_pg.models.offer_wallet import *
from cashfree_pg.models.order_authenticate_entity import *
from cashfree_pg.models.order_authenticate_payment_request import *
from cashfree_pg.models.order_create_refund_request import *
from cashfree_pg.models.order_entity import *
from cashfree_pg.models.order_meta import *
from cashfree_pg.models.order_pay_data import *
from cashfree_pg.models.pay_order_entity import *
from cashfree_pg.models.pay_order_request import *
from cashfree_pg.models.pay_order_request_payment_method import *
from cashfree_pg.models.paylater import *
from cashfree_pg.models.paylater_entity import *
from cashfree_pg.models.paylater_offer import *
from cashfree_pg.models.paylater_payment_method import *
from cashfree_pg.models.payment_entity import *
from cashfree_pg.models.payment_method_app_in_payments_entity import *
from cashfree_pg.models.payment_method_card_in_payments_entity import *
from cashfree_pg.models.payment_method_cardless_emiin_payments_entity import *
from cashfree_pg.models.payment_method_in_payments_entity import *
from cashfree_pg.models.payment_method_in_payments_entity_payment_method import *
from cashfree_pg.models.payment_method_net_banking_in_payments_entity import *
from cashfree_pg.models.payment_method_paylater_in_payments_entity import *
from cashfree_pg.models.payment_method_upiin_payments_entity import *
from cashfree_pg.models.payment_methods_filters import *
from cashfree_pg.models.payment_methods_queries import *
from cashfree_pg.models.payment_mode_details import *
from cashfree_pg.models.payment_url_object import *
from cashfree_pg.models.payment_webhook import *
from cashfree_pg.models.payment_webhook_customer_entity import *
from cashfree_pg.models.payment_webhook_data_entity import *
from cashfree_pg.models.payment_webhook_error_entity import *
from cashfree_pg.models.payment_webhook_gateway_details_entity import *
from cashfree_pg.models.payment_webhook_order_entity import *
from cashfree_pg.models.rate_limit_error import *
from cashfree_pg.models.recon_entity import *
from cashfree_pg.models.recon_entity_data_inner import *
from cashfree_pg.models.refund_entity import *
from cashfree_pg.models.refund_speed import *
from cashfree_pg.models.refund_url_object import *
from cashfree_pg.models.refund_webhook import *
from cashfree_pg.models.refund_webhook_data_entity import *
from cashfree_pg.models.saved_instrument_meta import *
from cashfree_pg.models.settlement_entity import *
from cashfree_pg.models.settlement_fetch_recon_request import *
from cashfree_pg.models.settlement_fetch_recon_request_filters import *
from cashfree_pg.models.settlement_recon_entity import *
from cashfree_pg.models.settlement_recon_entity_data_inner import *
from cashfree_pg.models.settlement_url_object import *
from cashfree_pg.models.settlement_webhook import *
from cashfree_pg.models.settlement_webhook_data_entity import *
from cashfree_pg.models.terminal_details import *
from cashfree_pg.models.terminal_entity import *
from cashfree_pg.models.terminal_transaction_entity import *
from cashfree_pg.models.upi_authorize_details import *
from cashfree_pg.models.upi_payment_method import *
from cashfree_pg.models.upi import *
from cashfree_pg.models.vendor_split import *
from cashfree_pg.models.wallet_offer import *

class CFEnvironment(Enum):
    SANDBOX = 1
    PRODUCTION = 2

class PGWebhookEvent:
    def __init__(self, type, rawBody, object):
        self.type = type;
        self.raw = rawBody
        self.object = object;

class Cashfree:

    XClientId = None
    XClientSecret = None
    XPartnerKey = None
    XClientSignature = None
    XPartnerMerchantId = None
    XEnvironment = CFEnvironment.SANDBOX

    XProduction = CFEnvironment.PRODUCTION
    XSandbox = CFEnvironment.SANDBOX

    PRODUCTION = CFEnvironment.PRODUCTION
    SANDBOX = CFEnvironment.SANDBOX

    XApiVersion = "2022-09-01";

    def PGVerifyWebhookSignature(signature, rawBody, timestamp):
        signatureData = timestamp+rawBody
        message = bytes(signatureData, 'utf-8')
        secretkey=bytes(Cashfree.XClientSecret,'utf-8')
        generatedSignature = base64.b64encode(hmac.new(secretkey, message, digestmod=hashlib.sha256).digest())
        computed_signature = str(generatedSignature, encoding='utf8')
        if computed_signature == signature:
            json_response = json.loads(rawBody)
            return PGWebhookEvent(type=json_response['type'], rawBody=rawBody, object=json_response)
        raise Exception("Generated signature and received signature did not match.")

    @validate_arguments
    def PGEligibilityFetchCardlessEmi(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, eligibility_fetch_cardless_emi_request : Annotated[EligibilityFetchCardlessEMIRequest, Field(..., description="Request Body to get eligible cardless emi options for a customer and order")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Eligible Cardless EMI  # noqa: E501

        Use this API to get eligible Cardless EMI Payment Methods available for a customer on an order basis their phone number.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGEligibilityFetchCardlessEmi_with_http_info(x_api_version, eligibility_fetch_cardless_emi_request, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param eligibility_fetch_cardless_emi_request: Request Body to get eligible cardless emi options for a customer and order (required)
        :type eligibility_fetch_cardless_emi_request: EligibilityFetchCardlessEMIRequest
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[EligibilityCardlessEMIEntity], status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'eligibility_fetch_cardless_emi_request',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGEligibilityFetchCardlessEmi" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['eligibility_fetch_cardless_emi_request'] is not None:
            _body_params = _params['eligibility_fetch_cardless_emi_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "List[EligibilityCardlessEMIEntity]",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
            '502': "ApiError502",
        }

        return api_client.call_api(
            '/eligibility/cardlessemi', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGEligibilityFetchOffers(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, eligibility_fetch_offers_request : Annotated[EligibilityFetchOffersRequest, Field(..., description="Request Body to get eligible offers for a customer and order")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Eligible Offers  # noqa: E501

        Use this API to get eligible offers for an order_id or order amount.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGEligibilityFetchOffers_with_http_info(x_api_version, eligibility_fetch_offers_request, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param eligibility_fetch_offers_request: Request Body to get eligible offers for a customer and order (required)
        :type eligibility_fetch_offers_request: EligibilityFetchOffersRequest
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[EligibilityOfferEntity], status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'eligibility_fetch_offers_request',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGEligibilityFetchOffers" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['eligibility_fetch_offers_request'] is not None:
            _body_params = _params['eligibility_fetch_offers_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "List[EligibilityOfferEntity]",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
        }

        return api_client.call_api(
            '/eligibility/offers', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGEligibilityFetchPaylater(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, eligibility_fetch_paylater_request : Annotated[EligibilityFetchPaylaterRequest, Field(..., description="Request Body to get eligible paylater options for a customer and order")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Eligible Paylater  # noqa: E501

        Use this API to get eligible Paylater Payment Methods for a customer on an order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGEligibilityFetchPaylater_with_http_info(x_api_version, eligibility_fetch_paylater_request, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param eligibility_fetch_paylater_request: Request Body to get eligible paylater options for a customer and order (required)
        :type eligibility_fetch_paylater_request: EligibilityFetchPaylaterRequest
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[EligibilityPaylaterEntity], status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'eligibility_fetch_paylater_request',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGEligibilityFetchPaylater" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['eligibility_fetch_paylater_request'] is not None:
            _body_params = _params['eligibility_fetch_paylater_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "List[EligibilityPaylaterEntity]",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
            '502': "ApiError502",
        }

        return api_client.call_api(
            '/eligibility/paylater', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGEligibilityFetchPaymentMethods(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, eligibility_fetch_payment_methods_request : Annotated[EligibilityFetchPaymentMethodsRequest, Field(..., description="Request Body to get eligible payment methods for an account and order")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Eligible Payment Methods  # noqa: E501

        Use this API to get eligible Payment Methods  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGEligibilityFetchPaymentMethods_with_http_info(x_api_version, eligibility_fetch_payment_methods_request, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param eligibility_fetch_payment_methods_request: Request Body to get eligible payment methods for an account and order (required)
        :type eligibility_fetch_payment_methods_request: EligibilityFetchPaymentMethodsRequest
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[EligibilityPaymentMethodsEntity], status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'eligibility_fetch_payment_methods_request',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGEligibilityFetchPaymentMethods" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['eligibility_fetch_payment_methods_request'] is not None:
            _body_params = _params['eligibility_fetch_payment_methods_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "List[EligibilityPaymentMethodsEntity]",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
            '502': "ApiError502",
        }

        return api_client.call_api(
            '/eligibility/payment_methods', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def PGCreateOffer(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, create_offer_request : Annotated[CreateOfferRequest, Field(..., description="Request body to create an offer at Cashfree")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create Offer  # noqa: E501

        Use this API to create offers with Cashfree from your backend  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGCreateOffer_with_http_info(x_api_version, create_offer_request, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param create_offer_request: Request body to create an offer at Cashfree (required)
        :type create_offer_request: CreateOfferRequest
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OfferEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'create_offer_request',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGCreateOffer" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_offer_request'] is not None:
            _body_params = _params['create_offer_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "OfferEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
        }

        return api_client.call_api(
            '/offers', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGFetchOffer(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, offer_id : Annotated[StrictStr, Field(..., description="The offer ID for which you want to view the offer details.")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Offer by ID  # noqa: E501

        Use this API to get offer by offer_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGFetchOffer_with_http_info(x_api_version, offer_id, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param offer_id: The offer ID for which you want to view the offer details. (required)
        :type offer_id: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OfferEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'offer_id',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGFetchOffer" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['offer_id']:
            _path_params['offer_id'] = _params['offer_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "OfferEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
        }

        return api_client.call_api(
            '/offers/{offer_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def PGCreateOrder(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, create_order_request : Annotated[CreateOrderRequest, Field(..., description="Request body to create an order at cashfree")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create Order  # noqa: E501

        ### Order An order is an entity which has a amount and currency associated with it. It is something for which you want to collect payment for. Use this API to create orders with Cashfree from your backend to get a `payment_sessions_id`.  You can use the `payment_sessions_id` to create a transaction for the order.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGCreateOrder_with_http_info(x_api_version, create_order_request, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param create_order_request: Request body to create an order at cashfree (required)
        :type create_order_request: CreateOrderRequest
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OrderEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'create_order_request',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGCreateOrder" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_order_request'] is not None:
            _body_params = _params['create_order_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "OrderEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
        }

        return api_client.call_api(
            '/orders', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGFetchOrder(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, order_id : Annotated[StrictStr, Field(..., description="The id which uniquely identifies your order")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Order  # noqa: E501

        Use this API to fetch the order that was created at Cashfree's using the `order_id`.  ## When to use this API - To check the status of your order - Once the order is PAID - Once your customer returns to `return_url`   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGFetchOrder_with_http_info(x_api_version, order_id, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param order_id: The id which uniquely identifies your order (required)
        :type order_id: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OrderEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'order_id',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGFetchOrder" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['order_id']:
            _path_params['order_id'] = _params['order_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "OrderEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
        }

        return api_client.call_api(
            '/orders/{order_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def PGFetchRecon(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, fetch_recon_request : Annotated[FetchReconRequest, Field(..., description="Request Body for the reconciliation")] = None, content_type : Annotated[Optional[StrictStr], Field(description="application/json")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, accept : Annotated[Optional[StrictStr], Field(description="application/json")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """PG Reconciliation  # noqa: E501

        - Use this API to get the payment gateway reconciliation details with date range. - It will have events for your payment account   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGFetchRecon_with_http_info(x_api_version, fetch_recon_request, content_type, x_request_id, x_idempotency_key, accept, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param fetch_recon_request: Request Body for the reconciliation (required)
        :type fetch_recon_request: FetchReconRequest
        :param content_type: application/json
        :type content_type: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param accept: application/json
        :type accept: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ReconEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'fetch_recon_request',
            'content_type',
            'x_request_id',
            'x_idempotency_key',
            'accept'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGFetchRecon" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['fetch_recon_request'] is not None:
            _body_params = _params['fetch_recon_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "ReconEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
        }

        return api_client.call_api(
            '/recon', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def PGCancelLink(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, link_id : Annotated[StrictStr, Field(..., description="The payment link ID for which you want to view the details.")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Cancel Payment Link  # noqa: E501

        Use this API to cancel a payment link. No further payments can be done against a cancelled link. Only a link in ACTIVE status can be cancelled.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGCancelLink_with_http_info(x_api_version, link_id, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param link_id: The payment link ID for which you want to view the details. (required)
        :type link_id: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LinkEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'link_id',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGCancelLink" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['link_id']:
            _path_params['link_id'] = _params['link_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "LinkEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
        }

        return api_client.call_api(
            '/links/{link_id}/cancel', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGCreateLink(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, create_link_request : Annotated[CreateLinkRequest, Field(..., description="Request Body to Create Payment Links")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create Payment Link  # noqa: E501

        Use this API to create a new payment link. The created payment link url will be available in the API response parameter link_url.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGCreateLink_with_http_info(x_api_version, create_link_request, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param create_link_request: Request Body to Create Payment Links (required)
        :type create_link_request: CreateLinkRequest
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LinkEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'create_link_request',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGCreateLink" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_link_request'] is not None:
            _body_params = _params['create_link_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "LinkEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
        }

        return api_client.call_api(
            '/links', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGFetchLink(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, link_id : Annotated[StrictStr, Field(..., description="The payment link ID for which you want to view the details.")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Fetch Payment Link Details  # noqa: E501

        Use this API to view all details and status of a payment link.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGFetchLink_with_http_info(x_api_version, link_id, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param link_id: The payment link ID for which you want to view the details. (required)
        :type link_id: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LinkEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'link_id',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGFetchLink" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['link_id']:
            _path_params['link_id'] = _params['link_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "LinkEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
            '502': "ApiError502",
        }

        return api_client.call_api(
            '/links/{link_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGLinkFetchOrders(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, link_id : Annotated[StrictStr, Field(..., description="The payment link ID for which you want to view the details.")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Orders for a Payment Link  # noqa: E501

        Use this API to view all order details for a payment link.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGLinkFetchOrders_with_http_info(x_api_version, link_id, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param link_id: The payment link ID for which you want to view the details. (required)
        :type link_id: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[OrderEntity], status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'link_id',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGLinkFetchOrders" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['link_id']:
            _path_params['link_id'] = _params['link_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "List[OrderEntity]",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
        }

        return api_client.call_api(
            '/links/{link_id}/orders', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def PGAuthorizeOrder(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, order_id : Annotated[StrictStr, Field(..., description="The id which uniquely identifies your order")] = None, authorize_order_request : Annotated[AuthorizeOrderRequest, Field(..., description="Request to Capture or Void Transactions")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Preauthorization  # noqa: E501

        Use this API to capture or void a preauthorized payment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGAuthorizeOrder_with_http_info(x_api_version, order_id, authorize_order_request, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param order_id: The id which uniquely identifies your order (required)
        :type order_id: str
        :param authorize_order_request: Request to Capture or Void Transactions (required)
        :type authorize_order_request: AuthorizeOrderRequest
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaymentEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'order_id',
            'authorize_order_request',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGAuthorizeOrder" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['order_id']:
            _path_params['order_id'] = _params['order_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['authorize_order_request'] is not None:
            _body_params = _params['authorize_order_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "PaymentEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
            '502': "ApiError502",
        }

        return api_client.call_api(
            '/orders/{order_id}/authorization', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGOrderAuthenticatePayment(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, cf_payment_id : Annotated[StrictStr, Field(..., description="The Cashfree payment or transaction ID.")] = None, order_authenticate_payment_request : Annotated[OrderAuthenticatePaymentRequest, Field(..., description="Request body to submit/resend headless OTP. To use this API make sure you have headless OTP enabled for your account")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Submit or Resend OTP  # noqa: E501

        If you accept OTP on your own page, you can use the below API to send OTP to Cashfree.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGOrderAuthenticatePayment_with_http_info(x_api_version, cf_payment_id, order_authenticate_payment_request, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param cf_payment_id: The Cashfree payment or transaction ID. (required)
        :type cf_payment_id: str
        :param order_authenticate_payment_request: Request body to submit/resend headless OTP. To use this API make sure you have headless OTP enabled for your account (required)
        :type order_authenticate_payment_request: OrderAuthenticatePaymentRequest
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OrderAuthenticateEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'cf_payment_id',
            'order_authenticate_payment_request',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGOrderAuthenticatePayment" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['cf_payment_id']:
            _path_params['cf_payment_id'] = _params['cf_payment_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['order_authenticate_payment_request'] is not None:
            _body_params = _params['order_authenticate_payment_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "OrderAuthenticateEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
            '502': "ApiError502",
        }

        return api_client.call_api(
            '/orders/pay/authenticate/{cf_payment_id}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGOrderFetchPayment(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, order_id : Annotated[StrictStr, Field(..., description="The id which uniquely identifies your order")] = None, cf_payment_id : Annotated[StrictStr, Field(..., description="The Cashfree payment or transaction ID.")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Payment by ID  # noqa: E501

        Use this API to view payment details of an order for a payment ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGOrderFetchPayment_with_http_info(x_api_version, order_id, cf_payment_id, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param order_id: The id which uniquely identifies your order (required)
        :type order_id: str
        :param cf_payment_id: The Cashfree payment or transaction ID. (required)
        :type cf_payment_id: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PaymentEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'order_id',
            'cf_payment_id',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGOrderFetchPayment" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['order_id']:
            _path_params['order_id'] = _params['order_id']

        if _params['cf_payment_id']:
            _path_params['cf_payment_id'] = _params['cf_payment_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "PaymentEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
            '502': "ApiError502",
        }

        return api_client.call_api(
            '/orders/{order_id}/payments/{cf_payment_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGOrderFetchPayments(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, order_id : Annotated[StrictStr, Field(..., description="The id which uniquely identifies your order")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Payments for an Order  # noqa: E501

        Use this API to view all payment details for an order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGOrderFetchPayments_with_http_info(x_api_version, order_id, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param order_id: The id which uniquely identifies your order (required)
        :type order_id: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[PaymentEntity], status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'order_id',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGOrderFetchPayments" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['order_id']:
            _path_params['order_id'] = _params['order_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "List[PaymentEntity]",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
            '502': "ApiError502",
        }

        return api_client.call_api(
            '/orders/{order_id}/payments', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGPayOrder(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, pay_order_request : Annotated[PayOrderRequest, Field(..., description="Request body to create a transaction at cashfree using `payment_session_id`")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Order Pay  # noqa: E501

        Use this API when you have already created the orders and want Cashfree to process the payment. To use this API S2S flag needs to be enabled from the backend. In case you want to use the cards payment option the PCI DSS flag is required, for more information send an email to \"care@cashfree.com\".   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGPayOrder_with_http_info(x_api_version, pay_order_request, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param pay_order_request: Request body to create a transaction at cashfree using `payment_session_id` (required)
        :type pay_order_request: PayOrderRequest
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PayOrderEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'pay_order_request',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGPayOrder" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['pay_order_request'] is not None:
            _body_params = _params['pay_order_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = []  # noqa: E501

        _response_types_map = {
            '200': "PayOrderEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
            '502': "ApiError502",
        }

        return api_client.call_api(
            '/orders/sessions', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def PGOrderCreateRefund(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, order_id : Annotated[StrictStr, Field(..., description="The id which uniquely identifies your order")] = None, order_create_refund_request : Annotated[OrderCreateRefundRequest, Field(..., description="Request Body to Create Refunds")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create Refund  # noqa: E501

        Use this API to initiate refunds.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGOrderCreateRefund_with_http_info(x_api_version, order_id, order_create_refund_request, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param order_id: The id which uniquely identifies your order (required)
        :type order_id: str
        :param order_create_refund_request: Request Body to Create Refunds (required)
        :type order_create_refund_request: OrderCreateRefundRequest
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RefundEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'order_id',
            'order_create_refund_request',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGOrderCreateRefund" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['order_id']:
            _path_params['order_id'] = _params['order_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['order_create_refund_request'] is not None:
            _body_params = _params['order_create_refund_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "RefundEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
            '502': "ApiError502",
        }

        return api_client.call_api(
            '/orders/{order_id}/refunds', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGOrderFetchRefund(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, order_id : Annotated[StrictStr, Field(..., description="The id which uniquely identifies your order")] = None, refund_id : Annotated[StrictStr, Field(..., description="Refund Id of the refund you want to fetch.")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Refund  # noqa: E501

        Use this API to fetch a specific refund processed on your Cashfree Account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGOrderFetchRefund_with_http_info(x_api_version, order_id, refund_id, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param order_id: The id which uniquely identifies your order (required)
        :type order_id: str
        :param refund_id: Refund Id of the refund you want to fetch. (required)
        :type refund_id: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RefundEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'order_id',
            'refund_id',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGOrderFetchRefund" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['order_id']:
            _path_params['order_id'] = _params['order_id']

        if _params['refund_id']:
            _path_params['refund_id'] = _params['refund_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "RefundEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
            '502': "ApiError502",
        }

        return api_client.call_api(
            '/orders/{order_id}/refunds/{refund_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGOrderFetchRefunds(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, order_id : Annotated[StrictStr, Field(..., description="The id which uniquely identifies your order")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get All Refunds for an Order  # noqa: E501

        Use this API to fetch all refunds processed against an order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGOrderFetchRefunds_with_http_info(x_api_version, order_id, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param order_id: The id which uniquely identifies your order (required)
        :type order_id: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[RefundEntity], status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'order_id',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGOrderFetchRefunds" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['order_id']:
            _path_params['order_id'] = _params['order_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "List[RefundEntity]",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
        }

        return api_client.call_api(
            '/orders/{order_id}/refunds', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def PGFetchSettlements(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, fetch_settlements_request : Annotated[FetchSettlementsRequest, Field(..., description="Request Body to get the settlements")] = None, content_type : Annotated[Optional[StrictStr], Field(description="application/json")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, accept : Annotated[Optional[StrictStr], Field(description="application/json")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get All Settlements  # noqa: E501

        Use this API to get all settlement details by specifying the settlement ID, settlement UTR or date range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGFetchSettlements_with_http_info(x_api_version, fetch_settlements_request, content_type, x_request_id, x_idempotency_key, accept, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param fetch_settlements_request: Request Body to get the settlements (required)
        :type fetch_settlements_request: FetchSettlementsRequest
        :param content_type: application/json
        :type content_type: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param accept: application/json
        :type accept: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SettlementEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'fetch_settlements_request',
            'content_type',
            'x_request_id',
            'x_idempotency_key',
            'accept'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGFetchSettlements" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['fetch_settlements_request'] is not None:
            _body_params = _params['fetch_settlements_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "SettlementEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
        }

        return api_client.call_api(
            '/settlements', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGSettlementFetchRecon(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, settlement_fetch_recon_request : Annotated[SettlementFetchReconRequest, Field(..., description="Request Body for the settlement reconciliation")] = None, content_type : Annotated[Optional[StrictStr], Field(description="application/json")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, accept : Annotated[Optional[StrictStr], Field(description="application/json")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Settlement Reconciliation  # noqa: E501

        - Use this API to get settlement reconciliation details using Settlement ID, settlement UTR or date range. - This API will return events for the settlement IDs you want   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGSettlementFetchRecon_with_http_info(x_api_version, settlement_fetch_recon_request, content_type, x_request_id, x_idempotency_key, accept, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param settlement_fetch_recon_request: Request Body for the settlement reconciliation (required)
        :type settlement_fetch_recon_request: SettlementFetchReconRequest
        :param content_type: application/json
        :type content_type: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param accept: application/json
        :type accept: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SettlementReconEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'settlement_fetch_recon_request',
            'content_type',
            'x_request_id',
            'x_idempotency_key',
            'accept'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGSettlementFetchRecon" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['settlement_fetch_recon_request'] is not None:
            _body_params = _params['settlement_fetch_recon_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "SettlementReconEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
        }

        return api_client.call_api(
            '/settlement/recon', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def PGOrderFetchSettlement(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, order_id : Annotated[StrictStr, Field(..., description="The id which uniquely identifies your order")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Settlements by Order ID  # noqa: E501

        Use this API to view all the settlements of a particular order.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGOrderFetchSettlement_with_http_info(x_api_version, order_id, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param order_id: The id which uniquely identifies your order (required)
        :type order_id: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SettlementEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'order_id',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGOrderFetchSettlement" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['order_id']:
            _path_params['order_id'] = _params['order_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "SettlementEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
            '502': "ApiError502",
        }

        return api_client.call_api(
            '/orders/{order_id}/settlements', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def PGCustomerDeleteInstrument(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, customer_id : Annotated[StrictStr, Field(..., description="Your Customer ID that you had sent during create order API `POST/orders`")] = None, instrument_id : Annotated[StrictStr, Field(..., description="The instrument_id which needs to be deleted")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Delete Saved Card Instrument  # noqa: E501

        Use this API to delete a saved card instrument for a customer_id and instrument_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGCustomerDeleteInstrument_with_http_info(x_api_version, customer_id, instrument_id, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param customer_id: Your Customer ID that you had sent during create order API `POST/orders` (required)
        :type customer_id: str
        :param instrument_id: The instrument_id which needs to be deleted (required)
        :type instrument_id: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InstrumentEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'customer_id',
            'instrument_id',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGCustomerDeleteInstrument" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        if _params['instrument_id']:
            _path_params['instrument_id'] = _params['instrument_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "InstrumentEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
            '502': "ApiError502",
        }

        return api_client.call_api(
            '/customers/{customer_id}/instruments/{instrument_id}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGCustomerFetchInstrument(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, customer_id : Annotated[StrictStr, Field(..., description="Your Customer ID that you had sent during create order API `POST/orders`")] = None, instrument_id : Annotated[StrictStr, Field(..., description="The instrument_id of the saved instrument which needs to be queried")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Fetch Specific Saved Card Instrument  # noqa: E501

        Use this API to fetch a single specific saved card for a customer_id by it's instrument_id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGCustomerFetchInstrument_with_http_info(x_api_version, customer_id, instrument_id, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param customer_id: Your Customer ID that you had sent during create order API `POST/orders` (required)
        :type customer_id: str
        :param instrument_id: The instrument_id of the saved instrument which needs to be queried (required)
        :type instrument_id: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(InstrumentEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'customer_id',
            'instrument_id',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGCustomerFetchInstrument" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        if _params['instrument_id']:
            _path_params['instrument_id'] = _params['instrument_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "InstrumentEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
            '502': "ApiError502",
        }

        return api_client.call_api(
            '/customers/{customer_id}/instruments/{instrument_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGCustomerFetchInstruments(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, customer_id : Annotated[StrictStr, Field(..., description="Your Customer ID that you had sent during create order API `POST/orders`")] = None, instrument_type : Annotated[StrictStr, Field(..., description="Payment mode or type of saved instrument ")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Fetch All Saved Card Instrument  # noqa: E501

        Use this API to fetch saved cards for a customer_id   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGCustomerFetchInstruments_with_http_info(x_api_version, customer_id, instrument_type, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param customer_id: Your Customer ID that you had sent during create order API `POST/orders` (required)
        :type customer_id: str
        :param instrument_type: Payment mode or type of saved instrument  (required)
        :type instrument_type: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[InstrumentEntity], status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'customer_id',
            'instrument_type',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGCustomerFetchInstruments" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']


        # process the query parameters
        _query_params = []
        if _params.get('instrument_type') is not None:  # noqa: E501
            _query_params.append(('instrument_type', _params['instrument_type']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "List[InstrumentEntity]",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
        }

        return api_client.call_api(
            '/customers/{customer_id}/instruments', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def PGCustomerInstrumentsFetchCryptogram(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, customer_id : Annotated[StrictStr, Field(..., description="Your Customer ID that you had sent during create order API `POST/orders`")] = None, instrument_id : Annotated[StrictStr, Field(..., description="The instrument_id of the saved card instrument which needs to be queried")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Fetch cryptogram for a saved card instrument  # noqa: E501

        Use this API To get the card network token, token expiry and cryptogram for a saved card instrument using instrument id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.PGCustomerInstrumentsFetchCryptogram_with_http_info(x_api_version, customer_id, instrument_id, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param customer_id: Your Customer ID that you had sent during create order API `POST/orders` (required)
        :type customer_id: str
        :param instrument_id: The instrument_id of the saved card instrument which needs to be queried (required)
        :type instrument_id: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CryptogramEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'customer_id',
            'instrument_id',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method PGCustomerInstrumentsFetchCryptogram" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['customer_id']:
            _path_params['customer_id'] = _params['customer_id']

        if _params['instrument_id']:
            _path_params['instrument_id'] = _params['instrument_id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "CryptogramEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
            '502': "ApiError502",
        }

        return api_client.call_api(
            '/customers/{customer_id}/instruments/{instrument_id}/cryptogram', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def SposCreateTerminal(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, create_terminal_request : Annotated[CreateTerminalRequest, Field(..., description="Request Body to Create Terminal for SPOS")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create Terminal  # noqa: E501

        Use this API to create new terminals to use softPOS.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.SposCreateTerminal_with_http_info(x_api_version, create_terminal_request, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param create_terminal_request: Request Body to Create Terminal for SPOS (required)
        :type create_terminal_request: CreateTerminalRequest
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TerminalEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'create_terminal_request',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method SposCreateTerminal" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_terminal_request'] is not None:
            _body_params = _params['create_terminal_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "TerminalEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
        }

        return api_client.call_api(
            '/terminal', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def SposCreateTerminalTransaction(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, create_terminal_transaction_request : Annotated[CreateTerminalTransactionRequest, Field(..., description="Request body to create a terminal transaction")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Create Terminal  # noqa: E501

        Use this API to create a new terminal transaction. To use this API you should first create an order using the Create Order API. Also, you need to enter the terminal details while creating the order and pass the same terminal information while creating a transaction using the below mentioned API.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.SposCreateTerminalTransaction_with_http_info(x_api_version, create_terminal_transaction_request, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param create_terminal_transaction_request: Request body to create a terminal transaction (required)
        :type create_terminal_transaction_request: CreateTerminalTransactionRequest
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TerminalTransactionEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'create_terminal_transaction_request',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method SposCreateTerminalTransaction" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_terminal_transaction_request'] is not None:
            _body_params = _params['create_terminal_transaction_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "TerminalTransactionEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
        }

        return api_client.call_api(
            '/terminal/transactions', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def SposFetchTerminal(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, terminal_phone_no : Annotated[StrictStr, Field(..., description="The terminal for which you want to view the order details.")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get terminal status using phone number  # noqa: E501

        Use this API to view all details of a terminal.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.SposFetchTerminal_with_http_info(x_api_version, terminal_phone_no, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param terminal_phone_no: The terminal for which you want to view the order details. (required)
        :type terminal_phone_no: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TerminalEntity, status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'terminal_phone_no',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method SposFetchTerminal" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['terminal_phone_no']:
            _path_params['terminal_phone_no'] = _params['terminal_phone_no']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "TerminalEntity",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
        }

        return api_client.call_api(
            '/terminal/{terminal_phone_no}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
    @validate_arguments
    def SposFetchTerminalQrCodes(self, x_api_version : Annotated[StrictStr, Field(..., description="API version to be used. Format is in YYYY-MM-DD")] = None, terminal_phone_no : Annotated[StrictStr, Field(..., description="Phone number assigned to the terminal. Required if you are not providing the cf_terminal_id in the request.")] = None, cf_terminal_id : Annotated[StrictStr, Field(..., description="Cashfree terminal id for which you want to get staticQRs. Required if you are not providing the terminal_phone_number in the request.")] = None, x_request_id : Annotated[Optional[StrictStr], Field(description="Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree")] = None, x_idempotency_key : Annotated[Optional[StrictStr], Field(description="An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Fetch Terminal QR Codes  # noqa: E501

        You can fetch all the StaticQRs corresponding to given terminal id or phone number. Provide either the terminal_phone_no or terminal_id in the request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.SposFetchTerminalQrCodes_with_http_info(x_api_version, terminal_phone_no, cf_terminal_id, x_request_id, x_idempotency_key, async_req=True)
        >>> result = thread.get()

        :param x_api_version: API version to be used. Format is in YYYY-MM-DD (required)
        :type x_api_version: str
        :param terminal_phone_no: Phone number assigned to the terminal. Required if you are not providing the cf_terminal_id in the request. (required)
        :type terminal_phone_no: str
        :param cf_terminal_id: Cashfree terminal id for which you want to get staticQRs. Required if you are not providing the terminal_phone_number in the request. (required)
        :type cf_terminal_id: str
        :param x_request_id: Request id for the API call. Can be used to resolve tech issues. Communicate this in your tech related queries to cashfree
        :type x_request_id: str
        :param x_idempotency_key: An idempotency key is a unique identifier you include with your API call. If the request fails or times out, you can safely retry it using the same key to avoid duplicate actions.
        :type x_idempotency_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(List[FetchTerminalQRCodesEntity], status_code(int), headers(HTTPHeaderDict))
        """

        api_client = ApiClient.get_default()
        host = "https://api.cashfree.com/pg"
        if Cashfree.XEnvironment == CFEnvironment.SANDBOX:
            host = "https://sandbox.cashfree.com/pg"
        configuration = Configuration(
            host = host
        )
        configuration.api_key['XClientID'] = Cashfree.XClientId
        configuration.api_key['XClientSecret'] = Cashfree.XClientSecret
        configuration.api_key['XClientSignature'] = Cashfree.XClientSignature
        configuration.api_key['XPartnerMerchantId'] = Cashfree.XPartnerMerchantId
        configuration.api_key['XPartnerKey'] = Cashfree.XPartnerKey
        api_client.configuration = configuration
        _params = locals()

        _all_params = [
            'x_api_version',
            'terminal_phone_no',
            'cf_terminal_id',
            'x_request_id',
            'x_idempotency_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method SposFetchTerminalQrCodes" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('terminal_phone_no') is not None:  # noqa: E501
            _query_params.append(('terminal_phone_no', _params['terminal_phone_no']))

        if _params.get('cf_terminal_id') is not None:  # noqa: E501
            _query_params.append(('cf_terminal_id', _params['cf_terminal_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        if x_request_id:
            _header_params["x-request-id"] = x_request_id

        if x_api_version:
            _header_params["x-api-version"] = x_api_version

        if x_idempotency_key:
            _header_params["x-idempotency-key"] = x_idempotency_key
        _header_params["x-sdk-platform"] = "pythonsdk-3.1.3"

        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['XPartnerAPIKey', 'XClientSecret', 'XPartnerMerchantID', 'XClientID', 'XClientSignatureHeader']  # noqa: E501

        _response_types_map = {
            '200': "List[FetchTerminalQRCodesEntity]",
            '400': "BadRequestError",
            '401': "AuthenticationError",
            '404': "ApiError404",
            '409': "ApiError409",
            '422': "IdempotencyError",
            '429': "RateLimitError",
            '500': "ApiError",
        }

        return api_client.call_api(
            '/terminal/qrcodes', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))



class ApiClient(object):
    """Generic API client for OpenAPI client library builds.

    OpenAPI generic API client. This client handles the client-
    server communication, and is invariant across implementations. Specifics of
    the methods and models for each application are generated from the OpenAPI
    templates.

    :param configuration: .Configuration object for this client
    :param header_name: a header to pass when making calls to the API.
    :param header_value: a header value to pass when making calls to
        the API.
    :param cookie: a cookie to include in the header when making calls
        to the API
    :param pool_threads: The number of threads to use for async requests
        to the API. More threads means more concurrent API requests.
    """

    PRIMITIVE_TYPES = (float, bool, bytes, str, int)
    NATIVE_TYPES_MAPPING = {
        'int': int,
        'long': int, # TODO remove as only py3 is supported?
        'float': float,
        'str': str,
        'bool': bool,
        'date': dt.date,
        'datetime': dt.datetime,
        'object': object,
    }
    _pool = None

    def __init__(self, configuration=None, header_name=None, header_value=None,
                 cookie=None, pool_threads=1):
        # use default configuration if none is provided
        if configuration is None:
            configuration = Configuration.get_default()
        self.configuration = configuration
        self.pool_threads = pool_threads

        self.rest_client = rest.RESTClientObject(configuration)
        self.default_headers = {}
        if header_name is not None:
            self.default_headers[header_name] = header_value
        self.cookie = cookie
        # Set default User-Agent.
        self.user_agent = 'OpenAPI-Generator/3.1.3/python'
        self.client_side_validation = configuration.client_side_validation

    def __enter__(self):
        return self

    def __exit__(self, exc_type, exc_value, traceback):
        self.close()

    def close(self):
        if self._pool:
            self._pool.close()
            self._pool.join()
            self._pool = None
            if hasattr(atexit, 'unregister'):
                atexit.unregister(self.close)

    @property
    def pool(self):
        """Create thread pool on first request
         avoids instantiating unused threadpool for blocking clients.
        """
        if self._pool is None:
            atexit.register(self.close)
            self._pool = ThreadPool(self.pool_threads)
        return self._pool

    @property
    def user_agent(self):
        """User agent for this API client"""
        return self.default_headers['User-Agent']

    @user_agent.setter
    def user_agent(self, value):
        self.default_headers['User-Agent'] = value

    def set_default_header(self, header_name, header_value):
        self.default_headers[header_name] = header_value


    _default = None

    @classmethod
    def get_default(cls):
        """Return new instance of ApiClient.

        This method returns newly created, based on default constructor,
        object of ApiClient class or returns a copy of default
        ApiClient.

        :return: The ApiClient object.
        """
        if cls._default is None:
            cls._default = ApiClient()
        return cls._default

    @classmethod
    def set_default(cls, default):
        """Set default instance of ApiClient.

        It stores default ApiClient.

        :param default: object of ApiClient.
        """
        cls._default = default

    def __call_api(
            self, resource_path, method, path_params=None,
            query_params=None, header_params=None, body=None, post_params=None,
            files=None, response_types_map=None, auth_settings=None,
            _return_http_data_only=None, collection_formats=None,
            _preload_content=True, _request_timeout=None, _host=None,
            _request_auth=None):

        config = self.configuration

        # header parameters
        header_params = header_params or {}
        header_params.update(self.default_headers)
        if self.cookie:
            header_params['Cookie'] = self.cookie
        if header_params:
            header_params = self.sanitize_for_serialization(header_params)
            header_params = dict(self.parameters_to_tuples(header_params,
                                                           collection_formats))

        # path parameters
        if path_params:
            path_params = self.sanitize_for_serialization(path_params)
            path_params = self.parameters_to_tuples(path_params,
                                                    collection_formats)
            for k, v in path_params:
                # specified safe chars, encode everything
                resource_path = resource_path.replace(
                    '{%s}' % k,
                    quote(str(v), safe=config.safe_chars_for_path_param)
                )

        # post parameters
        if post_params or files:
            post_params = post_params if post_params else []
            post_params = self.sanitize_for_serialization(post_params)
            post_params = self.parameters_to_tuples(post_params,
                                                    collection_formats)
            post_params.extend(self.files_parameters(files))

        # auth setting
        self.update_params_for_auth(
            header_params, query_params, auth_settings,
            resource_path, method, body,
            request_auth=_request_auth)

        # body
        if body:
            body = self.sanitize_for_serialization(body)

        # request url
        if _host is None:
            url = self.configuration.host + resource_path
        else:
            # use server/host defined in path or operation instead
            url = _host + resource_path

        # query parameters
        if query_params:
            query_params = self.sanitize_for_serialization(query_params)
            url_query = self.parameters_to_url_query(query_params,
                                                     collection_formats)
            url += "?" + url_query

        try:
            # perform request and return response
            response_data = self.request(
                method, url,
                query_params=query_params,
                headers=header_params,
                post_params=post_params, body=body,
                _preload_content=_preload_content,
                _request_timeout=_request_timeout)
        except ApiException as e:
            if e.body:
                e.body = e.body.decode('utf-8')
            raise e

        self.last_response = response_data

        return_data = None # assuming derialization is not needed
        # data needs deserialization or returns HTTP data (deserialized) only
        if _preload_content or _return_http_data_only:
          response_type = response_types_map.get(str(response_data.status), None)

          if response_type == "bytearray":
              response_data.data = response_data.data
          else:
              match = None
              content_type = response_data.getheader('content-type')
              if content_type is not None:
                  match = re.search(r"charset=([a-zA-Z\-\d]+)[\s;]?", content_type)
              encoding = match.group(1) if match else "utf-8"
              response_data.data = response_data.data.decode(encoding)

          # deserialize response data
          if response_type == "bytearray":
              return_data = response_data.data
          elif response_type:
              return_data = self.deserialize(response_data, response_type)
          else:
              return_data = None

        if _return_http_data_only:
            return return_data
        else:
            return ApiResponse(status_code = response_data.status,
                           data = return_data,
                           headers = response_data.getheaders(),
                           raw_data = response_data.data)

    def sanitize_for_serialization(self, obj):
        """Builds a JSON POST object.

        If obj is None, return None.
        If obj is str, int, long, float, bool, return directly.
        If obj is datetime.datetime, datetime.date
            convert to string in iso8601 format.
        If obj is list, sanitize each element in the list.
        If obj is dict, return the dict.
        If obj is OpenAPI model, return the properties dict.

        :param obj: The data to serialize.
        :return: The serialized form of data.
        """
        if obj is None:
            return None
        elif isinstance(obj, self.PRIMITIVE_TYPES):
            return obj
        elif isinstance(obj, list):
            return [self.sanitize_for_serialization(sub_obj)
                    for sub_obj in obj]
        elif isinstance(obj, tuple):
            return tuple(self.sanitize_for_serialization(sub_obj)
                         for sub_obj in obj)
        elif isinstance(obj, (dt.datetime, dt.date)):
            return obj.isoformat()

        if isinstance(obj, dict):
            obj_dict = obj
        else:
            # Convert model obj to dict except
            # attributes `openapi_types`, `attribute_map`
            # and attributes which value is not None.
            # Convert attribute name to json key in
            # model definition for request.
            obj_dict = obj.to_dict()

        return {key: self.sanitize_for_serialization(val)
                for key, val in obj_dict.items()}

    def deserialize(self, response, response_type):
        """Deserializes response into an object.

        :param response: RESTResponse object to be deserialized.
        :param response_type: class literal for
            deserialized object, or string of class name.

        :return: deserialized object.
        """
        # handle file downloading
        # save response body into a tmp file and return the instance
        if response_type == "file":
            return self.__deserialize_file(response)

        # fetch data from response object
        try:
            data = json.loads(response.data)
        except ValueError:
            data = response.data

        return self.__deserialize(data, response_type)

    def __deserialize(self, data, klass):
        """Deserializes dict, list, str into an object.

        :param data: dict, list or str.
        :param klass: class literal, or string of class name.

        :return: object.
        """
        if data is None:
            return None

        if type(klass) == str:
            if klass.startswith('List['):
                sub_kls = re.match(r'List\[(.*)]', klass).group(1)
                return [self.__deserialize(sub_data, sub_kls)
                        for sub_data in data]

            if klass.startswith('Dict['):
                sub_kls = re.match(r'Dict\[([^,]*), (.*)]', klass).group(2)
                return {k: self.__deserialize(v, sub_kls)
                        for k, v in data.items()}

            # convert str to class
            if klass in self.NATIVE_TYPES_MAPPING:
                klass = self.NATIVE_TYPES_MAPPING[klass]
            else:
                klass = getattr(cashfree_pg.models, klass)

        if klass in self.PRIMITIVE_TYPES:
            return self.__deserialize_primitive(data, klass)
        elif klass == object:
            return self.__deserialize_object(data)
        elif klass == dt.date:
            return self.__deserialize_date(data)
        elif klass == dt.datetime:
            return self.__deserialize_datetime(data)
        else:
            return self.__deserialize_model(data, klass)

    def call_api(self, resource_path, method,
                 path_params=None, query_params=None, header_params=None,
                 body=None, post_params=None, files=None,
                 response_types_map=None, auth_settings=None,
                 async_req=None, _return_http_data_only=None,
                 collection_formats=None, _preload_content=True,
                 _request_timeout=None, _host=None, _request_auth=None):
        """Makes the HTTP request (synchronous) and returns deserialized data.

        To make an async_req request, set the async_req parameter.

        :param resource_path: Path to method endpoint.
        :param method: Method to call.
        :param path_params: Path parameters in the url.
        :param query_params: Query parameters in the url.
        :param header_params: Header parameters to be
            placed in the request header.
        :param body: Request body.
        :param post_params dict: Request post form parameters,
            for `application/x-www-form-urlencoded`, `multipart/form-data`.
        :param auth_settings list: Auth Settings names for the request.
        :param response: Response data type.
        :param files dict: key -> filename, value -> filepath,
            for `multipart/form-data`.
        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :param collection_formats: dict of collection formats for path, query,
            header, and post parameters.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_token: dict, optional
        :return:
            If async_req parameter is True,
            the request will be called asynchronously.
            The method will return the request thread.
            If parameter async_req is False or missing,
            then the method will return the response directly.
        """
        if not async_req:
            return self.__call_api(resource_path, method,
                                   path_params, query_params, header_params,
                                   body, post_params, files,
                                   response_types_map, auth_settings,
                                   _return_http_data_only, collection_formats,
                                   _preload_content, _request_timeout, _host,
                                   _request_auth)

        return self.pool.apply_async(self.__call_api, (resource_path,
                                                       method, path_params,
                                                       query_params,
                                                       header_params, body,
                                                       post_params, files,
                                                       response_types_map,
                                                       auth_settings,
                                                       _return_http_data_only,
                                                       collection_formats,
                                                       _preload_content,
                                                       _request_timeout,
                                                       _host, _request_auth))

    def request(self, method, url, query_params=None, headers=None,
                post_params=None, body=None, _preload_content=True,
                _request_timeout=None):
        """Makes the HTTP request using RESTClient."""
        if method == "GET":
            return self.rest_client.get_request(url,
                                        query_params=query_params,
                                        _preload_content=_preload_content,
                                        _request_timeout=_request_timeout,
                                        headers=headers)
        elif method == "HEAD":
            return self.rest_client.head_request(url,
                                         query_params=query_params,
                                         _preload_content=_preload_content,
                                         _request_timeout=_request_timeout,
                                         headers=headers)
        elif method == "OPTIONS":
            return self.rest_client.options_request(url,
                                            query_params=query_params,
                                            headers=headers,
                                            _preload_content=_preload_content,
                                            _request_timeout=_request_timeout)
        elif method == "POST":
            return self.rest_client.post_request(url,
                                         query_params=query_params,
                                         headers=headers,
                                         post_params=post_params,
                                         _preload_content=_preload_content,
                                         _request_timeout=_request_timeout,
                                         body=body)
        elif method == "PUT":
            return self.rest_client.put_request(url,
                                        query_params=query_params,
                                        headers=headers,
                                        post_params=post_params,
                                        _preload_content=_preload_content,
                                        _request_timeout=_request_timeout,
                                        body=body)
        elif method == "PATCH":
            return self.rest_client.patch_request(url,
                                          query_params=query_params,
                                          headers=headers,
                                          post_params=post_params,
                                          _preload_content=_preload_content,
                                          _request_timeout=_request_timeout,
                                          body=body)
        elif method == "DELETE":
            return self.rest_client.delete_request(url,
                                           query_params=query_params,
                                           headers=headers,
                                           _preload_content=_preload_content,
                                           _request_timeout=_request_timeout,
                                           body=body)
        else:
            raise ApiValueError(
                "http method must be `GET`, `HEAD`, `OPTIONS`,"
                " `POST`, `PATCH`, `PUT` or `DELETE`."
            )

    def parameters_to_tuples(self, params, collection_formats):
        """Get parameters as list of tuples, formatting collections.

        :param params: Parameters as dict or list of two-tuples
        :param dict collection_formats: Parameter collection formats
        :return: Parameters as list of tuples, collections formatted
        """
        new_params = []
        if collection_formats is None:
            collection_formats = {}
        for k, v in params.items() if isinstance(params, dict) else params:  # noqa: E501
            if k in collection_formats:
                collection_format = collection_formats[k]
                if collection_format == 'multi':
                    new_params.extend((k, value) for value in v)
                else:
                    if collection_format == 'ssv':
                        delimiter = ' '
                    elif collection_format == 'tsv':
                        delimiter = '\t'
                    elif collection_format == 'pipes':
                        delimiter = '|'
                    else:  # csv is the default
                        delimiter = ','
                    new_params.append(
                        (k, delimiter.join(str(value) for value in v)))
            else:
                new_params.append((k, v))
        return new_params

    def parameters_to_url_query(self, params, collection_formats):
        """Get parameters as list of tuples, formatting collections.

        :param params: Parameters as dict or list of two-tuples
        :param dict collection_formats: Parameter collection formats
        :return: URL query string (e.g. a=Hello%20World&b=123)
        """
        new_params = []
        if collection_formats is None:
            collection_formats = {}
        for k, v in params.items() if isinstance(params, dict) else params:  # noqa: E501
            if isinstance(v, (int, float)):
                v = str(v)
            if isinstance(v, bool):
                v = str(v).lower()
            if isinstance(v, dict):
                v = json.dumps(v)

            if k in collection_formats:
                collection_format = collection_formats[k]
                if collection_format == 'multi':
                    new_params.extend((k, value) for value in v)
                else:
                    if collection_format == 'ssv':
                        delimiter = ' '
                    elif collection_format == 'tsv':
                        delimiter = '\t'
                    elif collection_format == 'pipes':
                        delimiter = '|'
                    else:  # csv is the default
                        delimiter = ','
                    new_params.append(
                        (k, delimiter.join(quote(str(value)) for value in v)))
            else:
                new_params.append((k, quote(str(v))))

        return "&".join(["=".join(item) for item in new_params])

    def files_parameters(self, files=None):
        """Builds form parameters.

        :param files: File parameters.
        :return: Form parameters with files.
        """
        params = []

        if files:
            for k, v in files.items():
                if not v:
                    continue
                file_names = v if type(v) is list else [v]
                for n in file_names:
                    with open(n, 'rb') as f:
                        filename = os.path.basename(f.name)
                        filedata = f.read()
                        mimetype = (mimetypes.guess_type(filename)[0] or
                                    'application/octet-stream')
                        params.append(
                            tuple([k, tuple([filename, filedata, mimetype])]))

        return params

    def select_header_accept(self, accepts):
        """Returns `Accept` based on an array of accepts provided.

        :param accepts: List of headers.
        :return: Accept (e.g. application/json).
        """
        if not accepts:
            return

        for accept in accepts:
            if re.search('json', accept, re.IGNORECASE):
                return accept

        return accepts[0]

    def select_header_content_type(self, content_types):
        """Returns `Content-Type` based on an array of content_types provided.

        :param content_types: List of content-types.
        :return: Content-Type (e.g. application/json).
        """
        if not content_types:
            return None

        for content_type in content_types:
            if re.search('json', content_type, re.IGNORECASE):
                return content_type

        return content_types[0]

    def update_params_for_auth(self, headers, queries, auth_settings,
                               resource_path, method, body,
                               request_auth=None):
        """Updates header and query params based on authentication setting.

        :param headers: Header parameters dict to be updated.
        :param queries: Query parameters tuple list to be updated.
        :param auth_settings: Authentication setting identifiers list.
        :resource_path: A string representation of the HTTP request resource path.
        :method: A string representation of the HTTP request method.
        :body: A object representing the body of the HTTP request.
        The object type is the return value of sanitize_for_serialization().
        :param request_auth: if set, the provided settings will
                             override the token in the configuration.
        """
        if not auth_settings:
            return

        if request_auth:
            self._apply_auth_params(headers, queries,
                                    resource_path, method, body,
                                    request_auth)
            return

        for auth in auth_settings:
            auth_setting = self.configuration.auth_settings().get(auth)
            if auth_setting:
                self._apply_auth_params(headers, queries,
                                        resource_path, method, body,
                                        auth_setting)

    def _apply_auth_params(self, headers, queries,
                           resource_path, method, body,
                           auth_setting):
        """Updates the request parameters based on a single auth_setting

        :param headers: Header parameters dict to be updated.
        :param queries: Query parameters tuple list to be updated.
        :resource_path: A string representation of the HTTP request resource path.
        :method: A string representation of the HTTP request method.
        :body: A object representing the body of the HTTP request.
        The object type is the return value of sanitize_for_serialization().
        :param auth_setting: auth settings for the endpoint
        """
        if auth_setting['in'] == 'cookie':
            headers['Cookie'] = auth_setting['value']
        elif auth_setting['in'] == 'header':
            if auth_setting['type'] != 'http-signature':
                headers[auth_setting['key']] = auth_setting['value']
        elif auth_setting['in'] == 'query':
            queries.append((auth_setting['key'], auth_setting['value']))
        else:
            raise ApiValueError(
                'Authentication token must be in `query` or `header`'
            )

    def __deserialize_file(self, response):
        """Deserializes body to file

        Saves response body into a file in a temporary folder,
        using the filename from the `Content-Disposition` header if provided.

        :param response:  RESTResponse.
        :return: file path.
        """
        fd, path = tempfile.mkstemp(dir=self.configuration.temp_folder_path)
        os.close(fd)
        os.remove(path)

        content_disposition = response.getheader("Content-Disposition")
        if content_disposition:
            filename = re.search(r'filename=[\'"]?([^\'"\s]+)[\'"]?',
                                 content_disposition).group(1)
            path = os.path.join(os.path.dirname(path), filename)

        with open(path, "wb") as f:
            f.write(response.data)

        return path

    def __deserialize_primitive(self, data, klass):
        """Deserializes string to primitive type.

        :param data: str.
        :param klass: class literal.

        :return: int, long, float, str, bool.
        """
        try:
            return klass(data)
        except UnicodeEncodeError:
            return str(data)
        except TypeError:
            return data

    def __deserialize_object(self, value):
        """Return an original value.

        :return: object.
        """
        return value

    def __deserialize_date(self, string):
        """Deserializes string to date.

        :param string: str.
        :return: date.
        """
        try:
            return parse(string).date()
        except ImportError:
            return string
        except ValueError:
            raise rest.ApiException(
                status=0,
                reason="Failed to parse `{0}` as date object".format(string)
            )

    def __deserialize_datetime(self, string):
        """Deserializes string to datetime.

        The string should be in iso8601 datetime format.

        :param string: str.
        :return: datetime.
        """
        try:
            return parse(string)
        except ImportError:
            return string
        except ValueError:
            raise rest.ApiException(
                status=0,
                reason=(
                    "Failed to parse `{0}` as datetime object"
                    .format(string)
                )
            )

    def __deserialize_model(self, data, klass):
        """Deserializes list or dict to model.

        :param data: dict, list.
        :param klass: class literal.
        :return: model object.
        """

        return klass.from_dict(data)
