# coding: utf-8

"""
    Cashfree Payment Gateway APIs

    Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.

    The version of the OpenAPI document: 2022-09-01
    Contact: developers@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictStr, validator

class App(BaseModel):
    """
    App payment method
    """
    channel: StrictStr = Field(..., description="Specify the channel through which the payment must be processed.")
    provider: StrictStr = Field(..., description="Specify the provider through which the payment must be processed.")
    phone: StrictStr = Field(..., description="Customer phone number associated with a wallet for payment.")
    __properties = ["channel", "provider", "phone"]

    @validator('provider')
    def provider_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('gpay', 'phonepe', 'ola', 'paytm', 'amazon', 'airtel', 'freecharge', 'mobikwik', 'jio'):
            raise ValueError("must be one of enum values ('gpay', 'phonepe', 'ola', 'paytm', 'amazon', 'airtel', 'freecharge', 'mobikwik', 'jio')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> App:
        """Create an instance of App from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> App:
        """Create an instance of App from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return App.parse_obj(obj)

        _obj = App.parse_obj({
            "channel": obj.get("channel"),
            "provider": obj.get("provider"),
            "phone": obj.get("phone")
        })
        return _obj


