# coding: utf-8

"""
    Cashfree Payment Gateway APIs

    Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.

    The version of the OpenAPI document: 2022-09-01
    Contact: developers@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, validator

class CardEMI(BaseModel):
    """
    Payment method for card emi
    """
    channel: StrictStr = Field(..., description="The channel for card payments will always be \"link\"")
    card_number: StrictStr = Field(..., description="Customer card number.")
    card_holder_name: Optional[StrictStr] = Field(None, description="Customer name mentioned on the card.")
    card_expiry_mm: StrictStr = Field(..., description="Card expiry month.")
    card_expiry_yy: StrictStr = Field(..., description="Card expiry year.")
    card_cvv: StrictStr = Field(..., description="CVV mentioned on the card.")
    card_alias: Optional[StrictStr] = Field(None, description="Card alias as returned by Cashfree Vault API")
    card_bank_name: StrictStr = Field(..., description="Card bank name, required for EMI payments. This is the bank user has selected for EMI. One of [\"hdfc, \"kotak\", \"icici\", \"rbl\", \"bob\", \"standard chartered\", \"axis\", \"au\", \"yes\", \"sbi\", \"fed\", \"hsbc\", \"citi\", \"amex\"]")
    emi_tenure: StrictInt = Field(..., description="EMI tenure selected by the user")
    __properties = ["channel", "card_number", "card_holder_name", "card_expiry_mm", "card_expiry_yy", "card_cvv", "card_alias", "card_bank_name", "emi_tenure"]

    @validator('card_bank_name')
    def card_bank_name_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('hdfc', 'kotak', 'icici', 'rbl', 'bob', 'standard chartered', 'axis', 'au', 'yes', 'sbi', 'fed', 'hsbc', 'citi', 'amex'):
            raise ValueError("must be one of enum values ('hdfc', 'kotak', 'icici', 'rbl', 'bob', 'standard chartered', 'axis', 'au', 'yes', 'sbi', 'fed', 'hsbc', 'citi', 'amex')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CardEMI:
        """Create an instance of CardEMI from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CardEMI:
        """Create an instance of CardEMI from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CardEMI.parse_obj(obj)

        _obj = CardEMI.parse_obj({
            "channel": obj.get("channel"),
            "card_number": obj.get("card_number"),
            "card_holder_name": obj.get("card_holder_name"),
            "card_expiry_mm": obj.get("card_expiry_mm"),
            "card_expiry_yy": obj.get("card_expiry_yy"),
            "card_cvv": obj.get("card_cvv"),
            "card_alias": obj.get("card_alias"),
            "card_bank_name": obj.get("card_bank_name"),
            "emi_tenure": obj.get("emi_tenure")
        })
        return _obj


