# coding: utf-8

"""
    Cashfree Payment Gateway APIs

    Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.

    The version of the OpenAPI document: 2022-09-01
    Contact: developers@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, constr
from cashfree_pg.models.create_terminal_request_terminal_meta import CreateTerminalRequestTerminalMeta

class CreateTerminalRequest(BaseModel):
    """
    Request body to create a terminal
    """
    terminal_id: constr(strict=True, max_length=100, min_length=3) = Field(..., description="merchant’s internal terminal id")
    terminal_phone_no: constr(strict=True, max_length=10, min_length=10) = Field(..., description="phone number assigned to the terminal")
    terminal_name: constr(strict=True, max_length=100, min_length=3) = Field(..., description="terminal name to be assigned by merchants")
    terminal_address: Optional[constr(strict=True, max_length=100, min_length=1)] = Field(None, description="address of the terminal. required for STOREFRONT")
    terminal_email: constr(strict=True, max_length=100, min_length=1) = Field(..., description="terminal email ID of the AGENT/STOREFRONT assigned by merchants.")
    terminal_note: Optional[constr(strict=True, max_length=100, min_length=1)] = Field(None, description="additional note for terminal")
    terminal_type: constr(strict=True, max_length=100, min_length=1) = Field(..., description="mention the terminal type. possible values - AGENT, STOREFRONT.")
    terminal_meta: Optional[CreateTerminalRequestTerminalMeta] = None
    __properties = ["terminal_id", "terminal_phone_no", "terminal_name", "terminal_address", "terminal_email", "terminal_note", "terminal_type", "terminal_meta"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateTerminalRequest:
        """Create an instance of CreateTerminalRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of terminal_meta
        if self.terminal_meta:
            _dict['terminal_meta'] = self.terminal_meta.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateTerminalRequest:
        """Create an instance of CreateTerminalRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateTerminalRequest.parse_obj(obj)

        _obj = CreateTerminalRequest.parse_obj({
            "terminal_id": obj.get("terminal_id"),
            "terminal_phone_no": obj.get("terminal_phone_no"),
            "terminal_name": obj.get("terminal_name"),
            "terminal_address": obj.get("terminal_address"),
            "terminal_email": obj.get("terminal_email"),
            "terminal_note": obj.get("terminal_note"),
            "terminal_type": obj.get("terminal_type"),
            "terminal_meta": CreateTerminalRequestTerminalMeta.from_dict(obj.get("terminal_meta")) if obj.get("terminal_meta") is not None else None
        })
        return _obj


