# coding: utf-8

"""
    Cashfree Payment Gateway APIs

    Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.

    The version of the OpenAPI document: 2022-09-01
    Contact: developers@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, StrictFloat, StrictInt, constr

class EMIPlansArray(BaseModel):
    """
    Single EMI object
    """
    tenure: Optional[StrictInt] = None
    interest_rate: Optional[Union[StrictFloat, StrictInt]] = None
    currency: Optional[constr(strict=True, max_length=50, min_length=3)] = None
    emi: Optional[StrictInt] = None
    total_interest: Optional[StrictInt] = None
    total_amount: Optional[StrictInt] = None
    __properties = ["tenure", "interest_rate", "currency", "emi", "total_interest", "total_amount"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EMIPlansArray:
        """Create an instance of EMIPlansArray from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EMIPlansArray:
        """Create an instance of EMIPlansArray from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return EMIPlansArray.parse_obj(obj)

        _obj = EMIPlansArray.parse_obj({
            "tenure": obj.get("tenure"),
            "interest_rate": obj.get("interest_rate"),
            "currency": obj.get("currency"),
            "emi": obj.get("emi"),
            "total_interest": obj.get("total_interest"),
            "total_amount": obj.get("total_amount")
        })
        return _obj


