# coding: utf-8

"""
    Cashfree Payment Gateway APIs

    Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.

    The version of the OpenAPI document: 2022-09-01
    Contact: developers@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictStr

class FetchReconRequestFilters(BaseModel):
    """
    FetchReconRequestFilters
    """
    start_date: StrictStr = Field(..., description="Specify the start date from when you want the settlement reconciliation details.")
    end_date: StrictStr = Field(..., description="Specify the end date till when you want the settlement reconciliation details.")
    __properties = ["start_date", "end_date"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FetchReconRequestFilters:
        """Create an instance of FetchReconRequestFilters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FetchReconRequestFilters:
        """Create an instance of FetchReconRequestFilters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FetchReconRequestFilters.parse_obj(obj)

        _obj = FetchReconRequestFilters.parse_obj({
            "start_date": obj.get("start_date"),
            "end_date": obj.get("end_date")
        })
        return _obj


