# coding: utf-8

"""
    Cashfree Payment Gateway APIs

    Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.

    The version of the OpenAPI document: 2022-09-01
    Contact: developers@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field
from cashfree_pg.models.emi_offer import EMIOffer

class OfferEMI(BaseModel):
    """
    EMI offer object
    """
    emi: EMIOffer = Field(...)
    __properties = ["emi"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OfferEMI:
        """Create an instance of OfferEMI from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of emi
        if self.emi:
            _dict['emi'] = self.emi.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OfferEMI:
        """Create an instance of OfferEMI from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return OfferEMI.parse_obj(obj)

        _obj = OfferEMI.parse_obj({
            "emi": EMIOffer.from_dict(obj.get("emi")) if obj.get("emi") is not None else None
        })
        return _obj


