# coding: utf-8

"""
    Cashfree Payment Gateway APIs

    Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.

    The version of the OpenAPI document: 2022-09-01
    Contact: developers@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr, validator
from cashfree_pg.models.order_pay_data import OrderPayData

class PayOrderEntity(BaseModel):
    """
    Order Pay response once you create a transaction for that order
    """
    payment_amount: Optional[Union[StrictFloat, StrictInt]] = Field(None, description="total amount payable")
    cf_payment_id: Optional[StrictInt] = Field(None, description="Payment identifier created by Cashfree")
    payment_method: Optional[StrictStr] = Field(None, description="One of [\"upi\", \"netbanking\", \"card\", \"app\", \"cardless_emi\", \"paylater\", \"banktransfer\"] ")
    channel: Optional[StrictStr] = Field(None, description="One of [\"link\", \"collect\", \"qrcode\"]. In an older version we used to support different channels like 'gpay', 'phonepe' etc. However, we now support only the following channels - link, collect and qrcode. To process payments using gpay, you will have to provide channel as 'link' and provider as 'gpay'")
    action: Optional[StrictStr] = Field(None, description="One of [\"link\", \"custom\", \"form\"]")
    data: Optional[OrderPayData] = None
    __properties = ["payment_amount", "cf_payment_id", "payment_method", "channel", "action", "data"]

    @validator('payment_method')
    def payment_method_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('netbanking', 'card', 'upi', 'app', 'cardless_emi', 'paylater', 'banktransfer'):
            raise ValueError("must be one of enum values ('netbanking', 'card', 'upi', 'app', 'cardless_emi', 'paylater', 'banktransfer')")
        return value

    @validator('channel')
    def channel_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('link', 'collect', 'qrcode', 'post'):
            raise ValueError("must be one of enum values ('link', 'collect', 'qrcode', 'post')")
        return value

    @validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('link', 'custom', 'form', 'post'):
            raise ValueError("must be one of enum values ('link', 'custom', 'form', 'post')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PayOrderEntity:
        """Create an instance of PayOrderEntity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of data
        if self.data:
            _dict['data'] = self.data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PayOrderEntity:
        """Create an instance of PayOrderEntity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PayOrderEntity.parse_obj(obj)

        _obj = PayOrderEntity.parse_obj({
            "payment_amount": obj.get("payment_amount"),
            "cf_payment_id": obj.get("cf_payment_id"),
            "payment_method": obj.get("payment_method"),
            "channel": obj.get("channel"),
            "action": obj.get("action"),
            "data": OrderPayData.from_dict(obj.get("data")) if obj.get("data") is not None else None
        })
        return _obj


