# coding: utf-8

"""
    Cashfree Payment Gateway APIs

    Cashfree's Payment Gateway APIs provide developers with a streamlined pathway to integrate advanced payment processing capabilities into their applications, platforms and websites.

    The version of the OpenAPI document: 2022-09-01
    Contact: developers@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from cashfree_pg.models.payment_method_app_in_payments_entity import PaymentMethodAppInPaymentsEntity
from cashfree_pg.models.payment_method_card_in_payments_entity import PaymentMethodCardInPaymentsEntity
from cashfree_pg.models.payment_method_cardless_emiin_payments_entity import PaymentMethodCardlessEMIInPaymentsEntity
from cashfree_pg.models.payment_method_net_banking_in_payments_entity import PaymentMethodNetBankingInPaymentsEntity
from cashfree_pg.models.payment_method_paylater_in_payments_entity import PaymentMethodPaylaterInPaymentsEntity
from cashfree_pg.models.payment_method_upiin_payments_entity import PaymentMethodUPIInPaymentsEntity
from typing import Union, Any, List, TYPE_CHECKING
from pydantic import StrictStr, Field

PAYMENTMETHODINPAYMENTSENTITYPAYMENTMETHOD_ONE_OF_SCHEMAS = ["PaymentMethodAppInPaymentsEntity", "PaymentMethodCardInPaymentsEntity", "PaymentMethodCardlessEMIInPaymentsEntity", "PaymentMethodNetBankingInPaymentsEntity", "PaymentMethodPaylaterInPaymentsEntity", "PaymentMethodUPIInPaymentsEntity"]

class PaymentMethodInPaymentsEntityPaymentMethod(BaseModel):
    """
    PaymentMethodInPaymentsEntityPaymentMethod
    """
    # data type: PaymentMethodCardInPaymentsEntity
    oneof_schema_1_validator: Optional[PaymentMethodCardInPaymentsEntity] = None
    # data type: PaymentMethodNetBankingInPaymentsEntity
    oneof_schema_2_validator: Optional[PaymentMethodNetBankingInPaymentsEntity] = None
    # data type: PaymentMethodUPIInPaymentsEntity
    oneof_schema_3_validator: Optional[PaymentMethodUPIInPaymentsEntity] = None
    # data type: PaymentMethodAppInPaymentsEntity
    oneof_schema_4_validator: Optional[PaymentMethodAppInPaymentsEntity] = None
    # data type: PaymentMethodCardlessEMIInPaymentsEntity
    oneof_schema_5_validator: Optional[PaymentMethodCardlessEMIInPaymentsEntity] = None
    # data type: PaymentMethodPaylaterInPaymentsEntity
    oneof_schema_6_validator: Optional[PaymentMethodPaylaterInPaymentsEntity] = None
    if TYPE_CHECKING:
        actual_instance: Union[PaymentMethodAppInPaymentsEntity, PaymentMethodCardInPaymentsEntity, PaymentMethodCardlessEMIInPaymentsEntity, PaymentMethodNetBankingInPaymentsEntity, PaymentMethodPaylaterInPaymentsEntity, PaymentMethodUPIInPaymentsEntity]
    else:
        actual_instance: Any
    one_of_schemas: List[str] = Field(PAYMENTMETHODINPAYMENTSENTITYPAYMENTMETHOD_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    def __init__(self, *args, **kwargs):
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = PaymentMethodInPaymentsEntityPaymentMethod.construct()
        error_messages = []
        match = 0
        # validate data type: PaymentMethodCardInPaymentsEntity
        if not isinstance(v, PaymentMethodCardInPaymentsEntity):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaymentMethodCardInPaymentsEntity`")
        else:
            match += 1
        # validate data type: PaymentMethodNetBankingInPaymentsEntity
        if not isinstance(v, PaymentMethodNetBankingInPaymentsEntity):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaymentMethodNetBankingInPaymentsEntity`")
        else:
            match += 1
        # validate data type: PaymentMethodUPIInPaymentsEntity
        if not isinstance(v, PaymentMethodUPIInPaymentsEntity):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaymentMethodUPIInPaymentsEntity`")
        else:
            match += 1
        # validate data type: PaymentMethodAppInPaymentsEntity
        if not isinstance(v, PaymentMethodAppInPaymentsEntity):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaymentMethodAppInPaymentsEntity`")
        else:
            match += 1
        # validate data type: PaymentMethodCardlessEMIInPaymentsEntity
        if not isinstance(v, PaymentMethodCardlessEMIInPaymentsEntity):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaymentMethodCardlessEMIInPaymentsEntity`")
        else:
            match += 1
        # validate data type: PaymentMethodPaylaterInPaymentsEntity
        if not isinstance(v, PaymentMethodPaylaterInPaymentsEntity):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaymentMethodPaylaterInPaymentsEntity`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in PaymentMethodInPaymentsEntityPaymentMethod with oneOf schemas: PaymentMethodAppInPaymentsEntity, PaymentMethodCardInPaymentsEntity, PaymentMethodCardlessEMIInPaymentsEntity, PaymentMethodNetBankingInPaymentsEntity, PaymentMethodPaylaterInPaymentsEntity, PaymentMethodUPIInPaymentsEntity. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in PaymentMethodInPaymentsEntityPaymentMethod with oneOf schemas: PaymentMethodAppInPaymentsEntity, PaymentMethodCardInPaymentsEntity, PaymentMethodCardlessEMIInPaymentsEntity, PaymentMethodNetBankingInPaymentsEntity, PaymentMethodPaylaterInPaymentsEntity, PaymentMethodUPIInPaymentsEntity. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> PaymentMethodInPaymentsEntityPaymentMethod:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> PaymentMethodInPaymentsEntityPaymentMethod:
        """Returns the object represented by the json string"""
        instance = PaymentMethodInPaymentsEntityPaymentMethod.construct()
        error_messages = []
        match = 0

        # deserialize data into PaymentMethodCardInPaymentsEntity
        try:
            instance.actual_instance = PaymentMethodCardInPaymentsEntity.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PaymentMethodNetBankingInPaymentsEntity
        try:
            instance.actual_instance = PaymentMethodNetBankingInPaymentsEntity.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PaymentMethodUPIInPaymentsEntity
        try:
            instance.actual_instance = PaymentMethodUPIInPaymentsEntity.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PaymentMethodAppInPaymentsEntity
        try:
            instance.actual_instance = PaymentMethodAppInPaymentsEntity.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PaymentMethodCardlessEMIInPaymentsEntity
        try:
            instance.actual_instance = PaymentMethodCardlessEMIInPaymentsEntity.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PaymentMethodPaylaterInPaymentsEntity
        try:
            instance.actual_instance = PaymentMethodPaylaterInPaymentsEntity.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into PaymentMethodInPaymentsEntityPaymentMethod with oneOf schemas: PaymentMethodAppInPaymentsEntity, PaymentMethodCardInPaymentsEntity, PaymentMethodCardlessEMIInPaymentsEntity, PaymentMethodNetBankingInPaymentsEntity, PaymentMethodPaylaterInPaymentsEntity, PaymentMethodUPIInPaymentsEntity. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into PaymentMethodInPaymentsEntityPaymentMethod with oneOf schemas: PaymentMethodAppInPaymentsEntity, PaymentMethodCardInPaymentsEntity, PaymentMethodCardlessEMIInPaymentsEntity, PaymentMethodNetBankingInPaymentsEntity, PaymentMethodPaylaterInPaymentsEntity, PaymentMethodUPIInPaymentsEntity. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())


